/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.maintenance.classes;

import com.sos.jitl.jobs.maintenance.MaintenanceWindowJobArguments;
import com.sos.jitl.jobs.maintenance.classes.MaintenanceWindowExecuter;
import com.sos.joc.model.controller.Components;
import com.sos.joc.model.controller.Controller;
import com.sos.joc.model.joc.Cockpit;
import com.sos.js7.job.DetailValue;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.jocapi.ApiExecutor;
import com.sos.js7.job.jocapi.ApiResponse;
import java.util.Map;

public class MaintenanceWindowImpl {
    private MaintenanceWindowJobArguments args;
    private Map<String, DetailValue> jobResources;
    private OrderProcessStepLogger logger;
    private String controllerId;

    public MaintenanceWindowImpl(OrderProcessStep<MaintenanceWindowJobArguments> step) {
        this.args = (MaintenanceWindowJobArguments)step.getDeclaredArguments();
        this.jobResources = step.getJobResourcesArgumentsAsNameDetailValueMap();
        this.logger = step.getLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeApiCall() throws Exception {
        ApiExecutor apiExecutor = new ApiExecutor(this.logger);
        apiExecutor.setJobResources(this.jobResources);
        String accessToken = null;
        ApiResponse apiResponse = null;
        try {
            if (this.args.getState() != null) {
                MaintenanceWindowExecuter maintenanceWindowExecuter;
                String controllerId;
                apiResponse = apiExecutor.login();
                if (apiExecutor.getClient() != null) {
                    apiExecutor.getClient().setConnectionTimeout(10000);
                }
                if (apiResponse.getStatusCode() == 200) {
                    accessToken = apiResponse.getAccessToken();
                }
                if ((controllerId = (maintenanceWindowExecuter = new MaintenanceWindowExecuter(this.logger, apiExecutor)).getControllerid(accessToken, this.args.getControllerId())) == null || controllerId.isEmpty()) {
                    controllerId = this.controllerId;
                }
                Components components = maintenanceWindowExecuter.getControllerClusterStatus(accessToken, controllerId);
                if (this.args.getControllerHost() != null) {
                    for (Controller controller : components.getControllers()) {
                        if (this.args.getState() == null || !controller.getHost().equals(this.args.getControllerHost()) || controller.getClusterNodeState().get_text().value().equalsIgnoreCase(this.args.getState().name())) continue;
                        maintenanceWindowExecuter.switchOverController(accessToken, controllerId);
                        break;
                    }
                }
                if (this.args.getJocHost() != null) {
                    block4: for (Cockpit cockpit : components.getJocs()) {
                        if (this.args.getState().equals((Object)MaintenanceWindowJobArguments.StateValues.ACTIVE) && cockpit.getHost().equals(this.args.getJocHost()) && !cockpit.getClusterNodeState().get_text().value().equalsIgnoreCase(this.args.getState().name())) {
                            maintenanceWindowExecuter.switchOverJoc(accessToken, cockpit.getMemberId());
                            break;
                        }
                        if (!this.args.getState().equals((Object)MaintenanceWindowJobArguments.StateValues.INACTIVE) || !cockpit.getHost().equals(this.args.getJocHost()) || cockpit.getClusterNodeState().get_text().value().equalsIgnoreCase(this.args.getState().name())) continue;
                        for (Cockpit cockpit2 : components.getJocs()) {
                            if (cockpit2.getHost().equals(this.args.getJocHost())) continue;
                            maintenanceWindowExecuter.switchOverJoc(accessToken, cockpit2.getMemberId());
                            continue block4;
                        }
                    }
                }
                if (this.args.getAgentIds() != null && this.args.getAgentIds().size() > 0) {
                    maintenanceWindowExecuter.enOrDisableAgent(accessToken, this.args.getState().equals((Object)MaintenanceWindowJobArguments.StateValues.ACTIVE), controllerId, this.args.getAgentIds());
                }
                if (this.args.getSubAgentIds() != null && this.args.getSubAgentIds().size() > 0) {
                    maintenanceWindowExecuter.enOrDisableSubAgent(accessToken, this.args.getState().equals((Object)MaintenanceWindowJobArguments.StateValues.ACTIVE), controllerId, this.args.getSubAgentIds());
                }
            }
        }
        finally {
            if (accessToken != null) {
                apiExecutor.logout(accessToken);
            }
            apiExecutor.close();
        }
    }
}

