/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.monitoring;

import com.sos.jitl.jobs.monitoring.ExecuteMonitoring;
import com.sos.jitl.jobs.monitoring.MonitoringJobArguments;
import com.sos.jitl.jobs.monitoring.classes.MonitoringCheckReturn;
import com.sos.jitl.jobs.monitoring.classes.MonitoringParameters;
import com.sos.joc.model.jitl.monitoring.MonitoringStatus;
import com.sos.js7.job.Job;
import com.sos.js7.job.OrderProcessStep;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class MonitoringJob
extends Job<MonitoringJobArguments> {
    private static final String REPORTFILE_FILENAME_DATEFORMAT = "yyyy-MM-dd.HH-mm-ss.SSS'Z'";
    private static final String REPORTFILE_SUBJECT_DATEFORMAT = "yyyy-MM-dd.HH:mm:ss.SSS'Z'";

    public MonitoringJob(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void processOrder(OrderProcessStep<MonitoringJobArguments> step) throws Exception {
        this.process(step, (MonitoringJobArguments)step.getDeclaredArguments());
    }

    private void process(OrderProcessStep<MonitoringJobArguments> step, MonitoringJobArguments args) throws Exception {
        if (args.getControllerId() == null || args.getControllerId().isEmpty()) {
            step.getLogger().info((Object)("Setting controller_id=" + step.getControllerId()));
            args.setControllerId(step.getControllerId());
        }
        if (args.getMonitorReportMaxFiles() == null) {
            args.setMonitorReportMaxFiles(30L);
        }
        MonitoringParameters monitoringParameters = new MonitoringParameters();
        DateTimeFormatter formatterFile = DateTimeFormatter.ofPattern(REPORTFILE_FILENAME_DATEFORMAT).withZone(ZoneId.of("UTC"));
        DateTimeFormatter formatterSubject = DateTimeFormatter.ofPattern(REPORTFILE_SUBJECT_DATEFORMAT).withZone(ZoneId.of("UTC"));
        monitoringParameters.setMonitorFileReportDate(formatterFile.format(Instant.now()));
        monitoringParameters.setMonitorSubjectReportDate(formatterSubject.format(Instant.now()));
        monitoringParameters.setMaxFailedOrders(args.getMaxFailedOrders());
        step.getLogger().debug((Object)("Setting controller_id=" + step.getControllerId()));
        ExecuteMonitoring executeMonitoring = new ExecuteMonitoring(step);
        MonitoringStatus monitoringStatus = executeMonitoring.getStatusInformations();
        MonitoringCheckReturn monitoringCheckReturn = executeMonitoring.checkStatusInformation(monitoringStatus, monitoringParameters);
        executeMonitoring.result2File(monitoringStatus, monitoringParameters, monitoringCheckReturn.getCount());
        step.getLogger().info((Object)("monitor report date: " + monitoringParameters.getMonitorSubjectReportDate()));
        step.getLogger().info((Object)("monitor report file: " + monitoringParameters.getMonitorReportFile()));
        step.getOutcome().putVariable("monitor_report_date", (Object)monitoringParameters.getMonitorSubjectReportDate());
        step.getOutcome().putVariable("monitor_report_file", (Object)monitoringParameters.getMonitorReportFile());
        step.getOutcome().putVariable("subject", (Object)monitoringCheckReturn.getSubject());
        step.getOutcome().putVariable("body", (Object)monitoringCheckReturn.getBody());
        step.getOutcome().putVariable("result", (Object)monitoringCheckReturn.getCount());
    }
}

