/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobs.sap;

import com.sos.jitl.jobs.sap.common.ASAPS4HANAJob;
import com.sos.jitl.jobs.sap.common.CommonJobArguments;
import com.sos.jitl.jobs.sap.common.HttpClient;
import com.sos.jitl.jobs.sap.common.bean.ResponseJob;
import com.sos.jitl.jobs.sap.common.bean.ResponseSchedule;
import com.sos.jitl.jobs.sap.common.bean.RunIds;
import com.sos.jitl.jobs.sap.common.bean.Schedule;
import com.sos.js7.job.JobArgument;
import com.sos.js7.job.OrderProcessStep;
import com.sos.js7.job.OrderProcessStepLogger;
import com.sos.js7.job.exception.JobException;
import com.sos.js7.job.exception.JobRequiredArgumentMissingException;
import java.util.Optional;
import js7.launcher.forjava.internal.BlockingInternalJob;

public class SAPS4HANACreateSchedule
extends ASAPS4HANAJob {
    public SAPS4HANACreateSchedule(BlockingInternalJob.JobContext jobContext) {
        super(jobContext);
    }

    public void processOrder(OrderProcessStep<CommonJobArguments> step) throws Exception {
        CommonJobArguments args = (CommonJobArguments)step.getDeclaredArguments();
        this.checkJobIdName(args.getJobId(), args.getJobName());
        this.execute(step, args, RunIds.Scope.SCHEDULE);
    }

    @Override
    public void createInactiveSchedule(OrderProcessStep<CommonJobArguments> step, CommonJobArguments args, HttpClient httpClient, OrderProcessStepLogger logger) throws Exception {
        httpClient.fetchCSRFToken();
        ResponseJob job = httpClient.retrieveJob((Long)args.getJobId().getValue(), (String)args.getJobName().getValue());
        args.setIJobId(job.getJobId());
        Optional<Schedule> scheduleOpt = job.getSchedules().stream().filter(s -> ((String)args.getScheduleId().getValue()).equals(s.getScheduleId())).findAny().map(responseSchedule -> new Schedule().withActive(false).withData(responseSchedule.getData()));
        if (!scheduleOpt.isPresent()) {
            throw new JobException(String.format("A Schedule '%s' doesn't exist in the Job '%d'", job.getJobId(), args.getScheduleId().getValue()));
        }
        ResponseSchedule respSchedule = httpClient.createSchedule((Long)args.getJobId().getValue(), scheduleOpt.get().withDescription(SAPS4HANACreateSchedule.setScheduleDescription(step)));
        args.setIScheduleId(respSchedule.getScheduleId());
        logger.info("Schedule jobId=%d scheduleId=%s is created", new Object[]{args.getJobId().getValue(), respSchedule.getScheduleId()});
    }

    private void checkJobIdName(JobArgument<Long> jobId, JobArgument<String> jobName) throws JobRequiredArgumentMissingException {
        if (jobId.isEmpty() && jobName.isEmpty()) {
            throw new JobRequiredArgumentMissingException(String.format("Either the %s or the %s must be specified", jobId.getName(), jobName.getName()));
        }
    }
}

