/*
 * Decompiled with CFR 0.152.
 */
package com.sos.credentialstore;

import com.sos.JSHelper.Annotations.JSOptionClass;
import com.sos.JSHelper.Basics.JSToolBox;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.Options.SOSOptionElement;
import com.sos.credentialstore.options.ISOSCredentialStoreOptionsBridge;
import com.sos.credentialstore.options.SOSCredentialStoreOptions;
import com.sos.keepass.SOSKeePassDatabase;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import org.linguafranca.pwdb.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SOSCredentialStoreImpl
extends JSToolBox {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSCredentialStoreImpl.class);
    @JSOptionClass(description="", name="SOSCredentialStoreOptions")
    private SOSCredentialStoreOptions options = null;
    private ISOSCredentialStoreOptionsBridge optionsBridge = null;

    public SOSCredentialStoreImpl(ISOSCredentialStoreOptionsBridge ob) {
        this.optionsBridge = ob;
    }

    public void setChildClasses(HashMap<String, String> settings, String prefix) throws Exception {
        this.getCredentialStore().setAllOptions(settings, prefix);
    }

    public SOSCredentialStoreOptions getCredentialStore() {
        if (this.options == null) {
            this.options = new SOSCredentialStoreOptions();
        }
        this.checkCredentialStoreOptions();
        return this.options;
    }

    public SOSCredentialStoreOptions getOptions() {
        if (this.options == null) {
            this.options = new SOSCredentialStoreOptions();
        }
        return this.options;
    }

    public void checkCredentialStoreOptions() {
        if (this.getOptions().useCredentialStore.isTrue()) {
            LOGGER.trace("entering checkCredentialStoreOptions ");
            this.options.credentialStoreFileName.checkMandatory(true);
            this.options.credentialStoreKeyPath.checkMandatory(true);
            String keePassPassword = null;
            String keePassKeyFile = null;
            if (!SOSString.isEmpty((String)this.options.credentialStorePassword.getValue())) {
                keePassPassword = this.options.credentialStorePassword.getValue();
            }
            if (!SOSString.isEmpty((String)this.options.credentialStoreKeyFileName.getValue())) {
                keePassKeyFile = this.options.credentialStoreKeyFileName.getValue();
            }
            Path keePassFile = Paths.get(this.options.credentialStoreFileName.getValue(), new String[0]);
            SOSKeePassDatabase kpd = null;
            Entry<?, ?, ?, ?> entry = null;
            try {
                kpd = new SOSKeePassDatabase(keePassFile, SOSKeePassDatabase.getModule(this.options.credentialStoreKeePassModule.getValue()));
                kpd.load(keePassPassword, Paths.get(keePassKeyFile, new String[0]));
                entry = kpd.getEntryByPath(this.options.credentialStoreKeyPath.getValue());
                if (entry == null) {
                    throw new Exception(String.format("[%s][%s]entry not found", this.options.credentialStoreFileName.getValue(), this.options.credentialStoreKeyPath.getValue()));
                }
                if (entry.getExpires()) {
                    throw new Exception(String.format("[%s][%s]entry is expired (%s)", this.options.credentialStoreFileName.getValue(), this.options.credentialStoreKeyPath.getValue(), entry.getExpiryTime()));
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage());
                throw new JobSchedulerException((Throwable)e);
            }
            if (entry.getUrl().length() > 0) {
                LOGGER.trace(entry.getUrl());
                try {
                    URL url = new URL(entry.getUrl());
                    this.setIfNotDirty((SOSOptionElement)this.optionsBridge.getHost(), url.getHost());
                    String urlPort = String.valueOf(url.getPort());
                    if (this.isEmpty(urlPort) || "-1".equals(urlPort)) {
                        urlPort = String.valueOf(url.getDefaultPort());
                    }
                    this.setIfNotDirty((SOSOptionElement)this.optionsBridge.getPort(), urlPort);
                    this.setIfNotDirty((SOSOptionElement)this.optionsBridge.getProtocol(), url.getProtocol());
                    String urlUserInfo = url.getUserInfo();
                    String[] ui = urlUserInfo.split(":");
                    this.setIfNotDirty((SOSOptionElement)this.optionsBridge.getUser(), ui[0]);
                    if (ui.length > 1) {
                        this.setIfNotDirty((SOSOptionElement)this.optionsBridge.getPassword(), ui[1]);
                    }
                }
                catch (MalformedURLException url) {
                    // empty catch block
                }
            }
            boolean hideValue = false;
            if (this.isNotEmpty(entry.getUsername())) {
                this.optionsBridge.getUser().setValue(entry.getUsername());
                this.optionsBridge.getUser().setHideValue(hideValue);
            }
            if (this.isNotEmpty(entry.getPassword())) {
                this.optionsBridge.getPassword().setValue(entry.getPassword());
                this.optionsBridge.getPassword().setHideValue(hideValue);
            }
            if (this.isNotEmpty(entry.getUrl())) {
                this.optionsBridge.getHost().setValue(entry.getUrl());
                this.optionsBridge.getHost().setHideValue(hideValue);
            }
            if (this.optionsBridge.getHost().isNotDirty()) {
                this.optionsBridge.getHost().setValue(entry.getUrl().toString());
            }
            if (this.options.credentialStoreExportAttachment.isTrue()) {
                Path attachmentTargetFile = Paths.get(this.options.credentialStoreExportAttachment2FileName.getValue(), new String[0]);
                try {
                    kpd.exportAttachment2File(entry, attachmentTargetFile);
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                    throw new JobSchedulerException((Throwable)e);
                }
                if (this.options.credentialStoreDeleteExportedFileOnExit.isTrue()) {
                    attachmentTargetFile.toFile().deleteOnExit();
                }
            }
            if (this.options.credentialStoreProcessNotesParams.isTrue()) {
                this.optionsBridge.commandLineArgs(entry.getNotes());
            }
        }
    }

    private void setIfNotDirty(SOSOptionElement element, String value) {
        if (element.isNotDirty() && this.isNotEmpty(value)) {
            LOGGER.trace("setValue = " + value);
            element.setValue(value);
        }
    }
}

