/*
 * Decompiled with CFR 0.152.
 */
package com.sos.keepass;

import com.sos.keepass.SOSKeePassPath;
import com.sos.keepass.db.ASOSKeePassHandler;
import com.sos.keepass.exceptions.SOSKeePassAttachmentException;
import com.sos.keepass.exceptions.SOSKeePassDatabaseException;
import com.sos.keepass.exceptions.SOSKeePassEntryExpiredException;
import com.sos.keepass.exceptions.SOSKeePassEntryNotFoundException;
import com.sos.keepass.exceptions.SOSKeePassPropertyNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.List;
import org.linguafranca.pwdb.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SOSKeePassDatabase {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSKeePassDatabase.class);
    public static final Module DEFAULT_MODULE = Module.JAXB;
    public static final String ENV_VAR_APPDATA_PATH = "APPDATA_PATH";
    public static final String STANDARD_PROPERTY_NAME_ATTACHMENT = "Attachment";
    private SOSKeePassPath _keepassPath;
    private Entry<?, ?, ?, ?> _entry;
    private ASOSKeePassHandler _handler;

    public SOSKeePassDatabase(Path file, Module module) throws SOSKeePassDatabaseException {
        if (file == null) {
            throw new SOSKeePassDatabaseException("KeePass file is null");
        }
        this._handler = ASOSKeePassHandler.newInstance(file, module);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s][%s]isKdbx=%s", SOSKeePassDatabase.class.getSimpleName(), SOSKeePassDatabase.getFilePath(this._handler.getKeePassFile()), this._handler.isKdbx()));
        }
    }

    public static boolean isKdbx(Path keePassFile) {
        return keePassFile != null && SOSKeePassDatabase.isKdbx(keePassFile.getFileName().toString());
    }

    public static boolean isKdbx(String keePassFile) {
        return keePassFile != null && !keePassFile.toLowerCase().endsWith(".kdb");
    }

    public void load(String password) throws SOSKeePassDatabaseException {
        this.load(password, null);
    }

    public void load(String password, Path keyFile) throws SOSKeePassDatabaseException {
        if (LOGGER.isTraceEnabled()) {
            String pass = password == null ? "" : "pass=?, ";
            LOGGER.trace(String.format("%skeyFile=%s", pass, keyFile));
        }
        this._handler.load(password, keyFile);
    }

    public List<? extends Entry<?, ?, ?, ?>> getEntries() {
        LOGGER.debug("[getEntries]");
        return this._handler.getEntries();
    }

    public List<? extends Entry<?, ?, ?, ?>> getEntriesByTitle(final String match) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[getEntriesByTitle]%s", match));
        }
        if (this._handler.getDatabase() == null) {
            return null;
        }
        return this._handler.getDatabase().findEntries(new Entry.Matcher(){

            public boolean matches(Entry entry) {
                return entry.getTitle().matches(match == null ? "" : match);
            }
        });
    }

    public List<? extends Entry<?, ?, ?, ?>> getEntriesByUsername(final String match) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[getEntriesByUsername]%s", match));
        }
        if (this._handler.getDatabase() == null) {
            return null;
        }
        return this._handler.getDatabase().findEntries(new Entry.Matcher(){

            public boolean matches(Entry entry) {
                return entry.getUsername().matches(match == null ? "" : match);
            }
        });
    }

    public List<? extends Entry<?, ?, ?, ?>> getEntriesByUrl(final String match) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[getEntriesByUrl]%s", match));
        }
        if (this._handler.getDatabase() == null) {
            return null;
        }
        return this._handler.getDatabase().findEntries(new Entry.Matcher(){

            public boolean matches(Entry entry) {
                return entry.getUrl().matches(match == null ? "" : match);
            }
        });
    }

    public Entry<?, ?, ?, ?> getEntryByPath(String path) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[getEntryByPath]%s", path));
        }
        return this._handler.getEntryByPath(path);
    }

    public byte[] getAttachment(String entryPath) throws SOSKeePassDatabaseException {
        return this.getAttachment(this.getEntryByPath(entryPath), null);
    }

    public byte[] getAttachment(String entryPath, String propertyName) throws SOSKeePassDatabaseException {
        return this.getAttachment(this.getEntryByPath(entryPath), propertyName);
    }

    public byte[] getAttachment(Entry<?, ?, ?, ?> entry) throws SOSKeePassDatabaseException {
        return this.getAttachment(entry, null);
    }

    public byte[] getAttachment(Entry<?, ?, ?, ?> entry, String propertyName) throws SOSKeePassDatabaseException {
        byte[] data;
        if (entry == null) {
            throw new SOSKeePassEntryNotFoundException("entry is null");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[getAttachment][%s]%s", entry.getPath(), propertyName));
        }
        if (propertyName != null && propertyName.equalsIgnoreCase(STANDARD_PROPERTY_NAME_ATTACHMENT)) {
            propertyName = null;
        }
        if ((data = this._handler.getBinaryProperty(entry, propertyName)) == null || data.length == 0) {
            if (propertyName == null) {
                throw new SOSKeePassAttachmentException(String.format("[%s]attachment not found or is 0 bytes", entry.getPath()));
            }
            throw new SOSKeePassAttachmentException(String.format("[%s][%s]attachment not found or is 0 bytes", entry.getPath(), propertyName));
        }
        return data;
    }

    public void exportAttachment2File(String entryPath, Path targetFile) throws SOSKeePassDatabaseException {
        this.exportAttachment2File(entryPath, targetFile, null);
    }

    public void exportAttachment2File(String entryPath, Path targetFile, String propertyName) throws SOSKeePassDatabaseException {
        this.exportAttachment2File(this.getEntryByPath(entryPath), targetFile, propertyName);
    }

    public void exportAttachment2File(Entry<?, ?, ?, ?> entry, Path targetFile) throws SOSKeePassDatabaseException {
        this.exportAttachment2File(entry, targetFile, null);
    }

    public String exportAttachment2File(Entry<?, ?, ?, ?> entry, Path targetFile, String propertyName) throws SOSKeePassDatabaseException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[exportAttachment2File][%s][%s]%s", entry.getPath(), propertyName, targetFile));
        }
        byte[] data = this.getAttachment(entry, propertyName);
        try {
            Files.write(targetFile, data, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
        }
        catch (Throwable e) {
            throw new SOSKeePassAttachmentException(String.format("[%s][%s][%s]can't write attachment to file: %s", entry.getPath(), propertyName, SOSKeePassDatabase.getFilePath(targetFile), e.toString()), e);
        }
        return SOSKeePassDatabase.getFilePath(targetFile);
    }

    public static String getPropertyName(String propertyName) {
        if (SOSString.isEmpty((String)propertyName)) {
            return propertyName;
        }
        switch (propertyName.toLowerCase()) {
            case "title": {
                return "Title";
            }
            case "user": 
            case "username": {
                return "UserName";
            }
            case "password": {
                return "Password";
            }
            case "url": {
                return "URL";
            }
            case "notes": {
                return "Notes";
            }
            case "attach": 
            case "attachment": {
                return STANDARD_PROPERTY_NAME_ATTACHMENT;
            }
        }
        return propertyName;
    }

    public ASOSKeePassHandler getHandler() {
        return this._handler;
    }

    public SOSKeePassPath getKeePassPath() {
        return this._keepassPath;
    }

    public void setKeePassPath(SOSKeePassPath val) {
        this._keepassPath = val;
    }

    public Entry<?, ?, ?, ?> getEntry() {
        return this._entry;
    }

    protected void setEntry(Entry<?, ?, ?, ?> val) {
        this._entry = val;
    }

    private Entry<?, ?, ?, ?> createEntry(String entryPath) throws SOSKeePassDatabaseException {
        return this._handler.createEntry(entryPath);
    }

    protected Entry<?, ?, ?, ?> getEntry(SOSKeePassPath path) throws SOSKeePassDatabaseException {
        Entry<?, ?, ?, ?> entry;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[getEntry]%s", path.getEntry()));
        }
        if ((entry = this.getEntryByPath(path.getEntry())) == null) {
            if (path.isCreateEntry()) {
                entry = this.createEntry(path.getEntry());
            } else {
                throw new SOSKeePassEntryNotFoundException(String.format("[%s][%s]entry not found", this._handler.getKeePassFile(), path.getEntry()));
            }
        }
        if (entry.getExpires() && !path.isIgnoreExpired()) {
            throw new SOSKeePassEntryExpiredException(String.format("[%s][%s]entry is expired (%s)", this._handler.getKeePassFile(), path.getEntry(), entry.getExpiryTime()));
        }
        return entry;
    }

    public static String getBinaryPropertyName(SOSKeePassPath path, Path attachment) {
        String propertyName = path.getPropertyName();
        if (path.getPropertyName().equals(STANDARD_PROPERTY_NAME_ATTACHMENT)) {
            propertyName = attachment.getFileName().toString();
        }
        return propertyName;
    }

    public void save() throws SOSKeePassDatabaseException {
        this.saveAs(this._handler.getKeePassFile());
    }

    public void saveAs(String file) throws SOSKeePassDatabaseException {
        this.saveAs(Paths.get(file, new String[0]));
    }

    public void saveAs(Path file) throws SOSKeePassDatabaseException {
        this._handler.saveAs(file);
    }

    public static String getProperty(String uri) throws Exception {
        SOSKeePassDatabase kpd = SOSKeePassDatabase.loadFromUri(uri);
        SOSKeePassPath path = kpd.getKeePassPath();
        Entry<?, ?, ?, ?> entry = kpd.getEntry(path);
        String val = null;
        String queryParamSetProperty = path.getQueryParameters().get("set_property");
        if (SOSString.isEmpty((String)queryParamSetProperty)) {
            if (path.isAttachment() || path.getPropertyName().equals(STANDARD_PROPERTY_NAME_ATTACHMENT)) {
                val = new String(kpd.getAttachment(entry, path.getPropertyName()));
            } else {
                val = entry.getProperty(path.getPropertyName());
                if (val == null) {
                    throw new SOSKeePassPropertyNotFoundException(String.format("[%s]property not found", path.toString()));
                }
            }
        } else if (path.isAttachment() || path.getPropertyName().equals(STANDARD_PROPERTY_NAME_ATTACHMENT)) {
            Path attachment = Paths.get(queryParamSetProperty, new String[0]);
            entry = kpd.getHandler().setBinaryProperty(path, entry, attachment);
            val = path.isStdoutOnSetBinaryProperty() ? new String(entry.getBinaryProperty(SOSKeePassDatabase.getBinaryPropertyName(path, attachment))) : "";
        } else {
            kpd.getHandler().setProperty(entry, path.getPropertyName(), queryParamSetProperty);
            val = queryParamSetProperty;
        }
        if (kpd.getHandler().isDirty()) {
            kpd.save();
        }
        return val;
    }

    public static byte[] getBinaryProperty(String uri) throws Exception {
        SOSKeePassDatabase kpd = SOSKeePassDatabase.loadFromUri(uri);
        SOSKeePassPath path = kpd.getKeePassPath();
        Entry<?, ?, ?, ?> entry = kpd.getEntry(path);
        byte[] val = null;
        String queryParamSetProperty = path.getQueryParameters().get("set_property");
        if (SOSString.isEmpty((String)queryParamSetProperty)) {
            val = kpd.getAttachment(entry, path.getPropertyName());
        } else {
            Path attachment = Paths.get(queryParamSetProperty, new String[0]);
            entry = kpd.getHandler().setBinaryProperty(path, entry, attachment);
            val = entry.getBinaryProperty(SOSKeePassDatabase.getBinaryPropertyName(path, attachment));
        }
        if (kpd.getHandler().isDirty()) {
            kpd.save();
        }
        return val;
    }

    public static SOSKeePassDatabase loadFromUri(String uri) throws Exception {
        SOSKeePassPath path = new SOSKeePassPath(uri);
        if (!path.isValid()) {
            throw new SOSKeePassDatabaseException(String.format("[%s][not valid uri]%s", uri, path.getError()));
        }
        String queryFile = path.getQueryParameters().get("file");
        String queryKeyFile = path.getQueryParameters().get("key_file");
        String queryPassword = path.getQueryParameters().get("password");
        String queryModule = path.getQueryParameters().get("module");
        Path file = Paths.get(queryFile, new String[0]);
        Path keyFile = null;
        if (SOSString.isEmpty((String)queryKeyFile)) {
            keyFile = SOSKeePassDatabase.getDefaultKeyFile(file);
            if (keyFile == null && SOSString.isEmpty((String)queryPassword)) {
                throw new SOSKeePassDatabaseException(String.format("[%s]default key file not found. password is empty", uri));
            }
        } else {
            keyFile = Paths.get(queryKeyFile, new String[0]);
            if (Files.notExists(keyFile, new LinkOption[0])) {
                throw new SOSKeePassDatabaseException(String.format("[%s][%s]key file not found", uri, SOSKeePassDatabase.getFilePath(keyFile)));
            }
        }
        SOSKeePassDatabase kpd = new SOSKeePassDatabase(file, SOSKeePassDatabase.getModule(queryModule));
        kpd.setKeePassPath(path);
        if (keyFile == null) {
            kpd.load(queryPassword);
        } else {
            kpd.load(queryPassword, keyFile);
        }
        return kpd;
    }

    public static Module getModule(String m) {
        if (m == null) {
            return DEFAULT_MODULE;
        }
        try {
            return Module.valueOf(m.toUpperCase());
        }
        catch (Throwable e) {
            return DEFAULT_MODULE;
        }
    }

    public static Path getDefaultKeyFile(Path database) {
        Path keyFile;
        String keyFileName = com.google.common.io.Files.getNameWithoutExtension((String)database.getFileName().toString()) + ".key";
        Path parentDir = database.getParent();
        Path path = keyFile = parentDir == null ? Paths.get(keyFileName, new String[0]) : parentDir.resolve(keyFileName);
        if (Files.notExists(keyFile, new LinkOption[0]) && Files.notExists(keyFile = Paths.get(keyFile.toString() + "x", new String[0]), new LinkOption[0])) {
            keyFile = null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[getDefaultKeyFile]%s", SOSKeePassDatabase.getFilePath(keyFile)));
        }
        return keyFile;
    }

    public static Path getCurrentPath(Path f) {
        if (f == null) {
            return null;
        }
        String appdata = System.getenv(ENV_VAR_APPDATA_PATH);
        if (SOSString.isEmpty((String)appdata)) {
            return f;
        }
        return Paths.get(appdata, new String[0]).resolve(f);
    }

    public static String getFilePath(Path path) {
        if (path == null) {
            return null;
        }
        try {
            return path.toFile().getCanonicalPath();
        }
        catch (Exception ex) {
            return path.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int exitStatus = 0;
        String uri = null;
        try {
            if (args.length > 0) {
                uri = args[0];
            }
            System.out.println(SOSKeePassDatabase.getProperty(uri));
        }
        catch (Throwable t) {
            exitStatus = 99;
            t.printStackTrace();
        }
        finally {
            System.exit(exitStatus);
        }
    }

    public static enum Module {
        DOM,
        JAXB;

    }
}

