/*
 * Decompiled with CFR 0.152.
 */
package com.sos.keepass;

import com.sos.keepass.SOSKeePassDatabase;
import com.sos.keepass.SOSKeePassPath;
import com.sos.keepass.exceptions.SOSKeePassDatabaseException;
import com.sos.keepass.exceptions.SOSKeePassPropertyNotFoundException;
import com.sos.keepass.exceptions.SOSKeePassResolverException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.linguafranca.pwdb.Entry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SOSKeePassResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSKeePassResolver.class);
    private Path file;
    private Path keyFile;
    private String password;
    private String entryPath;
    private Map<String, SOSKeePassDatabase> databases;
    private Map<String, Entry<?, ?, ?, ?>> entries;

    public SOSKeePassResolver() {
        this.databases = new HashMap<String, SOSKeePassDatabase>();
        this.entries = new HashMap();
    }

    public SOSKeePassResolver(Path databaseFile) {
        this(databaseFile, null, null);
    }

    public SOSKeePassResolver(String databaseFile) {
        this(databaseFile, null, null);
    }

    public SOSKeePassResolver(Path databaseFile, Path databaseKeyFile) {
        this(databaseFile, databaseKeyFile, null);
    }

    public SOSKeePassResolver(String databaseFile, String databaseKeyFile) {
        this(databaseFile, databaseKeyFile, null);
    }

    public SOSKeePassResolver(Path databaseFile, String databasePassword) {
        this(databaseFile, null, databasePassword);
    }

    public SOSKeePassResolver(String databaseFile, String databaseKeyFile, String databasePassword) {
        block8: {
            boolean isTraceEnabled;
            block7: {
                this.databases = new HashMap<String, SOSKeePassDatabase>();
                this.entries = new HashMap();
                isTraceEnabled = LOGGER.isTraceEnabled();
                try {
                    if (!SOSString.isEmpty((String)databaseFile)) {
                        this.file = SOSKeePassDatabase.getCurrentPath(Paths.get(databaseFile.trim(), new String[0]));
                    }
                }
                catch (Throwable e) {
                    if (!isTraceEnabled) break block7;
                    LOGGER.trace(String.format("[%s]%s", databaseFile, e.toString()));
                }
            }
            try {
                if (!SOSString.isEmpty((String)databaseKeyFile)) {
                    this.keyFile = SOSKeePassDatabase.getCurrentPath(Paths.get(databaseKeyFile.trim(), new String[0]));
                }
            }
            catch (Throwable e) {
                if (!isTraceEnabled) break block8;
                LOGGER.trace(String.format("[%s]%s", databaseKeyFile, e.toString()));
            }
        }
        if (!SOSString.isEmpty((String)databasePassword)) {
            this.password = databasePassword;
        }
    }

    public SOSKeePassResolver(Path databaseFile, Path databaseKeyFile, String databasePassword) {
        this.databases = new HashMap<String, SOSKeePassDatabase>();
        this.entries = new HashMap();
        this.file = SOSKeePassDatabase.getCurrentPath(databaseFile);
        this.keyFile = SOSKeePassDatabase.getCurrentPath(databaseKeyFile);
        if (!SOSString.isEmpty((String)databasePassword)) {
            this.password = databasePassword;
        }
    }

    public String resolve(String uri) throws SOSKeePassDatabaseException {
        String val;
        SOSKeePassPath path = this.getKeePassPath(uri);
        if (path == null) {
            return uri;
        }
        SOSKeePassDatabase d = this.init(path);
        if (path.isAttachment() || path.getPropertyName().equals("Attachment")) {
            val = new String(d.getAttachment(d.getEntry(), path.getPropertyName()));
        } else {
            val = d.getEntry().getProperty(path.getPropertyName());
            if (val == null) {
                throw new SOSKeePassPropertyNotFoundException(String.format("[%s]property not found", path.toString()));
            }
        }
        return val;
    }

    public byte[] getBinaryProperty(String uri) throws SOSKeePassDatabaseException {
        SOSKeePassPath path = this.getKeePassPath(uri);
        if (path == null) {
            return null;
        }
        SOSKeePassDatabase d = this.init(path);
        if (path.isAttachment() || path.getPropertyName().equals("Attachment")) {
            return d.getAttachment(d.getEntry(), path.getPropertyName());
        }
        return null;
    }

    private SOSKeePassPath getKeePassPath(String uri) throws SOSKeePassResolverException {
        boolean isTraceEnabled = LOGGER.isTraceEnabled();
        if (SOSString.isEmpty((String)uri)) {
            if (isTraceEnabled) {
                LOGGER.trace("[skip]uri is empty");
            }
            return null;
        }
        SOSKeePassPath path = new SOSKeePassPath(uri);
        if (path.isValid()) {
            return path;
        }
        if (!uri.startsWith("cs://")) {
            return null;
        }
        if (this.file == null) {
            throw new SOSKeePassResolverException(String.format("[%s]missing credential store file", uri));
        }
        path = uri.startsWith("cs://" + "@") ? new SOSKeePassPath(SOSKeePassDatabase.isKdbx(this.file), uri, this.entryPath) : new SOSKeePassPath(SOSKeePassDatabase.isKdbx(this.file), uri);
        if (!path.isValid()) {
            if (isTraceEnabled) {
                LOGGER.trace(String.format("[skip][uri=%s][entryPath=%s]invalid path", uri, this.entryPath));
            }
            path = null;
        }
        return path;
    }

    private SOSKeePassDatabase init(SOSKeePassPath path) throws SOSKeePassDatabaseException {
        Map<String, String> queryParameters = path.getQueryParameters();
        Path f = this.getCurrentFile(path, queryParameters);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("[%s]%s", f, path.getEntryPath()));
        }
        SOSKeePassDatabase d = null;
        String key = f.toString();
        if (this.databases.containsKey(key)) {
            d = this.databases.get(key);
        } else {
            String p = this.getCurrentPassword(queryParameters);
            Path kf = this.getCurrentKeyFile(path, queryParameters, f, p);
            d = this.loadDatabase(f, kf, p, this.getCurrentModule(queryParameters));
            this.databases.put(key, d);
        }
        d.setEntry(this.getCurrentEntry(path, f, d));
        d.setKeePassPath(path);
        return d;
    }

    private SOSKeePassDatabase loadDatabase(Path currentFile, Path currentKeyFile, String currentPassword, SOSKeePassDatabase.Module module) throws SOSKeePassDatabaseException {
        SOSKeePassDatabase d = new SOSKeePassDatabase(currentFile, module);
        if (currentKeyFile == null) {
            d.load(currentPassword);
        } else {
            d.load(currentPassword, currentKeyFile);
        }
        return d;
    }

    private Entry<?, ?, ?, ?> getCurrentEntry(SOSKeePassPath path, Path currentFile, SOSKeePassDatabase currentDatabase) throws SOSKeePassDatabaseException {
        Entry<?, ?, ?, ?> entry = null;
        String key = currentFile.toString() + path.getEntryPath();
        if (this.entries.containsKey(key)) {
            entry = this.entries.get(key);
        } else {
            entry = currentDatabase.getEntry(path);
            this.entries.put(key, entry);
        }
        return entry;
    }

    private Path getCurrentFile(SOSKeePassPath path, Map<String, String> queryParameters) throws SOSKeePassResolverException {
        String queryFile;
        Path f = null;
        if (queryParameters != null && (queryFile = queryParameters.get("file")) != null) {
            f = Paths.get(queryFile, new String[0]);
            if (this.file == null) {
                this.file = f;
            }
        }
        if (f == null) {
            f = this.file;
        }
        if (f == null) {
            throw new SOSKeePassResolverException(String.format("[%s]missing database file", path.getQuery()));
        }
        return SOSKeePassDatabase.getCurrentPath(f);
    }

    private Path getCurrentKeyFile(SOSKeePassPath path, Map<String, String> queryParameters, Path currentFile, String currentPassword) throws SOSKeePassDatabaseException {
        Path kf = null;
        String queryKeyFile = null;
        if (queryParameters != null) {
            queryKeyFile = queryParameters.get("key_file");
        }
        if (SOSString.isEmpty(queryKeyFile)) {
            if (this.keyFile == null) {
                kf = SOSKeePassDatabase.getDefaultKeyFile(currentFile);
                if (kf == null && SOSString.isEmpty((String)currentPassword)) {
                    throw new SOSKeePassDatabaseException(String.format("[%s]default key file not found. password is empty", path.getQuery()));
                }
                this.keyFile = kf;
            } else {
                kf = this.keyFile;
            }
        } else {
            kf = SOSKeePassDatabase.getCurrentPath(Paths.get(queryKeyFile, new String[0]));
            if (Files.notExists(kf, new LinkOption[0])) {
                throw new SOSKeePassDatabaseException(String.format("[%s][%s]key file not found", path.getQuery(), SOSKeePassDatabase.getFilePath(kf)));
            }
            if (this.keyFile == null) {
                this.keyFile = kf;
            }
        }
        return kf;
    }

    private String getCurrentPassword(Map<String, String> queryParameters) {
        String queryPassword;
        String p = null;
        if (queryParameters != null && (queryPassword = queryParameters.get("password")) != null) {
            p = queryPassword;
        }
        if (p == null) {
            p = this.password;
        }
        return p;
    }

    private SOSKeePassDatabase.Module getCurrentModule(Map<String, String> queryParameters) {
        String v = null;
        if (queryParameters != null) {
            v = queryParameters.get("module");
        }
        return SOSKeePassDatabase.getModule(v);
    }

    public Path getFile() {
        return this.file;
    }

    public Path getKeyFile() {
        return this.keyFile;
    }

    public String getEntryPath() {
        return this.entryPath;
    }

    public void setEntryPath(String val) {
        this.entryPath = val;
    }
}

