/*
 * Decompiled with CFR 0.152.
 */
package com.sos.keepass.db.kdbx.credentials;

import com.google.common.io.ByteStreams;
import com.google.common.primitives.Bytes;
import com.sos.keepass.SOSKeePassDatabase;
import com.sos.keepass.exceptions.SOSKeePassCredentialException;
import com.sos.keepass.exceptions.SOSKeePassDatabaseException;
import com.sos.keepass.exceptions.SOSKeePassKeyFileException;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.security.MessageDigest;
import org.jetbrains.annotations.NotNull;
import org.linguafranca.pwdb.Credentials;
import org.linguafranca.pwdb.kdbx.KdbxCreds;
import org.linguafranca.pwdb.security.Encryption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class SOSKdbxCreds
implements Credentials {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSKdbxCreds.class);
    private byte[] key;

    public void load(String password, Path keyFile) throws SOSKeePassDatabaseException {
        FileInputStream is = null;
        try {
            if (keyFile == null) {
                this.handlePassword(password);
            } else {
                is = new FileInputStream(SOSKeePassDatabase.getFilePath(keyFile));
                if (this.isXmlKey(is)) {
                    this.handleXmlKey(is, password);
                } else {
                    this.handleBinaryKey(is, password);
                }
            }
        }
        catch (Throwable e) {
            if (keyFile == null) {
                throw new SOSKeePassCredentialException(e);
            }
            throw new SOSKeePassCredentialException(String.format("[%s]%s", SOSKeePassDatabase.getFilePath(keyFile), e.toString()), e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private boolean isXmlKey(@NotNull FileInputStream is) throws Exception {
        FileChannel fc = null;
        try {
            ByteBuffer buffer = ByteBuffer.allocate(50);
            fc = is.getChannel();
            fc.read(buffer, 0L);
            String preview = new String(buffer.array()).trim().replaceAll(">\\s+<", "><").toLowerCase();
            boolean bl = preview.startsWith("<?xml version=\"1.0\" encoding=\"utf-8\"?><keyfile>");
            return bl;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (fc != null) {
                // empty if block
            }
        }
    }

    private void handlePassword(String password) throws Exception {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("[handlePassword]");
        }
        if (SOSString.isEmpty((String)password)) {
            throw new SOSKeePassCredentialException("The password for the database must not be null. Please provide a valid password.");
        }
        this.key = new KdbxCreds(password.getBytes()).getKey();
    }

    private void handleXmlKey(@NotNull InputStream keyFile, String password) throws SOSKeePassKeyFileException {
        if (SOSString.isEmpty((String)password)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("[handleXmlKey]keyFile");
            }
            this.key = new KdbxCreds(keyFile).getKey();
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("[handleXmlKey]pass,keyFile");
            }
            this.key = new KdbxCreds(password.getBytes(), keyFile).getKey();
        }
    }

    private void handleBinaryKey(@NotNull InputStream keyFile, String password) {
        MessageDigest md = Encryption.getSha256MessageDigestInstance();
        if (SOSString.isEmpty((String)password)) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("[handleBinaryKey]keyFile");
            }
            byte[] hash = md.digest(this.toByteArray(keyFile));
            this.key = md.digest(hash);
        } else {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("[handleBinaryKey]pass,keyFile");
            }
            byte[] passHash = md.digest(password.getBytes());
            byte[] keyHash = md.digest(this.toByteArray(keyFile));
            this.key = md.digest(Bytes.concat((byte[][])new byte[][]{passHash, keyHash}));
        }
    }

    private byte[] toByteArray(@NotNull InputStream keyFile) {
        byte[] ba = null;
        try {
            ba = ByteStreams.toByteArray((InputStream)keyFile);
        }
        catch (Throwable e) {
            throw new IllegalStateException(e);
        }
        return ba;
    }

    public byte[] getKey() {
        return this.key;
    }
}

