/*
 * Decompiled with CFR 0.152.
 */
package jcifs.config;

import java.net.InetAddress;
import java.util.Properties;
import jcifs.CIFSException;
import jcifs.Config;
import jcifs.Configuration;
import jcifs.DialectVersion;
import jcifs.config.BaseConfiguration;

public final class PropertyConfiguration
extends BaseConfiguration
implements Configuration {
    public PropertyConfiguration(Properties p) throws CIFSException {
        this.useBatching = Config.getBoolean(p, "jcifs.smb.client.useBatching", false);
        this.useUnicode = Config.getBoolean(p, "jcifs.smb.client.useUnicode", true);
        this.useLargeReadWrite = Config.getBoolean(p, "jcifs.smb.client.useLargeReadWrite", true);
        this.forceUnicode = Config.getBoolean(p, "jcifs.smb.client.forceUnicode", false);
        this.signingPreferred = Config.getBoolean(p, "jcifs.smb.client.signingPreferred", false);
        this.signingEnforced = Config.getBoolean(p, "jcifs.smb.client.signingEnforced", false);
        this.ipcSigningEnforced = Config.getBoolean(p, "jcifs.smb.client.ipcSigningEnforced", true);
        this.encryptionEnabled = Config.getBoolean(p, "jcifs.smb.client.encryptionEnabled", false);
        this.requireSecureNegotiate = Config.getBoolean(p, "jcifs.smb.client.requireSecureNegotiate", true);
        this.sendNTLMTargetName = Config.getBoolean(p, "jcifs.smb.client.SendNTLMTargetName", true);
        this.lanmanCompatibility = Config.getInt(p, "jcifs.smb.lmCompatibility", 3);
        this.allowNTLMFallback = Config.getBoolean(p, "jcifs.smb.allowNTLMFallback", true);
        this.useRawNTLM = Config.getBoolean(p, "jcifs.smb.useRawNTLM", false);
        this.disableSpnegoIntegrity = Config.getBoolean(p, "jcifs.smb.client.disableSpnegoIntegrity", false);
        this.enforceSpnegoIntegrity = Config.getBoolean(p, "jcifs.smb.client.enforceSpnegoIntegrity", false);
        this.disablePlainTextPasswords = Config.getBoolean(p, "jcifs.smb.client.disablePlainTextPasswords", true);
        this.oemEncoding = p.getProperty("jcifs.encoding", "Cp850");
        this.useNtStatus = Config.getBoolean(p, "jcifs.smb.client.useNtStatus", true);
        this.useExtendedSecurity = Config.getBoolean(p, "jcifs.smb.client.useExtendedSecurity", true);
        this.forceExtendedSecurity = Config.getBoolean(p, "jcifs.smb.client.forceExtendedSecurity", false);
        this.smb2OnlyNegotiation = Config.getBoolean(p, "jcifs.smb.client.useSMB2Negotiation", false);
        this.port139FailoverEnabled = Config.getBoolean(p, "jcifs.smb.client.port139.enabled", false);
        this.useNTSmbs = Config.getBoolean(p, "jcifs.smb.client.useNTSmbs", true);
        this.flags2 = Config.getInt(p, "jcifs.smb.client.flags2", 0);
        this.capabilities = Config.getInt(p, "jcifs.smb.client.capabilities", 0);
        this.sessionLimit = Config.getInt(p, "jcifs.smb.client.ssnLimit", 250);
        this.maxRequestRetries = Config.getInt(p, "jcifs.smb.client.maxRequestRetries", 2);
        this.smbTcpNoDelay = Config.getBoolean(p, "jcifs.smb.client.tcpNoDelay", false);
        this.smbResponseTimeout = Config.getInt(p, "jcifs.smb.client.responseTimeout", 30000);
        this.smbSocketTimeout = Config.getInt(p, "jcifs.smb.client.soTimeout", 35000);
        this.smbConnectionTimeout = Config.getInt(p, "jcifs.smb.client.connTimeout", 35000);
        this.smbSessionTimeout = Config.getInt(p, "jcifs.smb.client.sessionTimeout", 35000);
        this.idleTimeoutDisabled = Config.getBoolean(p, "jcifs.smb.client.disableIdleTimeout", false);
        this.smbLocalAddress = Config.getLocalHost(p);
        this.smbLocalPort = Config.getInt(p, "jcifs.smb.client.lport", 0);
        this.maxMpxCount = Config.getInt(p, "jcifs.smb.client.maxMpxCount", 10);
        this.smbSendBufferSize = Config.getInt(p, "jcifs.smb.client.snd_buf_size", 65535);
        this.smbRecvBufferSize = Config.getInt(p, "jcifs.smb.client.rcv_buf_size", 65535);
        this.smbNotifyBufferSize = Config.getInt(p, "jcifs.smb.client.notify_buf_size", 1024);
        this.nativeOs = p.getProperty("jcifs.smb.client.nativeOs", System.getProperty("os.name"));
        this.nativeLanMan = p.getProperty("jcifs.smb.client.nativeLanMan", "jCIFS");
        this.vcNumber = 1;
        this.dfsDisabled = Config.getBoolean(p, "jcifs.smb.client.dfs.disabled", false);
        this.dfsTTL = Config.getLong(p, "jcifs.smb.client.dfs.ttl", 300L);
        this.dfsStrictView = Config.getBoolean(p, "jcifs.smb.client.dfs.strictView", false);
        this.dfsConvertToFqdn = Config.getBoolean(p, "jcifs.smb.client.dfs.convertToFQDN", false);
        this.logonShare = p.getProperty("jcifs.smb.client.logonShare", null);
        this.defaultDomain = p.getProperty("jcifs.smb.client.domain", null);
        this.defaultUserName = p.getProperty("jcifs.smb.client.username", null);
        this.defaultPassword = p.getProperty("jcifs.smb.client.password", null);
        this.netbiosHostname = p.getProperty("jcifs.netbios.hostname", null);
        this.netbiosCachePolicy = Config.getInt(p, "jcifs.netbios.cachePolicy", 600) * 60;
        this.netbiosSocketTimeout = Config.getInt(p, "jcifs.netbios.soTimeout", 5000);
        this.netbiosSendBufferSize = Config.getInt(p, "jcifs.netbios.snd_buf_size", 576);
        this.netbiosRevcBufferSize = Config.getInt(p, "jcifs.netbios.rcv_buf_size", 576);
        this.netbiosRetryCount = Config.getInt(p, "jcifs.netbios.retryCount", 2);
        this.netbiosRetryTimeout = Config.getInt(p, "jcifs.netbios.retryTimeout", 3000);
        this.netbiosScope = p.getProperty("jcifs.netbios.scope");
        this.netbiosLocalPort = Config.getInt(p, "jcifs.netbios.lport", 0);
        this.netbiosLocalAddress = Config.getInetAddress(p, "jcifs.netbios.laddr", null);
        this.lmhostsFilename = p.getProperty("jcifs.netbios.lmhosts");
        this.winsServer = Config.getInetAddressArray(p, "jcifs.netbios.wins", ",", new InetAddress[0]);
        this.transactionBufferSize = Config.getInt(p, "jcifs.smb.client.transaction_buf_size", 65535) - 512;
        this.bufferCacheSize = Config.getInt(p, "jcifs.smb.maxBuffers", 16);
        this.smbListSize = Config.getInt(p, "jcifs.smb.client.listSize", 65435);
        this.smbListCount = Config.getInt(p, "jcifs.smb.client.listCount", 200);
        this.smbAttributeExpiration = Config.getLong(p, "jcifs.smb.client.attrExpirationPeriod", 5000L);
        this.ignoreCopyToException = Config.getBoolean(p, "jcifs.smb.client.ignoreCopyToException", false);
        this.broadcastAddress = Config.getInetAddress(p, "jcifs.netbios.baddr", null);
        this.traceResourceUsage = Config.getBoolean(p, "jcifs.traceResources", false);
        this.strictResourceLifecycle = Config.getBoolean(p, "jcifs.smb.client.strictResourceLifecycle", false);
        this.allowGuestFallback = Config.getBoolean(p, "jcifs.smb.client.allowGuestFallback", false);
        this.guestUsername = p.getProperty("jcifs.smb.client.guestUsername", "JCIFSGUEST");
        this.guestPassword = p.getProperty("jcifs.smb.client.guestPassword", "");
        String minVer = p.getProperty("jcifs.smb.client.minVersion");
        String maxVer = p.getProperty("jcifs.smb.client.maxVersion");
        if (minVer != null || maxVer != null) {
            this.initProtocolVersions(minVer, maxVer);
        } else {
            boolean smb2 = Config.getBoolean(p, "jcifs.smb.client.enableSMB2", true);
            boolean nosmb1 = Config.getBoolean(p, "jcifs.smb.client.disableSMB1", false);
            this.initProtocolVersions(nosmb1 ? DialectVersion.SMB202 : null, !smb2 ? DialectVersion.SMB1 : null);
        }
        this.initResolverOrder(p.getProperty("jcifs.resolveOrder"));
        this.initDisallowCompound(p.getProperty("jcifs.smb.client.disallowCompound"));
        this.initDefaults();
    }
}

