/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.dfs;

import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import jcifs.DfsReferralData;
import jcifs.internal.dfs.DfsReferralDataInternal;
import jcifs.internal.dfs.Referral;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DfsReferralDataImpl
implements DfsReferralDataInternal {
    private static final Logger log = LoggerFactory.getLogger(DfsReferralDataImpl.class);
    private int pathConsumed;
    private long ttl;
    private String server;
    private String share;
    private String link;
    private String path;
    private long expiration;
    private int rflags;
    private boolean resolveHashes;
    private DfsReferralDataImpl next = this;
    private Map<String, DfsReferralDataInternal> map;
    private String key;
    private String domain;
    private boolean intermediate;

    @Override
    public <T extends DfsReferralData> T unwrap(Class<T> type) {
        if (type.isAssignableFrom(this.getClass())) {
            return (T)this;
        }
        throw new ClassCastException();
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public int getPathConsumed() {
        return this.pathConsumed;
    }

    @Override
    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String getLink() {
        return this.link;
    }

    @Override
    public void setLink(String link) {
        this.link = link;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getServer() {
        return this.server;
    }

    @Override
    public String getShare() {
        return this.share;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public int getFlags() {
        return this.rflags;
    }

    @Override
    public void setCacheMap(Map<String, DfsReferralDataInternal> map) {
        this.map = map;
    }

    @Override
    public void replaceCache() {
        if (this.map != null && this.key != null) {
            this.map.put(this.key, this);
        }
    }

    @Override
    public DfsReferralDataImpl next() {
        return this.next;
    }

    @Override
    public void append(DfsReferralDataInternal dr) {
        DfsReferralDataImpl dri = (DfsReferralDataImpl)dr;
        dri.next = this.next;
        this.next = dri;
    }

    @Override
    public void stripPathConsumed(int i) {
        if (i > this.pathConsumed) {
            throw new IllegalArgumentException("Stripping more than consumed");
        }
        this.pathConsumed -= i;
    }

    @Override
    public void fixupDomain(String dom) {
        String s = this.getServer();
        if (s.indexOf(46) < 0 && s.toUpperCase(Locale.ROOT).equals(s)) {
            String fqdn = s + "." + dom;
            if (log.isDebugEnabled()) {
                log.debug(String.format("Applying DFS netbios name hack %s -> %s ", s, fqdn));
            }
            this.server = fqdn;
        }
    }

    @Override
    public void fixupHost(String fqdn) {
        String s = this.getServer();
        if (s.indexOf(46) < 0 && s.toUpperCase(Locale.ROOT).equals(s)) {
            if (fqdn.startsWith(s.toLowerCase(Locale.ROOT) + ".")) {
                if (log.isDebugEnabled()) {
                    log.debug("Adjusting server name " + s + " to " + fqdn);
                }
                this.server = fqdn;
            } else {
                log.warn("Have unmappable netbios name " + s);
            }
        }
    }

    @Override
    public boolean isResolveHashes() {
        return this.resolveHashes;
    }

    public void intermediate() {
        this.intermediate = true;
    }

    @Override
    public boolean isIntermediate() {
        return this.intermediate;
    }

    public String toString() {
        return "DfsReferralData[pathConsumed=" + this.pathConsumed + ",server=" + this.server + ",share=" + this.share + ",link=" + this.link + ",path=" + this.path + ",ttl=" + this.ttl + ",expiration=" + this.expiration + ",remain=" + (this.expiration - System.currentTimeMillis()) + "]";
    }

    public long getTtl() {
        return this.ttl;
    }

    public int hashCode() {
        return Objects.hash(this.server, this.share, this.path, this.pathConsumed);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DfsReferralData)) {
            return false;
        }
        DfsReferralData other = (DfsReferralData)obj;
        return Objects.equals(this.getServer(), other.getServer()) && Objects.equals(this.getShare(), other.getShare()) && Objects.equals(this.getPath(), other.getPath()) && Objects.equals(this.getPathConsumed(), other.getPathConsumed());
    }

    public static DfsReferralDataImpl fromReferral(Referral ref, String reqPath, long expire, int consumed) {
        DfsReferralDataImpl dr = new DfsReferralDataImpl();
        String[] arr = new String[4];
        dr.ttl = ref.getTtl();
        dr.rflags = ref.getRFlags();
        dr.expiration = expire;
        if ((dr.rflags & 2) == 2) {
            String[] expandedNames = ref.getExpandedNames();
            dr.server = expandedNames.length > 0 ? expandedNames[0].substring(1).toLowerCase() : ref.getSpecialName().substring(1).toLowerCase();
            if (log.isDebugEnabled()) {
                log.debug("Server " + dr.server + " path " + reqPath + " remain " + reqPath.substring(consumed) + " path consumed " + consumed);
            }
            dr.pathConsumed = consumed;
        } else {
            if (log.isDebugEnabled()) {
                log.debug("Node " + ref.getNode() + " path " + reqPath + " remain " + reqPath.substring(consumed) + " path consumed " + consumed);
            }
            DfsReferralDataImpl.dfsPathSplit(ref.getNode(), arr);
            dr.server = arr[1];
            dr.share = arr[2];
            dr.path = arr[3];
            dr.pathConsumed = consumed;
            if (reqPath.charAt(consumed - 1) == '\\') {
                if (log.isDebugEnabled()) {
                    log.debug("Server consumed trailing slash of request path, adjusting");
                }
                --dr.pathConsumed;
            }
            if (log.isDebugEnabled()) {
                String cons = reqPath.substring(0, consumed);
                log.debug("Request " + reqPath + " ref path " + dr.path + " consumed " + dr.pathConsumed + ": " + cons);
            }
        }
        return dr;
    }

    @Override
    public DfsReferralDataInternal combine(DfsReferralData n) {
        DfsReferralDataImpl dr = new DfsReferralDataImpl();
        dr.server = n.getServer();
        dr.share = n.getShare();
        dr.expiration = n.getExpiration();
        dr.path = n.getPath();
        dr.pathConsumed = this.pathConsumed + n.getPathConsumed();
        if (this.path != null) {
            dr.pathConsumed = dr.pathConsumed - (this.path != null ? this.path.length() + 1 : 0);
        }
        dr.domain = n.getDomain();
        return dr;
    }

    private static int dfsPathSplit(String path, String[] result) {
        int ri = 0;
        int rlast = result.length - 1;
        int i = 0;
        int b = 0;
        int len = path.length();
        int strip = 0;
        do {
            if (ri == rlast) {
                result[rlast] = path.substring(b);
                result[rlast] = path.substring(b);
                return strip;
            }
            if (i != len && path.charAt(i) != '\\') continue;
            result[ri++] = path.substring(b, i);
            ++strip;
            b = i + 1;
        } while (i++ < len);
        while (ri < result.length) {
            result[ri++] = "";
        }
        return strip;
    }
}

