/*
 * Decompiled with CFR 0.152.
 */
package com.sos.graphviz;

import com.sos.graphviz.EdgeProperties;
import com.sos.graphviz.GraphvizObject;
import com.sos.graphviz.IGraphvizObject;
import com.sos.graphviz.Node;

public class Edge
extends GraphvizObject
implements IGraphvizObject {
    private final Node fromNode;
    private final Node toNode;
    private EdgeProperties edgeProperties = new EdgeProperties();

    protected Edge(Node from, Node to) {
        super("", "");
        this.fromNode = from;
        this.toNode = to;
    }

    @Override
    public String getContent() {
        StringBuilder sb = new StringBuilder();
        if (this.fromNode != null && this.toNode != null) {
            sb.append(this.fromNode.getName() + " -> " + this.toNode.getName());
            sb.append(this.edgeProperties.getSource());
            if (this.edgeProperties.getContent().isEmpty()) {
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    @Override
    public GraphvizObject getProperties() {
        return this.edgeProperties;
    }

    public EdgeProperties getEdgeProperties() {
        return (EdgeProperties)this.getProperties();
    }

    public Node getFromNode() {
        return this.fromNode;
    }

    public Node getToNode() {
        return this.toNode;
    }
}

