/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkhistory;

import com.sos.exception.SOSException;
import com.sos.jitl.checkhistory.HistoryHelper;
import com.sos.jitl.checkhistory.JobHistory;
import com.sos.jitl.checkhistory.JobSchedulerHistoryInfo;
import com.sos.jitl.checkhistory.classes.HistoryDataSource;
import com.sos.jitl.checkhistory.classes.HistoryWebserviceExecuter;
import com.sos.jitl.checkhistory.classes.JobSchedulerHistoryInfoEntry;
import com.sos.jitl.checkhistory.interfaces.IJobSchedulerHistory;
import com.sos.jitl.checkhistory.interfaces.IJobSchedulerHistoryInfo;
import com.sos.jitl.restclient.WebserviceCredentials;
import com.sos.joc.model.order.OrderHistoryItem;
import com.sos.scheduler.model.answers.JobChain;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;

public class JobChainHistory
implements IJobSchedulerHistory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobHistory.class);
    private JobChain.OrderHistory.Order lastCompletedHistoryEntry = null;
    private JobChain.OrderHistory.Order lastRunningHistoryEntry = null;
    private JobChain.OrderHistory.Order lastCompletedSuccessfullHistoryEntry = null;
    private JobChain.OrderHistory.Order lastCompletedWithErrorHistoryEntry = null;
    private String timeLimit;
    private HistoryHelper jobHistoryHelper = new HistoryHelper();
    private String actHistoryObjectName = "";
    private String relativePath;
    private WebserviceCredentials webserviceCredentials;
    private HistoryDataSource historyDatasourceExecuter;

    public JobChainHistory(WebserviceCredentials webserviceCredentials) {
        this.webserviceCredentials = webserviceCredentials;
        this.timeLimit = "";
    }

    public JobChainHistory(Spooler spooler) {
        this.webserviceCredentials = new WebserviceCredentials();
        this.webserviceCredentials.setJocUrl(spooler.variables().value("joc_url"));
        String jocUser = spooler.variables().value("joc_user");
        this.webserviceCredentials.setAccessToken(spooler.variables().value(jocUser + "_X-Access-Token"));
        this.webserviceCredentials.setUser(jocUser);
        this.webserviceCredentials.setSchedulerId(spooler.id());
        this.webserviceCredentials.setKeyPassword(spooler.variables().value("key_password"));
        this.webserviceCredentials.setKeyStorePassword(spooler.variables().value("keystore_password"));
        this.webserviceCredentials.setKeyStorePath(spooler.variables().value("keystore_path"));
        this.webserviceCredentials.setKeyStoreType(spooler.variables().value("keystore_type"));
        this.webserviceCredentials.setTrustStorePassword(spooler.variables().value("truststore_password"));
        this.webserviceCredentials.setTrustStorePath(spooler.variables().value("truststore_path"));
        this.webserviceCredentials.setTrustStoreType(spooler.variables().value("truststore_type"));
        this.timeLimit = "";
    }

    public JobSchedulerHistoryInfo getJobChainInfo(String jobChainName) throws Exception {
        return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobChainName);
    }

    public JobSchedulerHistoryInfo getJobChainInfo(String jobChainName, String timeLimit_) throws Exception {
        return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobChainName, timeLimit_);
    }

    @Override
    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobChainName) throws Exception {
        this.lastCompletedHistoryEntry = null;
        this.lastRunningHistoryEntry = null;
        this.lastCompletedSuccessfullHistoryEntry = null;
        this.lastCompletedWithErrorHistoryEntry = null;
        return this.jobSchedulerHistoryInfo(jobChainName);
    }

    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobChainName, String timeLimit_) throws Exception {
        this.lastCompletedHistoryEntry = null;
        this.lastRunningHistoryEntry = null;
        this.lastCompletedSuccessfullHistoryEntry = null;
        this.lastCompletedWithErrorHistoryEntry = null;
        this.timeLimit = timeLimit_;
        return this.jobSchedulerHistoryInfo(jobChainName);
    }

    private void setError(JobSchedulerHistoryInfoEntry historyInfoEntry, OrderHistoryItem orderHistoryItem) {
        if (orderHistoryItem != null) {
            if (orderHistoryItem.getState().getSeverity() == 2) {
                historyInfoEntry.error = 1;
                historyInfoEntry.errorMessage = orderHistoryItem.getState().get_text().toString();
            } else {
                historyInfoEntry.error = 0;
                historyInfoEntry.errorCode = "";
            }
        }
    }

    public IJobSchedulerHistoryInfo jobSchedulerHistoryInfo(String jobChainName) throws Exception {
        this.getHistoryByWebServiceCall(jobChainName);
        this.historyDatasourceExecuter.setJobChainName(jobChainName);
        OrderHistoryItem orderHistoryItem = null;
        if (this.lastCompletedHistoryEntry != null) {
            orderHistoryItem = this.historyDatasourceExecuter.getJobChainOrderHistoryEntry(this.lastCompletedHistoryEntry.getHistoryId());
        }
        JobSchedulerHistoryInfo jobChainHistoryInfo = new JobSchedulerHistoryInfo();
        if (this.lastCompletedHistoryEntry != null) {
            this.setError(jobChainHistoryInfo.lastCompleted, orderHistoryItem);
            jobChainHistoryInfo.lastCompleted.found = true;
            jobChainHistoryInfo.lastCompleted.orderId = this.lastCompletedHistoryEntry.getOrder();
            jobChainHistoryInfo.lastCompleted.state = this.lastCompletedHistoryEntry.getState();
            jobChainHistoryInfo.lastCompleted.top = this.lastRunningHistoryEntry == null || this.lastRunningHistoryEntry.getHistoryId() == null || this.lastRunningHistoryEntry.getHistoryId().compareTo(this.lastCompletedHistoryEntry.getHistoryId()) <= 0;
            jobChainHistoryInfo.lastCompleted.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedHistoryEntry.getStartTime());
            jobChainHistoryInfo.lastCompleted.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedHistoryEntry.getEndTime());
            jobChainHistoryInfo.lastCompleted.id = this.jobHistoryHelper.big2int(this.lastCompletedHistoryEntry.getHistoryId());
            jobChainHistoryInfo.lastCompleted.jobChainName = this.lastCompletedHistoryEntry.getJobChain();
            jobChainHistoryInfo.lastCompleted.duration = this.jobHistoryHelper.getDuration(jobChainHistoryInfo.lastCompleted.start, jobChainHistoryInfo.lastCompleted.end);
        } else {
            jobChainHistoryInfo.lastCompleted.found = false;
            LOGGER.debug(String.format("no completed job chain run found for the job chain:%s", jobChainName));
        }
        if (this.lastCompletedSuccessfullHistoryEntry != null) {
            jobChainHistoryInfo.lastCompleted.error = 0;
            jobChainHistoryInfo.lastCompleted.errorCode = "";
            jobChainHistoryInfo.lastCompleted.errorMessage = "";
            jobChainHistoryInfo.lastCompletedSuccessful.found = true;
            jobChainHistoryInfo.lastCompletedSuccessful.orderId = this.lastCompletedSuccessfullHistoryEntry.getOrder();
            jobChainHistoryInfo.lastCompletedSuccessful.state = this.lastCompletedSuccessfullHistoryEntry.getState();
            jobChainHistoryInfo.lastCompletedSuccessful.top = !(this.lastRunningHistoryEntry != null && this.lastRunningHistoryEntry.getHistoryId() != null && this.lastRunningHistoryEntry.getHistoryId().compareTo(this.lastCompletedSuccessfullHistoryEntry.getHistoryId()) > 0 || this.lastCompletedWithErrorHistoryEntry != null && this.lastCompletedSuccessfullHistoryEntry.getHistoryId() != null && this.lastCompletedWithErrorHistoryEntry.getHistoryId().compareTo(this.lastCompletedSuccessfullHistoryEntry.getHistoryId()) > 0);
            jobChainHistoryInfo.lastCompletedSuccessful.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedSuccessfullHistoryEntry.getStartTime());
            jobChainHistoryInfo.lastCompletedSuccessful.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedSuccessfullHistoryEntry.getEndTime());
            jobChainHistoryInfo.lastCompletedSuccessful.id = this.jobHistoryHelper.big2int(this.lastCompletedSuccessfullHistoryEntry.getHistoryId());
            jobChainHistoryInfo.lastCompletedSuccessful.jobChainName = this.lastCompletedSuccessfullHistoryEntry.getJobChain();
            jobChainHistoryInfo.lastCompletedSuccessful.duration = this.jobHistoryHelper.getDuration(jobChainHistoryInfo.lastCompletedSuccessful.start, jobChainHistoryInfo.lastCompletedSuccessful.end);
        } else {
            jobChainHistoryInfo.lastCompletedSuccessful.found = false;
            LOGGER.debug(String.format("no successfull job chain run found for the job chain:%s", jobChainName));
        }
        if (this.lastCompletedWithErrorHistoryEntry != null) {
            this.setError(jobChainHistoryInfo.lastCompleted, orderHistoryItem);
            jobChainHistoryInfo.lastCompletedWithError.found = true;
            jobChainHistoryInfo.lastCompletedWithError.orderId = this.lastCompletedWithErrorHistoryEntry.getOrder();
            jobChainHistoryInfo.lastCompletedWithError.state = this.lastCompletedWithErrorHistoryEntry.getState();
            jobChainHistoryInfo.lastCompletedWithError.top = !(this.lastRunningHistoryEntry != null && this.lastRunningHistoryEntry.getHistoryId() != null && this.lastRunningHistoryEntry.getHistoryId().compareTo(this.lastCompletedWithErrorHistoryEntry.getHistoryId()) > 0 || this.lastCompletedSuccessfullHistoryEntry != null && this.lastCompletedSuccessfullHistoryEntry.getHistoryId() != null && this.lastCompletedSuccessfullHistoryEntry.getHistoryId().compareTo(this.lastCompletedWithErrorHistoryEntry.getHistoryId()) > 0);
            jobChainHistoryInfo.lastCompletedWithError.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedWithErrorHistoryEntry.getStartTime());
            jobChainHistoryInfo.lastCompletedWithError.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedWithErrorHistoryEntry.getEndTime());
            jobChainHistoryInfo.lastCompletedWithError.id = this.jobHistoryHelper.big2int(this.lastCompletedWithErrorHistoryEntry.getHistoryId());
            jobChainHistoryInfo.lastCompletedWithError.jobChainName = this.lastCompletedWithErrorHistoryEntry.getJobChain();
            jobChainHistoryInfo.lastCompletedWithError.duration = this.jobHistoryHelper.getDuration(jobChainHistoryInfo.lastCompletedWithError.start, jobChainHistoryInfo.lastCompletedWithError.end);
        } else {
            jobChainHistoryInfo.lastCompletedWithError.found = false;
            LOGGER.debug(String.format("no job chain runs with error found for the job chain:%s", jobChainName));
        }
        if (this.lastRunningHistoryEntry != null) {
            jobChainHistoryInfo.running.found = true;
            jobChainHistoryInfo.running.orderId = this.lastRunningHistoryEntry.getOrder();
            jobChainHistoryInfo.running.state = this.lastRunningHistoryEntry.getState();
            jobChainHistoryInfo.running.top = !jobChainHistoryInfo.lastCompleted.top;
            jobChainHistoryInfo.running.start = this.jobHistoryHelper.getDateFromString(this.lastRunningHistoryEntry.getStartTime());
            jobChainHistoryInfo.running.end = null;
            jobChainHistoryInfo.running.id = this.jobHistoryHelper.big2int(this.lastRunningHistoryEntry.getHistoryId());
            jobChainHistoryInfo.running.jobChainName = this.lastRunningHistoryEntry.getJobChain();
            jobChainHistoryInfo.running.duration = "";
        } else {
            jobChainHistoryInfo.running.found = false;
            LOGGER.debug(String.format("no running job chain found for the job chain:%s", jobChainName));
        }
        return jobChainHistoryInfo;
    }

    private void createDataSource() throws SOSException, URISyntaxException {
        if (this.historyDatasourceExecuter == null) {
            this.historyDatasourceExecuter = new HistoryWebserviceExecuter(this.webserviceCredentials);
            this.historyDatasourceExecuter.login(this.webserviceCredentials.getAccessToken());
        }
    }

    private void getHistoryByWebServiceCall(String jobChainName) throws Exception {
        String orderId = HistoryHelper.getOrderId(jobChainName);
        jobChainName = HistoryHelper.getJobChainName(jobChainName);
        this.actHistoryObjectName = jobChainName = this.jobHistoryHelper.normalizePath(this.relativePath, jobChainName);
        this.createDataSource();
        this.historyDatasourceExecuter.setTimeLimit(this.timeLimit);
        this.historyDatasourceExecuter.setJobChainName(jobChainName);
        this.historyDatasourceExecuter.setOrderId(orderId);
        this.historyDatasourceExecuter.setSchedulerId(this.webserviceCredentials.getSchedulerId());
        this.lastCompletedSuccessfullHistoryEntry = this.historyDatasourceExecuter.getLastCompletedSuccessfullJobChainHistoryEntry();
        this.lastCompletedHistoryEntry = this.historyDatasourceExecuter.getLastCompletedJobChainHistoryEntry();
        this.lastCompletedWithErrorHistoryEntry = this.historyDatasourceExecuter.getLastCompletedWithErrorJobChainHistoryEntry();
        this.lastRunningHistoryEntry = this.historyDatasourceExecuter.getLastRunningJobChainHistoryEntry();
    }

    public String getTimeLimit() {
        return this.timeLimit;
    }

    @Override
    public void setTimeLimit(String timeLimit) {
        this.timeLimit = timeLimit;
    }

    @Override
    public String getActHistoryObjectName() {
        return this.actHistoryObjectName;
    }

    @Override
    public void setRelativePath(String relativePath_) {
        if (!relativePath_.startsWith("/")) {
            relativePath_ = "/" + relativePath_;
        }
        this.relativePath = relativePath_ = relativePath_.replace('\\', '/');
    }

    @Override
    public WebserviceCredentials getWebserviceCredentials() {
        return this.webserviceCredentials;
    }

    public void setHistoryDatasourceExecuter(HistoryDataSource historyDatasourceExecuter) {
        this.historyDatasourceExecuter = historyDatasourceExecuter;
    }
}

