/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.checkrunhistory;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.checkrunhistory.IJobSchedulerHistory;
import com.sos.jitl.checkrunhistory.IJobSchedulerHistoryInfo;
import com.sos.jitl.checkrunhistory.JobHistoryHelper;
import com.sos.jitl.checkrunhistory.JobSchedulerHistoryInfo;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.answers.Answer;
import com.sos.scheduler.model.answers.ERROR;
import com.sos.scheduler.model.answers.JobChain;
import com.sos.scheduler.model.answers.JobChainNode;
import com.sos.scheduler.model.commands.JSCmdShowJobChain;
import com.sos.scheduler.model.commands.ShowHistory;
import java.io.File;
import java.math.BigInteger;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;

public class JobChainHistory
implements IJobSchedulerHistory {
    private static final int NUMBER_OF_RUNS = 100;
    private static final Logger LOGGER = LoggerFactory.getLogger(JobChainHistory.class);
    private String host;
    private int port;
    private Spooler spooler;
    private JobChain.OrderHistory.Order lastCompletedHistoryEntry = null;
    private JobChain.OrderHistory.Order lastRunningHistoryEntry = null;
    private JobChain.OrderHistory.Order lastCompletedSuccessfullHistoryEntry = null;
    private JobChain.OrderHistory.Order lastCompletedWithErrorHistoryEntry = null;
    private String timeLimit;
    private int numberOfStarts;
    private int numberOfCompletedSuccessful;
    private int numberOfCompletedWithError;
    private int numberOfCompleted;
    private int lastCompletedHistoryEntryPos;
    private int lastRunningHistoryEntryPos;
    private int lastCompletedHistoryEntryError;
    private int lastCompletedSuccessfullHistoryEntryPos;
    private int lastCompletedWithErrorHistoryEntryPos;
    private int count;
    private JobHistoryHelper jobHistoryHelper = new JobHistoryHelper();
    private String relativePath = "";
    private String actHistoryObjectName = "";

    public JobChainHistory(String host_, int port_) {
        this.host = host_;
        this.port = port_;
        this.timeLimit = "";
    }

    public JobChainHistory(Spooler spooler_) {
        this.spooler = spooler_;
        this.timeLimit = "";
    }

    public JobSchedulerHistoryInfo getJobChainInfo(String jobName) throws Exception {
        return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobName);
    }

    public JobSchedulerHistoryInfo getJobChainInfo(String jobName, String timeLimit_) throws Exception {
        return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobName, timeLimit_);
    }

    public JobSchedulerHistoryInfo getJobChainInfo(String jobName, int limit, String timeLimit_) throws Exception {
        return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobName, limit, timeLimit_);
    }

    public JobSchedulerHistoryInfo getJobChainInfo(String jobName, int numberOfRuns) throws Exception {
        return (JobSchedulerHistoryInfo)this.getJobSchedulerHistoryInfo(jobName, numberOfRuns);
    }

    @Override
    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobChainName) throws Exception {
        this.lastCompletedHistoryEntry = null;
        this.lastRunningHistoryEntry = null;
        this.lastCompletedSuccessfullHistoryEntry = null;
        this.lastCompletedWithErrorHistoryEntry = null;
        return this.getJobSchedulerHistoryInfo(jobChainName, 100);
    }

    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobChainName, String timeLimit_) throws Exception {
        this.lastCompletedHistoryEntry = null;
        this.lastRunningHistoryEntry = null;
        this.lastCompletedSuccessfullHistoryEntry = null;
        this.lastCompletedWithErrorHistoryEntry = null;
        this.timeLimit = timeLimit_;
        return this.getJobSchedulerHistoryInfo(jobChainName, 100);
    }

    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobChainName, int limit, String timeLimit_) throws Exception {
        this.lastCompletedHistoryEntry = null;
        this.lastRunningHistoryEntry = null;
        this.lastCompletedSuccessfullHistoryEntry = null;
        this.lastCompletedWithErrorHistoryEntry = null;
        this.timeLimit = timeLimit_;
        return this.getJobSchedulerHistoryInfo(jobChainName, limit);
    }

    public IJobSchedulerHistoryInfo getJobSchedulerHistoryInfo(String jobChainName, int numberOfRuns) throws Exception {
        this.getHistory(jobChainName, numberOfRuns);
        JobSchedulerHistoryInfo jobChainHistoryInfo = new JobSchedulerHistoryInfo();
        if (this.lastCompletedHistoryEntry != null) {
            jobChainHistoryInfo.lastCompleted.found = true;
            jobChainHistoryInfo.lastCompleted.position = this.lastCompletedHistoryEntryPos;
            jobChainHistoryInfo.lastCompleted.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedHistoryEntry.getStartTime());
            jobChainHistoryInfo.lastCompleted.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedHistoryEntry.getEndTime());
            jobChainHistoryInfo.lastCompleted.error = this.lastCompletedHistoryEntryError;
            jobChainHistoryInfo.lastCompleted.id = this.jobHistoryHelper.big2int(this.lastCompletedHistoryEntry.getHistoryId());
            jobChainHistoryInfo.lastCompleted.orderId = this.lastCompletedHistoryEntry.getOrder();
            jobChainHistoryInfo.lastCompleted.jobChainName = this.lastCompletedHistoryEntry.getJobChain();
            jobChainHistoryInfo.lastCompleted.state = this.lastCompletedHistoryEntry.getState();
            jobChainHistoryInfo.lastCompleted.duration = this.jobHistoryHelper.getDuration(jobChainHistoryInfo.lastCompleted.start, jobChainHistoryInfo.lastCompleted.end);
        } else {
            jobChainHistoryInfo.lastCompleted.found = false;
            LOGGER.debug(String.format("no completed job chain run found for the job chains:%s in the last %s job chain runs", jobChainName, numberOfRuns));
        }
        if (this.lastCompletedSuccessfullHistoryEntry != null) {
            jobChainHistoryInfo.lastCompletedSuccessful.found = true;
            jobChainHistoryInfo.lastCompletedSuccessful.position = this.lastCompletedSuccessfullHistoryEntryPos;
            jobChainHistoryInfo.lastCompletedSuccessful.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedSuccessfullHistoryEntry.getStartTime());
            jobChainHistoryInfo.lastCompletedSuccessful.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedSuccessfullHistoryEntry.getEndTime());
            jobChainHistoryInfo.lastCompletedSuccessful.id = this.jobHistoryHelper.big2int(this.lastCompletedSuccessfullHistoryEntry.getHistoryId());
            jobChainHistoryInfo.lastCompletedSuccessful.orderId = this.lastCompletedSuccessfullHistoryEntry.getOrder();
            jobChainHistoryInfo.lastCompletedSuccessful.jobChainName = this.lastCompletedSuccessfullHistoryEntry.getJobChain();
            jobChainHistoryInfo.lastCompletedSuccessful.state = this.lastCompletedSuccessfullHistoryEntry.getState();
            jobChainHistoryInfo.lastCompletedSuccessful.duration = this.jobHistoryHelper.getDuration(jobChainHistoryInfo.lastCompletedSuccessful.start, jobChainHistoryInfo.lastCompletedSuccessful.end);
        } else {
            jobChainHistoryInfo.lastCompletedSuccessful.found = false;
            LOGGER.debug(String.format("no successfull job chain run found for the job chain:%s in the last %s job chain runs", jobChainName, numberOfRuns));
        }
        if (this.lastCompletedWithErrorHistoryEntry != null) {
            jobChainHistoryInfo.lastCompletedWithError.found = true;
            jobChainHistoryInfo.lastCompletedWithError.position = this.lastCompletedWithErrorHistoryEntryPos;
            jobChainHistoryInfo.lastCompletedWithError.start = this.jobHistoryHelper.getDateFromString(this.lastCompletedWithErrorHistoryEntry.getStartTime());
            jobChainHistoryInfo.lastCompletedWithError.end = this.jobHistoryHelper.getDateFromString(this.lastCompletedWithErrorHistoryEntry.getEndTime());
            jobChainHistoryInfo.lastCompletedWithError.id = this.jobHistoryHelper.big2int(this.lastCompletedWithErrorHistoryEntry.getHistoryId());
            jobChainHistoryInfo.lastCompletedWithError.orderId = this.lastCompletedWithErrorHistoryEntry.getOrder();
            jobChainHistoryInfo.lastCompletedWithError.jobChainName = this.lastCompletedWithErrorHistoryEntry.getJobChain();
            jobChainHistoryInfo.lastCompletedWithError.state = this.lastCompletedWithErrorHistoryEntry.getState();
            jobChainHistoryInfo.lastCompletedWithError.duration = this.jobHistoryHelper.getDuration(jobChainHistoryInfo.lastCompletedWithError.start, jobChainHistoryInfo.lastCompletedWithError.end);
        } else {
            jobChainHistoryInfo.lastCompletedWithError.found = false;
            LOGGER.debug(String.format("no job chain runs with error found for the job chain%s in the last %s job chain runs", jobChainName, numberOfRuns));
        }
        if (this.lastRunningHistoryEntry != null) {
            jobChainHistoryInfo.running.found = true;
            jobChainHistoryInfo.running.position = this.lastRunningHistoryEntryPos;
            jobChainHistoryInfo.running.start = this.jobHistoryHelper.getDateFromString(this.lastRunningHistoryEntry.getStartTime());
            jobChainHistoryInfo.running.end = this.jobHistoryHelper.getDateFromString(this.lastRunningHistoryEntry.getEndTime());
            jobChainHistoryInfo.running.id = this.jobHistoryHelper.big2int(this.lastRunningHistoryEntry.getHistoryId());
            jobChainHistoryInfo.running.orderId = this.lastRunningHistoryEntry.getOrder();
            jobChainHistoryInfo.running.jobChainName = this.lastRunningHistoryEntry.getJobChain();
            jobChainHistoryInfo.running.state = this.lastRunningHistoryEntry.getState();
            jobChainHistoryInfo.running.duration = this.jobHistoryHelper.getDuration(jobChainHistoryInfo.running.start, jobChainHistoryInfo.running.end);
        } else {
            jobChainHistoryInfo.running.found = false;
            LOGGER.debug(String.format("no running job chains found for the job chain:%s in the last %s job chain runs", jobChainName, numberOfRuns));
        }
        return jobChainHistoryInfo;
    }

    private boolean isErrorNode(List<JobChainNode> jobChainNodes, String orderState) {
        for (JobChainNode jobChainNode : jobChainNodes) {
            if (jobChainNode.getErrorState() == null || !jobChainNode.getErrorState().equals(orderState)) continue;
            return true;
        }
        return false;
    }

    private void getHistory(String jobChainName, int numberOfRuns) throws Exception {
        String orderId = this.jobHistoryHelper.getOrderId(jobChainName);
        jobChainName = this.jobHistoryHelper.getJobChainName(jobChainName);
        SchedulerObjectFactory jsFactory = new SchedulerObjectFactory();
        jsFactory.initMarshaller(ShowHistory.class);
        JSCmdShowJobChain showJobChain = jsFactory.createShowJobChain();
        if (!jobChainName.startsWith("/") && !this.relativePath.isEmpty()) {
            String s = jobChainName;
            jobChainName = new File(this.relativePath, jobChainName).getPath();
            jobChainName = jobChainName.replace('\\', '/');
            LOGGER.debug(String.format("Changed job chain name from %s to %s", s, jobChainName));
        }
        this.actHistoryObjectName = jobChainName;
        showJobChain.setJobChain(jobChainName);
        showJobChain.setMaxOrderHistory(BigInteger.valueOf(numberOfRuns));
        Answer answer = null;
        String lastMsg = "";
        try {
            if (this.spooler == null) {
                jsFactory.getOptions().ServerName.setValue(this.host);
                jsFactory.getOptions().PortNumber.value(this.port);
                showJobChain.run();
                answer = showJobChain.getAnswer();
            } else {
                showJobChain.getAnswerFromSpooler(this.spooler);
                answer = showJobChain.getAnswer();
            }
        }
        catch (Exception e) {
            lastMsg = String.format("Query to JobScheduler results into an exception: %s", e.getMessage());
            LOGGER.debug(lastMsg);
        }
        this.numberOfCompleted = 0;
        this.numberOfStarts = 0;
        this.numberOfCompletedSuccessful = 0;
        this.numberOfCompletedWithError = 0;
        if (answer != null) {
            ERROR error = answer.getERROR();
            if (error != null) {
                String msg = String.format("Answer from JobScheduler have the error \"%s\"\nNo entries found for the job chain:%s", error.getText(), jobChainName);
                LOGGER.debug(msg);
            } else {
                List jobChainHistoryEntries = answer.getJobChain().getOrderHistory().getOrder();
                List jobChainNodes = answer.getJobChain().getJobChainNode();
                this.count = jobChainHistoryEntries.size();
                if (this.count == 0) {
                    String msg = "No entries found for the job chain:" + jobChainName;
                    LOGGER.debug(msg);
                } else {
                    int pos = 0;
                    for (JobChain.OrderHistory.Order historyItem : jobChainHistoryEntries) {
                        if (this.jobHistoryHelper.isInTimeLimit(this.timeLimit, historyItem.getEndTime()) && ("".equals(orderId) || orderId.equals(historyItem.getOrder()))) {
                            ++this.numberOfStarts;
                            boolean isError = this.isErrorNode(jobChainNodes, historyItem.getState());
                            if (historyItem.getEndTime() != null) {
                                ++this.numberOfCompleted;
                                if (this.lastCompletedHistoryEntry == null) {
                                    this.lastCompletedHistoryEntry = historyItem;
                                    this.lastCompletedHistoryEntryPos = pos;
                                    this.lastCompletedHistoryEntryError = isError ? 1 : 0;
                                }
                                if (!isError) {
                                    ++this.numberOfCompletedSuccessful;
                                    if (this.lastCompletedSuccessfullHistoryEntry == null) {
                                        this.lastCompletedSuccessfullHistoryEntry = historyItem;
                                        this.lastCompletedSuccessfullHistoryEntryPos = pos;
                                    }
                                }
                                if (isError) {
                                    ++this.numberOfCompletedWithError;
                                    if (this.lastCompletedWithErrorHistoryEntry == null) {
                                        this.lastCompletedWithErrorHistoryEntry = historyItem;
                                        this.lastCompletedWithErrorHistoryEntryPos = pos;
                                    }
                                }
                            } else if (this.lastRunningHistoryEntry == null) {
                                this.lastRunningHistoryEntry = historyItem;
                                this.lastRunningHistoryEntryPos = pos;
                            }
                        }
                        ++pos;
                    }
                }
            }
        } else {
            throw new JobSchedulerException(lastMsg);
        }
    }

    @Override
    public void setTimeLimit(String timeLimit) {
        this.timeLimit = timeLimit;
    }

    @Override
    public int getNumberOfCompleted() {
        return this.numberOfCompleted;
    }

    @Override
    public int getNumberOfStarts() {
        return this.numberOfStarts;
    }

    @Override
    public int getNumberOfCompletedSuccessful() {
        return this.numberOfCompletedSuccessful;
    }

    @Override
    public int getNumberOfCompletedWithError() {
        return this.numberOfCompletedWithError;
    }

    @Override
    public int getCount() {
        return this.count;
    }

    @Override
    public void setRelativePath(String relativePath_) {
        if (!relativePath_.startsWith("/")) {
            relativePath_ = "/" + relativePath_;
        }
        this.relativePath = relativePath_ = relativePath_.replace('\\', '/');
    }

    @Override
    public String getActHistoryObjectName() {
        return this.actHistoryObjectName;
    }
}

