/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.dailyplan.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.classes.UtcTimeHelper;
import com.sos.hibernate.exceptions.SOSHibernateObjectOperationException;
import com.sos.jitl.dailyplan.db.DailyPlanDBItem;
import com.sos.jitl.dailyplan.db.DailyPlanDBLayer;
import com.sos.jitl.dailyplan.db.DailyPlanWithReportExecutionDBItem;
import com.sos.jitl.dailyplan.db.DailyPlanWithReportTriggerDBItem;
import com.sos.jitl.dailyplan.job.CheckDailyPlanOptions;
import com.sos.jitl.reporting.db.DBItemReportTask;
import com.sos.jitl.reporting.db.DBItemReportTrigger;
import com.sos.jitl.reporting.db.DBLayerReporting;
import com.sos.jitl.reporting.db.ReportTaskExecutionsDBLayer;
import com.sos.jitl.reporting.db.ReportTriggerDBLayer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.TimeZone;
import org.hibernate.StaleStateException;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDuration;
import sos.util.SOSDurations;

public class DailyPlanAdjustment {
    private static final Logger LOGGER = LoggerFactory.getLogger(DailyPlanAdjustment.class);
    private DailyPlanDBLayer dailyPlanDBLayer;
    private ReportTaskExecutionsDBLayer dailyPlanTaskExecutionsDBLayer;
    private ReportTriggerDBLayer dailyPlanTriggerDbLayer;
    private String dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
    private String schedulerId;
    private Date from;
    private Date to;
    private int dayOffset;
    private CheckDailyPlanOptions options = null;
    private boolean dailyPlanUpdated = false;
    private HashMap<Long, String> reportExecutions;
    private HashMap<Long, String> reportTriggers;
    DBLayerReporting dbLayerReporting;

    public DailyPlanAdjustment(SOSHibernateSession sosHibernateSession) throws Exception {
        this.dailyPlanDBLayer = new DailyPlanDBLayer(sosHibernateSession);
        this.dailyPlanTaskExecutionsDBLayer = new ReportTaskExecutionsDBLayer(this.dailyPlanDBLayer.getSession());
        this.dailyPlanTriggerDbLayer = new ReportTriggerDBLayer(this.dailyPlanDBLayer.getSession());
        this.dbLayerReporting = new DBLayerReporting(this.dailyPlanDBLayer.getSession());
    }

    public void beginTransaction() throws Exception {
        if (this.dailyPlanDBLayer.getSession() == null) {
            throw new Exception("session is null");
        }
        this.dailyPlanDBLayer.getSession().beginTransaction();
    }

    public void commit() throws Exception {
        this.dailyPlanDBLayer.getSession().commit();
    }

    public void rollback() throws Exception {
        this.dailyPlanDBLayer.getSession().rollback();
    }

    public void closeSession() throws Exception {
        this.dailyPlanDBLayer.getSession().close();
    }

    private void initHashMaps() throws Exception {
        if (this.reportExecutions == null) {
            this.reportExecutions = new HashMap();
            this.reportTriggers = new HashMap();
            this.dailyPlanDBLayer.setWhereSchedulerId(this.schedulerId);
            this.dailyPlanDBLayer.setWhereFrom(this.from);
            this.dailyPlanDBLayer.setWhereTo(this.to);
            List<DailyPlanDBItem> dailyPlanList = this.dailyPlanDBLayer.getDailyPlanList(-1, false);
            for (DailyPlanDBItem dailyPlanDBItem : dailyPlanList) {
                if (dailyPlanDBItem.isOrderJob()) {
                    this.reportTriggers.put(dailyPlanDBItem.getReportTriggerId(), dailyPlanDBItem.getIdentifier());
                    continue;
                }
                this.reportExecutions.put(dailyPlanDBItem.getReportExecutionId(), dailyPlanDBItem.getIdentifier());
            }
        }
    }

    private boolean reportExecutionIsAssigned(DBItemReportTask dbItemReportTask) throws Exception {
        this.initHashMaps();
        return this.reportExecutions.get(dbItemReportTask.getId()) != null;
    }

    private boolean reportTriggerIsAssigned(DBItemReportTrigger dbItemReportTrigger) throws Exception {
        this.initHashMaps();
        return this.reportTriggers.get(dbItemReportTrigger.getId()) != null;
    }

    private void adjustDailyPlanStandaloneItem(DailyPlanWithReportExecutionDBItem dailyPlanWithReportExecutionDBItem, List<DBItemReportTask> reportTaskList) throws Exception {
        String planState;
        String actState;
        LOGGER.debug(String.format("%s records in reportTaskList", reportTaskList.size()));
        boolean late = dailyPlanWithReportExecutionDBItem.getExecutionState().isLate();
        if (late && dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().isStandalone() && !dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().getIsLate().booleanValue() && !dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().getIsAssigned().booleanValue()) {
            dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().setIsLate(late);
            try {
                this.dailyPlanDBLayer.getSession().update((Object)dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem());
                this.dailyPlanUpdated = true;
            }
            catch (SOSHibernateObjectOperationException e) {
                this.dailyPlanDBLayer.getSession().rollback();
                this.dailyPlanDBLayer.getSession().beginTransaction();
            }
        }
        if (!(actState = dailyPlanWithReportExecutionDBItem.getExecutionState().getState()).equals(planState = dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().getState()) && dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().isStandalone() && dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().getIsAssigned().booleanValue() && "INCOMPLETE".equals(planState)) {
            try {
                dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().setState(actState);
                this.dailyPlanDBLayer.getSession().update((Object)dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem());
                this.dailyPlanUpdated = true;
            }
            catch (SOSHibernateObjectOperationException e) {
                this.dailyPlanDBLayer.getSession().rollback();
                this.dailyPlanDBLayer.getSession().beginTransaction();
            }
        }
        for (int i = 0; i < reportTaskList.size(); ++i) {
            DBItemReportTask dbItemReportTask = reportTaskList.get(i);
            if (this.reportExecutionIsAssigned(dbItemReportTask) || !dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().isStandalone() || !dailyPlanWithReportExecutionDBItem.isEqual(dbItemReportTask)) continue;
            LOGGER.debug(String.format("... assign %s to %s", dbItemReportTask.getId(), dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().getJobName()));
            dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().setReportExecutionId(dbItemReportTask.getId());
            dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().setIsAssigned(true);
            dailyPlanWithReportExecutionDBItem.setDbItemReportExecution(reportTaskList.get(i));
            dailyPlanWithReportExecutionDBItem.setExecutionState(null);
            dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().setIsLate(dailyPlanWithReportExecutionDBItem.getExecutionState().isLate());
            dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().setState(dailyPlanWithReportExecutionDBItem.getExecutionState().getState());
            this.reportExecutions.put(dbItemReportTask.getId(), dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().getIdentifier());
            if (!dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().getPlannedStart().before(dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().getExpectedEnd())) {
                SOSDurations sosDurations = new SOSDurations();
                SOSDuration sosDuration = new SOSDuration();
                sosDuration.setStartTime(dbItemReportTask.getStartTime());
                sosDuration.setEndTime(dbItemReportTask.getEndTime());
                sosDurations.add(sosDuration);
                dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().setExpectedEnd(new Date(dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem().getPlannedStart().getTime() + sosDurations.average()));
            }
            try {
                this.dailyPlanDBLayer.getSession().update((Object)dailyPlanWithReportExecutionDBItem.getDailyPlanDbItem());
                this.dailyPlanUpdated = true;
            }
            catch (SOSHibernateObjectOperationException e) {
                this.dailyPlanDBLayer.getSession().rollback();
                this.dailyPlanDBLayer.getSession().beginTransaction();
            }
            break;
        }
    }

    private void adjustDailyPlanOrderItem(DailyPlanWithReportTriggerDBItem dailyPlanWithReportTriggerDBItem, List<DBItemReportTrigger> dbItemReportTriggerList) throws Exception {
        String planState;
        String actState;
        LOGGER.debug(String.format("%s records in dbItemReportTriggerList", dbItemReportTriggerList.size()));
        boolean late = dailyPlanWithReportTriggerDBItem.getExecutionState().isLate();
        if (late && dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().isOrderJob() && !dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getIsLate().booleanValue() && !dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getIsAssigned().booleanValue()) {
            dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().setIsLate(late);
            try {
                this.dailyPlanDBLayer.getSession().update((Object)dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem());
                this.dailyPlanUpdated = true;
            }
            catch (SOSHibernateObjectOperationException e) {
                this.dailyPlanDBLayer.getSession().rollback();
                this.dailyPlanDBLayer.getSession().beginTransaction();
            }
        }
        if (!(actState = dailyPlanWithReportTriggerDBItem.getExecutionState().getState()).equals(planState = dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getState()) && dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().isOrderJob() && dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getIsAssigned().booleanValue() && "INCOMPLETE".equals(dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getState())) {
            try {
                dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().setState(dailyPlanWithReportTriggerDBItem.getExecutionState().getState());
                this.dailyPlanDBLayer.getSession().update((Object)dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem());
                this.dailyPlanUpdated = true;
            }
            catch (SOSHibernateObjectOperationException e) {
                this.dailyPlanDBLayer.getSession().rollback();
                this.dailyPlanDBLayer.getSession().beginTransaction();
            }
        }
        for (DBItemReportTrigger dbItemReportTrigger : dbItemReportTriggerList) {
            if (this.reportTriggerIsAssigned(dbItemReportTrigger) || !dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().isOrderJob() || !dailyPlanWithReportTriggerDBItem.isEqual(dbItemReportTrigger)) continue;
            LOGGER.debug(String.format("... assign %s to %s/%s", dbItemReportTrigger.getHistoryId(), dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getJobChainNotNull(), dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getOrderId()));
            dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().setReportTriggerId(dbItemReportTrigger.getId());
            dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().setIsAssigned(true);
            dailyPlanWithReportTriggerDBItem.setDbItemReportTrigger(dbItemReportTrigger);
            dailyPlanWithReportTriggerDBItem.setExecutionState(null);
            dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().setIsLate(dailyPlanWithReportTriggerDBItem.getExecutionState().isLate());
            dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().setState(dailyPlanWithReportTriggerDBItem.getExecutionState().getState());
            this.reportTriggers.put(dbItemReportTrigger.getId(), dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getIdentifier());
            if (!dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getPlannedStart().before(dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getExpectedEnd())) {
                SOSDurations sosDurations = new SOSDurations();
                SOSDuration sosDuration = new SOSDuration();
                sosDuration.setStartTime(dbItemReportTrigger.getStartTime());
                sosDuration.setEndTime(dbItemReportTrigger.getEndTime());
                sosDurations.add(sosDuration);
                dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().setExpectedEnd(new Date(dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem().getPlannedStart().getTime() + sosDurations.average()));
            }
            try {
                try {
                    this.dailyPlanDBLayer.getSession().update((Object)dailyPlanWithReportTriggerDBItem.getDailyPlanDbItem());
                    this.dailyPlanUpdated = true;
                }
                catch (SOSHibernateObjectOperationException sosDurations) {
                }
            }
            catch (StaleStateException e) {
                this.dailyPlanDBLayer.getSession().rollback();
                this.dailyPlanDBLayer.getSession().beginTransaction();
            }
            break;
        }
    }

    public void adjustWithHistory() throws Exception {
        try {
            this.beginTransaction();
            String toTimeZoneString = "UTC";
            String fromTimeZoneString = DateTimeZone.getDefault().getID();
            this.from = UtcTimeHelper.convertTimeZonesToDate((String)fromTimeZoneString, (String)toTimeZoneString, (DateTime)new DateTime((Object)this.from));
            this.to = UtcTimeHelper.convertTimeZonesToDate((String)fromTimeZoneString, (String)toTimeZoneString, (DateTime)new DateTime((Object)this.to));
            LOGGER.debug(String.format("reading from: %s to %s", this.from, this.to));
            this.dailyPlanDBLayer.setWhereSchedulerId(this.schedulerId);
            this.dailyPlanDBLayer.setWhereFrom(this.from);
            this.dailyPlanDBLayer.setWhereTo(this.to);
            this.dailyPlanDBLayer.getFilter().setOrderCriteria("p.job,p.plannedStart");
            this.dailyPlanDBLayer.getFilter().setSortMode("desc");
            this.dailyPlanDBLayer.getFilter().setOrderCriteria("p.jobChain,p.plannedStart");
            List<DailyPlanWithReportTriggerDBItem> dailyPlanOrderList = this.dailyPlanDBLayer.getWaitingDailyPlanOrderList(-1);
            this.dailyPlanDBLayer.getFilter().setOrderCriteria("p.job,p.plannedStart");
            List<DailyPlanWithReportExecutionDBItem> dailyPlanStandaloneList = this.dailyPlanDBLayer.getWaitingDailyPlanStandaloneList(-1);
            this.dailyPlanTaskExecutionsDBLayer.getFilter().setLimit(-1);
            this.dailyPlanTaskExecutionsDBLayer.getFilter().setExecutedFrom(this.from);
            this.dailyPlanTaskExecutionsDBLayer.getFilter().setExecutedTo(this.to);
            this.dailyPlanTriggerDbLayer.getFilter().setLimit(-1);
            this.dailyPlanTriggerDbLayer.getFilter().setExecutedFrom(this.from);
            this.dailyPlanTriggerDbLayer.getFilter().setExecutedTo(this.to);
            List<DBItemReportTask> dbItemReportTaskList = null;
            List<DBItemReportTrigger> dbItemReportTriggerList = null;
            this.commit();
            this.beginTransaction();
            String lastJobChain = "";
            for (int i = 0; i < dailyPlanOrderList.size(); ++i) {
                DailyPlanWithReportTriggerDBItem dailyPlanWithReportTriggerItem = dailyPlanOrderList.get(i);
                String orderId = dailyPlanWithReportTriggerItem.getDailyPlanDbItem().getOrderId();
                String jobChain = dailyPlanWithReportTriggerItem.getDailyPlanDbItem().getJobChain();
                String s = String.format("%s(%s)", jobChain, orderId);
                if (!lastJobChain.equals(s)) {
                    this.dailyPlanTriggerDbLayer.getFilter().setSchedulerId(this.schedulerId);
                    this.dailyPlanTriggerDbLayer.getFilter().setOrderId(orderId);
                    this.dailyPlanTriggerDbLayer.getFilter().setJobChain(jobChain);
                    dbItemReportTriggerList = this.dailyPlanTriggerDbLayer.getSchedulerOrderHistoryListFromTo();
                    lastJobChain = String.format("%s(%s)", jobChain, orderId);
                }
                this.adjustDailyPlanOrderItem(dailyPlanWithReportTriggerItem, dbItemReportTriggerList);
            }
            String lastJob = "";
            for (int i = 0; i < dailyPlanStandaloneList.size(); ++i) {
                DailyPlanWithReportExecutionDBItem dailyPlanWithReportExecutionItem = dailyPlanStandaloneList.get(i);
                String jobName = dailyPlanWithReportExecutionItem.getDailyPlanDbItem().getJobName();
                if (!lastJob.equals(jobName)) {
                    this.dailyPlanTaskExecutionsDBLayer.getFilter().setSchedulerId(this.schedulerId);
                    this.dailyPlanTaskExecutionsDBLayer.getFilter().addJobPath(jobName);
                    dbItemReportTaskList = this.dailyPlanTaskExecutionsDBLayer.getSchedulerHistoryListFromTo();
                    lastJob = jobName;
                }
                this.adjustDailyPlanStandaloneItem(dailyPlanWithReportExecutionItem, dbItemReportTaskList);
            }
            this.commit();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.rollback();
            throw e;
        }
    }

    private void setFrom() throws ParseException {
        TimeZone.setDefault(TimeZone.getTimeZone(DateTimeZone.getDefault().getID()));
        Date now = new Date();
        if (this.dayOffset < 0) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(now);
            calendar.add(5, this.dayOffset);
            now = calendar.getTime();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String froms = formatter.format(now);
        froms = froms + "T00:00:00";
        formatter = new SimpleDateFormat(this.dateFormat);
        this.from = formatter.parse(froms);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    private void setTo() throws ParseException {
        TimeZone.setDefault(TimeZone.getTimeZone(DateTimeZone.getDefault().getID()));
        Date now = new Date();
        if (this.dayOffset > 0) {
            GregorianCalendar calendar = new GregorianCalendar();
            calendar.setTime(now);
            calendar.add(5, this.dayOffset);
            now = calendar.getTime();
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        String tos = formatter.format(now);
        tos = tos + "T23:59:59";
        formatter = new SimpleDateFormat(this.dateFormat);
        this.to = formatter.parse(tos);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
    }

    public Date getFrom() {
        return this.from;
    }

    public Date getTo() {
        return this.to;
    }

    public void setOptions(CheckDailyPlanOptions options) throws ParseException {
        this.options = options;
        this.schedulerId = this.options.getscheduler_id().getValue();
        this.dayOffset = this.options.getdayOffset().value();
        this.setFrom();
        this.setTo();
    }

    public void setTo(Date to) {
        this.to = to;
    }

    public boolean isDailyPlanUpdated() {
        return this.dailyPlanUpdated;
    }
}

