/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.dailyplan.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.dailyplan.db.DailyPlanDate;
import java.math.BigInteger;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hibernate.annotations.Type;

@Entity
@Table(name="DAILY_PLAN")
@SequenceGenerator(name="DAILY_PLAN_ID_SEQ", sequenceName="DAILY_PLAN_ID_SEQ", allocationSize=1)
public class DailyPlanDBItem
extends DbItem {
    private Long id;
    private String schedulerId;
    private String job;
    private String jobStream;
    private String jobChain;
    private String orderId;
    private Long jobStreamStarterId;
    private Date plannedStart;
    private Date expectedEnd;
    private Date periodBegin;
    private Date periodEnd;
    private boolean startStart;
    private Long repeatInterval;
    private boolean isAssigned;
    private boolean isLate;
    private String state;
    private Date created;
    private Date modified;
    private Long reportTriggerId;
    private Long reportExecutionId;
    private Long auditLogId;
    private String dateFormat = "yyyy-MM-dd hh:mm";

    public DailyPlanDBItem(String dateFormat_) {
        this.dateFormat = dateFormat_;
    }

    public DailyPlanDBItem() {
    }

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="DAILY_PLAN_ID_SEQ")
    @Column(name="[ID]")
    public Long getId() {
        return this.id;
    }

    @Column(name="[ID]")
    public void setId(Long id) {
        this.id = id;
    }

    @Column(name="[SCHEDULER_ID]", nullable=false)
    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }

    @Column(name="[SCHEDULER_ID]", nullable=false)
    public String getSchedulerId() {
        return this.schedulerId;
    }

    @Column(name="[JOB]", nullable=false)
    public void setJob(String job) {
        if (job == null) {
            job = ".";
        }
        this.job = job;
    }

    @Column(name="[JOB]", nullable=false)
    public String getJob() {
        return this.job;
    }

    @Column(name="[JOBSTREAM]", nullable=true)
    public void setJobStream(String jobStream) {
        this.jobStream = jobStream;
    }

    @Column(name="[JOBSTREAM]", nullable=true)
    public String getJobStream() {
        return this.jobStream;
    }

    @Column(name="[STATE]", nullable=true)
    public void setState(String state) {
        this.state = state;
    }

    @Column(name="[STATE]", nullable=true)
    public String getState() {
        return this.state;
    }

    @Column(name="[ORDER_ID]", nullable=false)
    public void setOrderId(String orderId) {
        if (orderId == null) {
            orderId = ".";
        }
        this.orderId = orderId;
    }

    @Column(name="[ORDER_ID]", nullable=false)
    public String getOrderId() {
        return this.orderId;
    }

    @Column(name="[JOB_CHAIN]", nullable=false)
    public void setJobChain(String jobChain) {
        if (jobChain == null) {
            jobChain = ".";
        }
        this.jobChain = jobChain;
    }

    @Column(name="[JOB_CHAIN]", nullable=false)
    public String getJobChain() {
        return this.jobChain;
    }

    @Column(name="[IS_ASSIGNED]", nullable=false)
    @Type(type="numeric_boolean")
    public void setIsAssigned(Boolean isAssigned) {
        this.isAssigned = isAssigned;
    }

    @Column(name="[IS_ASSIGNED]", nullable=false)
    @Type(type="numeric_boolean")
    public Boolean getIsAssigned() {
        return this.isAssigned;
    }

    @Column(name="[IS_LATE]", nullable=false)
    @Type(type="numeric_boolean")
    public void setIsLate(Boolean isLate) {
        this.isLate = isLate;
    }

    @Column(name="[IS_LATE]", nullable=false)
    @Type(type="numeric_boolean")
    public Boolean getIsLate() {
        return this.isLate;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[PLANNED_START]", nullable=true)
    public void setPlannedStart(Date plannedStart) {
        this.plannedStart = plannedStart;
    }

    public void nullPlannedStart() {
        this.plannedStart = null;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[PLANNED_START]", nullable=false)
    public Date getPlannedStart() {
        return this.plannedStart;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[EXPECTED_END]", nullable=true)
    public void setExpectedEnd(Date expectedEnd) {
        this.expectedEnd = expectedEnd;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[EXPECTED_END]", nullable=true)
    public Date getExpectedEnd() {
        return this.expectedEnd;
    }

    @Column(name="[REPEAT_INTERVAL]", nullable=true)
    public void setRepeatInterval(Long repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    @Column(name="[REPEAT_INTERVAL]", nullable=true)
    public Long getRepeatInterval() {
        return this.repeatInterval;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[PERIOD_BEGIN]", nullable=true)
    public void setPeriodBegin(Date periodBegin) {
        this.periodBegin = periodBegin;
        this.plannedStart = periodBegin;
    }

    public void nullPeriodBegin() {
        this.periodBegin = null;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[PERIOD_BEGIN]", nullable=true)
    public Date getPeriodBegin() {
        return this.periodBegin;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[PERIOD_END]", nullable=true)
    public void setPeriodEnd(Date periodEnd) {
        this.periodEnd = periodEnd;
    }

    public void nullPeriodEnd() {
        this.periodEnd = null;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[PERIOD_END]", nullable=true)
    public Date getPeriodEnd() {
        return this.periodEnd;
    }

    @Column(name="[START_START]", nullable=true)
    @Type(type="numeric_boolean")
    public void setStartStart(Boolean startStart) {
        this.startStart = startStart;
    }

    @Column(name="[START_START]", nullable=true)
    @Type(type="numeric_boolean")
    public Boolean getStartStart() {
        return this.startStart;
    }

    @Column(name="[REPORT_EXECUTIONS_ID]", nullable=true)
    public void setReportExecutionId(Long reportExecutionId) {
        this.reportExecutionId = reportExecutionId;
    }

    @Column(name="[REPORT_EXECUTIONS_ID]", nullable=true)
    public Long getReportExecutionId() {
        return this.reportExecutionId;
    }

    @Column(name="[REPORT_TRIGGER_ID]", nullable=true)
    public void setReportTriggerId(Long reportTriggerId) {
        this.reportTriggerId = reportTriggerId;
    }

    @Column(name="[REPORT_TRIGGER_ID]", nullable=true)
    public Long getReportTriggerId() {
        return this.reportTriggerId;
    }

    @Column(name="[JOBSTREAM_STARTER_ID]")
    public Long getJobStreamStarterId() {
        return this.jobStreamStarterId;
    }

    @Column(name="[JOBSTREAM_STARTER_ID]")
    public void setJobStreamStarterId(Long jobStreamStarterId) {
        this.jobStreamStarterId = jobStreamStarterId;
    }

    @Column(name="[AUDIT_LOG_ID]", nullable=true)
    public void setAuditLogId(Long val) {
        this.auditLogId = val;
    }

    @Column(name="[AUDIT_LOG_ID]", nullable=true)
    public Long getAuditLogId() {
        return this.auditLogId;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public Date getCreated() {
        return this.created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[CREATED]", nullable=false)
    public void setCreated(Date created) {
        this.created = created;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=true)
    public Date getModified() {
        return this.modified;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="[MODIFIED]", nullable=true)
    public void setModified(Date modified) {
        this.modified = modified;
    }

    @Transient
    public void setPlannedStart(String plannedStart) throws ParseException {
        DailyPlanDate dailyScheduleDate = new DailyPlanDate(this.dateFormat);
        dailyScheduleDate.setSchedule(plannedStart);
        this.setPlannedStart(dailyScheduleDate.getSchedule());
    }

    @Transient
    public void setPeriodBegin(String periodBegin) throws ParseException {
        DailyPlanDate daysScheduleDate = new DailyPlanDate(this.dateFormat);
        daysScheduleDate.setSchedule(periodBegin);
        this.setPeriodBegin(daysScheduleDate.getSchedule());
        this.setPlannedStart(this.getPeriodBegin());
    }

    @Transient
    public void setPeriodEnd(String periodEnd) throws ParseException {
        DailyPlanDate daysScheduleDate = new DailyPlanDate(this.dateFormat);
        daysScheduleDate.setSchedule(periodEnd);
        this.setPeriodEnd(daysScheduleDate.getSchedule());
    }

    @Transient
    public void setRepeatInterval(BigInteger absolutRepeat_, BigInteger repeat_) {
        BigInteger r = BigInteger.ZERO;
        Long l = 0L;
        if (absolutRepeat_ != null && !absolutRepeat_.equals(BigInteger.ZERO)) {
            r = absolutRepeat_;
            this.setStartStart(true);
            if (r != null) {
                l = r.longValue();
            }
        } else {
            r = repeat_;
            this.setStartStart(false);
            if (r != null) {
                l = r.longValue();
            }
        }
        this.setRepeatInterval(l);
    }

    @Transient
    public boolean isOrderJob() {
        return !this.isStandalone();
    }

    @Transient
    public boolean isStandalone() {
        return !"..".equals(this.getJob()) && !".".equals(this.getJob()) && !"".equals(this.getJob()) && (".".equals(this.getJobChain()) || "".equals(this.getJobChain()));
    }

    @Transient
    public String getJobNotNull() {
        return this.null2Blank(this.getJob());
    }

    @Transient
    public String getJobOrNull() {
        if (".".equals(this.job) || "..".equals(this.job)) {
            return null;
        }
        return this.null2Blank(this.getJob());
    }

    @Transient
    public String getJobChainOrNull() {
        if (".".equals(this.jobChain)) {
            return null;
        }
        return this.null2Blank(this.getJobChain());
    }

    @Transient
    public String getOrderIdOrNull() {
        if (".".equals(this.orderId)) {
            return null;
        }
        return this.null2Blank(this.getOrderId());
    }

    @Transient
    public String getOrderIdNotNull() {
        return this.null2Blank(this.getOrderId());
    }

    @Transient
    public String getJobChainNotNull() {
        return this.null2Blank(this.getJobChain());
    }

    @Transient
    public String getJobOrJobchain() {
        if (this.isOrderJob()) {
            return this.null2Blank(String.format("%s(%s)", this.getJobChainNotNull(), this.getOrderIdNotNull()));
        }
        return this.null2Blank(this.getJobNotNull());
    }

    @Transient
    public void setScheduleExecuted(String scheduleExecuted) throws ParseException {
        DailyPlanDate dailyScheduleDate = new DailyPlanDate(this.dateFormat);
        dailyScheduleDate.setSchedule(scheduleExecuted);
        this.setExpectedEnd(dailyScheduleDate.getSchedule());
    }

    @Transient
    public String getPlannedStartIso() {
        if (this.getPlannedStart() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(this.getPlannedStart());
    }

    @Transient
    public String getPlannedStartFormated() {
        return this.getDateFormatted(this.getPlannedStart());
    }

    @Transient
    public String getScheduleExecutedIso() {
        if (this.getExpectedEnd() == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        return formatter.format(this.getExpectedEnd());
    }

    @Transient
    public String getExpectedEndFormated() {
        return this.getDateFormatted(this.getExpectedEnd());
    }

    @Transient
    public Long getLogId() {
        if (this.isOrderJob()) {
            return this.getReportTriggerId();
        }
        return this.getReportExecutionId();
    }

    @Transient
    public String getTitle() {
        if (this.isOrderJob()) {
            return this.getJobChain() + "/" + this.getOrderId();
        }
        return this.getJob();
    }

    @Transient
    public String getIdentifier() {
        if (this.getLogId() != null) {
            return this.getTitle() + this.getLogId().toString();
        }
        return this.getTitle();
    }

    @Transient
    public String getJobName() {
        return this.getJob();
    }

    @Transient
    public String getName() {
        if (this.isStandalone()) {
            return this.getJob();
        }
        return this.getJobChain() + "/" + this.getOrderId();
    }

    @Transient
    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.schedulerId).append((Object)this.job).append((Object)this.jobChain).append((Object)this.orderId).append((Object)this.plannedStart).toHashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof DailyPlanDBItem)) {
            return false;
        }
        DailyPlanDBItem rhs = (DailyPlanDBItem)((Object)other);
        return new EqualsBuilder().append((Object)this.schedulerId, (Object)rhs.schedulerId).append((Object)this.job, (Object)rhs.job).append((Object)this.jobChain, (Object)rhs.jobChain).append((Object)this.orderId, (Object)rhs.orderId).append((Object)this.plannedStart, (Object)rhs.plannedStart).isEquals();
    }
}

