/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventing.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.hibernate.classes.SOSHibernateIntervalFilter;
import com.sos.hibernate.classes.UtcTimeHelper;
import com.sos.hibernate.interfaces.ISOSHibernateFilter;
import com.sos.jitl.reporting.helper.ReportUtil;
import com.sos.joc.model.job.JobPath;
import com.sos.joc.model.order.OrderPath;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;

public class SchedulerEventFilter
extends SOSHibernateIntervalFilter
implements ISOSHibernateFilter {
    private static final String EXPIRES_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static final String NEVER_DATE = "2999-01-01 00:00:00";
    private static final Logger LOGGER = LoggerFactory.getLogger(SchedulerEventFilter.class);
    private int limit = 0;
    private String filterTimezone;
    private String remoteUrl;
    private String remoteSchedulerHost;
    private String conditon;
    private Integer remoteSchedulerPort;
    private String jobChain;
    private String orderId;
    private String jobName;
    private String eventClass;
    private String eventId;
    private Integer exitCode;
    private Calendar expirationDate;
    private Date created;
    private String expirationPeriod = "24:00:00";
    private String expirationCycle = "";
    private Date expiresFrom;
    private Date expiresTo;
    private String parametersAsString;
    private String schedulerId = "";
    private boolean schedulerIdEmpty = false;
    private List<String> listOfEventClasses;
    private List<String> listOfEventIds;
    private List<Integer> listOfExitCodes;
    private List<OrderPath> listOfOrders;
    private List<JobPath> listOfJobs;
    private List<Long> listOfIds;

    public void setFilterTimezone(String filterTimezone) {
        this.filterTimezone = filterTimezone;
    }

    public int getLimit() {
        return this.limit;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public SchedulerEventFilter() {
        this.resetFilter();
    }

    public boolean hasEventClasses() {
        return this.listOfEventClasses != null && !this.listOfEventClasses.isEmpty();
    }

    public boolean hasIds() {
        return this.listOfIds != null && !this.listOfIds.isEmpty();
    }

    public boolean hasEventIds() {
        return this.listOfEventIds != null && !this.listOfEventIds.isEmpty();
    }

    public boolean hasExitCodes() {
        return this.listOfExitCodes != null && !this.listOfExitCodes.isEmpty();
    }

    public boolean hasOrders() {
        return this.listOfOrders != null && !this.listOfOrders.isEmpty();
    }

    public boolean hasJobs() {
        return this.listOfJobs != null && !this.listOfJobs.isEmpty();
    }

    public String getTitle() {
        String s = "";
        if (this.remoteSchedulerHost != null && !"".equals(this.remoteSchedulerHost)) {
            s = s + String.format("RemoteScheduler: %s:%s ", this.remoteSchedulerHost, this.remoteSchedulerPort);
        }
        if (this.schedulerId != null && !"".equals(this.schedulerId)) {
            s = s + String.format("Scheduler Id: %s ", this.schedulerId);
        }
        if (this.jobChain != null && !"".equals(this.jobChain)) {
            s = s + String.format("JobChain: %s ", this.jobChain);
        }
        if (this.jobName != null && !"".equals(this.jobName)) {
            s = s + String.format("JobName: %s ", this.jobName);
        }
        if (this.eventClass != null && !"".equals(this.eventClass)) {
            s = s + String.format("Class: %s ", this.eventClass);
        }
        if (this.eventId != null && !"".equals(this.eventId)) {
            s = s + String.format("Id: %s ", this.eventId);
        }
        if (this.exitCode != null) {
            s = s + String.format("Exit: %s ", this.exitCode);
        }
        return String.format("%1s", s);
    }

    public String getUtcTimeAsString(String expiresLocal) {
        if ("UTC".equalsIgnoreCase(this.filterTimezone)) {
            return expiresLocal;
        }
        String fromTimeZoneString = DateTimeZone.getDefault().getID();
        String toTimeZoneString = "UTC";
        DateTimeFormatter formatter = DateTimeFormat.forPattern((String)EXPIRES_DATE_FORMAT);
        DateTime now = formatter.parseDateTime(expiresLocal);
        DateTimeZone fromZone = DateTimeZone.forID((String)fromTimeZoneString);
        String expiresUtc = UtcTimeHelper.convertTimeZonesToString((String)EXPIRES_DATE_FORMAT, (String)fromTimeZoneString, (String)toTimeZoneString, (DateTime)now.withZone(fromZone));
        return expiresUtc;
    }

    public Calendar calculateExpirationDate() throws Exception {
        Calendar cal = Calendar.getInstance();
        String nowLocal = SOSDate.getCurrentTimeAsString();
        String nowUtc = this.getUtcTimeAsString(nowLocal);
        SimpleDateFormat format = new SimpleDateFormat(EXPIRES_DATE_FORMAT);
        Date now = format.parse(nowUtc);
        cal.setTime(now);
        if (this.expirationCycle.indexOf(":") > -1) {
            String[] timeArray = this.expirationCycle.split(":");
            int hours = Integer.parseInt(timeArray[0]);
            int minutes = Integer.parseInt(timeArray[1]);
            int seconds = 0;
            if (timeArray.length > 2) {
                seconds = Integer.parseInt(timeArray[2]);
            }
            cal.set(11, hours);
            cal.set(12, minutes);
            cal.set(13, seconds);
            Calendar calNow = Calendar.getInstance();
            calNow.setTime(now);
            if (calNow.after(cal)) {
                cal.add(5, 1);
            }
        } else if (this.expirationPeriod.indexOf(":") > -1) {
            String[] timeArray = this.expirationPeriod.split(":");
            int hours = Integer.parseInt(timeArray[0]);
            int minutes = Integer.parseInt(timeArray[1]);
            int seconds = 0;
            if (timeArray.length > 2) {
                seconds = Integer.parseInt(timeArray[2]);
            }
            if (hours > 0) {
                cal.add(11, hours);
            }
            if (minutes > 0) {
                cal.add(12, minutes);
            }
            if (seconds > 0) {
                cal.add(13, seconds);
            }
        } else if (!this.expirationPeriod.isEmpty()) {
            cal.add(13, Integer.parseInt(this.expirationPeriod));
        }
        return cal;
    }

    public void setIntervalFromDate(Date d) {
        this.expiresFrom = d;
    }

    public void setExpiresFrom(Date d) {
        this.expiresFrom = d;
    }

    public void setIntervalToDate(Date d) {
        this.expiresTo = d;
    }

    public void setExpiresTo(Date d) {
        this.expiresTo = d;
    }

    public Date getExpiresTo() {
        return this.expiresTo;
    }

    public Date getExpires() {
        if (this.expiresTo == null) {
            this.expiresTo = this.expirationDate.getTime();
        }
        return this.expiresTo;
    }

    public Date getExpiresFrom() {
        return this.expiresFrom;
    }

    public void setIntervalFromDateIso(String s) {
    }

    public void setIntervalToDateIso(String s) {
    }

    public void setExpires(Date d) {
        this.expiresTo = d;
        this.expiresFrom = null;
    }

    public String getRemoteSchedulerHost() {
        return this.remoteSchedulerHost;
    }

    public void setRemoteSchedulerHost(String remoteSchedulerHost) {
        this.remoteSchedulerHost = remoteSchedulerHost;
    }

    public Integer getRemoteSchedulerPort() {
        return this.remoteSchedulerPort;
    }

    public void setRemoteSchedulerPort(Integer remoteSchedulerPort) {
        this.remoteSchedulerPort = remoteSchedulerPort;
    }

    public void setRemoteSchedulerPort(String remoteSchedulerPort) {
        try {
            this.remoteSchedulerPort = Integer.parseInt(remoteSchedulerPort);
        }
        catch (NumberFormatException e) {
            this.remoteSchedulerPort = null;
        }
    }

    public String getJobChain() {
        return this.jobChain;
    }

    public void setJobChain(String jobChain) {
        this.jobChain = jobChain;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public void setOrderId(String orderId) {
        this.orderId = orderId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getEventClass() {
        return this.eventClass;
    }

    public void setEventClass(String eventClass) {
        this.eventClass = eventClass;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public String getSchedulerId() {
        return this.schedulerId;
    }

    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }

    public String getConditon() {
        return this.conditon;
    }

    public void setConditon(String conditon) {
        this.conditon = conditon;
    }

    public String getRemoteUrl() {
        return this.remoteUrl;
    }

    public void setRemoteUrl(String remoteUrl) {
        this.remoteUrl = remoteUrl;
    }

    public void setSchedulerIdEmpty(boolean schedulerIdEmpty) {
        this.schedulerIdEmpty = schedulerIdEmpty;
    }

    public boolean isSchedulerIdEmpty() {
        return this.schedulerIdEmpty;
    }

    public void setEventClasses(List<String> eventClasses) {
        this.listOfEventClasses = eventClasses;
    }

    public void setExitCodes(List<Integer> exitCodes) {
        this.listOfExitCodes = exitCodes;
    }

    public void setEventIds(List<String> eventIds) {
        this.listOfEventIds = eventIds;
    }

    public void setOrders(List<OrderPath> orders) {
        this.listOfOrders = orders;
    }

    public void setJobs(List<JobPath> jobs) {
        this.listOfJobs = jobs;
    }

    public List<String> getListOfEventClasses() {
        return this.listOfEventClasses;
    }

    public List<String> getListOfEventIds() {
        return this.listOfEventIds;
    }

    public List<Integer> getListOfExitCodes() {
        return this.listOfExitCodes;
    }

    public List<OrderPath> getListOfOrders() {
        return this.listOfOrders;
    }

    public List<JobPath> getListOfJobs() {
        return this.listOfJobs;
    }

    public List<String> getListOfJobNames() {
        ArrayList<String> l = new ArrayList<String>();
        for (JobPath job : this.listOfJobs) {
            l.add(job.getJob());
        }
        return l;
    }

    public List<Long> getListOfIds() {
        return this.listOfIds;
    }

    public void setIds(List<Long> ids) {
        this.listOfIds = ids;
    }

    public boolean isFiltered(DbItem h) {
        return false;
    }

    public Calendar getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationPeriod(String expirationPeriod) throws Exception {
        this.expirationPeriod = expirationPeriod;
        this.expirationDate = this.calculateExpirationDate();
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public void setExpirationCycle(String expirationCycle) throws Exception {
        this.expirationCycle = expirationCycle;
        this.expirationDate = this.calculateExpirationDate();
    }

    public String getParametersAsString() {
        return this.parametersAsString;
    }

    public void setParametersAsString(String parametersAsString) {
        this.parametersAsString = parametersAsString;
    }

    public void setExitCode(String exitCode) {
        try {
            this.exitCode = Integer.parseInt(exitCode);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("could not set exitCode: " + exitCode);
        }
    }

    public void setExpires(String expires) throws Exception {
        if (expires != null && !expires.isEmpty()) {
            if ("never".equalsIgnoreCase(expires)) {
                this.setExpires(ReportUtil.getDateFromString(NEVER_DATE));
            } else if ("now_utc".equalsIgnoreCase(expires)) {
                String nowLocal = SOSDate.getCurrentTimeAsString();
                String nowUtc = this.getUtcTimeAsString(nowLocal);
                SimpleDateFormat format = new SimpleDateFormat(EXPIRES_DATE_FORMAT);
                Date now = format.parse(nowUtc);
                this.setExpires(now);
            } else {
                expires = expires.replaceAll("T", " ").replaceAll(".000", "");
                Date utcDate = SOSDate.getTime((String)expires, (String)EXPIRES_DATE_FORMAT);
                this.setExpires(utcDate);
            }
            LOGGER.debug(".. parameter [expires]: " + expires);
            LOGGER.debug(".. --> eventExpires:" + this.getExpires());
        }
    }

    public void resetFilter() {
        this.setDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
        this.setOrderCriteria("id");
        this.setSortMode("desc");
        this.limit = 0;
    }
}

