/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventing.eventhandler;

import com.sos.jitl.eventing.db.SchedulerEventDBItem;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SchedulerEvent {
    private String eventName;
    private String eventTitle;
    private String eventClass;
    private String eventId;
    private String jobName;
    private String jobChain;
    private String orderId;
    private String exitCode;
    private String created;
    private String expires;
    private String remoteSchedulerHost;
    private String remoteSchedulerPort;
    private String schedulerId;
    private String condition = "";
    private String comment = "";

    public SchedulerEvent(SchedulerEventDBItem schedulerEventDBItem) {
        this.created = schedulerEventDBItem.getCreatedAsString();
        this.eventClass = schedulerEventDBItem.getEventClass();
        this.eventId = schedulerEventDBItem.getEventId();
        this.eventClass = schedulerEventDBItem.getEventClass();
        this.exitCode = schedulerEventDBItem.getExitCodeAsString();
        this.expires = schedulerEventDBItem.getExpiresAsString();
        this.jobChain = schedulerEventDBItem.getJobChain();
        this.jobName = schedulerEventDBItem.getJobName();
        this.orderId = schedulerEventDBItem.getOrderId();
        this.remoteSchedulerHost = schedulerEventDBItem.getRemoteSchedulerHost();
        this.remoteSchedulerPort = schedulerEventDBItem.getRemoteSchedulerPortAsString();
        this.schedulerId = schedulerEventDBItem.getSchedulerId();
    }

    public SchedulerEvent() {
    }

    public String getEventTitle() {
        return this.eventTitle;
    }

    public String getEventClass() {
        return this.eventClass;
    }

    public String getEventId() {
        return this.eventId;
    }

    public String getJobName() {
        return this.jobName;
    }

    public String getJobChain() {
        return this.jobChain;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getExitCode() {
        return this.exitCode;
    }

    public String getCreated() {
        return this.created;
    }

    public String getExpires() {
        return this.expires;
    }

    public String getRemoteSchedulerHost() {
        return this.remoteSchedulerHost;
    }

    public String getRemoteSchedulerPort() {
        return this.remoteSchedulerPort;
    }

    public String getSchedulerId() {
        return this.schedulerId;
    }

    private String getText(Node n) {
        if (n != null) {
            return n.getNodeValue();
        }
        return "";
    }

    private String getTextDefault(String d, Node n) {
        if (n != null) {
            return n.getNodeValue();
        }
        return d;
    }

    public void setProperties(NamedNodeMap attr) {
        this.eventClass = this.getTextDefault("", attr.getNamedItem("event_class"));
        this.eventId = this.getText(attr.getNamedItem("event_id"));
        this.jobName = this.getText(attr.getNamedItem("job_name"));
        this.jobChain = this.getText(attr.getNamedItem("job_chain"));
        this.orderId = this.getText(attr.getNamedItem("order_id"));
        this.exitCode = this.getText(attr.getNamedItem("exit_code"));
        this.created = this.getText(attr.getNamedItem("created"));
        this.expires = this.getText(attr.getNamedItem("expires"));
        this.comment = this.getText(attr.getNamedItem("comment"));
        this.schedulerId = this.getText(attr.getNamedItem("scheduler_id"));
        this.remoteSchedulerHost = this.getText(attr.getNamedItem("remote_scheduler_host"));
        this.remoteSchedulerPort = this.getText(attr.getNamedItem("remote_scheduler_port"));
    }

    public void setEventClassIfBlank(String eClass) {
        if ("".equals(this.eventClass)) {
            this.eventClass = eClass;
        }
    }

    public String getCondition() {
        return this.condition;
    }

    private HashMap<String, String> properties() {
        HashMap<String, String> attr = new HashMap<String, String>();
        attr.put("event_title", this.eventTitle);
        attr.put("event_class", this.eventClass);
        attr.put("event_id", this.eventId);
        attr.put("job_name", this.jobName);
        attr.put("job_chain", this.jobChain);
        attr.put("order_id", this.orderId);
        attr.put("exit_code", this.exitCode);
        attr.put("remote_scheduler_host", this.remoteSchedulerHost);
        attr.put("remote_scheduler_port", this.remoteSchedulerPort);
        attr.put("scheduler_id", this.schedulerId);
        return attr;
    }

    public boolean isEqual(SchedulerEvent eActive) {
        boolean erg = true;
        Iterator<String> iProperties = this.properties().keySet().iterator();
        while (iProperties.hasNext()) {
            String trigger = iProperties.next().toString();
            if ("".equals(this.properties().get(trigger)) || eActive.properties().get(trigger) == null || "expires".equalsIgnoreCase(trigger) || "created".equalsIgnoreCase(trigger) || eActive.properties().get(trigger).equals(this.properties().get(trigger))) continue;
            erg = false;
        }
        return erg;
    }

    public boolean isIn(List<SchedulerEvent> listOfActiveEvents) {
        boolean erg = false;
        Iterator<SchedulerEvent> i = listOfActiveEvents.iterator();
        while (i.hasNext() && !erg) {
            if (!this.isEqual(i.next())) continue;
            erg = true;
        }
        return erg;
    }

    public void setEvent_name(String eventName) {
        this.eventName = eventName;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getComment() {
        return this.comment;
    }

    public String getEventName() {
        if ("".equals(this.eventName)) {
            if ("".equals(this.eventClass)) {
                return this.eventId;
            }
            return this.eventClass + "." + this.eventId;
        }
        return this.eventName;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setExpires(String expires) {
        this.expires = expires;
    }
}

