/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.eventing.eventhandler;

import com.sos.jitl.eventing.db.SchedulerEventDBItem;
import com.sos.jitl.eventing.eventhandler.SOSActions;
import com.sos.jitl.eventing.eventhandler.SOSEvaluateEvents;
import com.sos.jitl.eventing.eventhandler.SchedulerEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.xpath.XPathAPI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.util.SOSFile;

public class XmlEventHandler {
    private Collection<Object> eventHandlerResultedCommands = new Vector<Object>();
    private List<SchedulerEvent> listOfActiveEvents;
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlEventHandler.class);
    private String eventHandlerFilepath;
    private String eventJobChainName;
    private String eventClass;

    public XmlEventHandler(Collection<Object> eventHandlerResultedCommands, List<SchedulerEventDBItem> listOfEvents, String eventHandlerFilepath, String eventJobChainName, String eventClass) {
        this.eventHandlerResultedCommands = eventHandlerResultedCommands;
        this.listOfActiveEvents = this.getActiveSchedulerEventList(listOfEvents);
        this.eventHandlerFilepath = eventHandlerFilepath;
        this.eventJobChainName = eventJobChainName;
        this.eventClass = eventClass;
    }

    private List<SchedulerEvent> getActiveSchedulerEventList(List<SchedulerEventDBItem> listOfEvents) {
        ArrayList<SchedulerEvent> listOfActiveEvents = new ArrayList<SchedulerEvent>();
        for (SchedulerEventDBItem item : listOfEvents) {
            SchedulerEvent schedulerEvent = new SchedulerEvent(item);
            listOfActiveEvents.add(schedulerEvent);
        }
        return listOfActiveEvents;
    }

    private boolean analyseMonitorEventHandler(String fileSpec, String fileSpecLog) throws Exception {
        boolean erg = false;
        LOGGER.debug(".. looking for special event handler for: " + fileSpecLog + " " + fileSpec);
        Vector specialFiles = SOSFile.getFilelist((String)this.eventHandlerFilepath, (String)fileSpec, (int)0);
        for (File actionEventHandler : specialFiles) {
            boolean ignore = false;
            if ("".equals(fileSpecLog)) {
                String filename = actionEventHandler.getAbsolutePath();
                boolean bl = ignore = filename.endsWith(".job.actions.xml") || filename.endsWith(".job_chain.actions.xml") || filename.endsWith(".event_class.actions.xml");
            }
            if (ignore || !actionEventHandler.exists() || !actionEventHandler.canRead()) continue;
            erg = true;
            LOGGER.debug(".. analysing action event handler: " + actionEventHandler.getCanonicalPath());
            SOSEvaluateEvents eval = new SOSEvaluateEvents();
            try {
                eval.setListOfActiveEvents(this.listOfActiveEvents);
                eval.readConfigurationFile(actionEventHandler);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            for (SOSActions a : eval.getListOfActions()) {
                LOGGER.debug(".... checking action " + a.getName());
                if (!a.isActive(eval.getListOfActiveEvents())) continue;
                LOGGER.debug(".... added action:" + a.getName());
                this.eventHandlerResultedCommands.add(a.getCommands());
                NodeList commands = XPathAPI.selectNodeList((Node)a.getCommands(), (String)"command | remove_event | add_event");
                for (int i = 0; i < commands.getLength(); ++i) {
                    Node n = commands.item(i);
                    if (!"command".equals(n.getNodeName()) && !"remove_event".equals(n.getNodeName()) && !"add_event".equals(n.getNodeName())) continue;
                    LOGGER.debug(".. " + n.getNodeName() + " was added");
                    NamedNodeMap attr = n.getAttributes();
                    if (attr == null) continue;
                    for (int ii = 0; ii < attr.getLength(); ++ii) {
                        LOGGER.debug("...." + attr.item(ii).getNodeName() + "=" + attr.item(ii).getNodeValue());
                    }
                }
            }
        }
        return erg;
    }

    public void getListOfCommands() throws IOException, Exception {
        boolean fileFound = false;
        File eventHandlerFile = new File(this.eventHandlerFilepath);
        if (eventHandlerFile.isDirectory()) {
            if (!eventHandlerFile.canRead()) {
                throw new Exception("event handler directory is not accessible: " + eventHandlerFile.getCanonicalPath());
            }
            LOGGER.debug("retrieving event handlers from directory: " + this.eventHandlerFilepath + " for file specification: Action");
            String fileSpec = "";
            String fileSpecLog = "";
            if (this.eventJobChainName != null && !this.eventJobChainName.isEmpty()) {
                fileSpec = "^" + this.eventJobChainName + "(\\..*)?\\.job_chain\\.actions.xml$";
                fileSpecLog = "job_chain";
                fileFound = this.analyseMonitorEventHandler(fileSpec, fileSpecLog);
            }
            if (!fileFound && this.eventClass != null && !this.eventClass.isEmpty()) {
                fileSpec = "^" + this.eventClass + "(\\..*)?\\.event_class\\.actions.xml$";
                fileSpecLog = "event_class";
                fileFound = this.analyseMonitorEventHandler(fileSpec, fileSpecLog);
            }
            if (!fileFound) {
                fileSpec = "(\\..*)?\\.actions\\.xml$";
                fileSpecLog = "";
                fileFound = this.analyseMonitorEventHandler(fileSpec, fileSpecLog);
            }
        }
    }
}

