/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.extract.job;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.extract.job.ResultSet2CSVJobOptions;
import com.sos.jitl.extract.model.ResultSet2CSVModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResultSet2CSVJob
extends JSJobUtilitiesClass<ResultSet2CSVJobOptions> {
    private final String className = ResultSet2CSVJob.class.getSimpleName();
    private static Logger logger = LoggerFactory.getLogger(ResultSet2CSVJob.class);
    private SOSHibernateSession session;

    public ResultSet2CSVJob() {
        super((Object)new ResultSet2CSVJobOptions());
    }

    public void init() throws Exception {
        try {
            SOSHibernateFactory sosHibernateFactory = new SOSHibernateFactory(this.getOptions().hibernate_configuration_file.getValue());
            sosHibernateFactory.setTransactionIsolation(this.getOptions().connection_transaction_isolation.value());
            sosHibernateFactory.build();
            this.session = sosHibernateFactory.openStatelessSession();
        }
        catch (Exception ex) {
            throw new Exception(String.format("init connection: %s", ex.toString()));
        }
    }

    public void exit() {
        if (this.session != null) {
            this.session.close();
            this.session.getFactory().close();
        }
    }

    public ResultSet2CSVJob execute() throws Exception {
        String methodName = this.className + "::execute";
        logger.debug(methodName);
        try {
            this.getOptions().checkMandatory();
            logger.debug(this.getOptions().toString());
            ResultSet2CSVModel model = new ResultSet2CSVModel(this.session, this.getOptions());
            model.process();
        }
        catch (Exception e) {
            logger.error(String.format("%s: %s", methodName, e.toString()));
            throw e;
        }
        return this;
    }

    public ResultSet2CSVJobOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new ResultSet2CSVJobOptions();
        }
        return (ResultSet2CSVJobOptions)((Object)this.objOptions);
    }
}

