/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.extract.model;

import com.sos.jitl.extract.helper.ExtractUtil;
import com.sos.jitl.extract.job.CSV2CSVJobOptions;
import com.sos.jitl.reporting.helper.ReportUtil;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.csv.QuoteMode;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class CSV2CSVModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CSV2CSVModel.class);
    private CSV2CSVJobOptions options;
    private String[] headers = null;
    private int[] headerIndexes = null;
    private String[] fields = null;
    boolean printAllFields = false;
    boolean hasNumericalFields = false;

    public CSV2CSVModel(CSV2CSVJobOptions opt) {
        this.options = opt;
    }

    private void setDefaults() {
        this.headers = null;
        this.headerIndexes = null;
        this.fields = null;
        this.printAllFields = false;
        this.hasNumericalFields = false;
    }

    public void process() throws Exception {
        String method = "process";
        DateTime start = new DateTime();
        InputStreamReader reader = null;
        CSVParser parser = null;
        CSVPrinter printer = null;
        OutputStreamWriter writer = null;
        boolean removeOutputFile = false;
        String outputFile = this.options.output_file.getValue();
        try {
            File f;
            this.setDefaults();
            if (ExtractUtil.hasDateReplacement(outputFile)) {
                outputFile = ExtractUtil.getDateReplacement(outputFile);
                LOGGER.info(String.format("%s: output file after replacement = %s", method, outputFile));
            }
            if (!(f = new File(this.options.input_file.getValue())).exists()) {
                throw new Exception(String.format("input file does not exist %s", f.getCanonicalPath()));
            }
            if (!f.canRead()) {
                throw new Exception(String.format("can't read the input file %s", f.getCanonicalPath()));
            }
            reader = new FileReader(this.options.input_file.getValue());
            writer = new FileWriter(outputFile);
            this.parseFields();
            parser = this.getCSVParser((FileReader)reader);
            this.parseHeader(parser);
            printer = this.getCSVPrinter((FileWriter)writer);
            int i = 0;
            int headerRows = this.options.skip_header.value() ? 0 : 1;
            int dataRows = 0;
            for (CSVRecord record : parser) {
                ArrayList<String> al;
                ArrayList<String> rec = null;
                if (this.printAllFields) {
                    al = new ArrayList<String>();
                    for (int j = 0; j < record.size(); ++j) {
                        String val = record.get(j);
                        if (val.equals(this.options.input_file_null_string.getValue())) {
                            val = this.options.null_string.getValue();
                        }
                        al.add(val);
                    }
                    rec = al;
                } else {
                    al = new ArrayList();
                    for (int index : this.headerIndexes) {
                        String val = null;
                        try {
                            val = record.get(index);
                        }
                        catch (Exception ex) {
                            throw new Exception(String.format("[param \"fields\" = %s] not found field index = %s", this.options.fields.getValue(), index + 1));
                        }
                        if (val.equals(this.options.input_file_null_string.getValue())) {
                            val = this.options.null_string.getValue();
                        }
                        al.add(val);
                    }
                    rec = al;
                }
                if (i != 0 || !this.hasNumericalFields || !this.options.skip_header.value()) {
                    printer.printRecord(rec);
                    if ((++dataRows + headerRows) % this.options.log_info_step.value() == 0) {
                        LOGGER.info(String.format("%s: %s entries processed ...", method, this.options.log_info_step.value()));
                    }
                }
                ++i;
            }
            LOGGER.info(String.format("%s: total rows written = %s (header = %s, data = %s), duration = %s", method, headerRows + dataRows, headerRows, dataRows, ReportUtil.getDuration(start, new DateTime())));
        }
        catch (Exception ex) {
            removeOutputFile = true;
            throw new Exception(String.format("%s: %s", method, ex.toString()), ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.flush();
                }
                catch (Exception exception) {}
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
            if (printer != null) {
                try {
                    printer.flush();
                }
                catch (Exception exception) {}
                try {
                    printer.close();
                }
                catch (Exception exception) {}
            }
            if (removeOutputFile) {
                try {
                    File f = new File(outputFile);
                    if (f.exists()) {
                        f.deleteOnExit();
                    }
                }
                catch (Exception exception) {}
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private void parseFields() {
        this.fields = this.options.fields.getValue().split(";");
        if (this.fields.length == 1 && "*".equals(this.fields[0])) {
            this.printAllFields = true;
        } else {
            try {
                Integer.parseInt(this.options.fields.getValue().replaceAll(";", ""));
                this.hasNumericalFields = true;
            }
            catch (Exception ex) {
                this.hasNumericalFields = false;
            }
        }
    }

    private void parseHeader(CSVParser parser) throws Exception {
        String method = "parseHeader";
        try {
            Map headerMap = parser.getHeaderMap();
            if (headerMap == null) {
                if (!this.hasNumericalFields) {
                    throw new Exception(String.format("param \"fields\" contains non-numeric values %s", this.options.fields.getValue()));
                }
                this.headerIndexes = new int[this.fields.length];
                for (int i = 0; i < this.fields.length; ++i) {
                    Integer intVal = Integer.parseInt(this.fields[i]);
                    this.headerIndexes[i] = intVal - 1;
                }
            } else if (this.printAllFields) {
                this.headers = new String[headerMap.size()];
                this.headerIndexes = new int[headerMap.size()];
                int j = 0;
                for (Map.Entry entry : headerMap.entrySet()) {
                    this.headers[j] = (String)entry.getKey();
                    this.headerIndexes[j] = (Integer)entry.getValue();
                    ++j;
                }
            } else {
                this.headers = new String[this.fields.length];
                this.headerIndexes = new int[this.fields.length];
                int j = 0;
                block6: for (int i = 0; i < this.fields.length; ++i) {
                    String val = this.fields[i];
                    try {
                        Integer intVal = Integer.parseInt(val);
                        for (Map.Entry entry : headerMap.entrySet()) {
                            if (!intVal.equals((Integer)entry.getValue() + 1)) continue;
                            this.headers[j] = (String)entry.getKey();
                            this.headerIndexes[j] = (Integer)entry.getValue();
                            ++j;
                            continue block6;
                        }
                        continue;
                    }
                    catch (Exception ex) {
                        if (headerMap.containsKey(val)) {
                            this.headers[j] = val;
                            this.headerIndexes[j] = (Integer)headerMap.get(val);
                            ++j;
                            continue;
                        }
                        throw new Exception(String.format("[param \"fields\" = %s] not found declared field %s in the header row %s", this.options.fields.getValue(), val, headerMap.keySet()));
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new Exception(String.format("%s: %s", method, ex.toString()), ex);
        }
    }

    private CSVParser getCSVParser(FileReader reader) throws Exception {
        Character inputFileDelimeter = Character.valueOf(SOSString.isEmpty((String)this.options.input_file_delimiter.getValue()) ? (char)'\u0000' : this.options.input_file_delimiter.getValue().charAt(0));
        Character inputFileQuoteCharacter = SOSString.isEmpty((String)this.options.input_file_quote_character.getValue()) ? null : Character.valueOf(this.options.input_file_quote_character.getValue().charAt(0));
        Character inputFileEscapeCharacter = SOSString.isEmpty((String)this.options.input_file_escape_character.getValue()) ? null : Character.valueOf(this.options.input_file_escape_character.getValue().charAt(0));
        CSVFormat formatReader = CSVFormat.newFormat((char)inputFileDelimeter.charValue()).withRecordSeparator(this.options.input_file_record_separator.getValue()).withCommentMarker('#').withIgnoreEmptyLines(false).withQuote(inputFileQuoteCharacter).withQuoteMode(QuoteMode.ALL).withEscape(inputFileEscapeCharacter);
        if (!this.hasNumericalFields) {
            formatReader = formatReader.withHeader(new String[0]);
        }
        return new CSVParser((Reader)reader, formatReader);
    }

    private CSVPrinter getCSVPrinter(FileWriter writer) throws Exception {
        Character delimeter = Character.valueOf(SOSString.isEmpty((String)this.options.delimiter.getValue()) ? (char)'\u0000' : this.options.delimiter.getValue().charAt(0));
        Character quoteCharacter = SOSString.isEmpty((String)this.options.quote_character.getValue()) ? null : Character.valueOf(this.options.quote_character.getValue().charAt(0));
        Character escapeCharacter = SOSString.isEmpty((String)this.options.escape_character.getValue()) ? null : Character.valueOf(this.options.escape_character.getValue().charAt(0));
        CSVFormat formatWriter = CSVFormat.newFormat((char)delimeter.charValue()).withRecordSeparator(this.options.record_separator.getValue()).withNullString(this.options.null_string.getValue()).withCommentMarker('#').withIgnoreEmptyLines(false).withQuote(quoteCharacter).withQuoteMode(QuoteMode.ALL).withEscape(escapeCharacter);
        if (!this.options.skip_header.value()) {
            formatWriter = formatWriter.withHeader(this.headers);
        }
        return new CSVPrinter((Appendable)writer, formatWriter);
    }
}

