/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.extract.model;

import com.sos.hibernate.classes.SOSHibernateSQLExecutor;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.extract.helper.ExtractUtil;
import com.sos.jitl.extract.job.ResultSet2CSVJobOptions;
import com.sos.jitl.reporting.helper.ReportUtil;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.sql.ResultSet;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.QuoteMode;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class ResultSet2CSVModel {
    private Logger logger = LoggerFactory.getLogger(ResultSet2CSVModel.class);
    private SOSHibernateSession session;
    private ResultSet2CSVJobOptions options;

    public ResultSet2CSVModel(SOSHibernateSession sess, ResultSet2CSVJobOptions opt) {
        this.session = sess;
        this.options = opt;
    }

    public void process() throws Exception {
        String outputFile;
        boolean removeOutputFile;
        CSVPrinter printer;
        OutputStreamWriter writer;
        block38: {
            String method = "process";
            SOSHibernateSQLExecutor sqlExecutor = null;
            ResultSet resultSet = null;
            writer = null;
            printer = null;
            DateTime start = new DateTime();
            removeOutputFile = false;
            outputFile = this.options.output_file.getValue();
            try {
                this.logger.info(String.format("%s: statement = %s, output file = %s", method, this.options.statement.getValue(), outputFile));
                if (ExtractUtil.hasDateReplacement(outputFile)) {
                    outputFile = ExtractUtil.getDateReplacement(outputFile);
                    this.logger.info(String.format("%s: output file after replacement = %s", method, outputFile));
                }
                Character delimeter = Character.valueOf(SOSString.isEmpty((String)this.options.delimiter.getValue()) ? (char)'\u0000' : this.options.delimiter.getValue().charAt(0));
                Character quoteCharacter = SOSString.isEmpty((String)this.options.quote_character.getValue()) ? null : Character.valueOf(this.options.quote_character.getValue().charAt(0));
                Character escapeCharacter = SOSString.isEmpty((String)this.options.escape_character.getValue()) ? null : Character.valueOf(this.options.escape_character.getValue().charAt(0));
                CSVFormat format = CSVFormat.newFormat((char)delimeter.charValue()).withRecordSeparator(this.options.record_separator.getValue()).withNullString(this.options.null_string.getValue()).withCommentMarker('#').withIgnoreEmptyLines(false).withQuote(quoteCharacter).withQuoteMode(QuoteMode.ALL).withEscape(escapeCharacter);
                writer = new FileWriter(outputFile);
                sqlExecutor = this.session.getSQLExecutor();
                resultSet = sqlExecutor.getResultSet(this.options.statement.getValue());
                int headerRows = 0;
                int dataRows = 0;
                if (this.options.skip_header.value()) {
                    printer = new CSVPrinter((Appendable)writer, format);
                } else {
                    printer = format.withHeader(resultSet).print((Appendable)writer);
                    ++headerRows;
                }
                int columnCount = resultSet.getMetaData().getColumnCount();
                while (resultSet.next()) {
                    for (int i = 1; i <= columnCount; ++i) {
                        printer.print(resultSet.getObject(i));
                    }
                    printer.println();
                    if ((++dataRows + headerRows) % this.options.log_info_step.value() != 0) continue;
                    this.logger.info(String.format("%s: %s entries processed ...", method, this.options.log_info_step.value()));
                }
                this.logger.info(String.format("%s: total rows written = %s (header = %s, data = %s), duration = %s", method, headerRows + dataRows, headerRows, dataRows, ReportUtil.getDuration(start, new DateTime())));
                if (sqlExecutor == null) break block38;
            }
            catch (Exception ex) {
                try {
                    removeOutputFile = true;
                    throw new Exception(String.format("%s[statement = %s]: %s", method, this.options.statement.getValue(), ex.toString()), ex);
                }
                catch (Throwable throwable) {
                    if (sqlExecutor != null) {
                        sqlExecutor.close(resultSet);
                    }
                    if (printer != null) {
                        try {
                            printer.flush();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            printer.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (writer != null) {
                        try {
                            writer.flush();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        try {
                            writer.close();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (removeOutputFile) {
                        try {
                            File f = new File(outputFile);
                            if (f.exists()) {
                                f.deleteOnExit();
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
            }
            sqlExecutor.close(resultSet);
        }
        if (printer != null) {
            try {
                printer.flush();
            }
            catch (Exception delimeter) {
                // empty catch block
            }
            try {
                printer.close();
            }
            catch (Exception delimeter) {
                // empty catch block
            }
        }
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (Exception delimeter) {
                // empty catch block
            }
            try {
                writer.close();
            }
            catch (Exception delimeter) {
                // empty catch block
            }
        }
        if (removeOutputFile) {
            try {
                File f = new File(outputFile);
                if (f.exists()) {
                    f.deleteOnExit();
                }
            }
            catch (Exception f) {}
        }
    }
}

