/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.housekeeping.dequeuemail;

import com.sos.jitl.housekeeping.dequeuemail.JobSchedulerDequeueMailJobOptions;
import com.sos.jitl.notification.helper.settings.InternalNotificationSettings;
import com.sos.jitl.notification.helper.settings.MailSettings;
import com.sos.jitl.notification.model.internal.ExecutorModel;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMail;
import sos.settings.SOSProfileSettings;
import sos.util.SOSFile;
import sos.util.SOSFileOperations;
import sos.util.SOSString;

public class DequeueMailExecuter {
    private static final String MSG_CODE_LONGER = "SCHEDULER-712";
    private static final String MSG_CODE_SHORTER = "SCHEDULER-711";
    private JobSchedulerDequeueMailJobOptions jobSchedulerDequeueMailJobOptions;
    private static final Logger LOGGER = LoggerFactory.getLogger(DequeueMailExecuter.class);
    private Vector<File> mailOrders = null;
    private Iterator<File> mailOrderIterator = null;
    private SOSMail sosMail;
    private boolean isFileOrder;
    private String hibernateConfiurationFile;
    private String configDir;
    private boolean notification;
    private String schedulerId;

    public DequeueMailExecuter(JobSchedulerDequeueMailJobOptions jobSchedulerDequeueMailJobOptions) {
        this.jobSchedulerDequeueMailJobOptions = jobSchedulerDequeueMailJobOptions;
    }

    public void execute() throws RuntimeException, Exception {
        this.sosMail = new SOSMail(this.jobSchedulerDequeueMailJobOptions.smtpHost.getValue());
        this.sosMail.setQueueMailOnError(false);
        this.isFileOrder = this.jobSchedulerDequeueMailJobOptions.fileWatching.value();
        this.readMailOrders();
        while (this.mailOrderIterator.hasNext()) {
            this.processOneFile(this.mailOrderIterator.next());
        }
    }

    private void readMailOrders() throws RuntimeException, Exception {
        if (this.isFileOrder) {
            this.mailOrders = new Vector();
            this.mailOrders.add(new File(this.jobSchedulerDequeueMailJobOptions.emailFileName.getValue()));
        } else {
            this.mailOrders = SOSFile.getFilelist((String)this.jobSchedulerDequeueMailJobOptions.queueDirectory.getValue(), (String)this.jobSchedulerDequeueMailJobOptions.queuePrefix.getValue(), (int)0);
        }
        this.mailOrderIterator = this.mailOrders.iterator();
        if (!this.mailOrders.isEmpty() && !this.isFileOrder) {
            LOGGER.info(this.mailOrders.size() + " mail files found");
        }
    }

    private File getWorkFile(File listFile) throws Exception {
        File workFile = new File(listFile.getAbsolutePath());
        if (!workFile.exists()) {
            throw new Exception("mail file [" + workFile.getAbsolutePath() + "] does not exist.");
        }
        if (!workFile.canRead()) {
            throw new Exception("cannot read from mail file [" + workFile.getAbsolutePath() + "]");
        }
        return workFile;
    }

    private File getFailedPath(File workFile) {
        String failedPath = workFile.getParent();
        String failedName = workFile.getName();
        if (failedName.endsWith("~")) {
            failedName = failedName.substring(0, failedName.length() - 1);
        }
        return new File(failedPath, this.jobSchedulerDequeueMailJobOptions.failedPrefix.getValue() + failedName);
    }

    private File getNotifiedPath(File workFile) {
        String notifiedPath = workFile.getParent();
        String notifiedName = workFile.getName();
        if (notifiedName.endsWith("~")) {
            notifiedName = notifiedName.substring(0, notifiedName.length() - 1);
        }
        return new File(notifiedPath, "notified." + notifiedName);
    }

    private void sendMessage(File messageFile, int curDeliveryCounter) throws Exception {
        try {
            boolean sendOk;
            boolean shouldSend = true;
            File mailFile = null;
            String message = "";
            if (this.jobSchedulerDequeueMailJobOptions.logDirectory.isDirty() && !this.jobSchedulerDequeueMailJobOptions.logDirectory.getValue().isEmpty()) {
                mailFile = this.getMailFile(this.jobSchedulerDequeueMailJobOptions.logDirectory.getValue());
                this.sosMail.dumpMessageToFile(mailFile, true);
            }
            int maxDeliveryCounter = this.jobSchedulerDequeueMailJobOptions.maxDelivery.value();
            boolean bl = sendOk = this.jobSchedulerDequeueMailJobOptions.logOnly.value() || this.sosMail.send();
            if (!sendOk || this.jobSchedulerDequeueMailJobOptions.logOnly.value()) {
                String but = "";
                String trials = "";
                but = this.jobSchedulerDequeueMailJobOptions.logOnly.value() ? "stored to a file:" + mailFile.getAbsolutePath() : "stored for later dequeueing:" + mailFile.getAbsolutePath();
                if (maxDeliveryCounter > 0) {
                    trials = "(trial " + curDeliveryCounter + " of " + maxDeliveryCounter + ")";
                }
                message = String.format("mail was NOT sent %s but %s", trials, but);
                LOGGER.info(message);
                if (message.length() > 250) {
                    message = message.substring(message.length() - 250);
                }
                message = message.replaceAll("'", "''");
                shouldSend = false;
            }
            try {
                if (!shouldSend && curDeliveryCounter > maxDeliveryCounter && maxDeliveryCounter > 0) {
                    throw new Exception("number of trials [" + maxDeliveryCounter + "] exceeded to send mail from file: " + messageFile.getAbsolutePath());
                }
            }
            catch (Exception e) {
                throw new Exception(e.getMessage());
            }
            if (this.jobSchedulerDequeueMailJobOptions.logOnly.value()) {
                LOGGER.info("mail was processed from file [" + messageFile.getAbsolutePath() + "] to: " + this.sosMail.getRecipientsAsString() + " into: " + mailFile.getAbsolutePath());
            } else {
                LOGGER.info("mail was sent from file [" + messageFile.getAbsolutePath() + "] to: " + this.sosMail.getRecipientsAsString());
            }
            LOGGER.debug("mail was sent with headers: " + this.sosMail.dumpHeaders());
            messageFile.delete();
        }
        catch (Exception ex) {
            throw new Exception("mail was NOT sent from file [" + messageFile.getAbsolutePath() + "]" + ex.getMessage());
        }
    }

    private File getMailFile(String path) throws Exception {
        Date d = new Date();
        StringBuffer bb = new StringBuffer();
        SimpleDateFormat s = new SimpleDateFormat(this.jobSchedulerDequeueMailJobOptions.queuePattern.getValue());
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + "/";
        }
        FieldPosition fp = new FieldPosition(0);
        StringBuffer b = s.format(d, bb, fp);
        String lastGeneratedFilename = path + this.jobSchedulerDequeueMailJobOptions.queuePrefix.getValue() + b + ".email";
        File f = new File(lastGeneratedFilename);
        while (f.exists()) {
            b = s.format(d, bb, fp);
            lastGeneratedFilename = path + this.jobSchedulerDequeueMailJobOptions.queuePrefix.getValue() + b + ".email";
            f = new File(lastGeneratedFilename);
        }
        return f;
    }

    private String getBodyFromMimeMultipart(MimeMultipart mimeMultipart) throws MessagingException, IOException {
        String result = "";
        int count = mimeMultipart.getCount();
        for (int i = 0; i < count; ++i) {
            BodyPart bodyPart = mimeMultipart.getBodyPart(i);
            if (bodyPart.isMimeType("text/plain")) {
                result = result + "\n" + bodyPart.getContent();
                break;
            }
            if (bodyPart.isMimeType("text/html")) {
                result = result + "\n" + bodyPart.getContent();
                continue;
            }
            if (!(bodyPart.getContent() instanceof MimeMultipart)) continue;
            result = result + this.getBodyFromMimeMultipart((MimeMultipart)bodyPart.getContent());
        }
        return result;
    }

    private String getBodyFromMessage(MimeMessage message) throws MessagingException, IOException {
        String result = "";
        if (message.isMimeType("text/plain")) {
            result = message.getContent().toString();
        } else if (message.isMimeType("multipart/*")) {
            MimeMultipart mimeMultipart = (MimeMultipart)message.getContent();
            result = this.getBodyFromMimeMultipart(mimeMultipart);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processOneFile(File listFile) throws Exception {
        boolean send = true;
        File workFile = this.getWorkFile(listFile);
        LOGGER.info("processing mail file: " + workFile.getAbsolutePath());
        File failedFile = this.getFailedPath(workFile);
        File notifiedFile = this.getNotifiedPath(workFile);
        File messageFile = new File(workFile.getAbsolutePath() + "~");
        if (messageFile.exists()) {
            messageFile.delete();
        }
        workFile.renameTo(messageFile);
        this.sosMail.setQueueDir(this.jobSchedulerDequeueMailJobOptions.queueDirectory.getValue());
        this.sosMail.setQueuePraefix(this.jobSchedulerDequeueMailJobOptions.queuePrefix.getValue());
        SOSProfileSettings smtpSettings = new SOSProfileSettings(this.jobSchedulerDequeueMailJobOptions.iniPath.getValue());
        Properties smtpProperties = smtpSettings.getSection("smtp");
        this.sosMail.setProperties(smtpProperties);
        try {
            if (!smtpProperties.isEmpty()) {
                if (smtpProperties.getProperty("mail.smtp.user") != null && !smtpProperties.getProperty("mail.smtp.user").isEmpty()) {
                    this.sosMail.setUser(smtpProperties.getProperty("mail.smtp.user"));
                }
                if (smtpProperties.getProperty("mail.smtp.password") != null && !smtpProperties.getProperty("mail.smtp.password").isEmpty()) {
                    this.sosMail.setPassword(smtpProperties.getProperty("mail.smtp.password"));
                }
                if (smtpProperties.getProperty("mail.smtp.port") != null && !smtpProperties.getProperty("mail.smtp.port").isEmpty()) {
                    this.sosMail.setPort(smtpProperties.getProperty("mail.smtp.port"));
                }
                if (smtpProperties.getProperty("mail.smtp.security_protocol") != null && !smtpProperties.getProperty("mail.smtp.security_protocol").isEmpty()) {
                    this.sosMail.setSecurityProtocol(smtpProperties.getProperty("mail.smtp.security_protocol"));
                }
            }
            try {
                this.sosMail.loadFile(messageFile);
                if (this.notification) {
                    String body = this.getBodyFromMessage(this.sosMail.getMessage());
                    LOGGER.debug("Body: " + body);
                    boolean considerShort = this.getConsider(body, "[warning].*Task.*runs shorter than the expected duration", ".*SCHEDULER-711.*");
                    boolean considerLong = this.getConsider(body, "[warning].*Task.*runs longer than the expected duration", ".*SCHEDULER-712.*");
                    boolean considerMasterMessage = !this.getConsider(body, "([warning]|[error]).*Task", null);
                    boolean considerTaskWarningMessage = this.getConsider(body, "[warning].*Task.*terminated with warnings", null);
                    if (considerTaskWarningMessage) {
                        String varTitle = this.sosMail.getMessage().getSubject();
                        send = !this.executeNotification(ExecutorModel.InternalType.TASK_WARNING, varTitle, body);
                    } else if (considerShort) {
                        String varTitle = this.sosMail.getMessage().getSubject();
                        send = !this.executeNotification(ExecutorModel.InternalType.TASK_IF_SHORTER_THAN, varTitle, body);
                    } else if (considerLong) {
                        String varTitle = this.sosMail.getMessage().getSubject();
                        send = !this.executeNotification(ExecutorModel.InternalType.TASK_IF_LONGER_THAN, varTitle, body);
                    } else if (considerMasterMessage) {
                        String varTitle = this.sosMail.getMessage().getSubject();
                        send = !this.executeNotification(ExecutorModel.InternalType.MASTER_MESSAGE, varTitle, body);
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new Exception("mail file [" + workFile.getAbsolutePath() + "]: " + e.getMessage());
            }
            int curDeliveryCounter = 0;
            int maxDeliveryCounter = this.jobSchedulerDequeueMailJobOptions.maxDelivery.value();
            try {
                if (this.sosMail.getMessage().getHeader("X-SOSMail-delivery-counter") != null && this.sosMail.getMessage().getHeader("X-SOSMail-delivery-counter").length > 0) {
                    try {
                        curDeliveryCounter = Integer.parseInt(this.sosMail.getMessage().getHeader("X-SOSMail-delivery-counter")[0].toString().trim());
                    }
                    catch (Exception ex) {
                        throw new Exception("illegal header value for X-SOSMail-delivery-counter: " + this.sosMail.getMessage().getHeader("X-SOSMail-delivery-counter")[0].toString());
                    }
                    if (++curDeliveryCounter > maxDeliveryCounter && maxDeliveryCounter > 0) {
                        LOGGER.debug("mail file [" + workFile.getAbsolutePath() + "] exceeds number of trials [" + maxDeliveryCounter + "] to send mail and will not be dequeued");
                        this.sosMail.setQueueDir("");
                    }
                }
                this.sosMail.getMessage().setHeader("X-SOSMail-delivery-counter", String.valueOf(curDeliveryCounter));
                this.sosMail.getMessage().saveChanges();
            }
            catch (Exception e) {
                throw new Exception("mail file [" + workFile.getAbsolutePath() + "]: " + e.getMessage());
            }
            if (send) {
                this.sendMessage(messageFile, curDeliveryCounter);
            } else {
                messageFile.delete();
            }
        }
        finally {
            try {
                if (messageFile.exists()) {
                    LOGGER.info("mail file is renamed to exclude it from further processing: " + failedFile.getAbsolutePath());
                    messageFile.renameTo(failedFile);
                }
            }
            catch (Exception exception) {}
        }
    }

    private String getSubString(String searchString, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(searchString);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return "";
    }

    private boolean getConsider(String body, String regexSubject, String regexBody) throws MessagingException, IOException {
        Matcher regExJobMatcher = null;
        regExJobMatcher = Pattern.compile(regexSubject).matcher("");
        boolean consider = regExJobMatcher.reset(this.sosMail.getMessage().getSubject()).find();
        if (regexBody != null) {
            regExJobMatcher = Pattern.compile(regexBody).matcher("");
            consider = consider || regExJobMatcher.reset(body).find();
        }
        return consider;
    }

    private boolean executeNotification(ExecutorModel.InternalType internalType, String varTitle, String body) throws MessagingException, IOException {
        String taskId;
        String code;
        String regex;
        boolean notify = true;
        String msgCode = "";
        if (internalType.equals((Object)ExecutorModel.InternalType.TASK_IF_SHORTER_THAN)) {
            msgCode = MSG_CODE_SHORTER;
        } else if (internalType.equals((Object)ExecutorModel.InternalType.TASK_IF_LONGER_THAN)) {
            msgCode = MSG_CODE_LONGER;
        } else if (internalType.equals((Object)ExecutorModel.InternalType.TASK_WARNING)) {
            regex = ".*(SCHEDULER-(.*?)\\s)";
            code = this.getSubString(body, regex);
            if (SOSString.isEmpty((String)code)) {
                code = "WARN";
            }
            msgCode = code;
        } else {
            try {
                regex = ".*((SCHEDULER|ERRNO|WSWIN)-(.*?)\\s)";
                code = this.getSubString(varTitle, regex);
                if (SOSString.isEmpty((String)code)) {
                    regex = ".*(Z-JAVA-(.*?)\\s)";
                    code = this.getSubString(body, regex);
                }
                if (!SOSString.isEmpty((String)code)) {
                    msgCode = code;
                }
            }
            catch (Exception regex2) {
                // empty catch block
            }
        }
        String schedulerId = this.getSubString(body, ".*JobScheduler -id=(.*?)host");
        if (schedulerId.isEmpty()) {
            schedulerId = this.schedulerId;
        }
        if ((taskId = this.getSubString(body, ".*Task:.*ID:(.*?)\\s")).isEmpty()) {
            taskId = this.getSubString(body, ".*Task.*with ID (.*?)\\s");
        }
        String jobPath = this.getSubString(body, ".*Task:.(.*?)ID:");
        LOGGER.debug("InternalType:" + (Object)((Object)internalType));
        LOGGER.debug("msgCode:" + msgCode);
        LOGGER.debug("vartitle=" + varTitle);
        LOGGER.debug("vartext=" + body);
        LOGGER.debug("schedulerId=" + schedulerId);
        LOGGER.debug("jobPath=" + jobPath);
        LOGGER.debug("taskId=" + taskId);
        LOGGER.debug("configuration Directory=" + this.configDir);
        LOGGER.debug("Hibernate cfg=" + this.hibernateConfiurationFile);
        if (!this.configDir.isEmpty()) {
            MailSettings mailSettings = new MailSettings();
            mailSettings.setIniPath(this.jobSchedulerDequeueMailJobOptions.iniPath.getValue());
            LOGGER.debug("iniPath:" + this.jobSchedulerDequeueMailJobOptions.iniPath.getValue());
            mailSettings.setSmtp(this.sosMail.getHost());
            LOGGER.debug("smtp:" + this.sosMail.getHost());
            mailSettings.setQueueDir(this.sosMail.getQueueDir());
            LOGGER.debug("queueDir:" + this.sosMail.getQueueDir());
            String from = "JobScheduler";
            if (this.sosMail.getMessage().getHeader("From") != null && this.sosMail.getMessage().getHeader("From").length > 0) {
                from = this.sosMail.getMessage().getHeader("From")[0].toString().trim();
            }
            mailSettings.setFrom(from);
            LOGGER.debug("from:" + from);
            mailSettings.setTo(this.sosMail.getRecipientsAsString());
            LOGGER.debug("to:" + this.sosMail.getRecipientsAsString());
            mailSettings.setCc(this.sosMail.getCCsAsString());
            LOGGER.debug("cc:" + this.sosMail.getCCsAsString());
            mailSettings.setBcc(this.sosMail.getBCCsAsString());
            LOGGER.debug("bcc:" + this.sosMail.getBCCsAsString());
            ExecutorModel model = new ExecutorModel(Paths.get(this.configDir, new String[0]), Paths.get(this.hibernateConfiurationFile, new String[0]), mailSettings);
            InternalNotificationSettings settings = new InternalNotificationSettings();
            settings.setSchedulerId(schedulerId);
            settings.setTaskId(taskId);
            settings.setMessage(body);
            settings.setMessageTitle(varTitle);
            settings.setMessageCode(msgCode);
            notify = model.process(internalType, settings);
        } else {
            notify = false;
        }
        return notify;
    }

    public void resendFailedMails() throws Exception {
        String prefix = this.jobSchedulerDequeueMailJobOptions.failedPrefix.getValue();
        String source = this.jobSchedulerDequeueMailJobOptions.queueDirectory.getValue();
        String fileSpec = prefix + ".*$";
        String replacing = prefix;
        String replacement = "";
        SOSFileOperations.renameFileCnt((String)source, null, (String)fileSpec, (int)0, (int)0, (String)replacing, (String)replacement, null, null, null, null, (int)0, (int)0);
    }

    public void setHibernateConfigurationFile(String hibernateConfigurationFile) {
        this.hibernateConfiurationFile = hibernateConfigurationFile;
    }

    public void setConfigDir(String configDir) {
        this.configDir = configDir;
    }

    public void setNotification(boolean notification) {
        this.notification = notification;
    }

    public String getSchedulerId() {
        return this.schedulerId;
    }

    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }
}

