/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.httppost;

import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.jitl.httppost.JobSchedulerHttpPostJobOptions;
import com.sos.scheduler.messages.JSMessages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSFile;

public class JobSchedulerHttpPostJob
extends JSJobUtilitiesClass<JobSchedulerHttpPostJobOptions> {
    protected JobSchedulerHttpPostJobOptions objOptions = null;
    protected Vector<File> inputFileList = null;
    protected Iterator<File> inputFileListIterator = null;
    protected int timeout = 0;
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerHttpPostJob.class);
    private JSJobUtilities objJSJobUtilities = this;

    public JobSchedulerHttpPostJob() {
        super((Object)new JobSchedulerHttpPostJobOptions());
    }

    public JobSchedulerHttpPostJobOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new JobSchedulerHttpPostJobOptions();
        }
        return this.objOptions;
    }

    public JobSchedulerHttpPostJobOptions getOptions(JobSchedulerHttpPostJobOptions pobjOptions) {
        this.objOptions = pobjOptions;
        return this.objOptions;
    }

    public JobSchedulerHttpPostJob Execute() throws Exception {
        String methodName = "JobSchedulerHttpPostJob::Execute";
        LOGGER.debug(String.format(JSMessages.JSJ_I_110.get(), "JobSchedulerHttpPostJob::Execute"));
        try {
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().toString());
            this.init();
            if (this.inputFileListIterator != null) {
                while (this.inputFileListIterator.hasNext()) {
                    this.processSingleFile();
                }
            }
        }
        catch (Exception e) {
            try {
                LOGGER.error(String.format(JSMessages.JSJ_F_107.get(), "JobSchedulerHttpPostJob::Execute") + " " + e.getMessage(), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                LOGGER.debug(String.format(JSMessages.JSJ_I_111.get(), "JobSchedulerHttpPostJob::Execute"));
                throw throwable;
            }
        }
        LOGGER.debug(String.format(JSMessages.JSJ_I_111.get(), "JobSchedulerHttpPostJob::Execute"));
        return this;
    }

    public void processSingleFile() {
        File inputFile = null;
        File outputFile = null;
        String url = null;
        try {
            if (this.objOptions.output.isDirty()) {
                outputFile = new File(this.objOptions.output.getValue());
            }
            inputFile = this.inputFileListIterator.next();
            String contentType = this.objOptions.content_type.getValue();
            url = this.objOptions.url.getValue();
            if (!inputFile.exists()) {
                throw new Exception("input file [" + inputFile.getCanonicalPath() + "] does not exist.");
            }
            if (url == null || url.isEmpty()) {
                throw new Exception("no URL was given to post files.");
            }
            if (this.objOptions.content_type.isNotDirty()) {
                if (inputFile.getName().endsWith(".xml")) {
                    contentType = "text/xml";
                } else if (inputFile.getName().endsWith(".htm") || inputFile.getName().endsWith(".html")) {
                    contentType = "text/html";
                }
                if ("text/html".equals(contentType) || "text/xml".equals(contentType)) {
                    BufferedReader br = new BufferedReader(new FileReader(inputFile));
                    String buffer = "";
                    String line = null;
                    int c = 0;
                    while ((line = br.readLine()) != null && ++c < 5) {
                        buffer = buffer + line;
                    }
                    Pattern p = "text/xml".equals(contentType) ? Pattern.compile("encoding=['\"]([a-zA-Z_0-9-]*)['\"]", 2) : Pattern.compile("charset=['\"]?([a-zA-Z_0-9-]*)['\"]?", 2);
                    Matcher m = p.matcher(buffer);
                    if (m.find()) {
                        contentType = contentType + "; charset=" + m.group(1);
                    }
                    br.close();
                }
            }
            int responseCode = this.postFile(inputFile, this.objOptions.input_filespec.getValue(), outputFile, contentType, url);
            LOGGER.info("input file [" + inputFile.getCanonicalPath() + "] processed for URL [" + url + "] with response code " + responseCode);
        }
        catch (Exception e) {
            String message = "error occurred processing";
            if (inputFile != null) {
                message = message + " file [" + inputFile.getAbsolutePath() + "]";
            }
            if (url != null && !url.isEmpty()) {
                message = message + " for url [" + url + "]";
            }
            LOGGER.warn(message + ": " + e);
        }
    }

    public int postFile(File inputFile, String inputFileSpec, File outputFile, String contentType, String url) throws Exception {
        int rc = 0;
        try {
            if (inputFile.isDirectory()) {
                Vector filelist = SOSFile.getFilelist((String)inputFile.getCanonicalPath(), (String)inputFileSpec, (int)0);
                Iterator iterator = filelist.iterator();
                while (iterator.hasNext()) {
                    rc = this.postFile((File)iterator.next(), inputFileSpec, outputFile, contentType, url);
                }
                return rc;
            }
            PostMethod post = new PostMethod(url);
            String content = SOSFile.readFile((File)inputFile);
            LOGGER.debug("post before replacements: " + content);
            content = this.objJSJobUtilities.replaceSchedulerVars(content);
            LOGGER.debug("Posting: " + content);
            StringRequestEntity req = new StringRequestEntity(content);
            post.setRequestEntity((RequestEntity)req);
            LOGGER.debug("....with content-type=" + contentType);
            post.setRequestHeader("Content-type", contentType);
            HttpClient httpClient = new HttpClient();
            if (this.objOptions.timeout.value() > 0) {
                HttpConnectionManager httpManager = httpClient.getHttpConnectionManager();
                HttpConnectionManagerParams httpParams = new HttpConnectionManagerParams();
                httpParams.setConnectionTimeout(this.objOptions.timeout.value() * 1000);
                httpManager.setParams(httpParams);
            }
            rc = httpClient.executeMethod((HttpMethod)post);
            if (outputFile != null) {
                this.logResponse(inputFile, outputFile, post.getResponseBodyAsStream());
            }
            return rc;
        }
        catch (Exception e) {
            throw new Exception("error occurred in HTTP POST: " + e);
        }
    }

    private void logResponse(File inputFile, File outputFile, InputStream responseStream) throws Exception {
        if (outputFile == null) {
            throw new Exception("cannot write response: output file is null");
        }
        if (responseStream == null) {
            throw new Exception("cannot write response: response is null");
        }
        if (!outputFile.canRead()) {
            File path = new File(outputFile.getParent());
            if (!path.canRead()) {
                path.mkdirs();
            }
            outputFile.createNewFile();
        }
        if (!outputFile.canWrite()) {
            throw new Exception("cannot write to file: " + outputFile.getCanonicalPath());
        }
        if (outputFile.isDirectory()) {
            outputFile = new File(outputFile.getCanonicalPath() + "/" + inputFile.getName());
        }
        FileOutputStream outputStream = new FileOutputStream(outputFile);
        try {
            byte[] buffer = new byte[1000];
            int numOfBytes = 0;
            while ((numOfBytes = responseStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, numOfBytes);
            }
        }
        catch (Exception e) {
            throw new Exception("error occurred while logging to file [" + outputFile.getCanonicalPath() + "]: " + e.getMessage());
        }
        finally {
            try {
                if (responseStream != null) {
                    responseStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public void init() {
        this.doInitialize();
    }

    private void doInitialize() {
        try {
            File inputFile = new File(this.objOptions.input.getValue());
            if (inputFile.isDirectory()) {
                if (!inputFile.canRead()) {
                    throw new Exception("input directory is not accessible: " + inputFile.getCanonicalPath());
                }
                LOGGER.info("retrieving files from directory: " + this.objOptions.input.getValue() + " for file specification: " + this.objOptions.input_filespec.getValue());
                this.inputFileList = SOSFile.getFilelist((String)this.objOptions.input.getValue(), (String)this.objOptions.input_filespec.getValue(), (int)0);
            } else {
                if (!inputFile.canRead()) {
                    throw new Exception("input file is not accessible: " + inputFile.getCanonicalPath());
                }
                this.inputFileList = new Vector();
                this.inputFileList.add(inputFile);
            }
            if (!this.inputFileList.isEmpty()) {
                LOGGER.info(this.inputFileList.size() + " input files found");
            }
            this.inputFileListIterator = this.inputFileList.iterator();
        }
        catch (Exception e) {
            LOGGER.warn("failed to retrieve input files from directory [" + this.objOptions.input.getValue() + ", " + this.objOptions.input_filespec.getValue() + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public String myReplaceAll(String pstrSourceString, String pstrReplaceWhat, String pstrReplaceWith) {
        String newReplacement = pstrReplaceWith.replaceAll("\\$", "\\\\\\$");
        return pstrSourceString.replaceAll("(?m)" + pstrReplaceWhat, newReplacement);
    }

    public String replaceSchedulerVars(String pstrString2Modify) {
        LOGGER.debug("replaceSchedulerVars as Dummy-call executed. No Instance of JobUtilites specified.");
        return pstrString2Modify;
    }

    public void setJSParam(String pstrKey, String pstrValue) {
    }

    public void setJSParam(String pstrKey, StringBuilder pstrValue) {
    }

    public void setJSJobUtilites(JSJobUtilities pobjJSJobUtilities) {
        this.objJSJobUtilities = pobjJSJobUtilities == null ? this : pobjJSJobUtilities;
        LOGGER.debug("objJSJobUtilities = " + this.objJSJobUtilities.getClass().getName());
    }
}

