/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.classes;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.jobstreams.classes.JSEventKey;
import com.sos.jitl.jobstreams.db.DBItemEvent;
import com.sos.jitl.jobstreams.db.DBLayerEvents;
import com.sos.jitl.jobstreams.db.FilterEvents;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class JSEvent {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSEvent.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    DBItemEvent itemEvent = new DBItemEvent();
    private String schedulerId;
    private boolean dbError;

    public DBItemEvent getItemEvent() {
        return this.itemEvent;
    }

    public String getSchedulerId() {
        return this.schedulerId;
    }

    public JSEventKey getKey() {
        JSEventKey jsEventKey = new JSEventKey();
        jsEventKey.setSession(this.itemEvent.getSession());
        String[] s = this.itemEvent.getEvent().split("\\.");
        if (s.length == 2) {
            jsEventKey.setEvent(s[1]);
            jsEventKey.setJobStream(s[0]);
        } else {
            jsEventKey.setEvent(this.itemEvent.getEvent());
            jsEventKey.setJobStream(this.itemEvent.getJobStream());
        }
        jsEventKey.setSchedulerId(this.schedulerId);
        jsEventKey.setGlobalEvent(this.itemEvent.getGlobalEvent());
        return jsEventKey;
    }

    public void setItemEvent(DBItemEvent itemEvent) {
        this.itemEvent = itemEvent;
    }

    public Boolean isGlobalEvent() {
        return this.itemEvent.getGlobalEvent();
    }

    public Long getId() {
        return this.itemEvent.getId();
    }

    public String getSession() {
        return this.itemEvent.getSession();
    }

    public String getEvent() {
        return this.itemEvent.getEvent();
    }

    public String getJobStream() {
        return this.itemEvent.getJobStream();
    }

    public Date getCreated() {
        return this.itemEvent.getCreated();
    }

    public long getOutConditionId() {
        return this.itemEvent.getOutConditionId();
    }

    public void setCreated(Date created) {
        this.itemEvent.setCreated(created);
    }

    public void setEvent(String event) {
        this.itemEvent.setEvent(event);
    }

    public void setGlobalEvent(boolean globalEvent) {
        this.itemEvent.setGlobalEvent(globalEvent);
    }

    public void setSession(String session) {
        this.itemEvent.setSession(session);
    }

    public void setJobStream(String jobStream) {
        this.itemEvent.setJobStream(jobStream);
    }

    public void setSchedulerId(String schedulerId) {
        this.schedulerId = schedulerId;
    }

    public void setOutConditionId(Long outConditionId) {
        this.itemEvent.setOutConditionId(outConditionId);
    }

    public void setJobStreamHistoryId(Long jobStreamHistoryId) {
        this.itemEvent.setJobStreamHistoryId(jobStreamHistoryId);
    }

    public boolean store(SOSHibernateSession sosHibernateSession) {
        block4: {
            this.dbError = false;
            DBLayerEvents dbLayerEvents = new DBLayerEvents(sosHibernateSession);
            try {
                sosHibernateSession.beginTransaction();
                dbLayerEvents.store(this);
                sosHibernateSession.commit();
            }
            catch (SOSHibernateException e) {
                this.dbError = true;
                try {
                    sosHibernateSession.rollback();
                }
                catch (SOSHibernateException e1) {
                    LOGGER.warn("Could not rollback the transaction while storing an event");
                }
                if (!isDebugEnabled) break block4;
                LOGGER.debug("Could not store event: " + this.getEvent() + ":" + SOSString.toString((Object)this) + " " + e.getMessage());
            }
        }
        return this.dbError;
    }

    public boolean deleteEvent(SOSHibernateSession sosHibernateSession) {
        block4: {
            this.dbError = false;
            DBLayerEvents dbLayerEvents = new DBLayerEvents(sosHibernateSession);
            try {
                sosHibernateSession.beginTransaction();
                FilterEvents filterEvents = new FilterEvents();
                filterEvents.setSchedulerId(this.getSchedulerId());
                filterEvents.setEvent(this.getKey().getEvent());
                filterEvents.setSession(this.getSession());
                filterEvents.setGlobalEvent(this.isGlobalEvent());
                dbLayerEvents.delete(filterEvents);
                sosHibernateSession.commit();
            }
            catch (SOSHibernateException e) {
                this.dbError = true;
                LOGGER.error(e.getMessage(), (Throwable)e);
                try {
                    sosHibernateSession.rollback();
                }
                catch (SOSHibernateException e1) {
                    LOGGER.warn("Could not rollback the transaction while storing an event");
                }
                if (!isDebugEnabled) break block4;
                LOGGER.debug("Could not delete event: " + this.getEvent() + ":" + SOSString.toString((Object)this));
            }
        }
        return this.dbError;
    }

    public boolean isDbError() {
        return this.dbError;
    }

    public String toStr() {
        return this.getEvent() + "::" + SOSString.toString((Object)this);
    }
}

