/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.classes;

import com.sos.exception.SOSInvalidDataException;
import com.sos.joc.model.calendar.Period;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeriodResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(PeriodResolver.class);
    private List<Long> listOfStartTimes = new ArrayList<Long>();
    private Map<Long, Period> listOfPeriods = new HashMap<Long, Period>();
    private Date now;
    private SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-M-dd'T'HH:mm:ssX");

    private Date getDate(String date) throws ParseException {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return this.dateFormat.parse(date);
    }

    private void logPeriod(Period p) {
        LOGGER.info(p.getBegin() + " - " + p.getEnd());
        LOGGER.info("Single Start: " + p.getSingleStart());
        LOGGER.info("Repeat: " + p.getRepeat());
        LOGGER.info("Absolute Repeat: " + p.getAbsoluteRepeat());
    }

    private void add(Long start, Period period) {
        Date startDate;
        if (this.now == null) {
            this.now = new Date();
        }
        if ((startDate = new Date(start)).after(this.now) || startDate.compareTo(this.now) == 0) {
            Period p = this.listOfPeriods.get(start);
            if (p == null) {
                this.listOfPeriods.put(start, period);
            } else {
                LOGGER.info("Overlapping period for start time: " + start);
                this.logPeriod(p);
                this.logPeriod(period);
            }
        }
    }

    private void addRepeat(Period period) throws ParseException {
        if (period.getAbsoluteRepeat() != null && !period.getAbsoluteRepeat().isEmpty() && !"00:00:00".equals(period.getAbsoluteRepeat())) {
            Long start = this.getDate(period.getBegin()).getTime();
            Long end = this.getDate(period.getEnd()).getTime();
            Date repeat = this.getDate("2001-01-01T" + period.getAbsoluteRepeat() + "Z");
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(repeat);
            long offset = 1000 * (calendar.get(11) * 60 * 60 + calendar.get(12) * 60 + calendar.get(13));
            while (offset > 0L && start < end) {
                this.add(start, period);
                start = start + offset;
            }
        }
    }

    private Period normalizePeriod(Period p) throws SOSInvalidDataException {
        if (p.getBegin() == null || p.getBegin().isEmpty()) {
            p.setBegin("00:00:00");
        }
        if (p.getEnd() == null || p.getEnd().isEmpty()) {
            p.setEnd("24:00:00");
        }
        if (p.getAbsoluteRepeat() == null || p.getAbsoluteRepeat().isEmpty()) {
            p.setAbsoluteRepeat("00:00:00");
        } else {
            String d = p.getAbsoluteRepeat() + ":00:00:00";
            d = d.replaceAll("::", ":").substring(0, 8);
            p.setAbsoluteRepeat(d);
        }
        return p;
    }

    public void addStartTimes(Period period) throws ParseException, SOSInvalidDataException {
        if ((period = this.normalizePeriod(period)).getSingleStart() != null && !period.getSingleStart().isEmpty()) {
            Long start = this.getDate(period.getSingleStart()).getTime();
            this.add(start, period);
        } else {
            this.addRepeat(period);
        }
    }

    public List<Long> getStartTimes() throws ParseException {
        this.listOfStartTimes = new ArrayList<Long>();
        for (Map.Entry<Long, Period> period : this.listOfPeriods.entrySet()) {
            this.listOfStartTimes.add(period.getKey());
        }
        return this.listOfStartTimes;
    }
}

