/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.dailyplan.db.Calendar2DB;
import com.sos.jitl.dailyplan.db.DailyPlanDBLayer;
import com.sos.jitl.jobstreams.classes.JobStreamScheduler;
import com.sos.jitl.jobstreams.db.DBItemJobStreamParameter;
import com.sos.jitl.jobstreams.db.DBItemJobStreamStarter;
import com.sos.jitl.jobstreams.db.DBItemJobStreamStarterJob;
import com.sos.jitl.jobstreams.db.DBLayerJobStreamParameters;
import com.sos.jitl.jobstreams.db.DBLayerJobStreamsStarterJobs;
import com.sos.jitl.jobstreams.db.FilterJobStreamParameters;
import com.sos.jitl.jobstreams.db.FilterJobStreamStarterJobs;
import com.sos.jitl.jobstreams.db.FilterJobStreamStarters;
import com.sos.jitl.jobstreams.db.FilterJobStreams;
import com.sos.joc.model.common.NameValuePair;
import com.sos.joc.model.jobstreams.JobStreamJob;
import com.sos.joc.model.jobstreams.JobStreamStarter;
import com.sos.joc.model.jobstreams.JobStreamStarters;
import com.sos.joc.model.joe.schedule.RunTime;
import java.io.IOException;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.persistence.LockModeType;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerJobStreamStarters {
    private static final int LOCK_TIMEOUT = 3000;
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerJobStreamStarters.class);
    private static final String MAX_DATE = "01-01-2038";
    private static final String DBItemJobStreamStarter = DBItemJobStreamStarter.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerJobStreamStarters(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemJobStreamStarter getJobStreamStartersDbItem(Long id) throws SOSHibernateException {
        if (id == null) {
            return null;
        }
        return (DBItemJobStreamStarter)this.sosHibernateSession.get(DBItemJobStreamStarter.class, (Serializable)id);
    }

    public FilterJobStreamStarters resetFilter() {
        FilterJobStreamStarters filter = new FilterJobStreamStarters();
        filter.setStatus("");
        return filter;
    }

    private String getWhere(FilterJobStreamStarters filter) {
        String where = " ";
        String and = " ";
        if (filter.getStatus() != null && !"".equals(filter.getStatus())) {
            where = where + and + " status = :status";
            and = " and ";
        }
        if (filter.getTitle() != null && !"".equals(filter.getTitle())) {
            where = where + and + " title = :title";
            and = " and ";
        }
        if (filter.getStarterName() != null && !"".equals(filter.getStarterName())) {
            where = where + and + " starterName = :starterName";
            and = " and ";
        }
        if (filter.getId() != null) {
            where = where + and + " id  = :id";
            and = " and ";
        }
        if (filter.getJobStreamId() != null) {
            where = where + and + " jobStream  = :jobStream";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = " where " + where;
        }
        return where;
    }

    private <T> Query<T> bindParameters(FilterJobStreamStarters filter, Query<T> query) {
        if (filter.getId() != null) {
            query.setParameter("id", (Object)filter.getId());
        }
        if (filter.getStatus() != null && !"".equals(filter.getStatus())) {
            query.setParameter("status", (Object)filter.getStatus());
        }
        if (filter.getTitle() != null && !"".equals(filter.getTitle())) {
            query.setParameter("title", (Object)filter.getTitle());
        }
        if (filter.getStarterName() != null && !"".equals(filter.getStarterName())) {
            query.setParameter("starterName", (Object)filter.getStarterName());
        }
        if (filter.getJobStreamId() != null) {
            query.setParameter("jobStream", (Object)filter.getJobStreamId());
        }
        return query;
    }

    public List<DBItemJobStreamStarter> getJobStreamStartersList(FilterJobStreamStarters filter, int limit) throws SOSHibernateException {
        String q = "  from " + DBItemJobStreamStarter + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public Integer delete(FilterJobStreamStarters filter) throws SOSHibernateException {
        int row = 0;
        String hql = "";
        hql = "delete from " + DBItemJobStreamStarter + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filter, query);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public void save(DBItemJobStreamStarter dbItemJobStreamStarter) throws SOSHibernateException {
        this.sosHibernateSession.save((Object)dbItemJobStreamStarter);
    }

    public void update(DBItemJobStreamStarter dbItemJobStreamStarter) throws SOSHibernateException {
        FilterJobStreamStarters filter = new FilterJobStreamStarters();
        filter.setId(dbItemJobStreamStarter.getId());
        String q = "  from " + DBItemJobStreamStarter + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        query.setHint("javax.persistence.lock.timeout", (Object)2000);
        this.sosHibernateSession.getResultList(query);
        this.sosHibernateSession.update((Object)dbItemJobStreamStarter);
    }

    public Integer updateNextStart(DBItemJobStreamStarter dbItemJobStreamStarter) throws SOSHibernateException {
        FilterJobStreamStarters filter = new FilterJobStreamStarters();
        filter.setId(dbItemJobStreamStarter.getId());
        String q = "  from " + DBItemJobStreamStarter + this.getWhere(filter);
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        query.setLockMode(LockModeType.PESSIMISTIC_WRITE);
        query.setHint("javax.persistence.lock.timeout", (Object)3000);
        List l = this.sosHibernateSession.getResultList(query);
        if (l.size() > 0 && dbItemJobStreamStarter.getRunTime().equals(((DBItemJobStreamStarter)l.get(0)).getRunTime())) {
            q = " update " + DBItemJobStreamStarter + " set nextStart=:nextStart " + this.getWhere(filter);
            query = this.sosHibernateSession.createQuery(q);
            query = this.bindParameters(filter, query);
            query.setParameter("nextStart", (Object)dbItemJobStreamStarter.getNextStart());
            int row = this.sosHibernateSession.executeUpdate(query);
            return row;
        }
        return 0;
    }

    public Date getNextStartTime(ObjectMapper objectMapper, String timeZone, String runTimeString) throws JsonParseException, JsonMappingException, JsonProcessingException, IOException, Exception {
        JobStreamScheduler jobStreamScheduler = new JobStreamScheduler(timeZone);
        RunTime runTime = null;
        if (runTimeString != null) {
            runTime = (RunTime)objectMapper.readValue(runTimeString, RunTime.class);
        }
        if (runTime != null) {
            Calendar c = Calendar.getInstance();
            Date from = new Date();
            Date to = new Date();
            c.setTime(to);
            c.add(5, 3);
            to = c.getTime();
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
            String max = MAX_DATE;
            Date maxDate = formatter.parse(max);
            do {
                jobStreamScheduler.schedule(from, to, runTime, true);
                c.setTime(to);
                c.add(2, 1);
                from = to;
                to = c.getTime();
            } while (jobStreamScheduler.getListOfStartTimes().isEmpty() && to.before(maxDate));
        }
        Date now = new Date();
        if (jobStreamScheduler.getListOfStartTimes() != null) {
            for (Long start : jobStreamScheduler.getListOfStartTimes()) {
                if (start <= now.getTime()) continue;
                return new Date(start);
            }
        }
        return null;
    }

    public void saveOrUpdate(JobStreamStarters jobStreamStarters, String timezone) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        DBLayerJobStreamsStarterJobs dbLayerJobStreamsStarterJobs = new DBLayerJobStreamsStarterJobs(this.sosHibernateSession);
        Calendar2DB calendar2Db = new Calendar2DB(this.sosHibernateSession, jobStreamStarters.getJobschedulerId());
        boolean isNew = false;
        for (JobStreamStarter jobStreamStarter : jobStreamStarters.getJobstreamStarters()) {
            Long oldId = jobStreamStarter.getJobStreamStarterId();
            DBItemJobStreamStarter dbItemJobStreamStarter = this.getJobStreamStartersDbItem(oldId);
            if (dbItemJobStreamStarter == null) {
                isNew = true;
                dbItemJobStreamStarter = new DBItemJobStreamStarter();
                dbItemJobStreamStarter.setCreated(new Date());
            }
            dbItemJobStreamStarter.setJobStream(jobStreamStarters.getJobStreamId());
            dbItemJobStreamStarter.setStarterName(jobStreamStarter.getStarterName());
            dbItemJobStreamStarter.setEndOfJobStream(jobStreamStarter.getEndOfJobStream());
            dbItemJobStreamStarter.setRequiredJob(jobStreamStarter.getRequiredJob());
            dbItemJobStreamStarter.setTitle(jobStreamStarter.getTitle());
            dbItemJobStreamStarter.setState(jobStreamStarter.getState());
            if (jobStreamStarter.getRunTime() != null) {
                dbItemJobStreamStarter.setRunTime(objectMapper.writeValueAsString((Object)jobStreamStarter.getRunTime()));
            }
            dbItemJobStreamStarter.setNextStart(this.getNextStartTime(objectMapper, timezone, dbItemJobStreamStarter.getRunTime()));
            if (isNew) {
                this.save(dbItemJobStreamStarter);
            } else {
                this.update(dbItemJobStreamStarter);
            }
            jobStreamStarter.setJobStreamStarterId(dbItemJobStreamStarter.getId());
            DailyPlanDBLayer dailyPlanDBLayer = new DailyPlanDBLayer(this.sosHibernateSession);
            dailyPlanDBLayer.getFilter().setJobStreamStarterId(oldId);
            dailyPlanDBLayer.delete(false);
            FilterJobStreamStarterJobs filterJobStreamStarterJobs = new FilterJobStreamStarterJobs();
            filterJobStreamStarterJobs.setJobStreamStarter(dbItemJobStreamStarter.getId());
            dbLayerJobStreamsStarterJobs.delete(filterJobStreamStarterJobs);
            for (JobStreamJob jobStreamJob : jobStreamStarter.getJobs()) {
                DBItemJobStreamStarterJob dbItemJobStreamStarterJob = new DBItemJobStreamStarterJob();
                dbItemJobStreamStarterJob.setCreated(new Date());
                dbItemJobStreamStarterJob.setDelay(jobStreamJob.getStartDelay());
                dbItemJobStreamStarterJob.setJob(jobStreamJob.getJob());
                dbItemJobStreamStarterJob.setJobStreamStarter(dbItemJobStreamStarter.getId());
                if (jobStreamJob.getSkipOutCondition() == null) {
                    dbItemJobStreamStarterJob.setSkipOutCondition(false);
                } else {
                    dbItemJobStreamStarterJob.setSkipOutCondition(jobStreamJob.getSkipOutCondition());
                }
                Long newJobId = dbLayerJobStreamsStarterJobs.store(dbItemJobStreamStarterJob);
                jobStreamJob.setJobId(newJobId);
            }
            DBLayerJobStreamParameters dbLayerJobStreamParameters = new DBLayerJobStreamParameters(this.sosHibernateSession);
            FilterJobStreamParameters filterJobStreamParameters = new FilterJobStreamParameters();
            filterJobStreamParameters.setJobStreamStarterId(dbItemJobStreamStarter.getId());
            dbLayerJobStreamParameters.delete(filterJobStreamParameters);
            for (NameValuePair param : jobStreamStarter.getParams()) {
                DBItemJobStreamParameter dbItemJobStreamParameter = new DBItemJobStreamParameter();
                dbItemJobStreamParameter.setCreated(new Date());
                dbItemJobStreamParameter.setJobStreamStarter(dbItemJobStreamStarter.getId());
                if (param.getName() == null) continue;
                dbItemJobStreamParameter.setName(param.getName());
                if (param.getValue() == null) {
                    param.setValue("");
                }
                dbItemJobStreamParameter.setValue(param.getValue());
                this.sosHibernateSession.save((Object)dbItemJobStreamParameter);
            }
        }
        FilterJobStreams filterJobStreams = new FilterJobStreams();
        filterJobStreams.setJobStreamId(jobStreamStarters.getJobStreamId());
        calendar2Db.processJobStreamStarterFilter(filterJobStreams, timezone);
    }

    public void deleteStarters(JobStreamStarters jobStreamStarters, String timezone) throws Exception {
        DBLayerJobStreamParameters dbLayerJobStreamParameters = new DBLayerJobStreamParameters(this.sosHibernateSession);
        DBLayerJobStreamsStarterJobs dbLayerJobStreamsStarterJobs = new DBLayerJobStreamsStarterJobs(this.sosHibernateSession);
        Calendar2DB calendar2Db = new Calendar2DB(this.sosHibernateSession, jobStreamStarters.getJobschedulerId());
        for (JobStreamStarter jobStreamStarter : jobStreamStarters.getJobstreamStarters()) {
            FilterJobStreamStarters filterJobStreamStarters = new FilterJobStreamStarters();
            filterJobStreamStarters.setJobStreamId(jobStreamStarters.getJobStreamId());
            List<DBItemJobStreamStarter> lStarters = this.getJobStreamStartersList(filterJobStreamStarters, 0);
            if (lStarters.size() <= 0) continue;
            DailyPlanDBLayer dailyPlanDBLayer = new DailyPlanDBLayer(this.sosHibernateSession);
            dailyPlanDBLayer.getFilter().setJobStreamStarterId(jobStreamStarter.getJobStreamStarterId());
            dailyPlanDBLayer.delete(false);
            filterJobStreamStarters.setId(jobStreamStarter.getJobStreamStarterId());
            lStarters = this.getJobStreamStartersList(filterJobStreamStarters, 0);
            for (DBItemJobStreamStarter dbItemJobStreamStarter : lStarters) {
                FilterJobStreamStarterJobs filterJobStreamStarterJobs = new FilterJobStreamStarterJobs();
                filterJobStreamStarterJobs.setJobStreamStarter(dbItemJobStreamStarter.getId());
                dbLayerJobStreamsStarterJobs.delete(filterJobStreamStarterJobs);
            }
            for (DBItemJobStreamStarter dbItemJobStreamStarter : lStarters) {
                FilterJobStreamParameters filterJobStreamParameters = new FilterJobStreamParameters();
                filterJobStreamParameters.setJobStreamStarterId(dbItemJobStreamStarter.getId());
                dbLayerJobStreamParameters.delete(filterJobStreamParameters);
            }
            this.delete(filterJobStreamStarters);
        }
        FilterJobStreams filterJobStreams = new FilterJobStreams();
        filterJobStreams.setJobStreamId(jobStreamStarters.getJobStreamId());
        calendar2Db.processJobStreamStarterFilter(filterJobStreams, timezone);
    }
}

