/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.jobstreams.db;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.exceptions.SOSHibernateException;
import com.sos.jitl.jobstreams.db.DBItemJobStreamTaskContext;
import com.sos.jitl.jobstreams.db.FilterJobStreamTaskContext;
import java.io.Serializable;
import java.util.List;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DBLayerJobStreamsTaskContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DBLayerJobStreamsTaskContext.class);
    private static final String DBItemJobStreamTaskContext = DBItemJobStreamTaskContext.class.getSimpleName();
    private final SOSHibernateSession sosHibernateSession;

    public DBLayerJobStreamsTaskContext(SOSHibernateSession session) {
        this.sosHibernateSession = session;
    }

    public DBItemJobStreamTaskContext getJobStreamStarterJobsDbItem(Long id) throws SOSHibernateException {
        return (DBItemJobStreamTaskContext)this.sosHibernateSession.get(DBItemJobStreamTaskContext.class, (Serializable)id);
    }

    public FilterJobStreamTaskContext resetFilter() {
        FilterJobStreamTaskContext filter = new FilterJobStreamTaskContext();
        filter.setJobstreamHistoryId("");
        return filter;
    }

    private String getWhere(FilterJobStreamTaskContext filter) {
        String where = "";
        String and = " ";
        if (filter.getId() != null) {
            where = where + and + " id = :id";
            and = " and ";
        }
        if (filter.getJobstreamHistoryId() != null && !"".equals(filter.getJobstreamHistoryId())) {
            where = where + and + " jobStreamHistoryId = :jobStreamHistoryId";
            and = " and ";
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            where = where + and + " jobStream = :jobStream";
            and = " and ";
        }
        if (filter.getTaskId() != null) {
            where = where + and + " taskId = :taskId";
            and = " and ";
        }
        if (!"".equals(where.trim())) {
            where = " where " + where;
        }
        return where;
    }

    private <T> Query<T> bindParameters(FilterJobStreamTaskContext filter, Query<T> query) {
        if (filter.getId() != null) {
            query.setParameter("id", (Object)filter.getId());
        }
        if (filter.getJobstreamHistoryId() != null && !"".equals(filter.getJobstreamHistoryId())) {
            query.setParameter("jobStreamHistoryId", (Object)filter.getJobstreamHistoryId());
        }
        if (filter.getTaskId() != null) {
            query.setParameter("taskId", (Object)filter.getTaskId());
        }
        if (filter.getJobStream() != null && !"".equals(filter.getJobStream())) {
            query.setParameter("jobstream", (Object)filter.getJobStream());
        }
        return query;
    }

    public List<DBItemJobStreamTaskContext> getJobStreamStarterJobsList(FilterJobStreamTaskContext filter, int limit) throws SOSHibernateException {
        String q = "  from " + DBItemJobStreamTaskContext + this.getWhere(filter) + filter.getOrderCriteria() + filter.getSortMode();
        Query query = this.sosHibernateSession.createQuery(q);
        query = this.bindParameters(filter, query);
        if (limit > 0) {
            query.setMaxResults(limit);
        }
        return this.sosHibernateSession.getResultList(query);
    }

    public Integer delete(FilterJobStreamTaskContext filter) throws SOSHibernateException {
        int row = 0;
        String hql = "";
        hql = "delete from " + DBItemJobStreamTaskContext + this.getWhere(filter);
        LOGGER.debug("delete context: " + hql);
        Query query = this.sosHibernateSession.createQuery(hql);
        query = this.bindParameters(filter, query);
        row = this.sosHibernateSession.executeUpdate(query);
        return row;
    }

    public Long store(DBItemJobStreamTaskContext dbItemJobStreamTaskContext) throws SOSHibernateException {
        FilterJobStreamTaskContext filter = new FilterJobStreamTaskContext();
        filter.setTaskId(dbItemJobStreamTaskContext.getTaskId());
        filter.setJobstreamHistoryId(dbItemJobStreamTaskContext.getJobStreamHistoryId());
        this.delete(filter);
        LOGGER.debug("save context " + dbItemJobStreamTaskContext.getJobStreamHistoryId() + ":" + dbItemJobStreamTaskContext.getTaskId());
        this.sosHibernateSession.save((Object)dbItemJobStreamTaskContext);
        LOGGER.debug("new id: " + dbItemJobStreamTaskContext.getId());
        return dbItemJobStreamTaskContext.getId();
    }
}

