/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.join;

import java.io.Serializable;

public class JoinOrder
implements Serializable {
    private static final long serialVersionUID = 6335640211910020020L;
    private String jobChain;
    private String orderId;
    private String joinSessionId;
    private boolean isMainOrder;
    private String joinState;

    public JoinOrder(String jobChain, String orderId, String joinSessionId, boolean isMainOrder, String state) {
        this.jobChain = jobChain;
        this.orderId = orderId;
        this.isMainOrder = isMainOrder;
        this.joinSessionId = this.getMainOrderId(joinSessionId);
        this.joinState = state;
    }

    public String getJobChain() {
        return this.jobChain;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getJoinSessionId() {
        return this.joinSessionId;
    }

    public boolean isMainOrder() {
        return this.isMainOrder;
    }

    public String getJoinState() {
        return this.joinState;
    }

    public String getTitle() {
        return this.jobChain + "(" + this.orderId + ")::" + this.joinSessionId;
    }

    public String paramNameForSerializedList() {
        return String.format("jitl_joinOrderList_%s_%s", this.getJobChain(), this.getJoinState());
    }

    private String getMainOrderId(String joinSessionId) {
        if (this.isMainOrder) {
            return this.orderId;
        }
        if (!joinSessionId.isEmpty()) {
            return joinSessionId;
        }
        return this.orderId.replaceFirst("_[^_]*$", "");
    }

    public String getMainOrderIdTest() {
        return this.getMainOrderId("");
    }
}

