/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.mail.smtp;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.JSHelper.interfaces.ISOSSmtpMailOptions;
import com.sos.jitl.mail.smtp.JSSmtpMailOptions;
import com.sos.scheduler.model.SchedulerObjectFactory;
import com.sos.scheduler.model.objects.Spooler;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMail;
import sos.scheduler.command.SOSSchedulerCommand;

public class JSSmtpMailClient
extends JSJobUtilitiesClass<JSSmtpMailOptions> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JSSmtpMailClient.class);
    private static final String MESSAGE_FILE_PATH = "com_sos_scheduler_messages";

    public JSSmtpMailClient() {
        super((Object)new JSSmtpMailOptions());
        this.setMessageResource(MESSAGE_FILE_PATH);
    }

    public JSSmtpMailOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new JSSmtpMailOptions();
        }
        return (JSSmtpMailOptions)((Object)this.objOptions);
    }

    public JSSmtpMailClient Execute() throws Exception {
        JSSmtpMailOptions objO = (JSSmtpMailOptions)((Object)this.objOptions);
        this.Execute(objO);
        return this;
    }

    public JSSmtpMailClient Execute(JSSmtpMailOptions pobjOptions) throws Exception {
        if (pobjOptions != null && pobjOptions.enabled.isFalse()) {
            LOGGER.info("JSSmtpMailClient is disabled due to the enabled=false parameter");
        }
        if (pobjOptions != null && pobjOptions.enabled.isTrue() && pobjOptions.FileNotificationTo.isDirty()) {
            try {
                boolean useCurrentTaskLog;
                boolean bl = useCurrentTaskLog = !pobjOptions.job_name.isDirty() && !pobjOptions.job_id.isDirty();
                if (pobjOptions.tasklog_to_body.value()) {
                    Object objSp;
                    if (useCurrentTaskLog) {
                        pobjOptions.job_name.setValue(pobjOptions.getCurrentJobFolder(), pobjOptions.getCurrentJobName());
                        pobjOptions.job_id.value(pobjOptions.getCurrentJobId());
                    }
                    if (this.isNotNull(objSp = this.getSpoolerObject())) {
                        sos.spooler.Spooler objSpooler = (sos.spooler.Spooler)objSp;
                        if (!pobjOptions.scheduler_host.isDirty()) {
                            pobjOptions.scheduler_host.setValue(objSpooler.hostname());
                        }
                        if (!pobjOptions.scheduler_port.isDirty()) {
                            pobjOptions.scheduler_port.value(SOSSchedulerCommand.getHTTPPortFromScheduler((sos.spooler.Spooler)objSpooler));
                        }
                    }
                    pobjOptions.job_name.isMandatory(true);
                    pobjOptions.job_id.isMandatory(true);
                    pobjOptions.scheduler_host.isMandatory(true);
                    pobjOptions.scheduler_port.isMandatory(true);
                }
                pobjOptions.checkMandatory();
                String log = "";
                if (pobjOptions.tasklog_to_body.value()) {
                    log = this.getTaskLog(pobjOptions.job_name.getValue(), pobjOptions.job_id.value(), pobjOptions.scheduler_host.getValue(), pobjOptions.scheduler_port.value(), useCurrentTaskLog);
                }
                if (!pobjOptions.subject.isDirty()) {
                    String strT = "SOSJobScheduler: ${JobName} - ${JobTitle} - CC ${CC} ";
                    pobjOptions.subject.setValue(strT);
                }
                String strM = pobjOptions.subject.getValue();
                strM = pobjOptions.replaceVars(strM);
                pobjOptions.subject.setValue(strM);
                strM = pobjOptions.body.getValue();
                strM = pobjOptions.replaceVars(strM);
                Pattern pattern = Pattern.compile("[?%]log[?%]|[$%]\\{log\\}", 2);
                Matcher matcher = pattern.matcher(strM);
                strM = matcher.find() ? matcher.replaceAll(log) : strM + "\n" + log;
                pobjOptions.body.setValue(strM);
                if (!pobjOptions.from.isDirty()) {
                    pobjOptions.from.setValue("JobScheduler@sos-berlin.com");
                }
                SOSMail objMail = pobjOptions.smtp_user.getValue() != null && !pobjOptions.smtp_user.getValue().isEmpty() ? new SOSMail(pobjOptions.host.getValue(), pobjOptions.smtp_user.getValue(), pobjOptions.smtp_password.getValue()) : new SOSMail(pobjOptions.host.getValue());
                LOGGER.debug(pobjOptions.dirtyString());
                objMail.sendMail((ISOSSmtpMailOptions)pobjOptions);
            }
            catch (Exception e) {
                throw new JobSchedulerException(e.getMessage(), (Throwable)e);
            }
        }
        return this;
    }

    private String getTaskLog(String strJobName, int intTaskId, String strJSHost, int intJSPort, boolean bUseCurrentTaskLog) {
        String log = null;
        try {
            SchedulerObjectFactory objSchedulerObjectFactory = new SchedulerObjectFactory(strJSHost, intJSPort);
            objSchedulerObjectFactory.initMarshaller(Spooler.class);
            log = objSchedulerObjectFactory.getTaskLog(strJobName, intTaskId, bUseCurrentTaskLog);
        }
        catch (Exception e) {
            LOGGER.error(this.Messages.getMsg("JSJ_W_0001", new Object[]{strJobName, intTaskId, strJSHost, intJSPort}), (Throwable)e);
            log = "";
        }
        if (log == null) {
            LOGGER.error(this.Messages.getMsg("JSJ_W_0001", new Object[]{strJobName, intTaskId, strJSHost, intJSPort}));
            log = "";
        }
        return log;
    }
}

