/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.mailprocessor;

import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.jitl.mailprocessor.PostproccesingEntry;
import com.sos.jitl.mailprocessor.SOSMailProcessInboxOptions;
import com.sos.jitl.mailprocessor.SOSMailProcessor;
import com.sos.scheduler.messages.JSMessages;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMailReceiver;

public class SOSMailProcessInbox
extends JSJobUtilitiesClass<SOSMailProcessInboxOptions> {
    protected SOSMailProcessInboxOptions sosMailProcessInboxOptions = null;
    private static final String CLASSNAME = "SOSMailProcessInbox";
    private JSJobUtilities jsJobUtilities = this;
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSMailProcessInboxOptions.class);
    private List<PostproccesingEntry> listOfPostprocessing;

    public SOSMailProcessInbox() {
        super((Object)new SOSMailProcessInboxOptions());
    }

    public SOSMailProcessInboxOptions getOptions() {
        if (this.sosMailProcessInboxOptions == null) {
            this.sosMailProcessInboxOptions = new SOSMailProcessInboxOptions();
        }
        return this.sosMailProcessInboxOptions;
    }

    public SOSMailProcessInboxOptions getOptions(SOSMailProcessInboxOptions psosMailProcessInboxOptionsptions) {
        this.sosMailProcessInboxOptions = psosMailProcessInboxOptionsptions;
        return this.sosMailProcessInboxOptions;
    }

    public SOSMailProcessInbox execute() throws Exception {
        String METHODNAME = "SOSMailProcessInbox::execute";
        LOGGER.debug(String.format(JSMessages.JSJ_I_110.get(), "SOSMailProcessInbox::execute"));
        SOSMailReceiver mailReader = null;
        try {
            String mailHost = this.sosMailProcessInboxOptions.mailHost.getValue();
            int mailPort = this.sosMailProcessInboxOptions.mailPort.value();
            String serverType = this.sosMailProcessInboxOptions.mailServerType.getValue();
            mailReader = new SOSMailReceiver(this.sosMailProcessInboxOptions.mailHost.getValue(), this.sosMailProcessInboxOptions.mailPort.getValue(), this.sosMailProcessInboxOptions.mailUser.getValue(), this.sosMailProcessInboxOptions.mailPassword.getValue(), this.sosMailProcessInboxOptions.mailSsl.value(), this.sosMailProcessInboxOptions.mailServerType.getValue());
            if (this.sosMailProcessInboxOptions.mailServerTimeout.value() > 0) {
                mailReader.setTimeout(this.sosMailProcessInboxOptions.mailServerTimeout.value());
            }
            LOGGER.debug(String.format("Connecting to Mailserver %1$s:%2$d (%3$s)...", mailHost, mailPort, serverType));
            SOSMailProcessor sosMailProcessor = new SOSMailProcessor(this.sosMailProcessInboxOptions);
            for (String mailFolderName : this.sosMailProcessInboxOptions.mailMessageFolder.getValue().split("[,|;]")) {
                mailReader.connect(this.sosMailProcessInboxOptions.mailServerType.getValue());
                sosMailProcessor.performMessagesInFolder(mailReader, mailFolderName.trim());
            }
            this.listOfPostprocessing = sosMailProcessor.getListOfPostprocessing();
        }
        catch (Exception e) {
            try {
                LOGGER.error(e.getMessage(), (Throwable)e);
                LOGGER.error(String.format(JSMessages.JSJ_F_107.get(), "SOSMailProcessInbox::execute"), (Throwable)e);
                throw e;
            }
            catch (Throwable throwable) {
                LOGGER.debug(String.format(JSMessages.JSJ_I_111.get(), "SOSMailProcessInbox::execute"));
                if (mailReader != null) {
                    mailReader.closeFolder(true);
                    mailReader.disconnect();
                    mailReader = null;
                }
                throw throwable;
            }
        }
        LOGGER.debug(String.format(JSMessages.JSJ_I_111.get(), "SOSMailProcessInbox::execute"));
        if (mailReader != null) {
            mailReader.closeFolder(true);
            mailReader.disconnect();
            mailReader = null;
        }
        return this;
    }

    public List<PostproccesingEntry> getListOfPostprocessing() {
        return this.listOfPostprocessing;
    }

    public String replaceSchedulerVars(String pstrString2Modify) {
        LOGGER.debug("replaceSchedulerVars as Dummy-call executed. No Instance of JobUtilites specified.");
        return pstrString2Modify;
    }

    public void setJSParam(String pstrKey, String pstrValue) {
    }

    public void setJSParam(String pstrKey, StringBuilder pstrValue) {
    }

    public void setJSJobUtilites(JSJobUtilities pobjJSJobUtilities) {
        this.jsJobUtilities = pobjJSJobUtilities == null ? this : pobjJSJobUtilities;
        LOGGER.debug("objJSJobUtilities = " + this.jsJobUtilities.getClass().getName());
    }
}

