/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.managed.job;

import com.sos.JSHelper.Basics.IJSCommands;
import com.sos.JSHelper.Basics.JSJobUtilities;
import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.jitl.managed.job.ManagedDatabaseJob;
import com.sos.jitl.managed.job.ManagedDatabaseJobOptions;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Order;
import sos.spooler.Variable_set;
import sos.util.SOSString;

public class ManagedDatabaseJobJSAdapterClass
extends JobSchedulerJobAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedDatabaseJobJSAdapterClass.class);
    private ManagedDatabaseJob job;

    public boolean spooler_init() {
        try {
            this.job = new ManagedDatabaseJob();
            this.job.setJSJobUtilites((JSJobUtilities)this);
            this.job.setJSCommands((IJSCommands)this);
        }
        catch (Exception e) {
            throw new JobSchedulerException("Fatal Error:" + e.getMessage(), (Throwable)e);
        }
        return super.spooler_init();
    }

    public boolean spooler_process() throws Exception {
        try {
            super.spooler_process();
            ManagedDatabaseJobOptions options = this.job.getOptions();
            options.setCurrentNodeName(this.getCurrentNodeName(this.getSpoolerProcess().getOrder(), true));
            options.setAllOptions(this.getSchedulerParameterAsProperties(this.getSpoolerProcess().getOrder()));
            if (SOSString.isEmpty((String)options.command.getValue())) {
                LOGGER.debug("\"command\" parameter is empty. set command from job script...");
                String jobScript = this.getJobScript();
                if (SOSString.isEmpty((String)jobScript)) {
                    throw new Exception("command is empty. please check the job/order \"command\" parameter or the job script element.");
                }
                jobScript = jobScript.replaceAll(Pattern.quote("\\${"), "\\${");
                options.command.setValue(this.replaceSchedulerVars(jobScript));
            }
            Variable_set orderParams = null;
            Order order = this.spooler_task.order();
            if (order != null) {
                orderParams = order.params();
            }
            this.job.execute(this.spooler_task.job().order_queue() != null, orderParams);
            if (this.job.getModel().getWarning() != null) {
                this.spooler_log.warn(this.job.getModel().getWarning());
            }
            options.command.setValue("");
            return this.getSpoolerProcess().isOrderJob();
        }
        catch (Exception e) {
            throw new JobSchedulerException(String.format("Exception: %s", e.toString()), (Throwable)e);
        }
    }
}

