/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.helper.elements.monitor.jms;

import com.sos.jitl.notification.helper.NotificationXmlHelper;
import com.sos.jitl.notification.helper.elements.monitor.AElementNotificationMonitor;
import com.sos.jitl.notification.helper.elements.monitor.jms.ElementNotificationJMSConnectionFactory;
import com.sos.jitl.notification.helper.elements.monitor.jms.ElementNotificationJMSJNDI;
import com.sos.jitl.notification.plugins.notifier.ISystemNotifierPlugin;
import com.sos.jitl.notification.plugins.notifier.SystemNotifierSendJMSPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import sos.util.SOSDate;
import sos.util.SOSString;

public class ElementNotificationJMS
extends AElementNotificationMonitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ElementNotificationJMS.class);
    public static int DEFAULT_ACKNOWLEDGE_MODE = 2;
    public static int DEFAULT_PRIOPITY = 4;
    public static int DEFAULT_DELIVERY_MODE = 2;
    public static long DEFAULT_TIME_TO_LIVE = 0L;
    public static String DEFAULT_DESTINATION = "Queue";
    public static String ELEMENT_NAME_CONNECTION_FACTORY = "ConnectionFactory";
    public static String ELEMENT_NAME_CONNECTION_JNDI = "ConnectionJNDI";
    public static String ELEMENT_NAME_MESSAGE = "Message";
    public static String ATTRIBUTE_NAME_CLIENT_ID = "client_id";
    public static String ATTRIBUTE_NAME_DESTINATION = "destination";
    public static String ATTRIBUTE_NAME_ACKNOWLEDGE_MODE = "acknowledge_mode";
    public static String ATTRIBUTE_NAME_DELIVERY_MODE = "delivery_mode";
    public static String ATTRIBUTE_NAME_PRIORITY = "priority";
    public static String ATTRIBUTE_NAME_TIME_TO_LIVE = "time_to_live";
    private ElementNotificationJMSConnectionFactory connectionFactory;
    private ElementNotificationJMSJNDI connectionJndi;
    private String clientId;
    private String destination;
    private boolean isQueueDestination;
    private int acknowledgeMode;
    private int priority;
    private int deliveryMode;
    private long timeToLive;
    private String message;

    public ElementNotificationJMS(Node node) throws Exception {
        super(node);
        Node cj;
        Node cf = NotificationXmlHelper.getChildNode(this.getXmlElement(), ELEMENT_NAME_CONNECTION_FACTORY);
        if (cf != null) {
            this.connectionFactory = new ElementNotificationJMSConnectionFactory(cf);
        }
        if ((cj = NotificationXmlHelper.getChildNode(this.getXmlElement(), ELEMENT_NAME_CONNECTION_JNDI)) != null) {
            this.connectionJndi = new ElementNotificationJMSJNDI(cj);
        }
        this.clientId = ElementNotificationJMS.getValue(this.getXmlElement().getAttribute(ATTRIBUTE_NAME_CLIENT_ID));
        this.destination = ElementNotificationJMS.getValue(this.getXmlElement().getAttribute(ATTRIBUTE_NAME_DESTINATION), DEFAULT_DESTINATION);
        this.isQueueDestination = this.destination.toLowerCase().equals(DEFAULT_DESTINATION.toLowerCase());
        this.acknowledgeMode = this.getAcknowledgeMode(this.getXmlElement().getAttribute(ATTRIBUTE_NAME_ACKNOWLEDGE_MODE));
        this.priority = ElementNotificationJMS.getValue(this.getXmlElement().getAttribute(ATTRIBUTE_NAME_PRIORITY), DEFAULT_PRIOPITY);
        this.deliveryMode = this.getDeliveryMode(this.getXmlElement().getAttribute(ATTRIBUTE_NAME_DELIVERY_MODE));
        this.timeToLive = this.getTimeToLive(this.getXmlElement().getAttribute(ATTRIBUTE_NAME_TIME_TO_LIVE));
        this.message = ElementNotificationJMS.getValue(NotificationXmlHelper.getChildNodeValue(this.getXmlElement(), ELEMENT_NAME_MESSAGE));
    }

    private long getTimeToLive(String val) {
        try {
            return SOSDate.resolveAge((String)"ms", (String)val);
        }
        catch (Exception ex) {
            LOGGER.warn(ex.toString(), (Throwable)ex);
            return DEFAULT_TIME_TO_LIVE;
        }
    }

    private int getAcknowledgeMode(String mode) {
        if (!SOSString.isEmpty((String)mode)) {
            switch (mode.trim().toUpperCase()) {
                case "SESSION.CLIENT_ACKNOWLEDGE": {
                    return 2;
                }
                case "SESSION.AUTO_ACKNOWLEDGE": {
                    return 1;
                }
                case "SESSION.DUPS_OK_ACKNOWLEDGE": {
                    return 3;
                }
            }
        }
        return DEFAULT_ACKNOWLEDGE_MODE;
    }

    private int getDeliveryMode(String mode) {
        if (!SOSString.isEmpty((String)mode)) {
            switch (mode.trim().toUpperCase()) {
                case "DELIVERYMODE.PERSISTENT": {
                    return 2;
                }
                case "DELIVERYMODE.NON_PERSISTENT": {
                    return 1;
                }
            }
        }
        return DEFAULT_DELIVERY_MODE;
    }

    @Override
    public ISystemNotifierPlugin getOrCreatePluginObject() throws Exception {
        if (SOSString.isEmpty((String)this.getPlugin())) {
            return new SystemNotifierSendJMSPlugin();
        }
        return this.initializePlugin(this.getPlugin());
    }

    public ElementNotificationJMSConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public ElementNotificationJMSJNDI getConnectionJNDI() {
        return this.connectionJndi;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getDestination() {
        return this.destination;
    }

    public boolean isQueueDestination() {
        return this.isQueueDestination;
    }

    public int getAcknowledgeMode() {
        return this.acknowledgeMode;
    }

    public int getPriority() {
        return this.priority;
    }

    public int getDeliveryMode() {
        return this.deliveryMode;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public String getMessage() {
        return this.message;
    }
}

