/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.jobs.notifier;

import com.sos.JSHelper.Basics.JSJobUtilitiesClass;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.notification.db.DBLayer;
import com.sos.jitl.notification.jobs.notifier.SystemNotifierJobOptions;
import com.sos.jitl.notification.model.notifier.SystemNotifierModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.spooler.Spooler;

public class SystemNotifierJob
extends JSJobUtilitiesClass<SystemNotifierJobOptions> {
    private static Logger LOGGER = LoggerFactory.getLogger(SystemNotifierJob.class);
    private final String className = SystemNotifierJob.class.getSimpleName();
    private SOSHibernateFactory factory;
    private SOSHibernateSession session;
    private Spooler spooler;

    public SystemNotifierJob() {
        super((Object)new SystemNotifierJobOptions());
    }

    public void init(Spooler sp) throws Exception {
        this.spooler = sp;
        try {
            this.factory = new SOSHibernateFactory(this.getOptions().hibernate_configuration_file_reporting.getValue());
            this.factory.setAutoCommit(this.getOptions().connection_autocommit.value());
            this.factory.setTransactionIsolation(this.getOptions().connection_transaction_isolation.value());
            this.factory.addClassMapping(DBLayer.getNotificationClassMapping());
            this.factory.build();
        }
        catch (Exception ex) {
            throw new Exception(String.format("init connection: %s", ex.toString()), ex);
        }
    }

    public void openSession() throws Exception {
        this.session = this.factory.openStatelessSession();
    }

    public void closeSession() throws Exception {
        if (this.session != null) {
            this.session.close();
        }
    }

    public void exit() {
        if (this.factory != null) {
            this.factory.close();
        }
    }

    public SystemNotifierJob execute() throws Exception {
        String methodName = this.className + "::execute";
        LOGGER.debug(methodName);
        try {
            this.getOptions().checkMandatory();
            LOGGER.debug(this.getOptions().toString());
            SystemNotifierModel model = new SystemNotifierModel(this.session, this.getOptions(), this.spooler);
            model.process();
        }
        catch (Exception e) {
            LOGGER.error(String.format("%s: %s", methodName, e.toString()), (Throwable)e);
            throw e;
        }
        return this;
    }

    public SystemNotifierJobOptions getOptions() {
        if (this.objOptions == null) {
            this.objOptions = new SystemNotifierJobOptions();
        }
        return (SystemNotifierJobOptions)((Object)this.objOptions);
    }
}

