/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.model.cleanup;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.notification.db.DBLayerSchedulerMon;
import com.sos.jitl.notification.jobs.cleanup.CleanupNotificationsJobOptions;
import com.sos.jitl.notification.model.INotificationModel;
import com.sos.jitl.notification.model.NotificationModel;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSDate;

public class CleanupNotificationsModel
extends NotificationModel
implements INotificationModel {
    final Logger logger = LoggerFactory.getLogger(CleanupNotificationsModel.class);
    private CleanupNotificationsJobOptions options;

    public CleanupNotificationsModel(SOSHibernateSession sess, CleanupNotificationsJobOptions opt) throws Exception {
        super(sess);
        TimeZone.setDefault(TimeZone.getTimeZone("UTC"));
        this.options = opt;
    }

    @Override
    public void process() throws Exception {
        try {
            Long minutes = SOSDate.resolveAge((String)"m", (String)this.options.age.getValue());
            Date date = DBLayerSchedulerMon.getCurrentDateTimeMinusMinutes(minutes.intValue());
            this.getDbLayer().getSession().beginTransaction();
            this.getDbLayer().cleanupNotifications(date);
            this.getDbLayer().getSession().commit();
        }
        catch (Exception ex) {
            this.getDbLayer().getSession().rollback();
            throw ex;
        }
    }
}

