/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.model.notifier;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.notification.db.DBItemSchedulerMonChecks;
import com.sos.jitl.notification.db.DBItemSchedulerMonInternalNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonSystemResults;
import com.sos.jitl.notification.db.DBLayer;
import com.sos.jitl.notification.helper.EServiceMessagePrefix;
import com.sos.jitl.notification.helper.EServiceStatus;
import com.sos.jitl.notification.helper.JobChainNotification;
import com.sos.jitl.notification.helper.NotificationXmlHelper;
import com.sos.jitl.notification.helper.counters.CounterSystemNotifier;
import com.sos.jitl.notification.helper.elements.monitor.ElementNotificationMonitor;
import com.sos.jitl.notification.helper.elements.objects.ElementJob;
import com.sos.jitl.notification.helper.elements.objects.ElementTimerRef;
import com.sos.jitl.notification.helper.elements.objects.internal.ElementInternal;
import com.sos.jitl.notification.helper.elements.objects.internal.ElementMasterMessage;
import com.sos.jitl.notification.helper.elements.objects.internal.ElementTaskIfLongerThan;
import com.sos.jitl.notification.helper.elements.objects.internal.ElementTaskIfShorterThan;
import com.sos.jitl.notification.helper.elements.objects.internal.ElementTaskWarning;
import com.sos.jitl.notification.helper.elements.objects.jobchain.ElementJobChain;
import com.sos.jitl.notification.jobs.notifier.SystemNotifierJobOptions;
import com.sos.jitl.notification.model.INotificationModel;
import com.sos.jitl.notification.model.NotificationModel;
import com.sos.jitl.notification.model.history.CheckHistoryModel;
import com.sos.jitl.notification.plugins.notifier.ISystemNotifierPlugin;
import com.sos.jitl.reporting.helper.ReportUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.spooler.Spooler;
import sos.util.SOSString;
import sos.xml.SOSXMLXPath;

public class SystemNotifierModel
extends NotificationModel
implements INotificationModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(SystemNotifierModel.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private static final String THREE_PARAMS_LOGGING = "[%s][%s][%s]-%s";
    private static final String CALL_PLUGIN_LOGGING = "[%s][%s][%s][%s][notification %s of %s]call plugin %s";
    private static final String SENT_LOGGING = "[%s]sended=%s, error=%s, skipped=%s (total checked=%s)";
    private Spooler spooler;
    private SystemNotifierJobOptions options;
    private String systemId;
    private File systemFile = null;
    private ArrayList<ElementNotificationMonitor> monitors;
    private ArrayList<ElementJob> monitorJobs;
    private ArrayList<ElementJobChain> monitorJobChains;
    private ArrayList<ElementTimerRef> monitorOnErrorTimers;
    private ArrayList<ElementTimerRef> monitorOnSuccessTimers;
    private ArrayList<ElementMasterMessage> monitorInternalMasterMessages;
    private ArrayList<ElementTaskIfLongerThan> monitorInternalTaskIfLongerThan;
    private ArrayList<ElementTaskIfShorterThan> monitorInternalTaskIfShorterThan;
    private ArrayList<ElementTaskWarning> monitorInternalTaskWarning;
    private Optional<Integer> largeResultFetchSize = Optional.empty();
    private CounterSystemNotifier counter;
    private ArrayList<Long> handledByNotifyAgain;

    public SystemNotifierModel(SOSHibernateSession sess, SystemNotifierJobOptions opt, Spooler sp) throws Exception {
        super(sess);
        this.options = opt;
        this.spooler = sp;
        try {
            int fetchSize = this.options.large_result_fetch_size.value();
            if (fetchSize != -1) {
                this.largeResultFetchSize = Optional.of(fetchSize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void initMonitorObjects() {
        this.monitors = new ArrayList();
        this.monitorJobs = new ArrayList();
        this.monitorJobChains = new ArrayList();
        this.monitorOnErrorTimers = new ArrayList();
        this.monitorOnSuccessTimers = new ArrayList();
        this.monitorInternalMasterMessages = new ArrayList();
        this.monitorInternalTaskIfLongerThan = new ArrayList();
        this.monitorInternalTaskIfShorterThan = new ArrayList();
        this.monitorInternalTaskWarning = new ArrayList();
    }

    private void initSendCounters() {
        this.counter = new CounterSystemNotifier();
    }

    private boolean initConfig() throws Exception {
        String method = "initConfig";
        this.systemFile = null;
        this.systemId = null;
        String systemFilePath = null;
        if (!SOSString.isEmpty((String)this.options.system_configuration_file.getValue())) {
            this.systemFile = new File(this.options.system_configuration_file.getValue());
            systemFilePath = this.systemFile.getCanonicalPath();
            if (!this.systemFile.exists()) {
                throw new Exception(String.format("[%s][%s]system configuration file not found", method, SystemNotifierModel.normalizePath(this.systemFile)));
            }
        }
        if (this.systemFile == null) {
            this.systemFile = SystemNotifierModel.getDefaultNotificationXml();
            systemFilePath = this.systemFile.getCanonicalPath();
            if (!this.systemFile.exists()) {
                throw new Exception(String.format("[%s][%s]default system configuration file not found", method, SystemNotifierModel.normalizePath(this.systemFile)));
            }
            this.systemId = "MonitorSystem";
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]ignore configured SystemMonitorNotification/@system_id and use default system_id=%s", method, this.systemId));
            }
        } else if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s][%s]skip check default configuration file", method, SystemNotifierModel.getDefaultNotificationXml()));
        }
        LOGGER.info(String.format("[%s]%s", method, systemFilePath));
        SOSXMLXPath xpath = new SOSXMLXPath(systemFilePath);
        this.initMonitorObjects();
        if (SOSString.isEmpty((String)this.systemId)) {
            this.systemId = NotificationXmlHelper.getSystemMonitorNotificationSystemId(xpath);
        }
        if (SOSString.isEmpty((String)this.systemId)) {
            throw new Exception(String.format("systemId is NULL (configured SystemMonitorNotification/@system_id is not found)", new Object[0]));
        }
        NodeList monitorList = NotificationXmlHelper.selectNotificationMonitorDefinitions(xpath);
        int valide = this.setMonitorObjects(xpath, monitorList);
        int jobChains = this.monitorJobChains.size();
        int jobs = this.monitorJobs.size();
        int timersOnError = this.monitorOnErrorTimers.size();
        int timersOnSuccess = this.monitorOnSuccessTimers.size();
        int masterMessages = this.monitorInternalMasterMessages.size();
        int taskIfLongerThan = this.monitorInternalTaskIfLongerThan.size();
        int taskIfShorterThan = this.monitorInternalTaskIfShorterThan.size();
        int taskWarning = this.monitorInternalTaskWarning.size();
        int total = jobChains + jobs + timersOnError + timersOnSuccess + masterMessages + taskIfLongerThan + taskIfShorterThan + taskWarning;
        String msg = String.format("[%s][NotificationMonitors=%s(valide=%s)][JobChains=%s][Jobs=%s][TimerRefs onError=%s, onSuccess=%s][MasterMessage=%s][TaskIfLongerThan=%s][TaskIfShorterThan=%s][TaskWarning=%s]", method, monitorList.getLength(), valide, jobChains, jobs, timersOnError, timersOnSuccess, masterMessages, taskIfLongerThan, taskIfShorterThan, taskWarning);
        if (total > 0) {
            LOGGER.info(msg);
        } else {
            LOGGER.warn(msg);
        }
        return total > 0;
    }

    private int setMonitorObjects(SOSXMLXPath xpath, NodeList monitorList) throws Exception {
        int counter = 0;
        for (int i = 0; i < monitorList.getLength(); ++i) {
            Node n = monitorList.item(i);
            ElementNotificationMonitor monitor = new ElementNotificationMonitor(n, this.options);
            if (monitor.getMonitorInterface() == null) {
                LOGGER.warn(String.format("skip NotificationMonitor[service_name_on_error=%s, service_name_on_success=%s]: missing child Notification... element", monitor.getServiceNameOnError(), monitor.getServiceNameOnSuccess()));
                continue;
            }
            ++counter;
            this.monitors.add(monitor);
            NodeList objects = NotificationXmlHelper.selectNotificationMonitorNotificationObjects(xpath, n);
            block19: for (int j = 0; j < objects.getLength(); ++j) {
                Node object = objects.item(j);
                switch (object.getNodeName()) {
                    case "Job": {
                        this.monitorJobs.add(new ElementJob(monitor, object));
                        continue block19;
                    }
                    case "JobChain": {
                        this.monitorJobChains.add(new ElementJobChain(monitor, object));
                        continue block19;
                    }
                    case "TimerRef": {
                        if (!SOSString.isEmpty((String)monitor.getServiceNameOnError())) {
                            this.monitorOnErrorTimers.add(new ElementTimerRef(monitor, object));
                        }
                        if (SOSString.isEmpty((String)monitor.getServiceNameOnSuccess())) continue block19;
                        this.monitorOnSuccessTimers.add(new ElementTimerRef(monitor, object));
                        continue block19;
                    }
                    case "MasterMessage": {
                        this.monitorInternalMasterMessages.add(new ElementMasterMessage(monitor, object));
                        continue block19;
                    }
                    case "TaskIfLongerThan": {
                        this.monitorInternalTaskIfLongerThan.add(new ElementTaskIfLongerThan(monitor, object));
                        continue block19;
                    }
                    case "TaskIfShorterThan": {
                        this.monitorInternalTaskIfShorterThan.add(new ElementTaskIfShorterThan(monitor, object));
                        continue block19;
                    }
                    case "TaskWarning": {
                        this.monitorInternalTaskWarning.add(new ElementTaskWarning(monitor, object));
                        continue block19;
                    }
                }
            }
        }
        return counter;
    }

    private void executeNotifyTimer(int currentCounter, String systemId, DBItemSchedulerMonChecks check, ElementTimerRef timer, boolean isNotifyOnErrorService) throws Exception {
        ISystemNotifierPlugin pl;
        String method = "    [" + currentCounter + "][executeNotifyTimer]";
        String serviceName = isNotifyOnErrorService ? timer.getMonitor().getServiceNameOnError() : timer.getMonitor().getServiceNameOnSuccess();
        EServiceStatus pluginStatus = isNotifyOnErrorService ? EServiceStatus.CRITICAL : EServiceStatus.OK;
        DBItemSchedulerMonNotifications notification = this.getDbLayer().getNotification(check.getNotificationId());
        if (notification == null) {
            this.counter.addSkip();
            LOGGER.info(String.format("%s[%s][skip]notification id=%s not found", method, serviceName, check.getNotificationId()));
            return;
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s %s", method, NotificationModel.toString(notification)));
        }
        if (notification.getStep().equals(DBLayer.NOTIFICATION_DUMMY_MAX_STEP)) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][skip][step is a dummy step]%s", method, NotificationModel.toString(notification)));
            }
            return;
        }
        boolean checkSmOnSuccess = false;
        String stepFrom = check.getStepFrom();
        String stepTo = check.getStepTo();
        String returnCodeFrom = null;
        String returnCodeTo = null;
        Long notifications = timer.getNotifications();
        if (notifications < 1L) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[%s][skip]notifications %s < 1", method, serviceName, notifications));
            }
            return;
        }
        DBItemSchedulerMonSystemNotifications sn = this.getDbLayer().getSystemNotification(systemId, serviceName, notification.getId(), check.getId(), check.getObjectType(), checkSmOnSuccess, stepFrom, stepTo, returnCodeFrom, returnCodeTo);
        boolean isNew = false;
        if (sn == null) {
            isNew = true;
            Date startTime = notification.getOrderStartTime();
            Date endTime = notification.getOrderEndTime();
            if (notification.getStandalone()) {
                startTime = notification.getTaskStartTime();
                endTime = notification.getTaskEndTime();
            }
            try {
                this.getDbLayer().getSession().beginTransaction();
                sn = this.getDbLayer().createSystemNotification(systemId, serviceName, notification.getId(), check.getId(), returnCodeFrom, returnCodeTo, check.getObjectType(), stepFrom, stepTo, startTime, endTime, new Long(0L), notifications, false, false, checkSmOnSuccess);
                this.getDbLayer().getSession().save((Object)sn);
                this.getDbLayer().getSession().commit();
            }
            catch (Exception ex) {
                try {
                    this.getDbLayer().getSession().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[notify_on_error=%s][isNew=%s]%s", method, timer.getNotifyOnError(), isNew, NotificationModel.toString(sn)));
        }
        if (sn.getMaxNotifications()) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]maxNotifications=true", method));
            }
            return;
        }
        if (sn.getAcknowledged()) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]acknowledged=true", method));
            }
            return;
        }
        if (sn.getCurrentNotification() >= notifications) {
            this.closeSystemNotification(sn, notification.getOrderEndTime());
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip][close][%s]count notifications was reached", method, notifications));
            }
            return;
        }
        if (!timer.getNotifyOnError()) {
            if (check.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_JOB_CHAIN)) {
                List<DBItemSchedulerMonSystemResults> sendedErrorNotifications = this.getDbLayer().getSystemResults(notification, systemId);
                if (sendedErrorNotifications != null && sendedErrorNotifications.size() > 0) {
                    this.closeSystemNotification(sn, notification.getOrderEndTime());
                    this.counter.addSkip();
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("%s[notify_on_error=false][skip][close]following errors were sent:", method));
                        int e = 0;
                        for (DBItemSchedulerMonSystemResults r : sendedErrorNotifications) {
                            LOGGER.debug(String.format("%s   [%s]%s", method, ++e, NotificationModel.toString(r)));
                        }
                    }
                    return;
                }
            } else if (check.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_JOB) && notification.getError()) {
                this.closeSystemNotification(sn, notification.getOrderEndTime());
                this.counter.addSkip();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[notify_on_error=false][skip][close]notification has an error", method));
                }
                return;
            }
        }
        if ((pl = this.getOrCreatePluginObject(timer.getMonitor(), method, serviceName)) == null) {
            return;
        }
        try {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[before]%s", method, NotificationModel.toString(sn)));
            }
            sn.setCurrentNotification(sn.getCurrentNotification() + 1L);
            if (sn.getCurrentNotification() >= notifications || sn.getAcknowledged()) {
                sn.setMaxNotifications(true);
            }
            sn.setSuccess(checkSmOnSuccess);
            sn.setModified(DBLayer.getCurrentDateTime());
            sn.setNotifications(notifications);
            String name = sn.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_JOB) ? "Job " + notification.getJobName() : notification.getJobChainName();
            LOGGER.info("----------------------------------------------------------------");
            LOGGER.info(String.format(CALL_PLUGIN_LOGGING, method, "notifyOnTimer", serviceName, name, sn.getCurrentNotification(), sn.getNotifications(), pl.getClass().getSimpleName()));
            pl.notifySystem(this.getSpooler(), this.options, this.getDbLayer(), notification, sn, check, pluginStatus, EServiceMessagePrefix.TIMER);
            this.getDbLayer().getSession().beginTransaction();
            this.getDbLayer().getSession().update((Object)sn);
            this.getDbLayer().getSession().commit();
            this.counter.addSuccess();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[after]%s", method, NotificationModel.toString(sn)));
            }
            LOGGER.info("----------------------------------------------------------------");
        }
        catch (Exception ex) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.warn(String.format(THREE_PARAMS_LOGGING, method, "notifyOnTimer", serviceName, ex.getMessage()), (Throwable)ex);
            this.counter.addError();
        }
    }

    private void closeSystemNotification(DBItemSchedulerMonSystemNotifications sm, Date stepToEndTime) throws Exception {
        sm.setStepToEndTime(stepToEndTime);
        sm.setMaxNotifications(true);
        sm.setModified(DBLayer.getCurrentDateTime());
        try {
            this.getDbLayer().getSession().beginTransaction();
            this.getDbLayer().getSession().update((Object)sm);
            this.getDbLayer().getSession().commit();
        }
        catch (Exception ex) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ex;
        }
    }

    private boolean checkDoNotifyByReturnCodes(DBItemSchedulerMonNotifications notification, String serviceName, String notifyMsg, String configuredName, String configuredReturnCodeFrom, String configuredReturnCodeTo) {
        Long rc;
        String method = "checkDoNotifyByReturnCodes";
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s][%s][%s]%s", method, notifyMsg, serviceName, NotificationModel.toString(notification)));
        }
        if (notification.getStandalone()) {
            if (notification.getTaskEndTime() == null) {
                this.counter.addSkip();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][%s][skip][standalone]task is not completed - task end time is empty", method, notifyMsg, serviceName));
                }
                return false;
            }
        } else if (notification.getOrderStepEndTime() == null) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s][skip][order]step is not completed - step end time is empty", method, notifyMsg, serviceName));
            }
            return false;
        }
        if (!configuredReturnCodeFrom.equals("*")) {
            try {
                rc = Long.parseLong(configuredReturnCodeFrom);
                if (notification.getReturnCode() < rc) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][%s][skip]return code (%s) less than configured return_code_from (%s)", method, notifyMsg, serviceName, notification.getReturnCode(), configuredReturnCodeFrom));
                    }
                    return false;
                }
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s][%s][%s][%s][skip][configured return_code_from \"%s\" is not a valid integer value]%s", method, notifyMsg, serviceName, configuredName, configuredReturnCodeFrom, ex.getMessage()));
                return false;
            }
        }
        if (!configuredReturnCodeTo.equals("*")) {
            try {
                rc = Long.parseLong(configuredReturnCodeTo);
                if (notification.getReturnCode() > rc) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][%s][skip]return code (%s) greater than configured return_code_to (%s)", method, notifyMsg, serviceName, notification.getReturnCode(), configuredReturnCodeTo));
                    }
                    return false;
                }
            }
            catch (Exception ex) {
                LOGGER.warn(String.format("[%s][%s][%s][%s][skip][configured return_code_to \"%s\" is not a valid integer value]%s", method, notifyMsg, serviceName, configuredName, configuredReturnCodeTo, ex.getMessage()));
                return false;
            }
        }
        return true;
    }

    private boolean checkDoNotifyTimer(int currentCounter, DBItemSchedulerMonChecks check, ElementTimerRef timer) {
        String method = "  [" + currentCounter + "][checkDoNotifyTimer]";
        boolean notify = true;
        String ref = timer.getRef();
        if (!check.getName().equals(ref)) {
            notify = false;
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[notify=%s]%s", method, notify, ref));
        }
        return notify;
    }

    public static boolean checkDoNotifyInternal(int currentCounter, String schedulerId, ElementInternal el) throws Exception {
        String method = "  [" + currentCounter + "][checkDoNotifyInternal]";
        boolean notify = true;
        if (!el.getSchedulerId().equals("*")) {
            try {
                if (!schedulerId.matches(el.getSchedulerId())) {
                    notify = false;
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("%s[notify=%s][schedulerId not match][%s][%s]", method, notify, schedulerId, el.getSchedulerId()));
                    }
                }
            }
            catch (Exception ex) {
                throw new Exception(String.format("%s[check with configured scheduler_id=%s]%s", method, schedulerId, ex));
            }
        }
        return notify;
    }

    private boolean checkDoNotify(int currentCounter, DBItemSchedulerMonNotifications notification, ElementJobChain jc) throws Exception {
        String method = "  [" + currentCounter + "][checkDoNotify]";
        boolean notify = true;
        String schedulerId = jc.getSchedulerId();
        String jobChainName = jc.getName();
        if (!schedulerId.equals("*")) {
            try {
                if (!notification.getSchedulerId().matches(schedulerId)) {
                    notify = false;
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("%s[notify=%s][schedulerId not match][%s][%s]", method, notify, notification.getSchedulerId(), schedulerId));
                    }
                }
            }
            catch (Exception ex) {
                throw new Exception(String.format("%s[check with configured scheduler_id=%s]%s", method, schedulerId, ex));
            }
        }
        if (notify && !jobChainName.equals("*")) {
            jobChainName = CheckHistoryModel.normalizeRegex(jobChainName);
            try {
                if (!notification.getJobChainName().matches(jobChainName)) {
                    notify = false;
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("%s[notify=%s][not match][%s][%s]", method, notify, notification.getJobChainName(), jobChainName));
                    }
                } else if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[notify=%s][match][%s][%s][%s][%s]", method, notify, notification.getSchedulerId(), schedulerId, notification.getJobChainName(), jobChainName));
                }
            }
            catch (Exception ex) {
                throw new Exception(String.format("%s[check with configured scheduler_id=%s, name=%s]%s", method, schedulerId, jobChainName, ex));
            }
        }
        return notify;
    }

    private boolean checkDoNotify(int currentCounter, DBItemSchedulerMonNotifications notification, ElementJob job) throws Exception {
        String method = "  [" + currentCounter + "][checkDoNotify]";
        boolean notify = true;
        String schedulerId = job.getSchedulerId();
        String jobName = job.getName();
        if (!schedulerId.equals("*")) {
            try {
                if (!notification.getSchedulerId().matches(schedulerId)) {
                    notify = false;
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("%s[notify=%s][schedulerId not match][%s][%s]", method, notify, notification.getSchedulerId(), schedulerId));
                    }
                }
            }
            catch (Exception ex) {
                throw new Exception(String.format("%s[check with configured scheduler_id=%s]%s", method, schedulerId, ex));
            }
        }
        if (notify && !jobName.equals("*")) {
            jobName = CheckHistoryModel.normalizeRegex(jobName);
            try {
                if (!notification.getJobName().matches(jobName)) {
                    notify = false;
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("%s[notify=%s][not match][%s][%s]", method, notify, notification.getJobName(), jobName));
                    }
                } else if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[notify=%s][match][%s][%s][%s][%s]", method, notify, notification.getSchedulerId(), schedulerId, notification.getJobName(), jobName));
                }
            }
            catch (Exception ex) {
                throw new Exception(String.format("%s[check with configured scheduler_id=%s, name=%s]%s", method, schedulerId, jobName, ex));
            }
        }
        return notify;
    }

    private JobChainNotification getJobChainNotification(int currentCounter, DBItemSchedulerMonNotifications notification, ElementJobChain jc) throws Exception {
        String method = "    [" + currentCounter + "][getJobChainNotification]";
        JobChainNotification jcn = new JobChainNotification();
        String stepFrom = jc.getStepFrom();
        String stepTo = jc.getStepTo();
        DBItemSchedulerMonNotifications stepFromNotification = null;
        DBItemSchedulerMonNotifications stepToNotification = null;
        if (!stepFrom.equals("*") || !stepTo.equals("*")) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s analyze configured step_from, step_to", method));
            }
            Long stepFromIndex = new Long(0L);
            Long stepToIndex = new Long(0L);
            List<DBItemSchedulerMonNotifications> steps = this.getDbLayer().getOrderNotifications(this.largeResultFetchSize, notification);
            if (steps == null || steps.isEmpty()) {
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[no steps found for orderHistoryId=%s]%s", method, notification.getOrderHistoryId(), NotificationModel.toString(notification)));
                }
                throw new Exception(String.format("%sno steps found for orderHistoryId=%s", method, notification.getOrderHistoryId()));
            }
            for (DBItemSchedulerMonNotifications step : steps) {
                if (stepFrom != null && step.getOrderStepState().equalsIgnoreCase(stepFrom) && stepFromIndex.equals(new Long(0L))) {
                    stepFromIndex = step.getStep();
                    stepFromNotification = step;
                }
                if (stepTo != null && step.getOrderStepState().equalsIgnoreCase(stepTo)) {
                    stepToIndex = step.getStep();
                    stepToNotification = step;
                }
                jcn.setLastStep(step);
            }
            if (stepToIndex.equals(new Long(0L))) {
                stepToIndex = jcn.getLastStep().getStep();
            }
            jcn.setSteps(steps);
            jcn.setStepFromIndex(stepFromIndex);
            jcn.setStepToIndex(stepToIndex);
            jcn.setStepFrom(stepFromNotification);
            jcn.setStepTo(stepToNotification);
            if (stepFrom != null && !stepFrom.equals("*") && jcn.getStepFrom() == null) {
                jcn.setSteps(null);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[setLastStepForNotification][configured step_from \"%s\" not found]%s", method, stepFrom, NotificationModel.toString(notification)));
                }
            } else {
                for (DBItemSchedulerMonNotifications step : jcn.getSteps()) {
                    if (step.getStep() < jcn.getStepFromIndex() || step.getStep() > jcn.getStepToIndex()) continue;
                    jcn.setLastStepForNotification(step);
                }
            }
        } else {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s getNotificationMaxStep", method));
            }
            jcn.setLastStepForNotification(this.getDbLayer().getNotificationMaxStep(notification));
            jcn.setStepFrom(notification);
            if (jcn.getLastStepForNotification() != null) {
                jcn.setStepTo(jcn.getLastStepForNotification());
                jcn.setStepToIndex(jcn.getStepTo().getStep());
            }
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[stepFromIndex=%s][stepToIndex=%s]", method, jcn.getStepFromIndex(), jcn.getStepToIndex()));
            LOGGER.debug(String.format("%s[stepFrom][%s]", method, NotificationModel.toString(jcn.getStepFrom())));
            LOGGER.debug(String.format("%s[stepTo][%s]", method, NotificationModel.toString(jcn.getStepTo())));
        }
        return jcn;
    }

    private void executeNotifyJob(int currentCounter, DBItemSchedulerMonSystemNotifications sm, String systemId, DBItemSchedulerMonNotifications notification, ElementJob job) throws Exception {
        String method = "    [" + currentCounter + "][executeNotifyJob]";
        String serviceNameOnError = job.getMonitor().getServiceNameOnError();
        String serviceNameOnSuccess = job.getMonitor().getServiceNameOnSuccess();
        if (job.getNotifications() < 1L) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][skip][notifications < 1]%s", method, NotificationModel.toString(job)));
            }
            return;
        }
        boolean executed = false;
        if (!SOSString.isEmpty((String)serviceNameOnError)) {
            this.executeNotifyJob(currentCounter, sm, systemId, notification, job, true);
            executed = true;
        }
        if (!SOSString.isEmpty((String)serviceNameOnSuccess)) {
            this.executeNotifyJob(currentCounter, sm, systemId, notification, job, false);
            executed = true;
        }
        if (!executed) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]serviceNameOnError and serviceNameOnSuccess are empty", method));
            }
        }
    }

    private void executeNotifyInternal(int currentCounter, DBItemSchedulerMonSystemNotifications sn, String systemId, DBItemSchedulerMonNotifications notification2send, ElementInternal el) throws Exception {
        String method = "    [" + currentCounter + "][executeNotifyInternal]";
        ElementNotificationMonitor monitor = el.getMonitor();
        String serviceName = monitor.getServiceNameOnError();
        ISystemNotifierPlugin pl = monitor.getOrCreatePluginObject();
        if (pl.hasErrorOnInit()) {
            throw new Exception(String.format("[%s][skip]due plugin init error: %s", method, pl.getInitError()));
        }
        if (sn.getMaxNotifications()) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]maxNotifications=true", method));
            }
            return;
        }
        if (sn.getCurrentNotification() >= el.getNotifications()) {
            this.counter.addSkip();
            this.closeSystemNotification(sn, notification2send.getTaskEndTime());
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip][close][%s]count notifications was reached", method, el.getNotifications()));
            }
            return;
        }
        sn.setCurrentNotification(sn.getCurrentNotification() + 1L);
        if (sn.getCurrentNotification() >= el.getNotifications() || sn.getAcknowledged()) {
            sn.setMaxNotifications(true);
        }
        sn.setNotifications(el.getNotifications());
        sn.setModified(DBLayer.getCurrentDateTime());
        try {
            EServiceStatus serviceStatus = EServiceStatus.CRITICAL;
            EServiceMessagePrefix serviceMessagePrefix = EServiceMessagePrefix.ERROR;
            if (notification2send.getError()) {
                if (sn.getRecovered()) {
                    serviceStatus = EServiceStatus.OK;
                    serviceMessagePrefix = EServiceMessagePrefix.RECOVERED;
                }
            } else {
                serviceStatus = EServiceStatus.OK;
                serviceMessagePrefix = EServiceMessagePrefix.SUCCESS;
            }
            LOGGER.info("----------------------------------------------------------------");
            LOGGER.info(String.format("[executeNotifyInternal][%s][%s][notification %s of %s]call plugin %s", el.getClass().getSimpleName(), serviceName, sn.getCurrentNotification(), sn.getNotifications(), pl.getClass().getSimpleName()));
            pl.notifySystem(null, this.options, this.getDbLayer(), notification2send, sn, null, serviceStatus, serviceMessagePrefix);
            this.getDbLayer().getSession().beginTransaction();
            this.getDbLayer().getSession().update((Object)sn);
            this.getDbLayer().getSession().commit();
            this.counter.addSuccess();
        }
        catch (Exception ex) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.error(String.format("[%s][error on message sending]%s", method, ex.toString()), (Throwable)ex);
            this.counter.addError();
        }
    }

    private void executeNotifyJob(int currentCounter, DBItemSchedulerMonSystemNotifications sn, String systemId, DBItemSchedulerMonNotifications notification, ElementJob job, boolean notifyOnError) throws Exception {
        String method = "    [" + currentCounter + "][executeNotifyJob]";
        String notifyMsg = null;
        String serviceName = null;
        EServiceStatus serviceStatus = null;
        EServiceMessagePrefix serviceMessagePrefix = null;
        boolean isNotifyAgain = sn != null;
        boolean isNew = false;
        if (notifyOnError) {
            notifyMsg = "notifyOnError";
            serviceName = job.getMonitor().getServiceNameOnError();
            serviceStatus = EServiceStatus.CRITICAL;
            serviceMessagePrefix = EServiceMessagePrefix.ERROR;
        } else {
            notifyMsg = "notifyOnSuccess";
            serviceName = job.getMonitor().getServiceNameOnSuccess();
            serviceStatus = EServiceStatus.OK;
            serviceMessagePrefix = EServiceMessagePrefix.SUCCESS;
        }
        String returnCodeFrom = job.getReturnCodeFrom();
        String returnCodeTo = job.getReturnCodeTo();
        boolean hasReturnCodes = this.hasReturnCodes(returnCodeFrom, returnCodeTo);
        Long notifications = job.getNotifications();
        Long checkId = new Long(0L);
        String stepFrom = notification.getOrderStepState();
        String stepTo = notification.getOrderStepState();
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s][%s][%s]%s", method, notifyMsg, serviceName, NotificationModel.toString(notification)));
        }
        if (isNotifyAgain) {
            if (!this.handledByNotifyAgain.contains(sn.getId())) {
                this.handledByNotifyAgain.add(sn.getId());
            }
            if (notifyOnError && sn.getSuccess()) {
                this.counter.addSkip();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[%s][%s][notifyAgain][skip]is notifyOnError but system notification has succes=1", method, notifyMsg, serviceName));
                }
                return;
            }
            if (!notifyOnError && !sn.getSuccess()) {
                this.counter.addSkip();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("%s[%s][%s][notifyAgain][skip]is notifyOnSuccess but system notification has succes=0", method, notifyMsg, serviceName));
                }
                return;
            }
        }
        Date startTime = null;
        Date endTime = null;
        if (notification.getStandalone()) {
            startTime = notification.getTaskStartTime();
            endTime = notification.getTaskEndTime();
        } else {
            startTime = notification.getOrderStepStartTime();
            endTime = notification.getOrderStepEndTime();
        }
        if (sn == null) {
            try {
                this.getDbLayer().getSession().beginTransaction();
                sn = this.getDbLayer().getSystemNotification(systemId, serviceName, notification.getId(), checkId, DBLayer.NOTIFICATION_OBJECT_TYPE_JOB, !notifyOnError, stepFrom, stepTo, returnCodeFrom, returnCodeTo);
                if (sn == null) {
                    isNew = true;
                    sn = this.getDbLayer().createSystemNotification(systemId, serviceName, notification.getId(), checkId, returnCodeFrom, returnCodeTo, DBLayer.NOTIFICATION_OBJECT_TYPE_JOB, stepFrom, stepTo, startTime, endTime, new Long(0L), notifications, false, false, !notifyOnError);
                    this.getDbLayer().getSession().save((Object)sn);
                }
                this.getDbLayer().getSession().commit();
            }
            catch (Exception ex) {
                try {
                    this.getDbLayer().getSession().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                LOGGER.error(String.format("%s %s", method, ex.toString()), (Throwable)ex);
                return;
            }
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[%s][%s][isNew=%s][isNotifyAgain=%s]%s", method, notifyMsg, serviceName, isNew, isNotifyAgain, NotificationModel.toString(sn)));
        }
        if (!isNotifyAgain && this.handledByNotifyAgain.contains(sn.getId())) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[%s][%s][skip]already handled by notifyAgain", method, notifyMsg, serviceName));
            }
            return;
        }
        if (notification.getStandalone()) {
            if (notification.getTaskEndTime() == null) {
                this.counter.addSkip();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][%s][skip][standalone][task is not completed]taskEndTime is null", method, notifyMsg, serviceName));
                }
                return;
            }
        } else if (notifyOnError) {
            if (notification.getOrderStepEndTime() == null && notification.getTaskEndTime() == null) {
                this.counter.addSkip();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][%s][skip][order][step is not completed]orderStepEndTime and taskEndTime is null", method, notifyMsg, serviceName));
                }
                return;
            }
            if (notification.getOrderStepEndTime() != null) {
                endTime = notification.getOrderStepEndTime();
            } else if (notification.getTaskEndTime() != null) {
                endTime = notification.getTaskEndTime();
            }
        } else {
            if (notification.getOrderStepEndTime() == null) {
                this.counter.addSkip();
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][%s][skip][order][step is not completed]orderStepEndTime is null", method, notifyMsg, serviceName));
                }
                return;
            }
            endTime = notification.getOrderStepEndTime();
        }
        if (notifyOnError && !notification.getError()) {
            this.closeSystemNotification(sn, endTime);
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s][skip][notifyOnError=%s]notification has no error", method, notifyMsg, serviceName, notifyOnError));
            }
            return;
        }
        if (!notifyOnError && notification.getError()) {
            this.closeSystemNotification(sn, endTime);
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s][skip][notifyOnError=%s]job has an error", method, notifyMsg, serviceName, notifyOnError));
            }
            return;
        }
        if (hasReturnCodes && !this.checkDoNotifyByReturnCodes(notification, serviceName, notifyMsg, job.getName(), returnCodeFrom, returnCodeTo)) {
            this.closeSystemNotification(sn, endTime);
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s][skip][notifyOnError=%s]checkDoNotifyByReturnCodes=false", method, notifyMsg, serviceName, notifyOnError));
            }
            return;
        }
        if (sn.getMaxNotifications()) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s][skip]maxNotifications=true", method, notifyMsg, serviceName));
            }
            return;
        }
        if (sn.getAcknowledged()) {
            this.closeSystemNotification(sn, endTime);
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s][skip]acknowledged=true", method, notifyMsg, serviceName));
            }
            return;
        }
        if (sn.getCurrentNotification() >= notifications) {
            this.closeSystemNotification(sn, endTime);
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s][skip][%s]count notifications was reached", method, notifyMsg, serviceName, notifications));
            }
            return;
        }
        ISystemNotifierPlugin pl = this.getOrCreatePluginObject(job.getMonitor(), method, serviceName);
        if (pl == null) {
            return;
        }
        try {
            sn.setStepFromStartTime(startTime);
            sn.setStepToEndTime(endTime);
            sn.setCurrentNotification(sn.getCurrentNotification() + 1L);
            if (sn.getCurrentNotification() >= notifications || sn.getAcknowledged()) {
                sn.setMaxNotifications(true);
            }
            sn.setNotifications(notifications);
            sn.setModified(DBLayer.getCurrentDateTime());
            LOGGER.info("----------------------------------------------------------------");
            LOGGER.info(String.format(CALL_PLUGIN_LOGGING, method, notifyMsg, serviceName, notification.getJobName(), sn.getCurrentNotification(), sn.getNotifications(), pl.getClass().getSimpleName()));
            pl.notifySystem(this.getSpooler(), this.options, this.getDbLayer(), notification, sn, null, serviceStatus, serviceMessagePrefix);
            this.getDbLayer().getSession().beginTransaction();
            this.getDbLayer().getSession().update((Object)sn);
            this.getDbLayer().getSession().commit();
            this.counter.addSuccess();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s][isNew=%s]%s", method, notifyMsg, serviceName, isNew, NotificationModel.toString(sn)));
            }
            LOGGER.info("----------------------------------------------------------------");
        }
        catch (Exception ex) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.warn(String.format(THREE_PARAMS_LOGGING, method, notifyMsg, serviceName, ex.getMessage()), (Throwable)ex);
            this.counter.addError();
        }
    }

    private boolean hasReturnCodes(String returnCodeFrom, String returnCodeTo) {
        return !returnCodeFrom.equals("*") || !returnCodeTo.equals("*");
    }

    private void executeNotifyJobChain(int currentCounter, DBItemSchedulerMonSystemNotifications sm, String systemId, DBItemSchedulerMonNotifications notification, ElementJobChain jobChain) throws Exception {
        String method = "    [" + currentCounter + "][executeNotifyJobChain]";
        if (jobChain.getNotifications() < 1L) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip][notifications < 1]%s", method, NotificationModel.toString(jobChain)));
            }
            return;
        }
        String serviceNameOnError = jobChain.getMonitor().getServiceNameOnError();
        String serviceNameOnSuccess = jobChain.getMonitor().getServiceNameOnSuccess();
        boolean executed = false;
        if (!SOSString.isEmpty((String)serviceNameOnError)) {
            this.executeNotifyJobChain(currentCounter, sm, systemId, notification, jobChain, true);
            executed = true;
        }
        if (!SOSString.isEmpty((String)serviceNameOnSuccess)) {
            this.executeNotifyJobChain(currentCounter, sm, systemId, notification, jobChain, false);
            executed = true;
        }
        if (!executed) {
            this.counter.addSkip();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[skip]serviceNameOnError and serviceNameOnSuccess are empty", method));
            }
        }
    }

    private boolean checkNotifyRepeatedErrorByPeriod(int currentCounter, String notifyMsg, String serviceName, String range, ElementJobChain jobChain, DBItemSchedulerMonSystemResults lastErrorSended, DBItemSchedulerMonNotifications lastErrorNotificationAfterSended) throws Exception {
        String method = "    [" + currentCounter + "][checkNotifyRepeatedErrorByPeriod]";
        Long period = jobChain.getNotifyRepeatedError().getNotifyByPeriod().getPeriodAsSeconds();
        Date lastSended = lastErrorSended.getOrderStepEndTime();
        if (lastSended == null) {
            lastSended = lastErrorSended.getCreated();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[%s][%s]%s[notifyRepeatedErrorByPeriod][state=%s][last notify][step=%s][OrderStepEndTime is null]set to created", method, notifyMsg, serviceName, range, lastErrorSended.getOrderStepState(), lastErrorSended.getOrderStep()));
            }
        }
        Date lastAfterSended = lastErrorNotificationAfterSended.getOrderStepEndTime();
        long diff = lastAfterSended.getTime() / 1000L - lastSended.getTime() / 1000L;
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[%s][%s]%s[notifyRepeatedErrorByPeriod][state=%s][last notify][step=%s][occured=%s(UTC)(notified=%s(UTC))][last error][step=%s][occured %s(UTC)][%s=%ss]diff between occured=%ss", method, notifyMsg, serviceName, range, lastErrorSended.getOrderStepState(), lastErrorSended.getOrderStep(), ReportUtil.getDateAsString(lastSended), ReportUtil.getDateAsString(lastErrorSended.getCreated()), lastErrorNotificationAfterSended.getStep(), ReportUtil.getDateAsString(lastAfterSended), jobChain.getNotifyRepeatedError().getNotifyByPeriod().getPeriod(), period, diff));
        }
        if (diff > period) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[%s][%s]%s[notifyRepeatedErrorByPeriod][state=%s][diff > period]%ss > %ss", method, notifyMsg, serviceName, range, lastErrorSended.getOrderStepState(), diff, period));
            }
            return true;
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("%s[%s][%s]%s[notifyRepeatedErrorByPeriod][state=%s][skip][diff <= period]%ss <= %ss", method, notifyMsg, serviceName, range, lastErrorSended.getOrderStepState(), diff, period));
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeNotifyJobChain(int currentCounter, DBItemSchedulerMonSystemNotifications sn, String systemId, DBItemSchedulerMonNotifications notification, ElementJobChain jobChain, boolean notifyOnError) throws Exception {
        ISystemNotifierPlugin pl;
        DBItemSchedulerMonSystemResults lastErrorSended;
        DBItemSchedulerMonNotifications notification2send;
        JobChainNotification jcn;
        boolean isNew;
        Long notifications;
        boolean maxNotifications;
        boolean recovered;
        EServiceMessagePrefix serviceMessagePrefix;
        EServiceStatus serviceStatus;
        String serviceName;
        String notifyMsg;
        String method;
        block94: {
            DBItemSchedulerMonNotifications notificationLastStep;
            boolean hasReturnCodes;
            String returnCodeTo;
            String returnCodeFrom;
            block83: {
                boolean isNotifyAgain;
                block89: {
                    block90: {
                        block91: {
                            boolean setRecovery;
                            block92: {
                                Long stepDiff;
                                block93: {
                                    DBItemSchedulerMonNotifications lastErrorNotification;
                                    block84: {
                                        block86: {
                                            block87: {
                                                block88: {
                                                    block85: {
                                                        method = "    [" + currentCounter + "][executeNotifyJobChain]";
                                                        notifyMsg = null;
                                                        serviceName = null;
                                                        serviceStatus = null;
                                                        serviceMessagePrefix = null;
                                                        recovered = false;
                                                        maxNotifications = false;
                                                        Long checkId = new Long(0L);
                                                        String stepFrom = jobChain.getStepFrom();
                                                        String stepTo = jobChain.getStepTo();
                                                        returnCodeFrom = jobChain.getReturnCodeFrom();
                                                        returnCodeTo = jobChain.getReturnCodeTo();
                                                        hasReturnCodes = this.hasReturnCodes(returnCodeFrom, returnCodeTo);
                                                        notifications = jobChain.getNotifications();
                                                        isNotifyAgain = sn != null;
                                                        isNew = false;
                                                        if (notifyOnError) {
                                                            notifyMsg = "notifyOnError";
                                                            serviceName = jobChain.getMonitor().getServiceNameOnError();
                                                            serviceStatus = EServiceStatus.CRITICAL;
                                                            serviceMessagePrefix = EServiceMessagePrefix.ERROR;
                                                        } else {
                                                            notifyMsg = "notifyOnSuccess";
                                                            serviceName = jobChain.getMonitor().getServiceNameOnSuccess();
                                                            serviceStatus = EServiceStatus.OK;
                                                            serviceMessagePrefix = EServiceMessagePrefix.SUCCESS;
                                                        }
                                                        if (isNotifyAgain) {
                                                            if (!this.handledByNotifyAgain.contains(sn.getId())) {
                                                                this.handledByNotifyAgain.add(sn.getId());
                                                            }
                                                            if (notifyOnError && sn.getSuccess()) {
                                                                this.counter.addSkip();
                                                                if (!isDebugEnabled) return;
                                                                LOGGER.debug(String.format("%s[%s][%s][notifyAgain][skip]is notifyOnError but system notification has succes=1", method, notifyMsg, serviceName));
                                                                return;
                                                            }
                                                            if (!notifyOnError && !sn.getSuccess()) {
                                                                this.counter.addSkip();
                                                                if (!isDebugEnabled) return;
                                                                LOGGER.debug(String.format("%s[%s][%s][notifyAgain][skip]is notifyOnSuccess but system notification has succes=0", method, notifyMsg, serviceName));
                                                                return;
                                                            }
                                                        }
                                                        if (sn == null) {
                                                            try {
                                                                this.getDbLayer().getSession().beginTransaction();
                                                                sn = this.getDbLayer().getSystemNotification(systemId, serviceName, notification.getId(), checkId, DBLayer.NOTIFICATION_OBJECT_TYPE_JOB_CHAIN, !notifyOnError, stepFrom, stepTo, returnCodeFrom, returnCodeTo);
                                                                if (sn == null) {
                                                                    isNew = true;
                                                                    sn = this.getDbLayer().createSystemNotification(systemId, serviceName, notification.getId(), checkId, returnCodeFrom, returnCodeTo, DBLayer.NOTIFICATION_OBJECT_TYPE_JOB_CHAIN, stepFrom, stepTo, notification.getOrderStartTime(), notification.getOrderEndTime(), new Long(0L), notifications, false, false, !notifyOnError);
                                                                    this.getDbLayer().getSession().save((Object)sn);
                                                                }
                                                                this.getDbLayer().getSession().commit();
                                                            }
                                                            catch (Exception ex) {
                                                                try {
                                                                    this.getDbLayer().getSession().rollback();
                                                                }
                                                                catch (Exception exception) {
                                                                    // empty catch block
                                                                }
                                                                LOGGER.error(String.format("%s %s", method, ex.toString()), (Throwable)ex);
                                                                return;
                                                            }
                                                        }
                                                        if (isDebugEnabled) {
                                                            LOGGER.debug(String.format("%s[%s][%s][isNew=%s][isNotifyAgain=%s]%s", method, notifyMsg, serviceName, isNew, isNotifyAgain, NotificationModel.toString(sn)));
                                                        }
                                                        if (!isNotifyAgain && this.handledByNotifyAgain.contains(sn.getId())) {
                                                            this.counter.addSkip();
                                                            if (!isDebugEnabled) return;
                                                            LOGGER.debug(String.format("%s[%s][%s][skip]already handled by notifyAgain", method, notifyMsg, serviceName));
                                                            return;
                                                        }
                                                        if (sn.getMaxNotifications()) {
                                                            this.counter.addSkip();
                                                            if (!isDebugEnabled) return;
                                                            LOGGER.debug(String.format("%s[%s][%s][skip]maxNotifications=true", method, notifyMsg, serviceName));
                                                            return;
                                                        }
                                                        if (sn.getAcknowledged()) {
                                                            this.counter.addSkip();
                                                            if (!isDebugEnabled) return;
                                                            LOGGER.debug(String.format("%s[%s][%s][skip]acknowledged=true", method, notifyMsg, serviceName));
                                                            return;
                                                        }
                                                        jcn = this.getJobChainNotification(currentCounter, notification, jobChain);
                                                        if (jcn.getLastStepForNotification() == null) {
                                                            this.counter.addSkip();
                                                            if (!isDebugEnabled) return;
                                                            LOGGER.debug(String.format("%s[%s][%s][skip][isNew=%s]getLastStepForNotification=null", method, notifyMsg, serviceName, isNew));
                                                            return;
                                                        }
                                                        notification2send = null;
                                                        notificationLastStep = jcn.getLastStepForNotification();
                                                        lastErrorSended = null;
                                                        if (isDebugEnabled) {
                                                            LOGGER.debug(String.format("%s[%s][%s][isNew=%s][notificationLastStep]%s", method, notifyMsg, serviceName, isNew, NotificationModel.toString(notificationLastStep)));
                                                            if (jobChain.getNotifyRepeatedError() != null) {
                                                                LOGGER.debug(String.format("%s[%s][%s][isNew=%s]%s", method, notifyMsg, serviceName, isNew, jobChain.getNotifyRepeatedError()));
                                                            }
                                                        }
                                                        if (!notifyOnError) break block83;
                                                        lastErrorSended = this.getDbLayer().getSystemResultMaxStep(sn.getId());
                                                        if (!notificationLastStep.getError()) break block84;
                                                        if (isDebugEnabled) {
                                                            LOGGER.debug(String.format("%s[%s][%s][onError][lastErrorSended]%s", method, notifyMsg, serviceName, NotificationModel.toString(lastErrorSended)));
                                                        }
                                                        if (lastErrorSended != null) break block85;
                                                        if (isDebugEnabled) {
                                                            LOGGER.debug(String.format("%s[%s][%s][onError]do notify error", method, notifyMsg, serviceName));
                                                        }
                                                        break block86;
                                                    }
                                                    if (!lastErrorSended.getOrderStepState().equals(notificationLastStep.getOrderStepState())) break block87;
                                                    if (jobChain.getNotifyRepeatedError() != null) break block88;
                                                    if (lastErrorSended.getCurrentNotification() >= notifications) {
                                                        this.counter.addSkip();
                                                        if (isDebugEnabled) {
                                                            LOGGER.debug(String.format("%s[%s][%s][onError][skip][%s][count notifications for this state was reached]%s of %s", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState(), lastErrorSended.getCurrentNotification(), notifications));
                                                        }
                                                        if (notificationLastStep.getOrderEndTime() == null) return;
                                                        this.closeSystemNotification(sn, notificationLastStep.getOrderEndTime());
                                                        if (!isDebugEnabled) return;
                                                        LOGGER.debug(String.format("%s[%s][%s][onError][close]count notifications was reached and orderEndTime is not null", method, notifyMsg, serviceName));
                                                        return;
                                                    }
                                                    break block86;
                                                }
                                                if (lastErrorSended.getOrderStep().equals(notificationLastStep.getStep())) {
                                                    if (lastErrorSended.getCurrentNotification() >= notifications) {
                                                        this.counter.addSkip();
                                                        if (isDebugEnabled) {
                                                            LOGGER.debug(String.format("%s[%s][%s][onError][skip][notifyRepeatedError=true][state=%s][step=%s][count notifications for this state was reached]%s of %s", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState(), lastErrorSended.getOrderStep(), lastErrorSended.getCurrentNotification(), notifications));
                                                        }
                                                        if (notificationLastStep.getOrderEndTime() == null) return;
                                                        this.closeSystemNotification(sn, notificationLastStep.getOrderEndTime());
                                                        if (!isDebugEnabled) return;
                                                        LOGGER.debug(String.format("%s[%s][%s][onError][close][notifyRepeatedError=true][state=%s][step=%s]count notifications was reached and orderEndTime is not null", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState(), lastErrorSended.getOrderStep()));
                                                        return;
                                                    }
                                                    if (isDebugEnabled) {
                                                        LOGGER.debug(String.format("%s[%s][%s][onError][notifyRepeatedError=true][state=%s][step=%s][count notifications for this state was not reached]%s of %s", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState(), lastErrorSended.getOrderStep(), lastErrorSended.getCurrentNotification(), notifications));
                                                    }
                                                    lastErrorSended = null;
                                                }
                                                if (lastErrorSended == null) break block86;
                                                if (isDebugEnabled) {
                                                    LOGGER.debug(String.format("%s[%s][%s][onError][notifyRepeatedError][state=%s][step changed]%s -> %s", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState(), lastErrorSended.getOrderStep(), notificationLastStep.getStep()));
                                                }
                                                if (jobChain.getNotifyRepeatedError().getNotifyByIntervention() == null && jobChain.getNotifyRepeatedError().getNotifyByPeriod() == null) {
                                                    if (isDebugEnabled) {
                                                        LOGGER.debug(String.format("%s[%s][%s][onError][notifyRepeatedError]all repeated errors", method, notifyMsg, serviceName));
                                                    }
                                                    lastErrorSended = null;
                                                    break block86;
                                                } else {
                                                    if (jobChain.getNotifyRepeatedError().getNotifyByIntervention() != null) {
                                                        if (sn.getAuditLogId() == null) {
                                                            Date startTimeFrom = Date.from(notificationLastStep.getOrderStartTime().toInstant().minusSeconds(2L));
                                                            Long auditLogId = this.getDbLayer().getMinAuditLogId(notificationLastStep.getSchedulerId(), "/" + notificationLastStep.getJobChainName(), notificationLastStep.getOrderId(), startTimeFrom, notificationLastStep.getOrderEndTime());
                                                            if (isDebugEnabled) {
                                                                LOGGER.debug(String.format("%s[%s][%s][onError][notifyRepeatedErrorByIntervention][%s(%s)-%s]auditLogId=%s", method, notifyMsg, serviceName, ReportUtil.getDateAsString(startTimeFrom), ReportUtil.getDateAsString(notificationLastStep.getOrderStartTime()), ReportUtil.getDateAsString(notificationLastStep.getOrderEndTime()), auditLogId));
                                                            }
                                                            sn.setAuditLogId(auditLogId);
                                                        }
                                                        if (sn.getAuditLogId() == null) {
                                                            if (isDebugEnabled) {
                                                                LOGGER.debug(String.format("%s[%s][%s][onError][skip][notifyRepeatedErrorByIntervention]auditLogId is null", method, notifyMsg, serviceName));
                                                            }
                                                            if (jobChain.getNotifyRepeatedError().getNotifyByPeriod() == null) {
                                                                this.counter.addSkip();
                                                                return;
                                                            }
                                                        } else {
                                                            if (isDebugEnabled) {
                                                                LOGGER.debug(String.format("%s[%s][%s][onError][notifyRepeatedErrorByIntervention][auditLogId=%s]do notify", method, notifyMsg, serviceName, sn.getAuditLogId()));
                                                            }
                                                            lastErrorSended = null;
                                                        }
                                                    }
                                                    if (lastErrorSended != null && jobChain.getNotifyRepeatedError().getNotifyByPeriod() != null) {
                                                        if (!this.checkNotifyRepeatedErrorByPeriod(currentCounter, notifyMsg, serviceName, "[onError]", jobChain, lastErrorSended, notificationLastStep)) {
                                                            this.counter.addSkip();
                                                            return;
                                                        }
                                                        lastErrorSended = null;
                                                    }
                                                }
                                                break block86;
                                            }
                                            if (isDebugEnabled) {
                                                LOGGER.debug(String.format("%s[%s][%s][onError][state changed]%s -> %s", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState(), notificationLastStep.getOrderStepState()));
                                            }
                                            lastErrorSended = null;
                                        }
                                        notification2send = notificationLastStep;
                                        break block89;
                                    }
                                    if (lastErrorSended == null) break block90;
                                    if (isDebugEnabled) {
                                        LOGGER.debug(String.format("%s[%s][%s][onNoError][lastErrorSended]%s", method, notifyMsg, serviceName, NotificationModel.toString(lastErrorSended)));
                                    }
                                    if (notificationLastStep.getId() <= lastErrorSended.getNotificationId()) break block91;
                                    setRecovery = true;
                                    if (!lastErrorSended.getOrderStepState().equals(notificationLastStep.getOrderStepState()) || notificationLastStep.getOrderStepEndTime() != null) break block92;
                                    if (isDebugEnabled) {
                                        LOGGER.debug(String.format("%s[%s][%s][onNoError][notCompleted][skip][recovery][state=%s]state rerun is not completed", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState()));
                                    }
                                    setRecovery = false;
                                    if (jobChain.getNotifyRepeatedError() == null || jobChain.getNotifyRepeatedError().getNotifyByPeriod() == null) break block92;
                                    stepDiff = notificationLastStep.getStep() - lastErrorSended.getOrderStep();
                                    if (stepDiff <= 1L) break block93;
                                    if (isDebugEnabled) {
                                        LOGGER.debug(String.format("%s[%s][%s][onNoError][notCompleted][NotifyRepeatedErrorByPeriod][state=%s]stepDiff=%s", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState(), stepDiff));
                                    }
                                    if ((lastErrorNotification = this.getDbLayer().getLastErrorNotificationByState(notificationLastStep.getSchedulerId(), notificationLastStep.getOrderHistoryId(), lastErrorSended.getOrderStepState(), lastErrorSended.getOrderStep())) == null) {
                                        if (isDebugEnabled) {
                                            LOGGER.debug(String.format("%s[%s][%s][onNoError][notCompleted][NotifyRepeatedErrorByPeriod][skip][state=%s][last notify][step=%s]not found new errors", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState(), lastErrorSended.getOrderStep()));
                                        }
                                        break block92;
                                    } else {
                                        if (isDebugEnabled) {
                                            LOGGER.debug(String.format("%s[%s][%s][onNoError][notCompleted][NotifyRepeatedErrorByPeriod][state=%s][last notify][step=%s][last error][step=%s]%s", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState(), lastErrorSended.getOrderStep(), lastErrorNotification.getStep(), NotificationModel.toString(lastErrorNotification)));
                                        }
                                        if (this.checkNotifyRepeatedErrorByPeriod(currentCounter, notifyMsg, serviceName, "[onNoError][notCompleted]", jobChain, lastErrorSended, lastErrorNotification)) {
                                            notification2send = lastErrorNotification;
                                            lastErrorSended = null;
                                        }
                                    }
                                    break block92;
                                }
                                if (isDebugEnabled) {
                                    LOGGER.debug(String.format("%s[%s][%s][onNoError][notCompleted][skip][NotifyRepeatedErrorByPeriod][state=%s]stepDiff=%s", method, notifyMsg, serviceName, lastErrorSended.getOrderStepState(), stepDiff));
                                }
                            }
                            if (!setRecovery) break block89;
                            if (lastErrorSended.getRecovered()) {
                                if (isDebugEnabled) {
                                    LOGGER.debug(String.format("%s[%s][%s][onNoError][skip][recovery]recovery already sended", method, notifyMsg, serviceName));
                                }
                                setRecovery = false;
                                break block89;
                            } else {
                                notification2send = this.getDbLayer().getNotification(lastErrorSended.getNotificationId());
                                lastErrorSended.setRecovered(true);
                                recovered = true;
                                if (isDebugEnabled) {
                                    LOGGER.debug(String.format("%s[%s][%s][onNoError][found][recovery]%s", method, notifyMsg, serviceName, NotificationModel.toString(notification2send)));
                                }
                            }
                            break block89;
                        }
                        if (isDebugEnabled) {
                            LOGGER.debug(String.format("%s[%s][%s][onNoError][skip][recovery]lastStep %s <= lastErrorSended %s", method, notifyMsg, serviceName, notificationLastStep.getId(), lastErrorSended.getNotificationId()));
                        }
                        break block89;
                    }
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("%s[%s][%s][onNoError][skip][recovery]lastErrorSended not found", method, notifyMsg, serviceName));
                        if (notificationLastStep.getOrderStepEndTime() == null) {
                            LOGGER.debug(String.format("%s[%s][%s][onNoError][skip][details]notificationLastStep is not completed", method, notifyMsg, serviceName));
                        }
                    }
                }
                if (notification2send == null) {
                    this.counter.addSkip();
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("%s[%s][%s][skip]notification2send is null", method, notifyMsg, serviceName));
                    }
                    if (!isNotifyAgain) return;
                    if (notificationLastStep.getOrderEndTime() != null) {
                        this.closeSystemNotification(sn, notificationLastStep.getOrderEndTime());
                        if (!isDebugEnabled) return;
                        LOGGER.debug(String.format("%s[%s][%s][notifyAgain][close]orderEndTime is not null", method, notifyMsg, serviceName));
                        return;
                    }
                    if (!isDebugEnabled) return;
                    LOGGER.debug(String.format("%s[%s][%s][notifyAgain][not close]orderEndTime is null", method, notifyMsg, serviceName));
                    return;
                }
                if (recovered) {
                    serviceStatus = EServiceStatus.OK;
                    serviceMessagePrefix = EServiceMessagePrefix.RECOVERED;
                } else {
                    if (jobChain.getExcludedSteps().contains(notification2send.getOrderStepState())) {
                        this.counter.addSkip();
                        if (!isDebugEnabled) return;
                        LOGGER.debug(String.format("%s[%s][%s][skip][%s][step is excluded]%s", method, notifyMsg, serviceName, notification2send.getOrderStepState(), NotificationModel.toString(notification2send)));
                        return;
                    }
                    if (hasReturnCodes && !this.checkDoNotifyByReturnCodes(notification2send, serviceName, notifyMsg, jobChain.getName(), returnCodeFrom, returnCodeTo)) {
                        this.counter.addSkip();
                        if (!isDebugEnabled) return;
                        LOGGER.debug(String.format("%s[%s][%s][skip][checkDoNotifyByReturnCodes=false][%s]", method, notifyMsg, serviceName, NotificationModel.toString(notification2send)));
                        return;
                    }
                }
                if (lastErrorSended == null && (lastErrorSended = this.getDbLayer().getSystemResult(sn.getId(), notification2send.getId())) == null) {
                    lastErrorSended = this.getDbLayer().createSystemResult(sn, notification2send);
                }
                lastErrorSended.setCurrentNotification(lastErrorSended.getCurrentNotification() + 1L);
                sn.setCurrentNotification(sn.getCurrentNotification() + 1L);
                if (notificationLastStep.getOrderEndTime() != null && lastErrorSended != null && lastErrorSended.getCurrentNotification() >= notifications) {
                    maxNotifications = true;
                }
                break block94;
            }
            lastErrorSended = null;
            if (notificationLastStep.getOrderEndTime() == null) {
                this.counter.addSkip();
                if (!isDebugEnabled) return;
                LOGGER.debug(String.format("%s[%s][%s][skip]notification orderEndTime is null", method, notifyMsg, serviceName));
                return;
            }
            if (notificationLastStep.getError()) {
                this.counter.addSkip();
                this.closeSystemNotification(sn, notificationLastStep.getOrderEndTime());
                if (!isDebugEnabled) return;
                LOGGER.debug(String.format("%s[%s][%s][skip][close][notificationLastStep ends with an error]orderEndTime is not null", method, notifyMsg, serviceName));
                return;
            }
            notification2send = notificationLastStep;
            if (hasReturnCodes && !this.checkDoNotifyByReturnCodes(notification2send, serviceName, notifyMsg, jobChain.getName(), returnCodeFrom, returnCodeTo)) {
                this.counter.addSkip();
                if (!isDebugEnabled) return;
                LOGGER.debug(String.format("%s[%s][%s][skip][checkDoNotifyByReturnCodes=false][%s]", method, notifyMsg, serviceName, NotificationModel.toString(notification2send)));
                return;
            }
            sn.setCurrentNotification(sn.getCurrentNotification() + 1L);
            if (sn.getCurrentNotification() >= notifications) {
                maxNotifications = true;
            }
        }
        if ((pl = this.getOrCreatePluginObject(jobChain.getMonitor(), method, serviceName)) == null) {
            return;
        }
        try {
            if (jcn.getStepFrom() != null) {
                sn.setStepFromStartTime(jcn.getStepFrom().getOrderStepStartTime());
            }
            if (jcn.getStepTo() != null) {
                sn.setStepToEndTime(jcn.getStepTo().getOrderStepEndTime());
            }
            sn.setMaxNotifications(maxNotifications);
            sn.setNotifications(notifications);
            sn.setModified(DBLayer.getCurrentDateTime());
            sn.setSuccess(!notifyOnError);
            sn.setRecovered(recovered);
            String jobChainInfo = notification2send.getJobChainName() + "-" + notification2send.getOrderId();
            LOGGER.info("----------------------------------------------------------------");
            LOGGER.info(String.format("[executeNotifyJobChain][%s][%s][%s][notification %s]call plugin %s", notifyMsg, serviceName, jobChainInfo, sn.getCurrentNotification(), pl.getClass().getSimpleName()));
            pl.notifySystem(this.getSpooler(), this.options, this.getDbLayer(), notification2send, sn, null, serviceStatus, serviceMessagePrefix);
            this.getDbLayer().getSession().beginTransaction();
            this.getDbLayer().getSession().update((Object)sn);
            if (lastErrorSended != null) {
                if (lastErrorSended.getId() == null) {
                    this.getDbLayer().getSession().save((Object)lastErrorSended);
                } else {
                    lastErrorSended.setModified(DBLayer.getCurrentDateTime());
                    this.getDbLayer().getSession().update((Object)lastErrorSended);
                }
            }
            this.getDbLayer().getSession().commit();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("%s[%s][%s][isNew=%s][send]%s", method, notifyMsg, serviceName, isNew, NotificationModel.toString(sn)));
                LOGGER.debug(String.format("%s[%s][%s][isNew=%s][send]%s", method, notifyMsg, serviceName, isNew, NotificationModel.toString(notification2send)));
                if (lastErrorSended != null) {
                    LOGGER.debug(String.format("%s[%s][%s][isNew=%s][send]%s", method, notifyMsg, serviceName, isNew, NotificationModel.toString(lastErrorSended)));
                }
            }
            this.counter.addSuccess();
            LOGGER.info("----------------------------------------------------------------");
            return;
        }
        catch (Exception ex) {
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
            LOGGER.warn(String.format(THREE_PARAMS_LOGGING, method, notifyMsg, serviceName, ex.getMessage()), (Throwable)ex);
            this.counter.addError();
        }
    }

    private ISystemNotifierPlugin getOrCreatePluginObject(ElementNotificationMonitor monitor, String method, String serviceName) {
        ISystemNotifierPlugin pl = null;
        try {
            pl = monitor.getOrCreatePluginObject();
            if (pl.hasErrorOnInit()) {
                this.counter.addSkip();
                LOGGER.warn(String.format("[%s][%s][skip] due plugin init error: %s", method, serviceName, pl.getInitError()));
                return null;
            }
        }
        catch (Exception e) {
            this.counter.addError();
            pl = null;
            LOGGER.error(String.format("[%s][%s]%s", method, serviceName, e.toString()), (Throwable)e);
        }
        return pl;
    }

    private void setDummySysNotification4NotifyNew(String systemId, Long notificationId, DBItemSchedulerMonSystemNotifications dummy) {
        String method = "setDummySysNotification4NotifyNew";
        try {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]notificationId=%s", method, notificationId));
            }
            this.getDbLayer().getSession().beginTransaction();
            if (dummy == null) {
                dummy = this.getDbLayer().createDummySystemNotification(systemId, notificationId);
                this.getDbLayer().getSession().save((Object)dummy);
            } else {
                dummy.setNotificationId(notificationId);
                dummy.setModified(DBLayer.getCurrentDateTime());
                this.getDbLayer().getSession().update((Object)dummy);
            }
            this.getDbLayer().getSession().commit();
        }
        catch (Exception ex) {
            LOGGER.warn(String.format("[%s]%s", method, ex.toString()), (Throwable)ex);
            try {
                this.getDbLayer().getSession().rollback();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void notifyTimer(String systemId) throws Exception {
        String method = "notifyTimer";
        if (!this.monitorOnSuccessTimers.isEmpty() || !this.monitorOnErrorTimers.isEmpty()) {
            this.notifyTimer(systemId, this.monitorOnSuccessTimers, this.monitorOnErrorTimers);
        } else {
            LOGGER.info(String.format("[%s][skip]found 0 Timer definitions", method));
        }
    }

    private void notifyTimer(String systemId, ArrayList<ElementTimerRef> timersOnSuccess, ArrayList<ElementTimerRef> timersOnError) throws Exception {
        String method = "notifyTimer";
        List<DBItemSchedulerMonChecks> result = this.getDbLayer().getChecksForNotifyTimer(this.largeResultFetchSize);
        LOGGER.info(String.format("[%s][service_name_on_success=%s][service_name_on_error=%s]found %s checks for timers in the db", method, timersOnSuccess.size(), timersOnError.size(), result.size()));
        this.initSendCounters();
        int currentCounter = 0;
        for (DBItemSchedulerMonChecks check : result) {
            ElementTimerRef t;
            int i;
            ++currentCounter;
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s]%s", method, currentCounter, NotificationModel.toString(check)));
            }
            for (i = 0; i < timersOnSuccess.size(); ++i) {
                this.counter.addTotal();
                t = timersOnSuccess.get(i);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][service_name_on_success][%s][%s]%s", method, currentCounter, i, t.getMonitor().getServiceNameOnSuccess(), t.getRef()));
                }
                if (!SOSString.isEmpty((String)t.getMonitor().getServiceNameOnError()) && !SOSString.isEmpty((String)t.getMonitor().getServiceNameOnSuccess())) {
                    this.counter.addSkip();
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][%s][skip][service_name_on_success]check %s later on service_name_on_error for serviceName=%s", method, currentCounter, t.getRef(), t.getMonitor().getServiceNameOnError()));
                    continue;
                }
                if (this.checkDoNotifyTimer(currentCounter, check, t)) {
                    this.executeNotifyTimer(currentCounter, systemId, check, t, false);
                    continue;
                }
                this.counter.addSkip();
            }
            for (i = 0; i < timersOnError.size(); ++i) {
                this.counter.addTotal();
                t = timersOnError.get(i);
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][service_name_on_error][%s][%s]%s", method, currentCounter, i, t.getMonitor().getServiceNameOnError(), t.getRef()));
                }
                if (this.checkDoNotifyTimer(currentCounter, check, t)) {
                    this.executeNotifyTimer(currentCounter, systemId, check, t, true);
                    continue;
                }
                this.counter.addSkip();
            }
        }
        LOGGER.info(String.format(SENT_LOGGING, method, this.counter.getSuccess(), this.counter.getError(), this.counter.getSkip(), this.counter.getTotal()));
    }

    private void notifyAgain(String systemId) throws Exception {
        String method = "notifyAgain";
        this.handledByNotifyAgain = new ArrayList();
        List<DBItemSchedulerMonSystemNotifications> result = this.getDbLayer().getSystemNotifications4NotifyAgain(systemId);
        LOGGER.info(String.format("[%s]found=%s", method, result.size()));
        this.initSendCounters();
        int c = 0;
        for (DBItemSchedulerMonSystemNotifications systemNotification : result) {
            String notifyMsg;
            ++c;
            this.counter.addTotal();
            String string = notifyMsg = systemNotification.getSuccess() ? "notifyOnSuccess" : "notifyOnError";
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s]%s", c, method, notifyMsg, NotificationModel.toString(systemNotification)));
            }
            DBItemSchedulerMonNotifications notification = null;
            if (systemNotification.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_MASTER_MESSAGE) || systemNotification.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_LONGER_THAN) || systemNotification.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_WARNING) || systemNotification.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_SHORTER_THAN)) {
                DBItemSchedulerMonInternalNotifications internalNotification = this.getDbLayer().getInternalNotification(systemNotification.getNotificationId());
                if (internalNotification == null) {
                    this.counter.addSkip();
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][%s][%s][skip]not foud internal notification", c, method, notifyMsg));
                    continue;
                }
                notification = new DBItemSchedulerMonNotifications();
                notification.setSchedulerId(internalNotification.getSchedulerId());
                notification.setStandalone(internalNotification.getStandalone());
                notification.setTaskId(internalNotification.getTaskId());
                notification.setJobChainName(internalNotification.getJobChainName());
                notification.setJobChainTitle(internalNotification.getJobChainTitle());
                notification.setOrderHistoryId(internalNotification.getOrderHistoryId());
                notification.setOrderId(internalNotification.getOrderId());
                notification.setOrderTitle(internalNotification.getOrderTitle());
                notification.setOrderStartTime(internalNotification.getOrderStartTime());
                notification.setOrderEndTime(internalNotification.getOrderEndTime());
                notification.setStep(internalNotification.getStep());
                notification.setOrderStepState(internalNotification.getOrderStepState());
                notification.setOrderStepStartTime(internalNotification.getOrderStepStartTime());
                notification.setOrderStepEndTime(internalNotification.getOrderStepEndTime());
                notification.setJobName(internalNotification.getJobName());
                notification.setJobTitle(internalNotification.getJobTitle());
                notification.setTaskStartTime(internalNotification.getTaskStartTime());
                notification.setTaskEndTime(internalNotification.getTaskEndTime());
                notification.setReturnCode(internalNotification.getReturnCode());
                notification.setAgentUrl(internalNotification.getAgentUrl());
                notification.setClusterMemberId(internalNotification.getClusterMemberId());
                notification.setError(internalNotification.getError());
                notification.setErrorCode(internalNotification.getMessageCode());
                notification.setErrorText(internalNotification.getMessage());
                notification.setCreated(internalNotification.getCreated());
                notification.setModified(internalNotification.getModified());
            } else {
                if (!systemNotification.getCheckId().equals(new Long(0L))) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][%s][skip]is timer system notifier", c, method, notifyMsg));
                    }
                    this.counter.addSkip();
                    continue;
                }
                notification = this.getDbLayer().getNotification(systemNotification.getNotificationId());
                if (notification == null) {
                    this.counter.addSkip();
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][%s][%s][skip]not foud notification", c, method, notifyMsg));
                    continue;
                }
                if (notification.getStep().equals(DBLayer.NOTIFICATION_DUMMY_MAX_STEP)) {
                    this.counter.addSkip();
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][%s][%s][skip][step is a dummy step]%s", c, method, notifyMsg, NotificationModel.toString(notification)));
                    continue;
                }
            }
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s][%s]%s", c, method, notifyMsg, NotificationModel.toString(notification)));
            }
            if (systemNotification.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_JOB_CHAIN)) {
                Long currentNotificationBefore = systemNotification.getCurrentNotification();
                boolean matches = false;
                for (int i = 0; i < this.monitorJobChains.size(); ++i) {
                    String serviceNameOnSuccess;
                    ElementJobChain jc = this.monitorJobChains.get(i);
                    if (!this.checkDoNotify(c, notification, jc)) continue;
                    matches = true;
                    String serviceNameOnError = SOSString.isEmpty((String)jc.getMonitor().getServiceNameOnError()) ? "" : jc.getMonitor().getServiceNameOnError();
                    String string2 = serviceNameOnSuccess = SOSString.isEmpty((String)jc.getMonitor().getServiceNameOnSuccess()) ? "" : jc.getMonitor().getServiceNameOnSuccess();
                    if (systemNotification.getServiceName().equalsIgnoreCase(serviceNameOnError) || systemNotification.getServiceName().equalsIgnoreCase(serviceNameOnSuccess)) {
                        this.executeNotifyJobChain(c, systemNotification, systemId, notification, jc);
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][%s][%s][skip]service names not match", c, method, notifyMsg));
                }
                if (!matches) {
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][%s][skip][JobChain]not match the current configuration", c, method, notifyMsg));
                    }
                    this.counter.addSkip();
                    continue;
                }
                Long currentNotificationAfter = systemNotification.getCurrentNotification();
                if (currentNotificationAfter.equals(currentNotificationBefore) && systemNotification.getStepToEndTime() == null) continue;
            }
            if (systemNotification.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_JOB)) {
                boolean matches = false;
                for (int i = 0; i < this.monitorJobs.size(); ++i) {
                    ElementJob job = this.monitorJobs.get(i);
                    if (this.checkDoNotify(c, notification, job)) {
                        String serviceNameOnSuccess;
                        matches = true;
                        String serviceNameOnError = SOSString.isEmpty((String)job.getMonitor().getServiceNameOnError()) ? "" : job.getMonitor().getServiceNameOnError();
                        String string3 = serviceNameOnSuccess = SOSString.isEmpty((String)job.getMonitor().getServiceNameOnSuccess()) ? "" : job.getMonitor().getServiceNameOnSuccess();
                        if (systemNotification.getServiceName().equalsIgnoreCase(serviceNameOnError) || systemNotification.getServiceName().equalsIgnoreCase(serviceNameOnSuccess)) {
                            this.executeNotifyJob(c, systemNotification, systemId, notification, job);
                            continue;
                        }
                        if (!isDebugEnabled) continue;
                        LOGGER.debug(String.format("[%s][%s][skip]service names not match", method, c));
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][%s][skip]checkDoNotify=false", method, c));
                }
                if (matches) continue;
                if (isDebugEnabled) {
                    LOGGER.debug(String.format("[%s][%s][%s][skip][Job]not match the current configuration", c, method, notifyMsg));
                }
                this.counter.addSkip();
                continue;
            }
            if (systemNotification.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_MASTER_MESSAGE)) {
                for (int i = 0; i < this.monitorInternalMasterMessages.size(); ++i) {
                    ElementMasterMessage jc = this.monitorInternalMasterMessages.get(i);
                    if (SystemNotifierModel.checkDoNotifyInternal(c, notification.getSchedulerId(), jc)) {
                        if (SOSString.isEmpty((String)jc.getMonitor().getServiceNameOnError()) || !systemNotification.getServiceName().equalsIgnoreCase(jc.getMonitor().getServiceNameOnError())) continue;
                        this.executeNotifyInternal(c, systemNotification, systemId, notification, jc);
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][%s][MasterMessages][skip]checkDoNotifyInternal=false", method, c));
                }
                continue;
            }
            if (systemNotification.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_LONGER_THAN)) {
                for (int i = 0; i < this.monitorInternalTaskIfLongerThan.size(); ++i) {
                    ElementTaskIfLongerThan jc = this.monitorInternalTaskIfLongerThan.get(i);
                    if (SystemNotifierModel.checkDoNotifyInternal(c, notification.getSchedulerId(), jc)) {
                        if (SOSString.isEmpty((String)jc.getMonitor().getServiceNameOnError()) || !systemNotification.getServiceName().equalsIgnoreCase(jc.getMonitor().getServiceNameOnError())) continue;
                        this.executeNotifyInternal(c, systemNotification, systemId, notification, jc);
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][%s][TaskIfLongerThan][skip]checkDoNotifyInternal=false", method, c));
                }
                continue;
            }
            if (systemNotification.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_IF_SHORTER_THAN)) {
                for (int i = 0; i < this.monitorInternalTaskIfShorterThan.size(); ++i) {
                    ElementTaskIfShorterThan jc = this.monitorInternalTaskIfShorterThan.get(i);
                    if (SystemNotifierModel.checkDoNotifyInternal(c, notification.getSchedulerId(), jc)) {
                        if (SOSString.isEmpty((String)jc.getMonitor().getServiceNameOnError()) || !systemNotification.getServiceName().equalsIgnoreCase(jc.getMonitor().getServiceNameOnError())) continue;
                        this.executeNotifyInternal(c, systemNotification, systemId, notification, jc);
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][%s][TaskIfLongerThan][skip]checkDoNotifyInternal=false", method, c));
                }
                continue;
            }
            if (systemNotification.getObjectType().equals(DBLayer.NOTIFICATION_OBJECT_TYPE_INTERNAL_TASK_WARNING)) {
                for (int i = 0; i < this.monitorInternalTaskWarning.size(); ++i) {
                    ElementTaskWarning jc = this.monitorInternalTaskWarning.get(i);
                    if (SystemNotifierModel.checkDoNotifyInternal(c, notification.getSchedulerId(), jc)) {
                        if (SOSString.isEmpty((String)jc.getMonitor().getServiceNameOnError()) || !systemNotification.getServiceName().equalsIgnoreCase(jc.getMonitor().getServiceNameOnError())) continue;
                        this.executeNotifyInternal(c, systemNotification, systemId, notification, jc);
                        continue;
                    }
                    if (!isDebugEnabled) continue;
                    LOGGER.debug(String.format("[%s][%s][TaskWarning][skip]checkDoNotifyInternal=false", method, c));
                }
                continue;
            }
            this.counter.addSkip();
            if (!isDebugEnabled) continue;
            LOGGER.debug(String.format("[%s][%s][%s][skip]dummy notification...", c, method, notifyMsg));
        }
        LOGGER.info(String.format(SENT_LOGGING, method, this.counter.getSuccess(), this.counter.getError(), this.counter.getSkip(), this.counter.getTotal()));
    }

    private void notifyNew(String systemId) throws Exception {
        String method = "notifyNew";
        Long maxNotificationId = new Long(0L);
        DBItemSchedulerMonSystemNotifications dummy = this.getDbLayer().getDummySystemNotification(systemId);
        List<DBItemSchedulerMonNotifications> result = this.getDbLayer().getNotifications4NotifyNew(systemId, dummy);
        LOGGER.info(String.format("[%s]found=%s", method, result.size()));
        this.initSendCounters();
        ArrayList<String> checkedJobchans = new ArrayList<String>();
        int c = 0;
        for (DBItemSchedulerMonNotifications notification : result) {
            ++c;
            this.counter.addTotal();
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][%s]%s", method, c, NotificationModel.toString(notification)));
            }
            if (notification.getStep().equals(DBLayer.NOTIFICATION_DUMMY_MAX_STEP)) {
                this.counter.addSkip();
                if (!isDebugEnabled) continue;
                LOGGER.debug(String.format("[%s][%s][skip][step is a dummy step]%s", method, c, NotificationModel.toString(notification)));
                continue;
            }
            if (notification.getId() > maxNotificationId) {
                maxNotificationId = notification.getId();
            }
            if (!notification.getStandalone()) {
                String identifier = notification.getOrderHistoryId().toString();
                if (notification.getStep().equals(new Long(1L))) {
                    if (!checkedJobchans.contains(identifier)) {
                        checkedJobchans.add(identifier);
                        for (int i = 0; i < this.monitorJobChains.size(); ++i) {
                            ElementJobChain jc = this.monitorJobChains.get(i);
                            if (!this.checkDoNotify(c, notification, jc)) continue;
                            this.executeNotifyJobChain(c, null, systemId, notification, jc);
                        }
                    } else if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][skip][step=1]order history id=%s already processed", method, c, notification.getStep(), identifier));
                    }
                } else if (checkedJobchans.contains(identifier)) {
                    this.counter.addSkip();
                    if (isDebugEnabled) {
                        LOGGER.debug(String.format("[%s][%s][skip][step %s > 1]order history id=%s already processed", method, c, notification.getStep(), identifier));
                    }
                } else {
                    checkedJobchans.add(identifier);
                    DBItemSchedulerMonNotifications n = null;
                    for (int i = 0; i < this.monitorJobChains.size(); ++i) {
                        ElementJobChain jc = this.monitorJobChains.get(i);
                        if (!this.checkDoNotify(c, notification, jc)) continue;
                        if (n == null && (n = this.getDbLayer().getNotificationFirstStep(notification)) == null) {
                            if (isDebugEnabled) {
                                LOGGER.debug(String.format("[%s][%s][first step not found in the database]try to find a min step. %s", method, c, NotificationModel.toString(notification)));
                            }
                            n = this.getDbLayer().getNotificationMinStep(notification);
                        }
                        if (n == null) {
                            this.counter.addSkip();
                            LOGGER.info(String.format("[%s][%s][skip][!!!first step and min step not found in the database]%s", method, c, NotificationModel.toString(notification)));
                            break;
                        }
                        this.executeNotifyJobChain(c, null, systemId, n, jc);
                    }
                }
            }
            for (int i = 0; i < this.monitorJobs.size(); ++i) {
                ElementJob job = this.monitorJobs.get(i);
                if (!this.checkDoNotify(c, notification, job)) continue;
                this.executeNotifyJob(c, null, systemId, notification, job);
            }
        }
        LOGGER.info(String.format(SENT_LOGGING, method, this.counter.getSuccess(), this.counter.getError(), this.counter.getSkip(), this.counter.getTotal()));
        if (maxNotificationId > 0L && this.counter.getError() == 0) {
            this.setDummySysNotification4NotifyNew(systemId, maxNotificationId, dummy);
        }
    }

    private void closePlugins() {
        if (this.monitors != null) {
            for (ElementNotificationMonitor monitor : this.monitors) {
                if (monitor.getPluginObject() == null) continue;
                try {
                    monitor.getPluginObject().close();
                }
                catch (Throwable throwable) {}
            }
        }
    }

    @Override
    public void process() throws Exception {
        if (this.initConfig()) {
            try {
                this.notifyAgain(this.systemId);
                this.notifyNew(this.systemId);
                this.notifyTimer(this.systemId);
            }
            catch (Throwable e) {
                throw e;
            }
            finally {
                this.closePlugins();
            }
        }
    }

    public Spooler getSpooler() {
        return this.spooler;
    }
}

