/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.notification.model.result;

import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.notification.db.DBItemSchedulerMonNotifications;
import com.sos.jitl.notification.db.DBItemSchedulerMonResults;
import com.sos.jitl.notification.db.DBLayer;
import com.sos.jitl.notification.jobs.result.StoreResultsJobOptions;
import com.sos.jitl.notification.model.INotificationModel;
import com.sos.jitl.notification.model.NotificationModel;
import com.sos.scheduler.SOSJobSchedulerGlobal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.util.SOSString;

public class StoreResultsModel
extends NotificationModel
implements INotificationModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(StoreResultsModel.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private StoreResultsJobOptions options;

    public StoreResultsModel(SOSHibernateSession sess, StoreResultsJobOptions opt) throws Exception {
        super(sess);
        this.options = opt;
    }

    @Override
    public void process() throws Exception {
        ArrayList<String> resultParamsAsList = this.getResultParamsAsArrayList(this.options.scheduler_notification_result_parameters.getValue());
        boolean hasResultParams = !resultParamsAsList.isEmpty();
        HashMap hm = this.options.getSettings();
        HashMap hmInsert = new HashMap();
        if (hm != null) {
            for (String name : hm.keySet()) {
                if (hasResultParams && !resultParamsAsList.contains(name)) continue;
                hmInsert.put(name, hm.get(name));
            }
        }
        LOGGER.info(String.format("[process]params=%s", hmInsert.size()));
        if (!hmInsert.isEmpty()) {
            try {
                this.getDbLayer().getSession().beginTransaction();
                DBItemSchedulerMonNotifications n = this.getNotification();
                this.getDbLayer().getSession().commit();
                this.getDbLayer().getSession().beginTransaction();
                for (String name : hmInsert.keySet()) {
                    this.insertParam(n.getId(), name, (String)hmInsert.get(name));
                }
                this.getDbLayer().getSession().commit();
            }
            catch (Exception ex) {
                try {
                    this.getDbLayer().getSession().rollback();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ex;
            }
        }
    }

    private DBItemSchedulerMonNotifications getNotification() throws Exception {
        List<DBItemSchedulerMonNotifications> dbItems;
        String method = "getNotification";
        DBItemSchedulerMonNotifications dbItem = null;
        DBItemSchedulerMonNotifications tmp = new DBItemSchedulerMonNotifications();
        tmp.setSchedulerId(this.options.mon_results_scheduler_id.getValue());
        tmp.setStandalone(this.options.mon_results_standalone.value());
        tmp.setTaskId(new Long(this.options.mon_results_task_id.value()));
        tmp.setOrderStepState(this.options.mon_results_order_step_state.getValue());
        tmp.setJobChainName(this.options.mon_results_job_chain_name.getValue());
        tmp.setOrderId(this.options.mon_results_order_id.getValue());
        tmp.setOrderHistoryId(new Long(this.options.mon_results_order_history_id.value()));
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s][tmp]%s", method, NotificationModel.toString(tmp)));
        }
        if ((dbItems = this.getDbLayer().getNotificationsByState(tmp.getSchedulerId(), tmp.getStandalone(), tmp.getTaskId(), tmp.getOrderHistoryId(), tmp.getOrderStepState())) == null || dbItems.size() == 0) {
            tmp.setStep(DBLayer.NOTIFICATION_DUMMY_MAX_STEP);
            tmp.setJobName("dummy");
            tmp.setJobCriticality(SOSJobSchedulerGlobal.JOB_CRITICALITY.NORMAL.toString());
            tmp.setTaskStartTime(new Date());
            dbItem = this.getDbLayer().createNotification(tmp.getSchedulerId(), tmp.getStandalone(), tmp.getTaskId(), tmp.getStep(), tmp.getOrderHistoryId(), tmp.getJobChainName(), tmp.getJobChainName(), tmp.getOrderId(), tmp.getOrderId(), tmp.getOrderStartTime(), tmp.getOrderEndTime(), tmp.getOrderStepState(), tmp.getOrderStepStartTime(), tmp.getOrderStepEndTime(), tmp.getJobName(), tmp.getJobName(), tmp.getTaskStartTime(), tmp.getTaskEndTime(), tmp.getError(), tmp.getReturnCode(), tmp.getAgentUrl(), tmp.getClusterMemberId(), tmp.getJobCriticality(), tmp.getError(), tmp.getErrorCode(), tmp.getErrorText());
            this.getDbLayer().getSession().save((Object)dbItem);
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][created]%s", method, NotificationModel.toString(dbItem)));
            }
        } else {
            dbItem = dbItems.get(0);
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][found=%s]%s", method, dbItems.size(), NotificationModel.toString(dbItem)));
            }
        }
        return dbItem;
    }

    private DBItemSchedulerMonResults insertParam(Long notificationId, String name, String value) throws Exception {
        DBItemSchedulerMonResults dbItem = this.getDbLayer().createResult(notificationId, name, value);
        this.getDbLayer().getSession().save((Object)dbItem);
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[insertParam]%s", NotificationModel.toString(dbItem)));
        }
        return dbItem;
    }

    private ArrayList<String> getResultParamsAsArrayList(String params) {
        ArrayList<String> list = new ArrayList<String>();
        if (!SOSString.isEmpty((String)params)) {
            String[] arr = params.split(";");
            for (int i = 0; i < arr.length; ++i) {
                String val = arr[i].trim();
                if (val.isEmpty()) continue;
                list.add(val);
            }
        }
        return list;
    }
}

