/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.parameters;

import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Job_chain;
import sos.spooler.Job_chain_node;
import sos.spooler.Order;
import sos.spooler.Supervisor_client;

public class SetSpecialParameters
extends JobSchedulerJobAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(SetSpecialParameters.class);

    public boolean spooler_process_before() throws Exception {
        LOGGER.debug("Starting spooler_process_before");
        try {
            if (this.spooler_job != null && this.getJobSettings() != null) {
                this.setJobProperties(this.getJobSettings().getSection("job " + this.spooler_job.name()));
            }
            if (this.spooler_task != null) {
                this.setJobId(this.spooler_task.id());
            }
            if (this.spooler_job != null) {
                this.setJobName(this.spooler_job.name());
            }
            if (this.spooler_job != null) {
                this.setJobFolder(this.spooler_job.folder_path());
            }
            if (this.spooler_job != null) {
                this.setJobTitle(this.spooler_job.title());
            }
            HashMap<String, String> specialParams = new HashMap<String, String>();
            specialParams.put("SCHEDULER_HOST", this.spooler.hostname());
            specialParams.put("SCHEDULER_TCP_PORT", "" + this.spooler.tcp_port());
            specialParams.put("SCHEDULER_UDP_PORT", "" + this.spooler.udp_port());
            specialParams.put("SCHEDULER_ID", this.spooler.id());
            specialParams.put("SCHEDULER_DIRECTORY", this.spooler.directory());
            specialParams.put("SCHEDULER_CONFIGURATION_DIRECTORY", this.spooler.configuration_directory());
            Order order = this.spooler_task.order();
            if (order != null) {
                Job_chain jobChain = order.job_chain();
                Job_chain_node jobChainNode = order.job_chain_node();
                specialParams.put("SCHEDULER_JOB_CHAIN_NAME", jobChain.name());
                specialParams.put("SCHEDULER_JOB_CHAIN_TITLE", jobChain.title());
                specialParams.put("SCHEDULER_JOB_CHAIN_PATH", jobChain.path());
                specialParams.put("SCHEDULER_ORDER_ID", order.id());
                specialParams.put("SCHEDULER_NODE_NAME", this.getCurrentNodeName(order, false));
                specialParams.put("SCHEDULER_NEXT_NODE_NAME", jobChainNode.next_state());
                specialParams.put("SCHEDULER_NEXT_ERROR_NODE_NAME", jobChainNode.error_state());
            }
            specialParams.put("SCHEDULER_JOB_NAME", this.getJobName());
            specialParams.put("SCHEDULER_JOB_FOLDER", this.getJobFolder());
            specialParams.put("SCHEDULER_JOB_PATH", this.getJobFolder() + "/" + this.getJobName());
            specialParams.put("SCHEDULER_JOB_TITLE", this.getJobTitle());
            specialParams.put("SCHEDULER_TASK_ID", "" + this.spooler_task.id());
            try {
                Supervisor_client supervisorClient = this.spooler.supervisor_client();
                if (supervisorClient != null) {
                    specialParams.put("SCHEDULER_SUPERVISOR_HOST", supervisorClient.hostname());
                    specialParams.put("SCHEDULER_SUPERVISOR_PORT", "" + supervisorClient.tcp_port());
                }
            }
            catch (Exception e) {
                specialParams.put("SCHEDULER_SUPERVISOR_HOST", "n.a.");
                specialParams.put("SCHEDULER_SUPERVISOR_PORT", "n.a.");
            }
            for (Map.Entry e : specialParams.entrySet()) {
                if (e.getValue() != null) continue;
                specialParams.put((String)e.getKey(), "");
            }
            if (this.spooler_task != null) {
                if (this.spooler_task.order() != null) {
                    for (Map.Entry e : specialParams.entrySet()) {
                        LOGGER.debug((String)e.getKey() + "=" + (String)e.getValue());
                        this.spooler_task.order().params().set_value((String)e.getKey(), (String)e.getValue());
                    }
                } else {
                    for (Map.Entry e : specialParams.entrySet()) {
                        this.spooler_task.params().set_value((String)e.getKey(), (String)e.getValue());
                    }
                }
            } else {
                for (Map.Entry e : specialParams.entrySet()) {
                    LOGGER.info((String)e.getKey() + "=" + (String)e.getValue());
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return true;
    }
}

