/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.reporting.plugin;

import com.sos.hibernate.classes.SOSHibernate;
import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.jitl.dailyplan.db.DailyPlanAdjustment;
import com.sos.jitl.dailyplan.job.CheckDailyPlanOptions;
import com.sos.jitl.eventhandler.EventMeta;
import com.sos.jitl.eventhandler.handler.LoopEventHandler;
import com.sos.jitl.eventhandler.plugin.notifier.Notifier;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.jitl.reporting.exceptions.SOSReportingConcurrencyException;
import com.sos.jitl.reporting.exceptions.SOSReportingInvalidSessionException;
import com.sos.jitl.reporting.exceptions.SOSReportingLockException;
import com.sos.jitl.reporting.job.report.FactJobOptions;
import com.sos.jitl.reporting.model.report.FactModel;
import com.sos.scheduler.engine.eventbus.EventPublisher;
import com.sos.scheduler.engine.kernel.scheduler.SchedulerXmlCommandExecutor;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import javax.json.JsonArray;
import javax.json.JsonObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class FactEventHandler
extends LoopEventHandler {
    public static final String CUSTOM_EVENT_KEY = FactEventHandler.class.getSimpleName();
    private static final String JOB_CHAIN_CREATE_DAILY_PLAN = "/sos/dailyplan/CreateDailyPlan";
    private static final Logger LOGGER = LoggerFactory.getLogger(FactEventHandler.class);
    private static final boolean isDebugEnabled = LOGGER.isDebugEnabled();
    private String customEventValue = null;
    private boolean rerun = false;
    private boolean firstEventProcessed = false;
    private SOSHibernateFactory reportingFactory;
    private SOSHibernateFactory schedulerFactory;
    private boolean useNotificationPlugin = false;
    private int waitInterval = 2;
    private Notifier pluginNotifier;

    public FactEventHandler(SchedulerXmlCommandExecutor xmlExecutor, EventPublisher eventBus) {
        super(xmlExecutor, eventBus);
    }

    @Override
    public void onActivate(Notifier notifier) {
        super.onActivate(notifier);
        String method = "onActivate";
        try {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]create db factories...", method));
            }
            this.createReportingFactory(this.getSettings().getHibernateConfigurationReporting());
            this.createSchedulerFactory(this.getSettings().getHibernateConfigurationScheduler());
            if (this.useNotificationPlugin) {
                this.pluginNotifier = this.getNotifier().newInstance();
            }
            EventMeta.EventType[] observedEventTypes = new EventMeta.EventType[]{EventMeta.EventType.TaskStarted, EventMeta.EventType.TaskClosed, EventMeta.EventType.OrderStepStarted, EventMeta.EventType.OrderStepEnded, EventMeta.EventType.OrderFinished, EventMeta.EventType.OrderRemoved, EventMeta.EventType.OrderResumed, EventMeta.EventType.OrderWaitingInTask};
            LOGGER.info(String.format("[%s]start...", method));
            this.start(observedEventTypes);
        }
        catch (Exception e) {
            LOGGER.error(String.format("[%s]%s", method, e.toString()), (Throwable)e);
            this.getNotifier().notifyOnError(method, e);
        }
    }

    @Override
    public void onProcessingEnd(Long eventId) {
        if (isDebugEnabled) {
            LOGGER.debug("[onProcessingEnd]close db factories ...");
        }
        this.closeSchedulerFactory();
        this.closeReportingFactory();
        LOGGER.info("[onProcessingEnd]closed");
    }

    @Override
    public void onEmptyEvent(Long eventId) {
        if (this.rerun || !this.firstEventProcessed) {
            if (isDebugEnabled) {
                if (this.firstEventProcessed) {
                    LOGGER.debug(String.format("[onEmptyEvent][rerun]%s", eventId));
                } else {
                    LOGGER.debug(String.format("[onEmptyEvent][firstEvent]%s", eventId));
                }
            }
            this.execute(eventId, null, false);
        }
    }

    @Override
    public void onNonEmptyEvent(Long eventId, JsonArray events) {
        this.rerun = false;
        this.execute(eventId, events, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(Long eventId, JsonArray events, boolean onNonEmptyEvent) {
        String method = "execute";
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s][%s][onNonEmptyEvent=%s]", method, eventId, onNonEmptyEvent));
        }
        SOSHibernateSession reportingSession = null;
        SOSHibernateSession schedulerSession = null;
        FactModel factModel = null;
        int waitIntervalOnFinally = this.waitInterval;
        this.customEventValue = null;
        this.firstEventProcessed = true;
        try {
            reportingSession = this.reportingFactory.openStatelessSession();
            schedulerSession = this.schedulerFactory.openStatelessSession();
            factModel = this.executeFacts(reportingSession, schedulerSession, events, this.useNotificationPlugin);
            if (factModel.isLocked()) {
                this.rerun = true;
            } else {
                this.executeDailyPlan(reportingSession, factModel.isChanged(), events);
                this.rerun = false;
            }
            if (this.getNotifier().smartNotifyOnRecovery()) {
                LOGGER.info(String.format("[%s]recovered from previous error", method));
            }
        }
        catch (SOSReportingConcurrencyException e) {
            this.rerun = true;
            LOGGER.warn(String.format("[%s]%s", method, e.toString()), (Throwable)((Object)e));
        }
        catch (SOSReportingLockException e) {
            this.rerun = true;
            LOGGER.warn(String.format("[%s]%s", method, e.toString()), (Throwable)((Object)e));
        }
        catch (SOSReportingInvalidSessionException e) {
            this.rerun = true;
            waitIntervalOnFinally = this.getWaitIntervalOnError();
            this.getNotifier().smartNotifyOnError(this.getClass(), (Throwable)((Object)e));
        }
        catch (Throwable e) {
            this.rerun = true;
            this.getNotifier().smartNotifyOnError(this.getClass(), e);
        }
        finally {
            if (factModel != null) {
                factModel.exit();
            }
            if (reportingSession != null) {
                reportingSession.close();
            }
            if (schedulerSession != null) {
                schedulerSession.close();
            }
            this.wait(waitIntervalOnFinally);
        }
    }

    private void executeDailyPlan(SOSHibernateSession reportingSession, boolean hasReportingChanges, JsonArray events) throws Exception {
        String method = "executeDailyPlan";
        if (events == null) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][skip]events is null", method));
            }
            return;
        }
        if (!hasReportingChanges) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][skip]0 reporting changes", method));
            }
            return;
        }
        ArrayList<String> createDailyPlanEvents = this.getCreateDailyPlanEvents(events);
        if (createDailyPlanEvents.size() > 0 && !createDailyPlanEvents.contains(EventMeta.EventType.TaskEnded.name()) && !createDailyPlanEvents.contains(EventMeta.EventType.TaskClosed.name())) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s][skip]found not ended %s events", method, JOB_CHAIN_CREATE_DAILY_PLAN));
            }
            return;
        }
        if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]execute ...", method));
        }
        CheckDailyPlanOptions options = new CheckDailyPlanOptions();
        options.scheduler_id.setValue(this.getSettings().getSchedulerId());
        options.dayOffset.setValue("0");
        try {
            options.configuration_file.setValue(this.getSettings().getHibernateConfigurationReporting().toFile().getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
        String pluginContext = MDC.get((String)"plugin");
        MDC.put((String)"plugin", (String)"dailyplan");
        DailyPlanAdjustment dp = new DailyPlanAdjustment(reportingSession);
        dp.setOptions(options);
        dp.setTo(new Date());
        int count = 0;
        boolean run = true;
        while (run) {
            ++count;
            try {
                dp.adjustWithHistory();
                run = false;
            }
            catch (Exception e) {
                Exception lae = SOSHibernate.findLockException((Exception)e);
                if (lae == null) {
                    throw e;
                }
                if (count >= 3) {
                    throw new SOSReportingLockException(e);
                }
                LOGGER.warn(String.format("[%s]%s occured, wait %ss and try again (%s of %s) ...", method, lae.getClass().getName(), 2L, count, 3));
                Thread.sleep(2000L);
            }
        }
        if (dp.isDailyPlanUpdated()) {
            if (isDebugEnabled) {
                LOGGER.debug(String.format("[%s]daily plan was changed, publish CustomEventType.DailyPlanChanged event", method));
            }
            this.publishCustomEvent(CUSTOM_EVENT_KEY, CustomEventType.DailyPlanChanged.name(), this.customEventValue);
        } else if (isDebugEnabled) {
            LOGGER.debug(String.format("[%s]daily plan was not changed", method));
        }
        if (pluginContext != null) {
            MDC.put((String)"plugin", (String)pluginContext);
        } else {
            MDC.remove((String)"plugin");
        }
    }

    private FactModel executeFacts(SOSHibernateSession reportingSession, SOSHibernateSession schedulerSession, JsonArray events, boolean executeNotificationPlugin) throws Exception {
        LOGGER.debug("[executeFacts]execute ...");
        FactModel factModel = null;
        FactJobOptions options = new FactJobOptions();
        options.current_scheduler_id.setValue(this.getSettings().getSchedulerId());
        options.current_scheduler_hostname.setValue(this.getSettings().getHost());
        options.current_scheduler_http_port.setValue(this.getSettings().getHttpPort());
        options.hibernate_configuration_file.setValue(this.getSettings().getHibernateConfigurationReporting().toString());
        options.hibernate_configuration_file_scheduler.setValue(this.getSettings().getHibernateConfigurationScheduler().toString());
        options.max_history_tasks.setValue("200000");
        options.max_history_age.setValue("1h");
        options.force_max_history_age.value(false);
        options.execute_notification_plugin.setValue(String.valueOf(executeNotificationPlugin));
        options.wait_interval.setValue(String.valueOf(this.waitInterval));
        factModel = new FactModel(reportingSession, schedulerSession, options, events);
        factModel.init(this.pluginNotifier, this.getSettings().getConfigDirectory());
        factModel.process();
        if (factModel.isChanged()) {
            if (factModel.isOrdersChanged() && factModel.isTasksChanged()) {
                this.customEventValue = CustomEventTypeValue.order_standalone.name();
            } else if (factModel.isOrdersChanged()) {
                this.customEventValue = CustomEventTypeValue.order.name();
            } else if (factModel.isTasksChanged()) {
                this.customEventValue = CustomEventTypeValue.standalone.name();
            }
            this.publishCustomEvent(CUSTOM_EVENT_KEY, CustomEventType.ReportingChanged.name(), this.customEventValue);
            this.publishTransferHistory(factModel);
        }
        return factModel;
    }

    private void publishTransferHistory(FactModel factModel) {
        if (factModel.getTransferHistory().getTransferIds().size() > 0) {
            Iterator<Long> it = factModel.getTransferHistory().getTransferIds().iterator();
            while (it.hasNext()) {
                this.publishCustomEvent(CustomEventType.YADETransferFinished.name(), "transferId", String.valueOf(it.next()));
            }
            factModel.getTransferHistory().resetTransferIds();
        }
    }

    private ArrayList<String> getCreateDailyPlanEvents(JsonArray events) throws Exception {
        ArrayList<String> createDailyPlanEvents = new ArrayList<String>();
        if (events != null && events.size() > 0) {
            for (int i = 0; i < events.size(); ++i) {
                JsonObject jo = events.getJsonObject(i);
                String joType = jo.getString(EventMeta.EventKey.TYPE.name());
                String key = this.getEventKey(jo);
                if (key == null || !key.toLowerCase().contains(JOB_CHAIN_CREATE_DAILY_PLAN.toLowerCase())) continue;
                createDailyPlanEvents.add(joType);
            }
        }
        return createDailyPlanEvents;
    }

    public void setUseNotificationPlugin(boolean useNotification) {
        this.useNotificationPlugin = useNotification;
    }

    private void closeReportingFactory() {
        if (this.reportingFactory != null) {
            this.reportingFactory.close();
            this.reportingFactory = null;
        }
    }

    private void closeSchedulerFactory() {
        if (this.schedulerFactory != null) {
            this.schedulerFactory.close();
            this.schedulerFactory = null;
        }
    }

    private void createReportingFactory(Path configFile) throws Exception {
        this.reportingFactory = new SOSHibernateFactory(configFile);
        this.reportingFactory.setIdentifier("reporting");
        this.reportingFactory.setAutoCommit(false);
        this.reportingFactory.setTransactionIsolation(2);
        this.reportingFactory.addClassMapping(DBLayer.getReportingClassMapping());
        this.reportingFactory.addClassMapping(DBLayer.getInventoryClassMapping());
        this.reportingFactory.addClassMapping(DBLayer.getYadeClassMapping());
        this.reportingFactory.addClassMapping(com.sos.jitl.notification.db.DBLayer.getNotificationClassMapping());
        this.reportingFactory.build();
    }

    private void createSchedulerFactory(Path configFile) throws Exception {
        this.schedulerFactory = new SOSHibernateFactory(configFile);
        this.schedulerFactory.setIdentifier("scheduler");
        this.schedulerFactory.setAutoCommit(true);
        Enum dbms = this.schedulerFactory.getDbmsBeforeBuild();
        if (dbms.equals(SOSHibernateFactory.Dbms.MSSQL) || dbms.equals(SOSHibernateFactory.Dbms.MYSQL)) {
            this.schedulerFactory.setTransactionIsolation(1);
        } else {
            this.schedulerFactory.setTransactionIsolation(2);
        }
        this.schedulerFactory.addClassMapping(DBLayer.getSchedulerClassMapping());
        this.schedulerFactory.build();
    }

    public static enum CustomEventTypeValue {
        order,
        order_standalone,
        standalone;

    }

    public static enum CustomEventType {
        DailyPlanChanged,
        ReportingChanged,
        YADETransferFinished;

    }
}

