/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.restclient;

import com.google.common.base.Charsets;
import com.sos.exception.SOSBadRequestException;
import com.sos.exception.SOSConnectionRefusedException;
import com.sos.exception.SOSConnectionResetException;
import com.sos.exception.SOSException;
import com.sos.exception.SOSMissingDataException;
import com.sos.exception.SOSNoResponseException;
import com.sos.exception.SOSSSLException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.HttpHostConnectException;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;

public class JobSchedulerRestApiClient {
    private String accept = "application/json";
    private String basicAuthorization = null;
    private Map<String, String> headers = new HashMap<String, String>();
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private RequestConfig.Builder requestConfigBuilder = RequestConfig.custom();
    private CredentialsProvider credentialsProvider = null;
    private HostnameVerifier hostnameVerifier = NoopHostnameVerifier.INSTANCE;
    private HttpResponse httpResponse;
    private HttpRequestRetryHandler httpRequestRetryHandler;
    private CloseableHttpClient httpClient = null;
    private boolean forcedClosingHttpClient = false;
    private boolean autoCloseHttpClient = true;
    private String keystorePath = null;
    private String keystorePass = null;
    private String keystoreType = null;
    private char[] keyPass = null;
    private KeyStore keyStore = null;
    private String trustStorePath = null;
    private String trustStorePass = null;
    private String trustStoreType = null;
    private SSLContext sslContext = null;
    private KeyStore trustStore;

    public HttpResponse getHttpResponse() {
        return this.httpResponse;
    }

    public void setAccept(String accept) {
        this.accept = accept;
    }

    public void setBasicAuthorization(String basicAuthorization) {
        this.basicAuthorization = basicAuthorization;
    }

    public String getBasicAuthorization() {
        return this.basicAuthorization;
    }

    public int statusCode() {
        return this.httpResponse.getStatusLine().getStatusCode();
    }

    public void clearHeaders() {
        this.headers = new HashMap<String, String>();
    }

    public String getResponseHeader(String key) {
        if (this.responseHeaders != null) {
            return this.responseHeaders.get(key);
        }
        return "";
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.requestConfigBuilder.setConnectTimeout(connectionTimeout);
    }

    public void setConnectionRequestTimeout(int connectionTimeout) {
        this.requestConfigBuilder.setConnectionRequestTimeout(connectionTimeout);
    }

    public void setSocketTimeout(int socketTimeout) {
        this.requestConfigBuilder.setSocketTimeout(socketTimeout);
    }

    public void setAllowAllHostnameVerifier(boolean flag) {
        this.hostnameVerifier = flag ? NoopHostnameVerifier.INSTANCE : null;
    }

    public void setHttpRequestRetryHandler(HttpRequestRetryHandler handler) {
        this.httpRequestRetryHandler = handler;
    }

    public void setProxy(String proxyHost, Integer proxyPort) {
        this.setProxy(proxyHost, proxyPort, null, null);
    }

    public void setProxy(String proxyHost, Integer proxyPort, String proxyUser, String proxyPassword) {
        this.requestConfigBuilder.setProxy(new HttpHost(proxyHost, proxyPort.intValue()));
        if (proxyUser != null && !proxyUser.isEmpty()) {
            this.credentialsProvider = new BasicCredentialsProvider();
            this.credentialsProvider.setCredentials(new AuthScope(proxyHost, proxyPort.intValue()), (Credentials)new UsernamePasswordCredentials(proxyUser, proxyPassword));
        }
    }

    public void setKeystorePath(String keystorePath) {
        this.keystorePath = keystorePath;
    }

    public void setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
    }

    private Path getKeystorePath() throws SOSMissingDataException {
        String kStorePath = this.keystorePath;
        if (kStorePath == null) {
            kStorePath = System.getProperty("javax.net.ssl.keyStore");
        }
        if (kStorePath == null) {
            throw new SOSMissingDataException("The keystore path is missing.");
        }
        return Paths.get(kStorePath, new String[0]);
    }

    private Path getTruststorePath() throws SOSMissingDataException {
        String tStorePath = this.trustStorePath;
        if (tStorePath == null) {
            tStorePath = System.getProperty("javax.net.ssl.trustStore");
        }
        if (tStorePath == null) {
            throw new SOSMissingDataException("The truststore path is missing.");
        }
        return Paths.get(tStorePath, new String[0]);
    }

    public void setKeystorePass(String keystorePass) {
        this.keystorePass = keystorePass;
    }

    public void setTruststorePass(String trustStorePass) {
        this.trustStorePass = trustStorePass;
    }

    private char[] getKeystorePass() {
        String kStorePass = this.keystorePass;
        if (kStorePass == null) {
            kStorePass = System.getProperty("javax.net.ssl.keyStorePassword");
        }
        if (kStorePass != null) {
            return kStorePass.toCharArray();
        }
        return null;
    }

    private char[] getTruststorePass() {
        String tStorePass = this.trustStorePass;
        if (tStorePass == null) {
            tStorePass = System.getProperty("javax.net.ssl.trustStorePassword");
        }
        if (tStorePass != null) {
            return tStorePass.toCharArray();
        }
        return null;
    }

    public void setKeystoreType(String keystoreType) {
        this.keystoreType = keystoreType;
    }

    public void setTruststoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    private String getKeystoreType() {
        String kStoreType = this.keystoreType;
        if (kStoreType == null) {
            kStoreType = System.getProperty("javax.net.ssl.keyStoreType");
        }
        if (kStoreType == null) {
            kStoreType = "JKS";
        }
        return kStoreType;
    }

    private String getTruststoreType() {
        String tStoreType = this.trustStoreType;
        if (tStoreType == null) {
            tStoreType = System.getProperty("javax.net.ssl.trustStoreType");
        }
        if (tStoreType == null) {
            tStoreType = "JKS";
        }
        return tStoreType;
    }

    public void setKeyPass(String keyPass) {
        if (keyPass == null) {
            String k = System.getProperty("javax.net.ssl.keyPassword");
            if (k != null) {
                this.keyPass = k.toCharArray();
            }
        } else {
            this.keyPass = keyPass.toCharArray();
        }
    }

    public void createHttpClient() {
        this.createHttpClient(this.getDefaultHttpClientBuilder());
    }

    public void createHttpClient(HttpClientBuilder builder) {
        if (this.httpClient == null) {
            if (builder == null) {
                builder = this.getDefaultHttpClientBuilder();
            }
            this.httpClient = builder.setDefaultRequestConfig(this.requestConfigBuilder.build()).build();
        }
    }

    public HttpClientBuilder getDefaultHttpClientBuilder() {
        HttpClientBuilder builder = HttpClientBuilder.create();
        if (this.httpRequestRetryHandler != null) {
            builder.setRetryHandler(this.httpRequestRetryHandler);
        } else {
            builder.setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
        }
        if (this.credentialsProvider != null) {
            builder.setDefaultCredentialsProvider(this.credentialsProvider);
        }
        if (this.sslContext != null) {
            builder.setSSLContext(this.sslContext);
        }
        if (this.hostnameVerifier != null) {
            builder.setSSLHostnameVerifier(this.hostnameVerifier);
        }
        return builder;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void closeHttpClient() {
        try {
            if (this.httpClient != null) {
                this.httpClient.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.httpClient = null;
        }
    }

    public void forcedClosingHttpClient() {
        try {
            if (this.httpClient != null) {
                this.forcedClosingHttpClient = true;
                this.httpClient.close();
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.httpClient = null;
        }
    }

    public boolean isForcedClosingHttpClient() {
        return this.forcedClosingHttpClient;
    }

    public boolean isAutoCloseHttpClient() {
        return this.autoCloseHttpClient;
    }

    public void setAutoCloseHttpClient(boolean autoCloseHttpClient) {
        this.autoCloseHttpClient = autoCloseHttpClient;
    }

    public void setSSLContext() throws SOSSSLException {
        if (this.keyStore != null || this.trustStore != null) {
            try {
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                if (this.keyStore != null) {
                    sslContextBuilder.loadKeyMaterial(this.keyStore, this.keyPass);
                }
                if (this.trustStore != null) {
                    sslContextBuilder.loadTrustMaterial(this.trustStore, null);
                }
                this.sslContext = sslContextBuilder.build();
            }
            catch (GeneralSecurityException e) {
                throw new SOSSSLException((Throwable)e);
            }
        }
    }

    public void setSSLContext(KeyStore keyStore, char[] clientCertificatePass, KeyStore truststore) throws SOSSSLException {
        this.setKeystore(keyStore, clientCertificatePass);
        this.setTruststore(truststore);
        this.setSSLContext();
    }

    public void setSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public String executeRestServiceCommand(String restCommand, String urlParam) throws SOSException, SocketException {
        URL url;
        String s = urlParam.replaceFirst("^([^:]*)://.*$", "$1");
        if (s.equals(urlParam)) {
            urlParam = "http://" + urlParam;
        }
        try {
            url = new URL(urlParam);
        }
        catch (Exception e) {
            throw new SOSException((Throwable)e);
        }
        return this.executeRestServiceCommand(restCommand, url);
    }

    public String executeRestServiceCommand(String restCommand, URL url) throws SOSException, SocketException {
        return this.executeRestServiceCommand(restCommand, url, null);
    }

    private static String getParameter(String p) {
        String[] pParts = p.replaceFirst("\\)\\s*$", "").split("\\(", 2);
        String s = pParts.length == 2 ? pParts[1] : "";
        return s.trim();
    }

    public String executeRestServiceCommand(String restCommand, URI uri) throws SOSException, SocketException {
        return this.executeRestServiceCommand(restCommand, uri, null);
    }

    public String executeRestServiceCommand(String restCommand, URL url, String body) throws SOSException, SocketException {
        String result = "";
        if (body == null) {
            body = JobSchedulerRestApiClient.getParameter(restCommand);
        }
        String path = url.getPath();
        String query = url.getQuery();
        if (query != null && !query.isEmpty()) {
            path = path + "?" + query;
        }
        HttpHost httpHost = new HttpHost(url.getHost(), url.getPort(), url.getProtocol());
        if (restCommand.toLowerCase().startsWith("post")) {
            result = this.postRestService(httpHost, path, body);
        } else if ("get".equalsIgnoreCase(restCommand)) {
            result = this.getRestService(httpHost, path);
        } else if ("delete".equalsIgnoreCase(restCommand)) {
            result = this.deleteRestService(restCommand, url);
        } else if (restCommand.toLowerCase().startsWith("put")) {
            result = this.putRestService(httpHost, path, body);
        } else {
            throw new SOSException(String.format("Unknown rest command method: %s (usage: get|post(body)|delete|put(body))", restCommand));
        }
        return result;
    }

    public String executeRestServiceCommand(String restCommand, URI uri, String body) throws SOSException, SocketException {
        String result = "";
        if (body == null) {
            body = JobSchedulerRestApiClient.getParameter(restCommand);
        }
        if (restCommand.toLowerCase().startsWith("post")) {
            result = this.postRestService(uri, body);
        } else if ("get".equalsIgnoreCase(restCommand)) {
            result = this.getRestService(uri);
        } else if ("delete".equalsIgnoreCase(restCommand)) {
            result = this.deleteRestService(restCommand, uri);
        } else if (restCommand.toLowerCase().startsWith("put")) {
            result = this.putRestService(uri, body);
        } else {
            throw new SOSException(String.format("Unknown rest command method: %s (usage: get|post(body)|delete|put(body))", restCommand));
        }
        return result;
    }

    public String executeRestService(String urlParam) throws SOSException, SocketException {
        return this.executeRestServiceCommand("get", urlParam);
    }

    public void addHeader(String header, String value) {
        this.headers.put(header, value);
    }

    public String deleteRestService(String command, URL url) throws SOSException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)url.openConnection();
            connection.setRequestMethod(command.toUpperCase());
            try {
                String string = String.valueOf(connection.getResponseCode());
                return string;
            }
            catch (Exception e) {
                try {
                    throw new SOSNoResponseException(url.toString(), (Throwable)e);
                }
                catch (SOSNoResponseException e2) {
                    throw e2;
                }
                catch (Exception e3) {
                    throw new SOSConnectionRefusedException(url.toString(), (Throwable)e3);
                }
            }
        }
        finally {
            try {
                connection.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    public String deleteRestService(String command, URI uri) throws SOSException {
        try {
            return this.deleteRestService(command, uri.toURL());
        }
        catch (SOSException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SOSException((Throwable)e);
        }
    }

    public String deleteRestService(URI uri) throws SOSException {
        return this.getStringResponse((HttpUriRequest)new HttpDelete(uri));
    }

    public String getRestService(HttpHost target, String path) throws SOSException, SocketException {
        return this.getStringResponse(target, (HttpRequest)new HttpGet(path));
    }

    public String getRestService(URI uri) throws SOSException, SocketException {
        return this.getStringResponse((HttpUriRequest)new HttpGet(uri));
    }

    public byte[] getByteArrayByRestService(URI uri) throws SOSException, SocketException {
        return this.getByteArrayResponse((HttpUriRequest)new HttpGet(uri));
    }

    public Path getFilePathByRestService(URI uri, String prefix, boolean withGzipEncoding) throws SOSException, SocketException {
        return this.getFilePathResponse((HttpUriRequest)new HttpGet(uri), prefix, withGzipEncoding);
    }

    public String postRestService(HttpHost target, String path, String body) throws SOSException {
        HttpPost requestPost = new HttpPost(path);
        try {
            if (body != null && !body.isEmpty()) {
                StringEntity entity = new StringEntity(body, StandardCharsets.UTF_8);
                requestPost.setEntity((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            throw new SOSBadRequestException(body, (Throwable)e);
        }
        return this.getStringResponse(target, (HttpRequest)requestPost);
    }

    public String postRestService(URI uri, String body) throws SOSException {
        HttpPost requestPost = new HttpPost(uri);
        try {
            if (body != null && !body.isEmpty()) {
                StringEntity entity = new StringEntity(body, StandardCharsets.UTF_8);
                requestPost.setEntity((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            throw new SOSBadRequestException(body, (Throwable)e);
        }
        return this.getStringResponse((HttpUriRequest)requestPost);
    }

    public String putRestService(HttpHost target, String path, String body) throws SOSException, SocketException {
        HttpPut requestPut = new HttpPut(path);
        try {
            if (body != null && !body.isEmpty()) {
                StringEntity entity = new StringEntity(body, StandardCharsets.UTF_8);
                requestPut.setEntity((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            throw new SOSBadRequestException(body, (Throwable)e);
        }
        return this.getStringResponse(target, (HttpRequest)requestPut);
    }

    public String putRestService(URI uri, String body) throws SOSException, SocketException {
        HttpPut requestPut = new HttpPut(uri);
        try {
            if (body != null && !body.isEmpty()) {
                StringEntity entity = new StringEntity(body, StandardCharsets.UTF_8);
                requestPut.setEntity((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            throw new SOSBadRequestException(body, (Throwable)e);
        }
        return this.getStringResponse((HttpUriRequest)requestPut);
    }

    public String putByteArrayRestService(URI uri, byte[] body) throws SOSException {
        HttpPut requestPut = new HttpPut(uri);
        try {
            if (body != null) {
                ByteArrayEntity entity = new ByteArrayEntity(body);
                requestPut.setEntity((HttpEntity)entity);
            }
        }
        catch (Exception e) {
            throw new SOSBadRequestException((Throwable)e);
        }
        return this.getStringResponse((HttpUriRequest)requestPut);
    }

    private String getStringResponse(HttpHost target, HttpRequest request) throws SOSException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders(request);
        try {
            this.httpResponse = this.httpClient.execute(target, request);
            return this.getResponse();
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
        catch (ClientProtocolException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (SocketTimeoutException e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((Throwable)e);
        }
        catch (HttpHostConnectException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (SocketException e) {
            this.closeHttpClient();
            if ("connection reset".equalsIgnoreCase(e.getMessage())) {
                throw new SOSConnectionResetException((Throwable)e);
            }
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
    }

    private String getStringResponse(HttpUriRequest request) throws SOSException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders((HttpRequest)request);
        try {
            this.httpResponse = this.httpClient.execute(request);
            return this.getResponse();
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
        catch (ClientProtocolException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (SocketTimeoutException e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((Throwable)e);
        }
        catch (HttpHostConnectException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (SocketException e) {
            this.closeHttpClient();
            if ("connection reset".equalsIgnoreCase(e.getMessage())) {
                throw new SOSConnectionResetException((Throwable)e);
            }
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
    }

    private byte[] getByteArrayResponse(HttpUriRequest request) throws SOSException, SocketException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders((HttpRequest)request);
        try {
            this.httpResponse = this.httpClient.execute(request);
            return this.getByteArrayResponse();
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
        catch (ClientProtocolException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (SocketTimeoutException e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((Throwable)e);
        }
        catch (HttpHostConnectException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (SocketException e) {
            this.closeHttpClient();
            if ("connection reset".equalsIgnoreCase(e.getMessage())) {
                throw new SOSConnectionResetException((Throwable)e);
            }
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
    }

    private Path getFilePathResponse(HttpUriRequest request, String prefix, boolean withGzipEncoding) throws SOSException, SocketException {
        this.httpResponse = null;
        this.createHttpClient();
        this.setHttpRequestHeaders((HttpRequest)request);
        try {
            this.httpResponse = this.httpClient.execute(request);
            return this.getFilePathResponse(prefix, withGzipEncoding);
        }
        catch (SOSException e) {
            this.closeHttpClient();
            throw e;
        }
        catch (ClientProtocolException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (SocketTimeoutException e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((Throwable)e);
        }
        catch (HttpHostConnectException e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (SocketException e) {
            this.closeHttpClient();
            if ("connection reset".equalsIgnoreCase(e.getMessage())) {
                throw new SOSConnectionResetException((Throwable)e);
            }
            throw new SOSConnectionRefusedException((Throwable)e);
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSConnectionRefusedException((Throwable)e);
        }
    }

    private String getResponse() throws SOSNoResponseException {
        try {
            String s = "";
            this.setHttpResponseHeaders();
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity != null) {
                s = EntityUtils.toString((HttpEntity)entity, (Charset)StandardCharsets.UTF_8);
            }
            if (this.isAutoCloseHttpClient()) {
                this.closeHttpClient();
            }
            return s;
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((Throwable)e);
        }
    }

    private byte[] getByteArrayResponse() throws SOSNoResponseException {
        try {
            byte[] is = null;
            this.setHttpResponseHeaders();
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity != null) {
                is = EntityUtils.toByteArray((HttpEntity)entity);
            }
            if (this.isAutoCloseHttpClient()) {
                this.closeHttpClient();
            }
            return is;
        }
        catch (Exception e) {
            this.closeHttpClient();
            throw new SOSNoResponseException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Path getFilePathResponse(String prefix, boolean withGzipEncoding) throws SOSNoResponseException {
        Path path = null;
        try {
            this.setHttpResponseHeaders();
            HttpEntity entity = this.httpResponse.getEntity();
            if (entity != null) {
                InputStream instream = entity.getContent();
                OutputStream out = null;
                if (instream != null) {
                    try {
                        int length;
                        if (prefix == null) {
                            prefix = "sos-download-";
                        }
                        path = Files.createTempFile(prefix, null, new FileAttribute[0]);
                        out = withGzipEncoding ? new GZIPOutputStream(Files.newOutputStream(path, new OpenOption[0])) : Files.newOutputStream(path, new OpenOption[0]);
                        byte[] buffer = new byte[4096];
                        while ((length = instream.read(buffer)) > 0) {
                            out.write(buffer, 0, length);
                        }
                        out.flush();
                    }
                    finally {
                        try {
                            instream.close();
                            instream = null;
                        }
                        catch (Exception exception) {}
                        try {
                            if (out != null) {
                                out.close();
                            }
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            if (this.isAutoCloseHttpClient()) {
                this.closeHttpClient();
            }
            return path;
        }
        catch (Exception e) {
            throw new SOSNoResponseException((Throwable)e);
        }
        finally {
            if (path != null) {
                try {
                    Files.deleteIfExists(path);
                }
                catch (IOException iOException) {}
            }
            this.closeHttpClient();
        }
    }

    private void setHttpRequestHeaders(HttpRequest request) {
        request.setHeader("Accept", this.accept);
        if (this.basicAuthorization != null && !this.basicAuthorization.isEmpty()) {
            request.setHeader("Authorization", "Basic " + this.basicAuthorization);
        }
        for (Map.Entry<String, String> entry : this.headers.entrySet()) {
            request.setHeader(entry.getKey(), entry.getValue());
        }
    }

    private void setHttpResponseHeaders() {
        if (this.httpResponse != null) {
            Header[] headers;
            for (Header header : headers = this.httpResponse.getAllHeaders()) {
                this.responseHeaders.put(header.getName(), header.getValue());
            }
        }
    }

    public void addAuthorizationHeader(String user, String password) {
        String s = user + ":" + password;
        byte[] authEncBytes = Base64.encodeBase64((byte[])s.getBytes());
        String authStringEnc = new String(authEncBytes);
        this.addHeader("Authorization", "Basic " + authStringEnc);
    }

    public String addAuthorizationHeader(String jocAccount) throws SOSException {
        if (jocAccount == null) {
            throw new SOSException("There is no valid joc account");
        }
        String user = "";
        String password = "";
        String[] s = jocAccount.split(":");
        if (s.length > 0) {
            user = s[0];
        }
        if (s.length > 1) {
            for (int i = 1; i < s.length; ++i) {
                password = password + ":" + s[i];
            }
            password = password.substring(1);
        }
        this.addAuthorizationHeader(user, password);
        return user;
    }

    public void setKeyStore() throws SOSMissingDataException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.keyStore = this.readKeyStore();
    }

    public void setKeystore(KeyStore keyStore, char[] clientCertificatePass) {
        this.keyStore = keyStore;
    }

    public void setKeyStore(String keystorePath, String keyPass, String keystoreType, String keystorePass) throws SOSMissingDataException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.setKeystorePath(keystorePath);
        this.setKeyPass(keyPass);
        this.setKeystoreType(keystoreType);
        this.setKeystorePass(keystorePass);
        this.keyStore = this.readKeyStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore readKeyStore() throws SOSMissingDataException, IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        InputStream keyStoreStream = null;
        try {
            Path kp = this.getKeystorePath();
            if (kp != null) {
                keyStoreStream = Files.newInputStream(this.getKeystorePath(), new OpenOption[0]);
                KeyStore keyStore = KeyStore.getInstance(this.getKeystoreType());
                keyStore.load(keyStoreStream, this.getKeystorePass());
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (keyStoreStream != null) {
                try {
                    keyStoreStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore readTrustStore() throws SOSMissingDataException, IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        InputStream trustStoreStream = null;
        try {
            Path tp = this.getTruststorePath();
            if (tp != null) {
                trustStoreStream = Files.newInputStream(tp, new OpenOption[0]);
                KeyStore trustStore = KeyStore.getInstance(this.getTruststoreType());
                trustStore.load(trustStoreStream, this.getTruststorePass());
                KeyStore keyStore = trustStore;
                return keyStore;
            }
            KeyStore keyStore = null;
            return keyStore;
        }
        finally {
            if (trustStoreStream != null) {
                try {
                    trustStoreStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void setKeyStore(String keyStorePath) throws SOSMissingDataException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (keyStorePath != null && !keyStorePath.isEmpty()) {
            this.setKeystorePath(keyStorePath);
            this.keyStore = this.readKeyStore();
        }
    }

    public void setTrustStore() throws SOSMissingDataException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        this.trustStore = this.readTrustStore();
    }

    public void setTrustStore(String trustStorePath) throws SOSMissingDataException, KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        if (trustStorePath != null && !trustStorePath.isEmpty()) {
            this.setTrustStorePath(trustStorePath);
            this.trustStore = this.readTrustStore();
        }
    }

    public void setTruststore(KeyStore trustStore) {
        this.trustStore = trustStore;
    }

    public String getRestService(URI masterAgentApiUrl, int socketTimeout, int connectionTimeout) throws SOSException, IOException {
        return this.getRestService(masterAgentApiUrl.toURL(), socketTimeout, connectionTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getRestService(URL masterAgentApiUrl, int socketTimeout, int connectionTimeout) throws IOException, SOSBadRequestException {
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)masterAgentApiUrl.openConnection();
            connection.setRequestMethod("GET");
            if (this.basicAuthorization != null && !this.basicAuthorization.isEmpty()) {
                connection.setRequestProperty("Authorization", "Basic " + this.basicAuthorization);
            }
            connection.setRequestProperty("Accept", "application/json");
            connection.setUseCaches(false);
            connection.setDoOutput(true);
            connection.setConnectTimeout(connectionTimeout);
            connection.setReadTimeout(socketTimeout);
            int responseCode = connection.getResponseCode();
            String response = null;
            if (responseCode == 200) {
                response = IOUtils.toString((InputStream)connection.getInputStream(), (Charset)Charsets.UTF_8);
            } else if (responseCode == 400) {
                response = IOUtils.toString((InputStream)connection.getErrorStream(), (Charset)Charsets.UTF_8);
            } else {
                throw new SOSBadRequestException("ResponseCode: " + responseCode + " " + connection.getResponseMessage());
            }
            String string = response;
            return string;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    public HttpURLConnection getHttpURLConnection(URL masterAgentApiUrl, int socketTimeout, int connectionTimeout) throws IOException, SOSBadRequestException {
        HttpURLConnection connection = (HttpURLConnection)masterAgentApiUrl.openConnection();
        connection.setRequestMethod("GET");
        if (this.basicAuthorization != null && !this.basicAuthorization.isEmpty()) {
            connection.setRequestProperty("Authorization", "Basic " + this.basicAuthorization);
        }
        connection.setRequestProperty("Accept", "application/json");
        connection.setUseCaches(false);
        connection.setDoOutput(true);
        connection.setConnectTimeout(connectionTimeout);
        connection.setReadTimeout(socketTimeout);
        return connection;
    }
}

