/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.schedulerhistory.db;

import com.sos.hibernate.classes.DbItem;
import com.sos.jitl.schedulerhistory.classes.SOSStreamUnzip;
import java.io.IOException;
import java.nio.file.Path;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import javax.persistence.Transient;

@MappedSuperclass
public class SchedulerHistoryLogDBItem
extends DbItem {
    private byte[] log;

    @Lob
    @Column(name="[LOG]", nullable=true)
    public byte[] getLog() {
        return this.log;
    }

    @Column(name="[LOG]", nullable=true)
    public void setLog(byte[] log) {
        this.log = log;
    }

    @Transient
    public String getLogAsString() throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.unzip2String(this.log);
    }

    @Transient
    public byte[] getLogAsByteArray() throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.unzip(this.log);
    }

    @Transient
    public Path writeLogFile(String prefix) throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.unzipToFile(this.log, prefix);
    }

    @Transient
    public Path writeGzipLogFile(String prefix) throws IOException {
        if (this.log == null) {
            return null;
        }
        return SOSStreamUnzip.zippedToFile(this.log, prefix);
    }

    @Transient
    public long getSize() throws IOException {
        if (this.log == null) {
            return 0L;
        }
        return SOSStreamUnzip.getSize(this.log);
    }
}

