/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.sync;

import com.sos.jitl.sync.SyncNodeWaitingOrder;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyncNode {
    private String syncNodeJobchainName;
    private String syncNodeJobchainPath;
    private String syncNodeState;
    private int required = 1;
    private List<SyncNodeWaitingOrder> listOfSyncNodeWaitingOrder = new ArrayList<SyncNodeWaitingOrder>();
    private static final Logger LOGGER = LoggerFactory.getLogger(SyncNode.class);

    public void addOrder(SyncNodeWaitingOrder so) {
        if (this.listOfSyncNodeWaitingOrder == null) {
            this.listOfSyncNodeWaitingOrder = new ArrayList<SyncNodeWaitingOrder>();
        }
        this.listOfSyncNodeWaitingOrder.add(so);
    }

    public String getSyncNodeJobchain() {
        return this.syncNodeJobchainName;
    }

    public String getSyncNodeState() {
        return this.syncNodeState;
    }

    public void setSyncNodeState(String syncNodeState) {
        this.syncNodeState = syncNodeState;
    }

    public int getRequired() {
        return this.required;
    }

    public void setRequired(int required) {
        LOGGER.debug(String.format("%s: required orders=%s", this.syncNodeJobchainName, required));
        this.required = required;
    }

    public void setRequired(String required) {
        try {
            LOGGER.debug(String.format("%s: required orders=%s", this.syncNodeJobchainName, required));
            this.required = Integer.parseInt(required);
        }
        catch (NumberFormatException e) {
            LOGGER.warn(String.format("could not convert %s", required));
        }
    }

    public List<SyncNodeWaitingOrder> getSyncNodeWaitingOrderList() {
        return this.listOfSyncNodeWaitingOrder;
    }

    public void setSyncNodeWaitingOrderList(List<SyncNodeWaitingOrder> syncNodeWaitingOrderList) {
        this.listOfSyncNodeWaitingOrder = syncNodeWaitingOrderList;
    }

    public boolean isReleased() {
        boolean erg = this.listOfSyncNodeWaitingOrder.size() >= this.required;
        LOGGER.debug(String.format("Jobchain: %s, State: %s,  required: %s, waiting: %s ----> %s", this.syncNodeJobchainPath, this.syncNodeState, this.required, this.listOfSyncNodeWaitingOrder.size(), erg));
        return this.listOfSyncNodeWaitingOrder.size() >= this.required;
    }

    public boolean isReleased(String syncId) {
        return this.listOfSyncNodeWaitingOrder.size() >= this.required;
    }

    public void setSyncNodeJobchainName(String syncNodeJobchainName) {
        this.syncNodeJobchainName = syncNodeJobchainName;
    }

    public String getSyncNodeJobchainPath() {
        return this.syncNodeJobchainPath;
    }

    public void setSyncNodeJobchainPath(String syncNodeJobchainPath) {
        this.syncNodeJobchainPath = syncNodeJobchainPath;
    }

    public String getSyncNodeJobchainName() {
        return this.syncNodeJobchainName;
    }
}

