/*
 * Decompiled with CFR 0.152.
 */
package com.sos.jitl.sync;

import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import sos.xml.SOSXMLXPath;

public class SyncXmlReader {
    private final String xml;
    private final String xPathExpression;
    private NodeList nodes;
    private int index;
    private SOSXMLXPath xPath;
    private Node lastNode;

    public SyncXmlReader(String xml, String xPathExpression) throws Exception {
        this.xml = xml;
        this.xPathExpression = xPathExpression;
        this.getNodes();
    }

    private void getNodes() throws Exception {
        this.xPath = new SOSXMLXPath(new StringBuffer(this.xml));
        this.nodes = this.xPath.selectNodeList(this.xPathExpression);
        this.index = 0;
    }

    public boolean eof() {
        return this.index >= this.nodes.getLength();
    }

    public void getNext() {
        this.lastNode = this.nodes.item(this.index);
        ++this.index;
    }

    public String getAttributeValue(String attribute) {
        String strR = "";
        if (this.lastNode != null) {
            Node objN = this.lastNode.getAttributes().getNamedItem(attribute);
            if (objN != null) {
                strR = objN.getNodeValue();
            }
            return strR;
        }
        return strR;
    }

    public String getAttributeValueFromParent(String attribute) {
        if (this.lastNode != null) {
            return this.lastNode.getParentNode().getAttributes().getNamedItem(attribute).getNodeValue();
        }
        return null;
    }

    public Node getNode(String xpression) throws Exception {
        return this.xPath.selectSingleNode(xpression);
    }

    public String getAttributeValueFromXpath(String xPath, String attribute) throws Exception {
        Node n = this.getNode(xPath);
        if (n == null) {
            return "";
        }
        return n.getAttributes().getNamedItem(attribute).getNodeValue();
    }
}

