/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.file;

import java.io.File;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDescriptor {
    private final String conClassName = this.getClass().getSimpleName();
    private static final String conSVNVersion = "$Id$";
    private final Logger logger = LoggerFactory.getLogger(FileDescriptor.class);
    private long lastModificationDate;
    private long lastFileLength;
    private String FileName;
    private boolean flgIsSteady;

    public FileDescriptor() {
    }

    public FileDescriptor(File objFile) {
        this();
        this.setLastFileLength(objFile.length());
        this.setLastModificationDate(objFile.lastModified());
        this.setFileName(objFile.getAbsolutePath());
    }

    public FileDescriptor(long lastModificationDate, long lastFileLength, String fileName, boolean flgIsSteady) {
        this.lastModificationDate = lastModificationDate;
        this.lastFileLength = lastFileLength;
        this.FileName = fileName;
        this.flgIsSteady = flgIsSteady;
    }

    public File getFile() {
        File objActFile = new File(this.getFileName());
        this.logger.debug("result is : " + objActFile.lastModified() + ", " + this.getLastModificationDate() + ", " + objActFile.length() + ", " + this.getLastFileLength());
        return objActFile;
    }

    public boolean isSteady() {
        boolean isSteady = true;
        File objActFile = this.getFile();
        if (objActFile.lastModified() != this.getLastModificationDate() || objActFile.length() != this.getLastFileLength()) {
            this.setLastModificationDate(objActFile.lastModified());
            this.setLastFileLength(objActFile.length());
            this.setFlgIsSteady(false);
            isSteady = false;
            this.logger.info(String.format("File '%1$s' changed during checking steady state", objActFile.getAbsolutePath()));
        } else {
            this.setFlgIsSteady(true);
        }
        return isSteady;
    }

    public long getLastModificationDate() {
        return this.lastModificationDate;
    }

    public void setLastModificationDate(long lastModificationDate) {
        this.lastModificationDate = lastModificationDate;
    }

    public long getLastFileLength() {
        return this.lastFileLength;
    }

    public void setLastFileLength(long lastFileLength) {
        this.lastFileLength = lastFileLength;
    }

    public String getFileName() {
        return this.FileName;
    }

    public void setFileName(String fileName) {
        this.FileName = fileName;
    }

    public boolean isFlgIsSteady() {
        return this.flgIsSteady;
    }

    public void setFlgIsSteady(boolean flgIsSteady) {
        this.flgIsSteady = flgIsSteady;
    }
}

