/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.file;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SOSXMLHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SOSXMLHelper.class);
    private int intIndent = 0;
    private String fleXMLFileName = "";
    private String fleXSLTFileName = "";
    private String strXMLDirective = "?xml version='1.0' encoding='ISO-8859-1' ?";
    private String strXSLDirective = "?xml-stylesheet href='$FileName$' type='text/sos.scheduler.xsl' ?";
    private PrintWriter fleOut = null;
    private long lngNoOfLinesWritten = 0L;

    public SOSXMLHelper() {
    }

    public SOSXMLHelper(String pstrXMLFileName) {
        this.fleXMLFileName = pstrXMLFileName;
        LOGGER.debug(this.fleXMLFileName);
        this.fleXSLTFileName = "http://be-list-viewer.eu.schering.net/systems/sos.scheduler.xsl/SOSFolderTree.xsl";
    }

    public SOSXMLHelper(String pstrXMLFileName, String pstrXSLTFileName) {
        this.fleXMLFileName = pstrXMLFileName;
        LOGGER.debug("XML-File Name: " + this.fleXMLFileName);
        this.fleXSLTFileName = pstrXSLTFileName;
        LOGGER.debug("XSLT-File Name: " + this.fleXSLTFileName);
    }

    public void XMLTagV(String strTagName, String strTagValue) throws Exception {
        this.Out(this.getStartTag(strTagName) + strTagValue + this.getEndTag(strTagName));
    }

    public long NoOfLinesWritten() {
        return this.lngNoOfLinesWritten;
    }

    public void XMLTagV(String strTagName, int intTagValue) throws Exception {
        this.XMLTagV(strTagName, String.valueOf(intTagValue));
    }

    public void XMLTagV(String strTagName, long lngTagValue) throws Exception {
        this.XMLTagV(strTagName, String.valueOf(lngTagValue));
    }

    public void XMLTag(String strTagName) throws Exception {
        this.Out(this.getStartTag(strTagName));
        ++this.intIndent;
    }

    public void XMLTagE(String strTagName) throws Exception {
        --this.intIndent;
        this.Out(this.getEndTag(strTagName));
    }

    public String getStartTag(String strTagName) {
        return "<" + strTagName + ">";
    }

    public String getEndTag(String strTagName) {
        return "</" + strTagName + ">";
    }

    public void Out(String strBuffer) throws IOException, Exception {
        if (this.fleOut == null) {
            if (this.fleXMLFileName.isEmpty()) {
                throw new Exception("no output-file-name given");
            }
            File fl = new File(this.fleXMLFileName);
            fl.createNewFile();
            this.fleOut = new PrintWriter(new FileWriter(fl));
            this.fleOut.println(this.getStartTag(this.strXMLDirective));
            if (this.fleXSLTFileName.isEmpty()) {
                String strT = this.strXSLDirective.replaceAll("\\$FileName\\$", this.fleXSLTFileName);
                this.fleOut.println(this.getStartTag(strT));
            }
        }
        if (this.fleOut == null) {
            throw new Exception("no output-file specfied");
        }
        for (int i = 0; i < this.intIndent; ++i) {
            this.fleOut.print(" ");
        }
        this.fleOut.println(strBuffer);
        ++this.lngNoOfLinesWritten;
    }

    public int getIndent() {
        return this.intIndent;
    }

    public void setXMLFileName(String pfleXMLFileName) throws IOException {
        this.fleXMLFileName = pfleXMLFileName;
    }

    public void close() {
        if (this.fleOut != null) {
            this.fleOut.close();
            this.fleOut = null;
        }
    }
}

