/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.job;

import com.sos.hibernate.classes.SOSHibernateFactory;
import com.sos.hibernate.classes.SOSHibernateSession;
import com.sos.hibernate.classes.UtcTimeHelper;
import com.sos.jitl.eventing.db.SchedulerEventDBItem;
import com.sos.jitl.eventing.db.SchedulerEventDBLayer;
import com.sos.jitl.eventing.db.SchedulerEventFilter;
import com.sos.jitl.eventing.eventhandler.EventCommandsExecuter;
import com.sos.jitl.eventing.eventhandler.XmlEventHandler;
import com.sos.jitl.eventing.eventhandler.XsltEventHandler;
import com.sos.jitl.reporting.db.DBLayer;
import com.sos.jitl.reporting.helper.ReportUtil;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Vector;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.command.SOSSchedulerCommand;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Spooler;
import sos.spooler.Variable_set;

public class JobSchedulerEventJob
extends JobSchedulerJobAdapter {
    private static final String DEFAULT_EXPIRATION_PERIOD = "24:00";
    private static final String EXPIRATION_CYCLE_DATE_FORMAT = "HH:mm:ss";
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerEventJob.class);
    private static final String EXPIRES_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private String confFile;
    private SchedulerEventDBLayer schedulerEventDBLayer;
    private SchedulerEventFilter filter;
    private String eventAction = "";
    private String eventHandlerFilepath = "";
    private String eventHandlerFilespec = "";
    private Variable_set parameters = null;
    private Collection<Object> eventHandlerResultedCommands = new Vector<Object>();
    private int socketTimeout = 5;
    private List<SchedulerEventDBItem> listOfEvents;
    private int httpPort;

    public boolean spooler_init() {
        try {
            this.httpPort = SOSSchedulerCommand.getHTTPPortFromScheduler((Spooler)this.spooler);
        }
        catch (Exception e) {
            LOGGER.debug("could not read http port from scheduler.xml");
        }
        boolean rc = super.spooler_init();
        this.confFile = "";
        if (this.spooler_task.params() != null) {
            this.confFile = this.spooler_task.params().value("configuration_file");
        }
        if (this.spooler_job.order_queue() != null) {
            this.confFile = this.spooler_task.order().params().value("configuration_file");
        }
        if (this.confFile != null && !this.confFile.isEmpty()) {
            LOGGER.debug("configuration_file from param");
        } else {
            LOGGER.debug("configuration_file from scheduler");
            this.confFile = this.getHibernateConfigurationReporting().toFile().getAbsolutePath();
        }
        return rc;
    }

    public boolean spooler_process() throws Exception {
        super.spooler_process();
        this.filter = new SchedulerEventFilter();
        boolean rc = true;
        try {
            this.parameters = this.spooler.create_variable_set();
            HashSet<String> jobParameterNames = new HashSet<String>();
            try {
                String timeZone;
                if (this.spooler_task.params() != null) {
                    this.parameters.merge(this.spooler_task.params());
                }
                if (this.spooler_job.order_queue() != null) {
                    this.parameters.merge(this.spooler_task.order().params());
                }
                if (this.parameters.value("socket_timeout") != null && !this.parameters.value("socket_timeout").isEmpty()) {
                    this.setSockettimeout(this.parameters.value("socket_timeout"));
                    LOGGER.debug(".. parameter [socket_timeout]: " + this.parameters.value("socket_timeout"));
                } else {
                    this.setSockettimeout("5");
                }
                if (this.parameters.value("action") != null && !this.parameters.value("action").isEmpty()) {
                    this.setEventAction(this.parameters.value("action"));
                    LOGGER.debug(".. parameter [action]: " + this.parameters.value("action"));
                } else {
                    this.setEventAction("add");
                }
                jobParameterNames.add("action");
                if (this.parameters.value("scheduler_id") != null && !this.parameters.value("scheduler_id").isEmpty()) {
                    this.filter.setSchedulerId(this.parameters.value("scheduler_id"));
                    LOGGER.debug(".. parameter [scheduler_id]: " + this.parameters.value("scheduler_id"));
                } else if ("add".equalsIgnoreCase(this.eventAction)) {
                    this.filter.setSchedulerId(this.spooler.id());
                }
                jobParameterNames.add("scheduler_id");
                if (this.parameters.value("spooler_id") != null && !this.parameters.value("spooler_id").isEmpty()) {
                    this.filter.setSchedulerId(this.parameters.value("spooler_id"));
                    LOGGER.debug(".. parameter [spooler_id]: " + this.parameters.value("spooler_id"));
                }
                jobParameterNames.add("spooler_id");
                if (this.parameters.value("remote_scheduler_host") != null && !this.parameters.value("remote_scheduler_host").isEmpty()) {
                    this.filter.setRemoteSchedulerHost(this.parameters.value("remote_scheduler_host"));
                    LOGGER.debug(".. parameter [remote_scheduler_host]: " + this.parameters.value("remote_scheduler_host"));
                }
                jobParameterNames.add("remote_scheduler_host");
                if (this.parameters.value("remote_scheduler_port") != null && !this.parameters.value("remote_scheduler_port").isEmpty()) {
                    this.filter.setRemoteSchedulerPort(this.parameters.value("remote_scheduler_port"));
                    LOGGER.debug(".. parameter [remote_scheduler_port]: " + this.parameters.value("remote_scheduler_port"));
                }
                jobParameterNames.add("remote_scheduler_port");
                if (this.parameters.value("job_chain") != null && !this.parameters.value("job_chain").isEmpty()) {
                    this.filter.setJobChain(this.parameters.value("job_chain"));
                    LOGGER.debug(".. parameter [job_chain]: " + this.parameters.value("job_chain"));
                }
                jobParameterNames.add("job_chain");
                if (this.parameters.value("order_id") != null && !this.parameters.value("order_id").isEmpty()) {
                    this.filter.setOrderId(this.parameters.value("order_id"));
                    LOGGER.debug(".. parameter [order_id]: " + this.parameters.value("order_id"));
                }
                jobParameterNames.add("order_id");
                if (this.parameters.value("job_name") != null && !this.parameters.value("job_name").isEmpty()) {
                    this.filter.setJobName(this.parameters.value("job_name"));
                    LOGGER.debug(".. parameter [job_name]: " + this.parameters.value("job_name"));
                }
                jobParameterNames.add("job_name");
                if (this.parameters.value("event_class") != null && !this.parameters.value("event_class").isEmpty()) {
                    this.filter.setEventClass(this.parameters.value("event_class"));
                    LOGGER.debug(".. parameter [event_class]: " + this.parameters.value("event_class"));
                }
                jobParameterNames.add("event_class");
                if (this.parameters.value("event_id") != null && !this.parameters.value("event_id").isEmpty()) {
                    this.filter.setEventId(this.parameters.value("event_id"));
                    LOGGER.debug(".. parameter [event_id]: " + this.parameters.value("event_id"));
                }
                jobParameterNames.add("event_id");
                if (this.parameters.value("exit_code") != null && !this.parameters.value("exit_code").isEmpty()) {
                    this.filter.setExitCode(this.parameters.value("exit_code"));
                    LOGGER.debug(".. parameter [exit_code]: " + this.parameters.value("exit_code"));
                }
                jobParameterNames.add("exit_code");
                if (this.parameters.value("expires") != null && !this.parameters.value("expires").isEmpty()) {
                    String expires = this.parameters.value("expires");
                    if (this.parameters.value("expires_timezone") != null && !this.parameters.value("expires_timezone").isEmpty()) {
                        timeZone = this.parameters.value("expires_timezone");
                        expires = UtcTimeHelper.convertTimeZoneToTimeZone((String)EXPIRES_DATE_FORMAT, (String)timeZone, (String)"UTC", (String)expires);
                    }
                    this.filter.setExpires(expires);
                    LOGGER.debug(".. parameter [expires]: " + this.parameters.value("expires"));
                    LOGGER.debug(".. --> eventExpires:" + this.filter.getExpires());
                }
                jobParameterNames.add("expires");
                if (this.parameters.value("created") != null && !this.parameters.value("created").isEmpty()) {
                    this.filter.setCreated(ReportUtil.getDateFromString(this.parameters.value("created")));
                    LOGGER.debug(".. parameter [created]: " + this.parameters.value("created"));
                }
                jobParameterNames.add("created");
                if (this.parameters.value("expiration_period") != null && !this.parameters.value("expiration_period").isEmpty()) {
                    this.filter.setExpirationPeriod(this.parameters.value("expiration_period"));
                    LOGGER.debug(".. parameter [expiration_period]: " + this.parameters.value("expiration_period"));
                } else {
                    this.filter.setExpirationPeriod(DEFAULT_EXPIRATION_PERIOD);
                }
                jobParameterNames.add("expiration_period");
                if (this.parameters.value("expiration_cycle") != null && !this.parameters.value("expiration_cycle").isEmpty()) {
                    String expirationCycle = this.parameters.value("expiration_cycle") + ":00:00:00";
                    expirationCycle = expirationCycle.substring(0, 8);
                    if (this.parameters.value("expires_timezone") != null && !this.parameters.value("expires_timezone").isEmpty()) {
                        timeZone = this.parameters.value("expires_timezone");
                        expirationCycle = UtcTimeHelper.convertTimeZoneToTimeZone((String)EXPIRATION_CYCLE_DATE_FORMAT, (String)timeZone, (String)"UTC", (String)expirationCycle);
                    }
                    this.filter.setExpirationCycle(expirationCycle);
                    LOGGER.debug(".. parameter [expiration_cycle]: " + this.parameters.value("expiration_cycle"));
                } else {
                    this.filter.setExpirationCycle(this.parameters.value(""));
                }
                jobParameterNames.add("expiration_cycle");
                if (this.parameters.value("event_handler_filepath") != null && !this.parameters.value("event_handler_filepath").isEmpty()) {
                    this.eventHandlerFilepath = this.parameters.value("event_handler_filepath");
                    LOGGER.debug(".. parameter [event_handler_filepath]: " + this.parameters.value("event_handler_filepath"));
                } else {
                    this.eventHandlerFilepath = "./config/events";
                }
                jobParameterNames.add("event_handler_filepath");
                if (this.parameters.value("event_handler_filespec") != null && !this.parameters.value("event_handler_filespec").isEmpty()) {
                    this.eventHandlerFilespec = this.parameters.value("event_handler_filespec");
                    LOGGER.debug(".. parameter [event_handler_filespec]: " + this.parameters.value("event_handler_filespec"));
                } else {
                    this.eventHandlerFilespec = "\\.sos.scheduler.xsl$";
                }
                jobParameterNames.add("event_handler_filespec");
                Element params = DocumentHelper.createElement((String)"params");
                String[] parameterNames = this.parameters.names().split(";");
                for (int i = 0; i < parameterNames.length; ++i) {
                    if (jobParameterNames.contains(parameterNames[i])) continue;
                    params.addElement("param").addAttribute("name", parameterNames[i]).addAttribute("value", this.parameters.value(parameterNames[i]));
                    if (parameterNames[i].contains("password")) {
                        LOGGER.debug("Event parameter [" + parameterNames[i] + "]: *****");
                        continue;
                    }
                    LOGGER.debug("Event parameter [" + parameterNames[i] + "]: " + this.parameters.value(parameterNames[i]));
                }
                if (params.hasContent()) {
                    this.filter.setParametersAsString(params.asXML());
                }
            }
            catch (Exception e) {
                LOGGER.error("error occurred processing parameters: " + e.getMessage());
                throw e;
            }
            SOSHibernateFactory sosHibernateFactory = null;
            SOSHibernateSession session = null;
            try {
                try {
                    sosHibernateFactory = this.getFactory(this.confFile);
                    session = sosHibernateFactory.openStatelessSession();
                    this.schedulerEventDBLayer = new SchedulerEventDBLayer(session);
                }
                catch (Exception e) {
                    LOGGER.error("Could not create session: " + e.getMessage());
                    throw new RuntimeException(e);
                }
                if ("add".equalsIgnoreCase(this.eventAction)) {
                    LOGGER.info("adding event: " + this.filter.getEventClass() + " " + this.filter.getEventId());
                    this.addEvent();
                } else if ("remove".equalsIgnoreCase(this.eventAction)) {
                    LOGGER.info("removing event: " + this.filter.getEventClass() + " " + this.filter.getEventId());
                    this.removeEvent();
                } else {
                    LOGGER.info("processing events");
                }
                this.getSchedulerEvents();
                this.processSchedulerEvents();
            }
            catch (Exception e) {
                LOGGER.error("error occurred processing event: " + e.getMessage());
                throw e;
            }
            finally {
                if (session != null) {
                    session.close();
                }
                if (sosHibernateFactory != null) {
                    sosHibernateFactory.close();
                }
            }
            return this.spooler_job.order_queue() != null ? rc : false;
        }
        catch (Exception e) {
            if (this.filter.getEventId() == null) {
                LOGGER.warn("error occurred processing event handlers" + e.getMessage(), (Throwable)e);
            } else {
                LOGGER.warn("error occurred processing event [" + this.filter.getEventClass() + " " + this.filter.getEventId() + "]: " + e.getMessage(), (Throwable)e);
            }
            return false;
        }
    }

    private void getSchedulerEvents() throws Exception {
        this.removeExpiredEventsFromDatabase();
        try {
            LOGGER.debug("readEventsFromDB");
            if (this.schedulerEventDBLayer != null) {
                this.schedulerEventDBLayer.getSession().beginTransaction();
                SchedulerEventFilter filter = new SchedulerEventFilter();
                filter.setSchedulerId(this.spooler.id());
                filter.setSchedulerIdEmpty(true);
                this.listOfEvents = this.schedulerEventDBLayer.getSchedulerEventList(filter);
                LOGGER.debug(String.format("%s items found in database", this.listOfEvents.size()));
                this.schedulerEventDBLayer.getSession().commit();
            }
        }
        catch (Exception e) {
            LOGGER.error("Failed to read events from database: " + e.getMessage());
            throw e;
        }
    }

    private SOSHibernateFactory getFactory(String confFile) throws Exception {
        SOSHibernateFactory sosHibernateFactory = new SOSHibernateFactory(confFile);
        sosHibernateFactory.addClassMapping(DBLayer.getReportingClassMapping());
        sosHibernateFactory.build();
        return sosHibernateFactory;
    }

    private void processSchedulerEvents() throws Exception {
        this.eventHandlerResultedCommands = new LinkedHashSet<Object>();
        XmlEventHandler xmlEventHandler = new XmlEventHandler(this.eventHandlerResultedCommands, this.listOfEvents, this.eventHandlerFilepath, this.filter.getJobChain(), this.filter.getEventClass());
        xmlEventHandler.getListOfCommands();
        XsltEventHandler xsltEventHandler = new XsltEventHandler(this.eventHandlerResultedCommands, this.schedulerEventDBLayer.getEventsAsXml(this.filter.getSchedulerId(), this.listOfEvents), this.eventHandlerFilepath, this.eventHandlerFilespec, this.filter.getJobName(), this.filter.getJobChain(), this.filter.getEventClass(), this.filter.getExpirationDate());
        xsltEventHandler.getListOfCommands();
        EventCommandsExecuter commandsExecuter = new EventCommandsExecuter(this.eventHandlerResultedCommands, this.listOfEvents, this.spooler.hostname(), this.httpPort, this.socketTimeout);
        commandsExecuter.executeCommands();
        this.addEvents(commandsExecuter.getListOfAddEvents());
        this.removeEvents(commandsExecuter.getListOfRemoveEvents());
    }

    private Date getDefaultExpires() throws Exception {
        SchedulerEventFilter filter = new SchedulerEventFilter();
        filter.setExpirationPeriod(DEFAULT_EXPIRATION_PERIOD);
        filter.setExpirationCycle("");
        return filter.getExpires();
    }

    private void addEvents(List<SchedulerEventDBItem> listOfEvents) throws Exception {
        try {
            this.schedulerEventDBLayer.beginTransaction();
            for (SchedulerEventDBItem item : listOfEvents) {
                SchedulerEventFilter filter = new SchedulerEventFilter();
                filter.setEventClass(item.getEventClass());
                filter.setEventId(item.getEventId());
                filter.setExitCode(item.getExitCode());
                LOGGER.debug("event_id --> " + filter.getEventId());
                if (item.getExpires() == null) {
                    filter.setExpires(this.getDefaultExpires());
                } else {
                    filter.setExpires(item.getExpires());
                }
                this.schedulerEventDBLayer.addEvent(filter);
            }
            this.schedulerEventDBLayer.commit();
            if (listOfEvents.size() > 0) {
                this.spooler.execute_xml(this.schedulerEventDBLayer.getNotifyCommand());
            }
        }
        catch (Exception e) {
            if (this.schedulerEventDBLayer != null) {
                this.schedulerEventDBLayer.rollback();
            }
            LOGGER.error(e.getMessage());
            throw e;
        }
    }

    private void removeEvents(List<SchedulerEventDBItem> listOfEvents) throws Exception {
        try {
            this.schedulerEventDBLayer.beginTransaction();
            for (SchedulerEventDBItem item : listOfEvents) {
                SchedulerEventFilter removeFilter = new SchedulerEventFilter();
                item.setSchedulerId(this.filter.getSchedulerId());
                removeFilter.setEventClass(item.getEventClass());
                removeFilter.setEventId(item.getEventId());
                removeFilter.setExitCode(item.getExitCode());
                removeFilter.setJobChain(item.getJobChain());
                removeFilter.setJobName(item.getJobName());
                removeFilter.setOrderId(item.getOrderId());
                removeFilter.setSchedulerId(item.getSchedulerId());
                if (item.getSchedulerId() == null) {
                    removeFilter.setSchedulerId(this.filter.getSchedulerId());
                } else {
                    removeFilter.setSchedulerId(item.getSchedulerId());
                }
                this.schedulerEventDBLayer.delete(removeFilter);
            }
            this.schedulerEventDBLayer.commit();
            if (listOfEvents.size() > 0) {
                this.spooler.execute_xml(this.schedulerEventDBLayer.getNotifyCommand());
            }
        }
        catch (Exception e) {
            if (this.schedulerEventDBLayer != null) {
                this.schedulerEventDBLayer.rollback();
            }
            LOGGER.error(e.getMessage());
            throw e;
        }
    }

    private void addEvent() throws Exception {
        try {
            this.schedulerEventDBLayer.beginTransaction();
            this.schedulerEventDBLayer.addEvent(this.filter);
            this.schedulerEventDBLayer.commit();
            this.spooler.execute_xml(this.schedulerEventDBLayer.getNotifyCommand());
        }
        catch (Exception e) {
            if (this.schedulerEventDBLayer != null) {
                this.schedulerEventDBLayer.rollback();
            }
            LOGGER.error(e.getMessage());
            throw e;
        }
    }

    private void removeEvent() throws Exception {
        try {
            LOGGER.debug("Remove event from database: " + this.filter.getEventClass() + ":" + this.filter.getEventId());
            this.schedulerEventDBLayer.beginTransaction();
            this.schedulerEventDBLayer.removeEvent(this.filter);
            this.schedulerEventDBLayer.commit();
            this.spooler.execute_xml(this.schedulerEventDBLayer.getNotifyCommand());
        }
        catch (Exception e) {
            if (this.schedulerEventDBLayer != null) {
                this.schedulerEventDBLayer.rollback();
            }
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw e;
        }
    }

    private void removeExpiredEventsFromDatabase() throws Exception {
        if (this.schedulerEventDBLayer != null) {
            try {
                SchedulerEventFilter filter = new SchedulerEventFilter();
                LOGGER.debug("Remove expired events from database:");
                this.schedulerEventDBLayer.beginTransaction();
                filter.setExpires("now_utc");
                int row = this.schedulerEventDBLayer.delete(filter);
                LOGGER.debug(row + " on " + filter.getExpires() + " expired events removed");
                this.schedulerEventDBLayer.commit();
            }
            catch (Exception e) {
                if (this.schedulerEventDBLayer != null) {
                    this.schedulerEventDBLayer.rollback();
                }
                LOGGER.error(e.getMessage());
                throw e;
            }
        }
    }

    private void setEventAction(String eventAction) throws Exception {
        if (!("add".equalsIgnoreCase(eventAction) || "remove".equalsIgnoreCase(eventAction) || "process".equalsIgnoreCase(eventAction))) {
            throw new Exception("invalid action specified [add, remove, process]: " + eventAction);
        }
        this.eventAction = eventAction;
    }

    private void setSockettimeout(String s) {
        try {
            this.socketTimeout = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            this.spooler_log.warn("Illegal value for parameter socket_timeout:" + s + ". Integer expected. Using default=5");
            this.socketTimeout = 5;
        }
    }
}

