/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.managed;

import java.io.BufferedReader;
import java.io.FileReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.scheduler.managed.JobSchedulerManagedJob;
import sos.scheduler.managed.JobSchedulerManagedObject;
import sos.spooler.Job_impl;
import sos.spooler.Order;
import sos.spooler.Subprocess;
import sos.spooler.Variable_set;

public class JobSchedulerManagedExecutableJob
extends JobSchedulerManagedJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(JobSchedulerManagedExecutableJob.class);
    private final String strOrderParamPrefix = "scheduler_order_";
    private String[][] inputParameterAliases = new String[][]{{"scheduler_order_ignore_stderr", "ignore_stderr"}, {"scheduler_order_ignore_error", "ignore_error"}, {"scheduler_order_ignore_signal", "ignore_signal"}, {"scheduler_order_timeout", "timeout"}, {"scheduler_order_priority_class", "priority_class"}};
    private final String conStd_err_output = "std_err_output";
    private final String conStd_out_output = "std_out_output";
    private final String conExit_code = "exit_code";
    private final String conClassName = "JobSchedulerManagedExecutableJob";
    private final String[][] outputParameterAliases = new String[][]{{"std_err_output", "scheduler_order_stderr_output"}, {"std_out_output", "scheduler_order_stdout_output"}, {"exit_code", "scheduler_order_exit_code"}};
    private BufferedReader stdoutStream;
    private BufferedReader stderrStream;

    public boolean spooler_init() {
        try {
            FileReader fisOut = new FileReader(this.spooler_task.stdout_path());
            FileReader fisErr = new FileReader(this.spooler_task.stderr_path());
            this.stdoutStream = new BufferedReader(fisOut);
            this.stderrStream = new BufferedReader(fisErr);
        }
        catch (Exception e) {
            this.spooler_log.warn("failed to initialize stdout and stderr streams. " + e);
        }
        return super.spooler_init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean spooler_process() {
        Order order = null;
        this.orderPayload = null;
        String program = "";
        String logFile = "";
        String priorityClass = "normal";
        try {
            super.prepareParams();
            String command = "";
            try {
                String commandScript = this.getJobScript();
                LOGGER.trace("setting 'command_script' value from script tag of job: " + commandScript);
                if (this.orderJob) {
                    command = JobSchedulerManagedObject.getOrderCommand((Job_impl)this, commandScript);
                    order = this.spooler_task.order();
                }
                if (command == null || command.trim().isEmpty()) {
                    command = JobSchedulerManagedObject.getJobCommand((Job_impl)this);
                }
                if ((command = this.modifyCommand(command)) == null || command.trim().isEmpty()) {
                    throw new Exception("command is empty");
                }
            }
            catch (Exception e) {
                throw new Exception("no executable command found for order:" + e);
            }
            LOGGER.debug("command before replacements:\n" + command);
            boolean ignoreError = false;
            boolean ignoreSignal = false;
            boolean ignoreStderr = false;
            boolean ignoreTimeout = false;
            boolean timedOut = false;
            boolean ownProcessGroup = false;
            if (this.orderPayload != null) {
                this.replaceAliases(this.orderPayload, this.inputParameterAliases);
                if (this.orderPayload.var("ignore_error") != null && ("true".equalsIgnoreCase(this.orderPayload.var("ignore_error")) || "1".equalsIgnoreCase(this.orderPayload.var("ignore_error")) || "yes".equalsIgnoreCase(this.orderPayload.var("ignore_error")))) {
                    ignoreError = true;
                }
                if (this.orderPayload.var("ignore_signal") != null && ("true".equalsIgnoreCase(this.orderPayload.var("ignore_signal")) || "1".equalsIgnoreCase(this.orderPayload.var("ignore_signal")) || "yes".equalsIgnoreCase(this.orderPayload.var("ignore_signal")))) {
                    ignoreSignal = true;
                }
                if (this.orderPayload.var("ignore_stderr") != null && ("true".equalsIgnoreCase(this.orderPayload.var("ignore_stderr")) || "1".equalsIgnoreCase(this.orderPayload.var("ignore_stderr")) || "yes".equalsIgnoreCase(this.orderPayload.var("ignore_stderr")))) {
                    ignoreStderr = true;
                }
                if (this.orderPayload.var("ignore_timeout") != null && ("true".equalsIgnoreCase(this.orderPayload.var("ignore_timeout")) || "1".equalsIgnoreCase(this.orderPayload.var("ignore_timeout")) || "yes".equalsIgnoreCase(this.orderPayload.var("ignore_timeout")))) {
                    ignoreTimeout = true;
                }
                if (this.orderPayload.var("own_process_group") != null && ("true".equalsIgnoreCase(this.orderPayload.var("own_process_group")) || "1".equalsIgnoreCase(this.orderPayload.var("own_process_group")) || "yes".equalsIgnoreCase(this.orderPayload.var("own_process_group")))) {
                    ownProcessGroup = true;
                }
                if (this.orderPayload.var("log_file") != null && !this.orderPayload.var("log_file").toString().isEmpty()) {
                    logFile = this.orderPayload.var("log_file").toString();
                }
                if (this.orderPayload.var("priority_class") != null && !this.orderPayload.var("priority_class").toString().isEmpty()) {
                    priorityClass = this.orderPayload.var("priority_class").toString();
                }
                if (this.orderPayload.var("scheduler_order_command_parameters") != null && !this.orderPayload.var("scheduler_order_command_parameters").toString().isEmpty()) {
                    command = command + " " + this.orderPayload.var("scheduler_order_command_parameters").toString();
                }
            }
            if (this.spooler_task.params().var("interpreter") != null && !this.spooler_task.params().var("interpreter").isEmpty()) {
                program = this.spooler_task.params().var("interpreter");
                this.spooler_log.debug3("Using interpreter: " + program);
            }
            this.spooler_log.debug3("current setting ignore_error: " + ignoreError);
            this.spooler_log.debug3("current setting ignore_signal: " + ignoreSignal);
            this.spooler_log.debug3("current setting own_process_group: " + ownProcessGroup);
            this.spooler_log.debug9("logFile.lentgh:" + logFile.length());
            if (logFile.length() > 0) {
                this.spooler_log.debug3("current setting log_file: " + logFile);
            }
            command = command.replaceAll("(\\$|\u00a7)\\{scheduler_order_job_name\\}", this.getJobName());
            command = command.replaceAll("(\\$|\u00a7)\\{scheduler_order_job_id\\}", Integer.toString(this.getJobId()));
            command = command.replaceAll("(\\$|\u00a7)\\{scheduler_id\\}", this.spooler.id());
            if (this.orderJob && order != null) {
                command = command.replaceAll("(\\$|\u00a7)\\{scheduler_order_id\\}", order.id());
            }
            if (this.orderPayload != null) {
                command = JobSchedulerManagedObject.replaceVariablesInCommand(command, this.orderPayload);
            }
            command = command.replaceAll("\r\n", "\n");
            LOGGER.debug("Command after replacements:\n" + command);
            String[] commands = command.split("\n");
            LOGGER.debug("Found " + commands.length + " commands.");
            for (int i = 0; i < commands.length && !timedOut; ++i) {
                Subprocess subProc = this.spooler_task.create_subprocess();
                subProc.set_own_process_group(ownProcessGroup);
                subProc.set_ignore_error(ignoreError);
                subProc.set_ignore_signal(ignoreSignal);
                subProc.set_priority_class(priorityClass);
                try {
                    this.setEnvironment(this.orderPayload, subProc);
                }
                catch (Exception e) {
                    throw new Exception("Error occured setting environment variables: " + e);
                }
                if (program != null && !program.isEmpty()) {
                    subProc.start(program + " " + commands[i]);
                    this.spooler_log.info("executing \"" + program + " " + commands[i] + "\"");
                } else {
                    subProc.start(commands[i]);
                    this.spooler_log.info("executing \"" + commands[i] + "\"");
                }
                if (this.orderPayload != null && this.orderPayload.var("timeout") != null && !this.orderPayload.var("timeout").toString().isEmpty() && !"0".equals(this.orderPayload.var("timeout").toString())) {
                    this.spooler_log.info("executable file is launched with process id " + subProc.pid() + " for timeout in " + this.orderPayload.var("timeout").toString() + "s");
                    boolean terminated = subProc.wait_for_termination(Double.parseDouble(this.orderPayload.var("timeout").toString()));
                    if (!terminated) {
                        this.spooler_log.info("timeout reached, process will be terminated.");
                        subProc.kill();
                        subProc.wait_for_termination();
                        timedOut = true;
                    }
                } else {
                    this.spooler_log.info("executable file is launched with process id " + subProc.pid());
                    subProc.wait_for_termination();
                }
                if (!timedOut) {
                    this.spooler_log.info("file executed");
                }
                this.spooler_log.debug9("Exit code: " + subProc.exit_code());
                boolean stdErrEmpty = true;
                String stdErrString = "";
                String stdOutString = "";
                this.spooler_log.info("std_out for " + commands[i] + ":");
                while (this.stdoutStream != null && this.stdoutStream.ready()) {
                    String stdOutLine = this.stdoutStream.readLine();
                    this.spooler_log.info(stdOutLine);
                    stdOutString = stdOutString + stdOutLine + "\n";
                }
                this.spooler_log.info("std_err for " + commands[i] + ":");
                while (this.stderrStream != null && this.stderrStream.ready()) {
                    String stdErrLine = this.stderrStream.readLine();
                    this.spooler_log.info(stdErrLine);
                    if (!stdErrLine.trim().isEmpty()) {
                        stdErrEmpty = false;
                    }
                    stdErrString = stdErrString + stdErrLine + "\n";
                }
                if (this.orderJob && order != null) {
                    Variable_set realOrderPayload = order.params();
                    this.SetVar(realOrderPayload, "exit_code", "" + subProc.exit_code());
                    this.SetVar(realOrderPayload, "timed_out", "" + timedOut);
                    this.SetVar(realOrderPayload, "scheduler_order_terminated", !timedOut ? "true" : "false");
                    this.replaceAliases(realOrderPayload, this.outputParameterAliases);
                }
                Variable_set taskParams = this.spooler_task.params();
                this.SetVar(taskParams, "exit_code", "" + subProc.exit_code());
                this.SetVar(taskParams, "timed_out", "" + timedOut);
                this.replaceAliases(taskParams, this.outputParameterAliases);
                if (timedOut && !ignoreTimeout) {
                    throw new Exception("Process had to be killed because of timeout");
                }
                if (subProc.exit_code() != 0) {
                    if (ignoreError) {
                        this.spooler_log.info("Command terminated with exit code: " + subProc.exit_code());
                    } else {
                        throw new Exception("Command terminated with exit code: " + subProc.exit_code());
                    }
                }
                if (subProc.termination_signal() != 0) {
                    if (ignoreSignal) {
                        this.spooler_log.info("Command terminated with signal: " + subProc.termination_signal());
                    } else {
                        throw new Exception("Command terminated with signal: " + subProc.termination_signal());
                    }
                }
                if (ignoreStderr || stdErrEmpty) continue;
                throw new Exception("Command terminated with text in stderr:\n" + stdErrString);
            }
            boolean bl = this.orderJob;
            return bl;
        }
        catch (Exception e) {
            if (this.orderJob) {
                this.spooler_log.warn("error occurred processing managed order [" + (order != null ? "Job Chain: " + order.job_chain().name() + ", ID:" + order.id() : "(none)") + "] : " + e);
            } else {
                this.spooler_log.warn("error occurred processing executable file: " + e);
            }
            this.spooler_task.end();
            boolean bl = false;
            return bl;
        }
        finally {
            if (!logFile.isEmpty()) {
                this.spooler_log.log_file(logFile);
            }
        }
    }

    private void replaceAliases(Variable_set pOrderPayload, String[][] aliases) {
        if (pOrderPayload != null && aliases != null) {
            for (int i = 0; i < aliases.length; ++i) {
                String aliasParam = aliases[i][0];
                String replacedParam = aliases[i][1];
                String aliasParamValue = pOrderPayload.value(aliasParam);
                if (aliasParamValue != null) {
                    this.SetVar(pOrderPayload, replacedParam, aliasParamValue);
                    continue;
                }
                this.spooler_log.info("Variable not found: '" + aliasParam + "'.");
            }
        }
    }

    private void SetVar(Variable_set objVars, String strVarName, String strVarValue) {
        String conMethodName = "JobSchedulerManagedExecutableJob::SetVar";
        objVars.set_var(strVarName, strVarValue);
        this.spooler_log.info("JobSchedulerManagedExecutableJob::SetVarVariable '" + strVarName + "' set to value '" + strVarValue + "'.");
    }

    protected String modifyCommand(String command) {
        return command;
    }

    private void setEnvironment(Variable_set vars, Subprocess proc) throws Exception {
        if (vars == null || vars.xml() == null || vars.xml().isEmpty()) {
            return;
        }
        String[] keys = vars.names().split(";");
        for (int i = 0; i < keys.length; ++i) {
            String parameterName = keys[i];
            String parameterValue = vars.var(keys[i]);
            if (!parameterName.startsWith("env.")) continue;
            proc.set_environment(parameterName.substring(4), parameterValue);
        }
        if (vars.value("scheduler_file_path") != null && !vars.value("scheduler_file_path").isEmpty()) {
            proc.set_environment("SCHEDULER_TRIGGER_FILE", vars.value("scheduler_file_path"));
        }
        if (vars.value("scheduler_order_additional_envvars") != null && !vars.value("scheduler_order_additional_envvars").isEmpty()) {
            LOGGER.debug("Setting additional envvars.");
            String[] envVarKeys = vars.value("scheduler_order_additional_envvars").split(";");
            for (int i = 0; i < envVarKeys.length; ++i) {
                String key = envVarKeys[i];
                String value = vars.value(key);
                if (value == null || value.isEmpty()) continue;
                proc.set_environment(key, value);
            }
        }
    }
}

