/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.managed;

import java.util.HashMap;
import sos.scheduler.job.JobSchedulerJobAdapter;
import sos.spooler.Order;
import sos.spooler.Variable_set;

public abstract class JobSchedulerManagedJob
extends JobSchedulerJobAdapter {
    protected HashMap<String, String> globalSettings = null;
    protected Variable_set orderPayload;
    protected boolean orderJob = true;

    protected void prepareParams() throws Exception {
        this.orderJob = this.spooler_task.job().order_queue() != null;
        Order order = null;
        if (!this.orderJob) {
            this.spooler_log.debug3(this.spooler_job.name() + " running without order.");
        }
        try {
            Variable_set params = this.spooler.create_variable_set();
            params.merge(this.spooler_task.params());
            if (this.orderJob) {
                order = this.spooler_task.order();
                params.merge(order.params());
            }
            this.orderPayload = this.clearBlanks(params);
            this.spooler_log.debug6("Merged Payload: " + this.orderPayload.xml());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Variable_set clearBlanks(Variable_set set) throws Exception {
        String[] keys;
        Variable_set retSet = this.spooler.create_variable_set();
        for (String key : keys = set.names().split(";")) {
            String parameterValue = set.var(key);
            this.spooler_log.debug9(key + "=" + parameterValue);
            if (parameterValue == null || parameterValue.length() <= 0) continue;
            retSet.set_var(key, parameterValue);
        }
        return retSet;
    }

    protected void debugParamter(Variable_set params, String name) {
        try {
            if (name.contains("password")) {
                this.spooler_log.debug6("Parameter: " + name + " value:\"*****\"");
            } else {
                this.spooler_log.debug6("Parameter: " + name + " value:\"" + params.var(name) + "\"");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isOrderJob() {
        return this.orderJob;
    }

    public void setOrderJob(boolean pOrderJob) {
        this.orderJob = pOrderJob;
    }

    public Variable_set getOrderPayload() {
        return this.orderPayload;
    }
}

