/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.managed;

import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.connection.SOSConnection;
import sos.marshalling.SOSExport;
import sos.scheduler.managed.JobSchedulerManagedObject;
import sos.settings.SOSProfileSettings;
import sos.util.SOSArguments;

public class ManagedJobExport {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedJobExport.class);
    private static SOSConnection conn;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length == 0 || "-?".equals(args[0]) || "-h".equals(args[0])) {
            ManagedJobExport.showUsage();
            System.exit(0);
        }
        try {
            SOSArguments arguments = new SOSArguments(args);
            String xmlFile = "";
            String settingsFile = "";
            int jobID = 0;
            try {
                xmlFile = arguments.asString("-file=", "job_export.xml");
                jobID = arguments.asInt("-job=");
                settingsFile = arguments.asString("-settings=", "../config/factory.ini");
            }
            catch (Exception e1) {
                LOGGER.debug(e1.getMessage(), (Throwable)e1);
                ManagedJobExport.showUsage();
                System.exit(0);
            }
            ManagedJobExport.getDBConnection(settingsFile);
            conn.connect();
            arguments.checkAllUsed();
            ManagedJobExport.export(xmlFile, jobID);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        finally {
            try {
                conn.disconnect();
            }
            catch (Exception exception) {}
        }
    }

    protected static SOSConnection getDBConnection(String settingsFile) throws Exception {
        SOSProfileSettings settings = new SOSProfileSettings(settingsFile);
        Properties props = settings.getSection("spooler");
        if (props.isEmpty()) {
            throw new Exception("no settings found in section [spooler] of configuration file: " + settingsFile);
        }
        if (props.getProperty("db") == null || props.getProperty("db").isEmpty()) {
            throw new Exception("no settings found for entry [db] in section [spooler] of configuration file: " + settingsFile);
        }
        if (props.getProperty("db_class") == null || props.getProperty("db_class").isEmpty()) {
            throw new Exception("no settings found for entry [db_class] in section [spooler] of configuration file: " + settingsFile);
        }
        LOGGER.debug("connecting to database.. .");
        String dbProperty = props.getProperty("db").replaceAll("jdbc:", "-url=jdbc:");
        dbProperty = dbProperty.substring(dbProperty.indexOf(45));
        SOSArguments dbArguments = new SOSArguments(dbProperty);
        conn = SOSConnection.createInstance((String)props.getProperty("db_class"), (String)dbArguments.asString("-class=", ""), (String)dbArguments.asString("-url=", ""), (String)dbArguments.asString("-user=", ""), (String)dbArguments.asString("-password=", ""));
        return conn;
    }

    public static void showUsage() {
        LOGGER.info("usage:ManagedJobExport ");
        LOGGER.info("Argumente:");
        LOGGER.info("     -job=            ID des zu kopierenden jobs");
        LOGGER.info("     -v=              Loglevel (optional)");
        LOGGER.info("     -log=            LogDatei (optional)");
        LOGGER.info("     -settings=       factory.ini Datei (default:../config/factory.ini)");
        LOGGER.info("     -file=           Exportdatei (default:job_export.xml)");
    }

    private static void export(String xmlFile, int jobID) throws Exception {
        String selManagedJobs = "SELECT * FROM " + JobSchedulerManagedObject.getTableManagedJobs() + " WHERE \"ID\"=" + jobID;
        String selJobTypes = "SELECT * FROM " + JobSchedulerManagedObject.getTableManagedJobTypes() + " WHERE \"TYPE\"='?'";
        String selSettings = "SELECT * FROM " + JobSchedulerManagedObject.getTableSettings() + " WHERE \"APPLICATION\" IN ('job_type/local/?', 'job_type/global/?', 'job_type/mixed/?')";
        SOSExport export = new SOSExport(conn, xmlFile, "DOCUMENT");
        int job = export.query(JobSchedulerManagedObject.getTableManagedJobs(), "ID", selManagedJobs);
        int jobTypes = export.query(JobSchedulerManagedObject.getTableManagedJobTypes(), "TYPE", selJobTypes, "JOB_TYPE", job);
        int settings = export.query(JobSchedulerManagedObject.getTableSettings(), "APPLICATION,SECTION,NAME", selSettings, "TYPE,TYPE,TYPE", jobTypes);
        export.doExport();
    }
}

