/*
 * Decompiled with CFR 0.152.
 */
package sos.scheduler.managed;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sos.net.SOSMail;
import sos.net.SOSMailOrder;
import sos.scheduler.managed.JobSchedulerManagedJob;
import sos.settings.SOSConnectionSettings;
import sos.settings.SOSSettings;
import sos.spooler.Task;
import sos.spooler.Variable_set;
import sos.util.SOSDate;

public class ManagedReporter {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManagedReporter.class);
    protected String tableMailSettings = "SETTINGS";
    protected String applicationMail = "email";
    protected String sectionMail = "mail_server";
    private SOSSettings jobSettings;
    private SOSSettings sosMailSettings;
    private SOSMail mail;
    private Task spooler_task;
    private JobSchedulerManagedJob job;
    private boolean orderJob;
    private Map<String, String> replacements = new HashMap<String, String>();
    private String body = "";
    private String subject = "Report [taskid]";
    private Variable_set orderPayload;
    private File attach;
    private boolean deleteAttach = false;
    private boolean sendIfNoResult = true;
    private boolean sendIfResult = true;
    private boolean hasResult = true;
    private String logDirectory;
    private String mailServer = "";
    private String logMailFrom = "";
    private String mailUser = "";
    private String mailPassword = "";
    private String mailPort = "";
    private String securityProtocol = "";
    private boolean isUniversalAgent;

    public ManagedReporter(JobSchedulerManagedJob job) throws Exception {
        this.setJobSettings(job.getJobSettings());
        this.job = job;
        try {
            this.isUniversalAgent = false;
            job.spooler.ini_path();
        }
        catch (Exception e) {
            this.isUniversalAgent = true;
        }
        this.spooler_task = job.spooler_task;
        if (this.spooler_task.params().var("application_mail") != null && !this.spooler_task.params().var("application_mail").isEmpty()) {
            this.setApplicationMail(this.spooler_task.params().var("application_mail"));
            LOGGER.debug(".. job parameter [application_mail]: " + this.getApplicationMail());
        }
        if (this.spooler_task.params().var("section_mail") != null && !this.spooler_task.params().var("section_mail").isEmpty()) {
            this.setSectionMail(this.spooler_task.params().var("section_mail"));
            LOGGER.debug(".. job parameter [section_mail]: " + this.getSectionMail());
        }
        if (this.spooler_task.params().var("table_settings") != null && !this.spooler_task.params().var("table_settingss").isEmpty()) {
            this.setTableMailSettings(this.spooler_task.params().var("table_settings"));
            LOGGER.debug(".. job parameter [table_settings]: " + this.getTableMailSettings());
        }
        try {
            this.sosMailSettings = new SOSConnectionSettings(job.getConnection(), this.getTableMailSettings(), this.getApplicationMail(), this.getSectionMail());
            LOGGER.debug("MailSettings: " + this.sosMailSettings.getSection().size());
        }
        catch (Exception e) {
            LOGGER.debug("MailSettings were not found.");
            this.sosMailSettings = null;
        }
        if (!this.isUniversalAgent) {
            try {
                Properties spoolProp = this.getJobSettings().getSection("spooler");
                Properties smtpProp = this.getJobSettings().getSection("smtp");
                this.mailServer = spoolProp.getProperty("smtp");
                this.logMailFrom = spoolProp.getProperty("log_mail_from");
                this.mailUser = smtpProp.getProperty("mail.smtp.user");
                if ("".equals(this.mailUser)) {
                    this.mailUser = spoolProp.getProperty("mail.smtp.user");
                }
                this.mailPassword = smtpProp.getProperty("mail.smtp.password");
                if ("".equals(this.mailPassword)) {
                    this.mailPassword = spoolProp.getProperty("mail.smtp.password");
                }
                this.securityProtocol = smtpProp.getProperty("mail.smtp.security_protocol");
                if ("".equals(this.securityProtocol)) {
                    this.securityProtocol = spoolProp.getProperty("mail.smtp.security_protocol");
                }
            }
            catch (Exception spoolProp) {
                // empty catch block
            }
        }
        if (this.mailServer == null) {
            this.mailServer = "";
        }
        if (this.mailPort == null) {
            this.mailPort = "";
        }
        if (this.logMailFrom == null) {
            this.logMailFrom = "";
        }
        if (this.mailUser == null) {
            this.mailUser = "";
        }
        if (this.mailPassword == null) {
            this.mailPassword = "";
        }
        if (this.securityProtocol == null) {
            this.securityProtocol = "";
        }
        if (!this.spooler_task.params().var("smtp_port").isEmpty()) {
            this.mailPort = this.spooler_task.params().var("smtp_port");
        }
        if (!this.spooler_task.params().var("from").isEmpty()) {
            this.logMailFrom = this.spooler_task.params().var("from");
        }
        if (!this.spooler_task.params().var("smtp_user").isEmpty()) {
            this.mailUser = this.spooler_task.params().var("smtp_user");
        }
        if (!this.spooler_task.params().var("smtp_password").isEmpty()) {
            this.mailPassword = this.spooler_task.params().var("smtp_password");
        }
        if (!this.spooler_task.params().var("security_protocol").isEmpty()) {
            this.securityProtocol = this.spooler_task.params().var("security_protocol");
        }
        if (!this.spooler_task.params().var("host").isEmpty()) {
            this.mailServer = this.spooler_task.params().var("host");
        }
        boolean hasSOSMailOrder = false;
        if (job.getConnection() != null) {
            try {
                String result = job.getConnection().getSingleValue("SELECT COUNT(*) FROM MAILS");
                if (!result.isEmpty()) {
                    hasSOSMailOrder = true;
                }
            }
            catch (Exception e) {
                LOGGER.debug("Table MAILS was not found.");
            }
        }
        try {
            if (job.getConnection() == null) {
                LOGGER.trace("Initializing SOSMail without database.");
                this.mail = new SOSMail(this.mailServer);
                LOGGER.trace("Setting mail sender: " + this.logMailFrom);
                this.mail.setFrom(this.logMailFrom);
                this.mail.setUser(this.mailUser);
                this.mail.setPassword(this.mailPassword);
                this.mail.setCharset("ISO-8859-1");
                this.mail.setQueueDir(job.spooler_log.mail().queue_dir());
            } else if (this.sosMailSettings != null && this.sosMailSettings.getSection() != null && !this.sosMailSettings.getSection().isEmpty()) {
                if (hasSOSMailOrder) {
                    LOGGER.trace("Initializing SOSMailOrder with Mail Settings");
                    this.mail = new SOSMailOrder(this.sosMailSettings, job.getConnection());
                } else {
                    LOGGER.trace("Initializing SOSMail with Mail Settings");
                    this.mail = new SOSMail(this.sosMailSettings);
                }
            } else {
                if (hasSOSMailOrder) {
                    LOGGER.trace("Initializing SOSMailOrder without Mail Settings");
                    this.mail = new SOSMailOrder(this.mailServer, job.getConnection());
                } else {
                    LOGGER.trace("Initializing SOSMail without Mail Settings");
                    this.mail = new SOSMail(this.mailServer);
                }
                LOGGER.trace("Setting mail sender: " + this.logMailFrom);
                this.mail.setFrom(this.logMailFrom);
                if (this.mailUser != null) {
                    LOGGER.trace("Setting mail user: " + this.mailUser);
                    this.mail.setUser(this.mailUser);
                }
                if (this.mailPassword != null) {
                    LOGGER.trace("Setting mail password xxxxxxxx");
                    this.mail.setPassword(this.mailPassword);
                }
                this.mail.setCharset("ISO-8859-1");
                if (job.spooler_log.mail() != null && job.spooler_log.mail().queue_dir() != null) {
                    LOGGER.trace("Setting mail queue dir: " + job.spooler_log.mail().queue_dir());
                    this.mail.setQueueDir(job.spooler_log.mail().queue_dir());
                }
                if (!this.mailPort.isEmpty()) {
                    LOGGER.trace("Setting mail smtp port:" + this.mailPort);
                    this.mail.setPort(this.mailPort);
                }
                if (!this.securityProtocol.isEmpty()) {
                    LOGGER.trace("Setting mail securityProtocol:" + this.securityProtocol);
                    this.mail.setSecurityProtocol(this.securityProtocol);
                }
            }
        }
        catch (Exception e) {
            throw new Exception("Failed to initialize SOSMail class." + e, e);
        }
    }

    public File getReportFile() throws Exception {
        this.orderJob = this.spooler_task.job().order_queue() != null;
        String fileName = "report_[date]_[taskid].xml";
        this.orderPayload = this.job.getOrderPayload();
        try {
            String path;
            if (this.getOrderPayload() != null && this.getOrderPayload().var("scheduler_order_report_mailto") != null && !this.getOrderPayload().var("scheduler_order_report_mailto").isEmpty()) {
                int i;
                String[] mails = this.getOrderPayload().var("scheduler_order_report_mailto").split(",");
                for (int i2 = 0; i2 < mails.length; ++i2) {
                    this.mail.addRecipient(mails[i2].trim());
                }
                this.job.debugParamter(this.getOrderPayload(), "scheduler_order_report_mailto");
                if (this.getOrderPayload() != null && this.getOrderPayload().var("scheduler_order_report_mailcc") != null && !this.getOrderPayload().var("scheduler_order_report_mailcc").isEmpty()) {
                    String[] mailscc = this.getOrderPayload().var("scheduler_order_report_mailcc").split(",");
                    for (i = 0; i < mailscc.length; ++i) {
                        this.mail.addCC(mailscc[i].trim());
                    }
                    this.job.debugParamter(this.getOrderPayload(), "scheduler_order_report_mailcc");
                }
                if (this.getOrderPayload() != null && this.getOrderPayload().var("scheduler_order_report_mailbcc") != null && !this.getOrderPayload().var("scheduler_order_report_mailbcc").isEmpty()) {
                    String[] mailsbcc = this.getOrderPayload().var("scheduler_order_report_mailbcc").split(",");
                    for (i = 0; i < mailsbcc.length; ++i) {
                        this.mail.addBCC(mailsbcc[i].trim());
                    }
                    this.job.debugParamter(this.getOrderPayload(), "scheduler_order_report_mailbcc");
                }
            } else {
                LOGGER.debug("Using mail recipients from job.");
                this.mail.addRecipient(this.job.spooler_log.mail().to());
                if (this.job.spooler_log.mail().cc() != null && !this.job.spooler_log.mail().cc().isEmpty()) {
                    this.mail.addCC(this.job.spooler_log.mail().cc());
                }
                if (this.job.spooler_log.mail().bcc() != null && !this.job.spooler_log.mail().bcc().isEmpty()) {
                    this.mail.addBCC(this.job.spooler_log.mail().bcc());
                }
            }
            if (this.getOrderPayload() != null && this.getOrderPayload().var("scheduler_order_report_subject") != null && !this.getOrderPayload().var("scheduler_order_report_subject").isEmpty()) {
                this.subject = this.getOrderPayload().var("scheduler_order_report_subject");
                this.job.debugParamter(this.getOrderPayload(), "scheduler_order_report_subject");
            }
            this.subject = this.replace(this.subject);
            if (this.getOrderPayload() != null && this.getOrderPayload().var("scheduler_order_report_body") != null && !this.getOrderPayload().var("scheduler_order_report_body").isEmpty()) {
                this.body = this.getOrderPayload().var("scheduler_order_report_body");
                this.job.debugParamter(this.getOrderPayload(), "scheduler_order_report_body");
            }
            this.body = this.replace(this.body);
            this.logDirectory = "";
            if (this.getOrderPayload() != null && this.getOrderPayload().var("log_directory") != null && !this.getOrderPayload().var("log_directory").isEmpty()) {
                this.logDirectory = this.getOrderPayload().var("log_directory");
                this.job.debugParamter(this.getOrderPayload(), "log_directory");
            }
            if (this.getOrderPayload() != null && this.getOrderPayload().var("scheduler_order_report_filename") != null && !this.getOrderPayload().var("scheduler_order_report_filename").isEmpty()) {
                fileName = this.getOrderPayload().var("scheduler_order_report_filename");
                this.job.debugParamter(this.getOrderPayload(), "scheduler_order_report_filename");
            }
            fileName = this.replace(fileName);
            LOGGER.debug("Output filename: " + fileName);
            if (this.getOrderPayload() != null && this.getOrderPayload().var("scheduler_order_report_path") != null && !this.getOrderPayload().var("scheduler_order_report_path").isEmpty()) {
                File reportPath;
                path = this.getOrderPayload().var("scheduler_order_report_path");
                this.job.debugParamter(this.getOrderPayload(), "scheduler_order_report_path");
                if (!(path.endsWith("/") || path.endsWith("\\") || path.isEmpty())) {
                    path = path + "/";
                }
                if (!(reportPath = new File(path = this.replace(path))).exists()) {
                    reportPath.mkdirs();
                }
                this.attach = new File(path + fileName);
                this.deleteAttach = false;
            } else {
                path = System.getProperty("java.io.tmpdir");
                if (!(path.endsWith("/") || path.endsWith("\\") || path.isEmpty())) {
                    path = path + "/";
                }
                this.attach = new File(path + fileName);
                this.deleteAttach = true;
            }
            if (this.getOrderPayload() != null && this.getOrderPayload().var("scheduler_order_report_send_if_no_result") != null && !this.getOrderPayload().var("scheduler_order_report_send_if_no_result").isEmpty()) {
                this.sendIfNoResult = "1".equals(this.getOrderPayload().var("scheduler_order_report_send_if_no_result")) || "true".equalsIgnoreCase(this.getOrderPayload().var("scheduler_order_report_send_if_no_result"));
                this.job.debugParamter(this.getOrderPayload(), "scheduler_order_report_send_if_no_result");
            }
            if (this.getOrderPayload() != null && this.getOrderPayload().var("scheduler_order_report_send_if_result") != null && !this.getOrderPayload().var("scheduler_order_report_send_if_result").isEmpty()) {
                this.sendIfResult = "1".equals(this.getOrderPayload().var("scheduler_order_report_send_if_result")) || "true".equalsIgnoreCase(this.getOrderPayload().var("scheduler_order_report_send_if_result"));
                this.job.debugParamter(this.getOrderPayload(), "scheduler_order_report_send_if_result");
            }
            return this.attach;
        }
        catch (Exception e) {
            this.mail.clearAttachments();
            this.mail.clearRecipients();
            this.clearReplacements();
            throw new Exception("error occurred preparing report file: " + e, e);
        }
    }

    public void report(File[] files) throws Exception {
        try {
            if (this.hasResult() && !this.sendIfResult) {
                LOGGER.info("Query returned a result. No report will be sent because scheduler_order_send_if_result=false");
                return;
            }
            if (!this.hasResult() && !this.sendIfNoResult) {
                LOGGER.info("Query returned no result. No report will be sent because scheduler_order_send_if_no_result=false");
                return;
            }
            boolean asbody = false;
            if (this.getOrderPayload() != null && this.getOrderPayload().var("scheduler_order_report_asbody") != null) {
                asbody = "1".equals(this.getOrderPayload().var("scheduler_order_report_asbody")) || "true".equalsIgnoreCase(this.getOrderPayload().var("scheduler_order_report_asbody"));
                this.job.debugParamter(this.getOrderPayload(), "scheduler_order_report_asbody");
            }
            if (files != null) {
                this.getReportFile();
                this.deleteAttach = false;
                this.attach = files[0];
            }
            if (files != null && files.length > 1) {
                asbody = false;
            }
            if (asbody) {
                BufferedReader reader = new BufferedReader(new FileReader(this.attach));
                StringBuilder builder = new StringBuilder();
                String line = reader.readLine();
                while (line != null) {
                    builder.append(line);
                    builder.append('\n');
                    line = reader.readLine();
                }
                reader.close();
                this.body = builder.toString();
                this.mail.setContentType("text/html");
            }
            if (this.body.trim().startsWith("<html")) {
                this.mail.setContentType("text/html");
            }
            this.mail.setBody(this.body);
            this.mail.setSubject(this.subject);
            if (files != null) {
                if (!asbody) {
                    for (int i = 0; i < files.length; ++i) {
                        this.mail.addAttachment(files[i].getAbsolutePath());
                    }
                }
            } else if (!asbody) {
                this.mail.addAttachment(this.attach.getAbsolutePath());
            }
            if (!this.isUniversalAgent && this.logDirectory.isEmpty() && this.job.spooler_log.level() == -9) {
                this.logDirectory = this.job.spooler.log_dir();
            }
            if (!this.logDirectory.isEmpty()) {
                this.dumpMessage();
            }
            LOGGER.info("Sending report email to: " + this.mail.getRecipientsAsString() + ", subject: " + this.mail.getSubject());
            if (this.mail instanceof SOSMailOrder) {
                SOSMailOrder mo = (SOSMailOrder)this.mail;
                mo.setJobId(this.job.spooler_task.id());
            }
            this.mail.send();
        }
        catch (Exception e) {
            throw new Exception("Error occurred sending report: " + e, e);
        }
        finally {
            if (this.mail instanceof SOSMailOrder) {
                SOSMailOrder mo = (SOSMailOrder)this.mail;
                mo.initOrder();
            }
            this.clearReplacements();
            if (this.deleteAttach) {
                try {
                    this.attach.delete();
                    this.attach = null;
                }
                catch (SecurityException e) {
                    LOGGER.warn("Failed to delete temporary attachment file: " + e);
                }
            }
        }
    }

    public void report() throws Exception {
        this.report(null);
    }

    private String replace(String source) {
        String target;
        try {
            target = source.replaceAll("\\[date\\]", SOSDate.getCurrentDateAsString());
            target = target.replaceAll("\\[datetime\\]", SOSDate.getCurrentTimeAsString());
            target = target.replaceAll("\\[date_german\\]", SOSDate.getCurrentDateAsString((String)"dd.MM.yyyy"));
            target = target.replaceAll("\\[datetime_german\\]", SOSDate.getCurrentTimeAsString((String)"dd.MM.yyyy HH:mm:ss"));
            target = target.replaceAll("\\[subject\\]", this.getSubject());
            target = target.replaceAll("\\[nl\\]", "\n");
            if (this.isOrderJob()) {
                target = target.replaceAll("\\[orderid\\]", this.spooler_task.order().id());
            }
            target = target.replaceAll("\\[jobname\\]", this.spooler_task.job().name());
            target = target.replaceAll("\\[taskid\\]", Integer.toString(this.spooler_task.id()));
            for (String key : this.replacements.keySet()) {
                String repl = this.replacements.get(key);
                target = target.replaceAll(key, repl);
            }
        }
        catch (Exception e) {
            try {
                LOGGER.warn("An error occurred replacing fields in String \"" + source + "\"");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return source;
        }
        return target;
    }

    public void addReplacement(String regex, String replacement) {
        this.replacements.put(regex, replacement);
    }

    public void clearReplacements() {
        this.replacements.clear();
    }

    public SOSSettings getJobSettings() {
        return this.jobSettings;
    }

    public void setJobSettings(SOSSettings jobSettings) {
        this.jobSettings = jobSettings;
    }

    public boolean isOrderJob() {
        return this.orderJob;
    }

    public String getBody() {
        return this.body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public String getSubject() {
        return this.subject;
    }

    public void setSubject(String subject) {
        this.subject = subject;
    }

    public Variable_set getOrderPayload() {
        return this.orderPayload;
    }

    public boolean hasResult() {
        return this.hasResult;
    }

    public void setHasResult(boolean hasResult) {
        this.hasResult = hasResult;
    }

    public String getTableMailSettings() {
        return this.tableMailSettings;
    }

    public void setTableMailSettings(String tableMailSettings) {
        this.tableMailSettings = tableMailSettings;
    }

    public String getApplicationMail() {
        return this.applicationMail;
    }

    public void setApplicationMail(String applicationMail) {
        this.applicationMail = applicationMail;
    }

    public String getSectionMail() {
        return this.sectionMail;
    }

    public void setSectionMail(String sectionMail) {
        this.sectionMail = sectionMail;
    }

    private void dumpMessage() {
        String queuePattern = "yyyy-MM-dd.HHmmss.S";
        Date d = new Date();
        StringBuffer bb = new StringBuffer();
        SimpleDateFormat s = new SimpleDateFormat(queuePattern);
        FieldPosition fp = new FieldPosition(0);
        StringBuffer b = s.format(d, bb, fp);
        String dumpFileName = this.logDirectory + "/sos." + b + ".email";
        try {
            this.mail.dumpMessageToFile(dumpFileName, true);
        }
        catch (Exception e) {
            try {
                LOGGER.warn(e.toString(), (Throwable)e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

