/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common;

import com.sos.JSHelper.Exceptions.JobSchedulerException;
import com.sos.i18n.annotation.I18NResourceBundle;
import com.sos.vfs.common.SOSVFSMessageCodes;
import com.sos.vfs.common.interfaces.ISOSProvider;
import com.sos.vfs.common.interfaces.ISOSProviderFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

@I18NResourceBundle(baseName="SOSVirtualFileSystem", defaultLocale="en")
public abstract class SOSCommonFile
extends SOSVFSMessageCodes
implements ISOSProviderFile {
    private ISOSProvider provider = null;
    private InputStream inputStream = null;
    private OutputStream outputStream = null;
    private boolean modeAppend = false;
    private boolean modeRestart = false;

    public SOSCommonFile(String name) {
        super(name);
    }

    @Override
    public void setProvider(ISOSProvider val) {
        this.provider = val;
    }

    @Override
    public ISOSProvider getProvider() {
        return this.provider;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public void setOutputStream(OutputStream os) {
        this.outputStream = os;
    }

    @Override
    public String file2String() {
        InputStream is = this.getFileInputStream();
        if (is == null) {
            throw new JobSchedulerException("input stream is null");
        }
        StringBuilder sb = new StringBuilder((int)this.getFileSize());
        byte[] buffer = new byte[1024];
        try {
            int bytes;
            while ((bytes = is.read(buffer)) != -1) {
                sb.append(new String(buffer).substring(0, bytes));
            }
        }
        catch (Exception e) {
            throw new JobSchedulerException(SOSVfs_E_134.get(new Object[]{"File2String()"}), (Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException iOException) {}
        }
        return sb.toString();
    }

    @Override
    public InputStream getFileInputStream() {
        return null;
    }

    @Override
    public long getFileSize() {
        return 0L;
    }

    @Override
    public boolean fileExists() throws Exception {
        return false;
    }

    @Override
    public boolean isDirectory() throws Exception {
        return false;
    }

    @Override
    public boolean delete(boolean checkIsDirectory) {
        return false;
    }

    @Override
    public void rename(String newPath) {
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void write(byte[] buffer, int offset, int length) {
    }

    @Override
    public void write(byte[] buffer) {
    }

    @Override
    public int read(byte[] buffer) {
        return 0;
    }

    @Override
    public void closeInput() {
    }

    @Override
    public void closeOutput() {
    }

    @Override
    public void setModeAppend(boolean val) {
        this.modeAppend = val;
    }

    public boolean isModeAppend() {
        return this.modeAppend;
    }

    @Override
    public void setModeRestart(boolean val) {
        this.modeRestart = val;
    }

    public boolean isModeRestart() {
        return this.modeRestart;
    }
}

