/*
 * Decompiled with CFR 0.152.
 */
package com.sos.vfs.common;

import com.sos.vfs.common.SOSCommonProvider;
import java.io.File;

public class SOSFileEntry {
    private static final String FILE = "File";
    private static final String FOLDER = "Folder";
    private EntryType type;
    private String parentPath;
    private String fullPath;
    private String directoryPath;
    private String filename;
    private String normalizedFilename;
    private long filesize;
    private boolean directory;

    public SOSFileEntry(EntryType val) {
        this.type = val;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String val) {
        this.filename = val;
    }

    public String getNormalizedFilename() {
        return this.normalizedFilename;
    }

    public void setNormalizedFilename(String val) {
        this.normalizedFilename = val;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(long val) {
        this.filesize = val;
    }

    public boolean isDirectory() {
        this.setDirectoryPath();
        return this.directory;
    }

    public void setDirectory(boolean val) {
        this.directory = val;
    }

    public String getParentPath() {
        if (this.parentPath == null) {
            return "";
        }
        return this.parentPath;
    }

    public void setParentPath(String parent) {
        this.parentPath = parent == null ? "/" : (this.type.equals((Object)EntryType.FILESYSTEM) ? SOSCommonProvider.normalizePath(new File(parent).getPath()) : parent);
    }

    public void setFullPath(String val) {
        this.fullPath = val;
    }

    public String getFullPath() {
        if (this.fullPath == null) {
            if (this.type.equals((Object)EntryType.FILESYSTEM)) {
                this.fullPath = SOSCommonProvider.normalizePath(new File(this.parentPath, this.filename).getPath());
            } else if (this.parentPath == null) {
                this.fullPath = this.filename;
            } else {
                String parent = this.parentPath.endsWith("/") ? this.parentPath : this.parentPath + "/";
                this.fullPath = parent + this.filename;
            }
        }
        return this.fullPath;
    }

    private String setDirectoryPath() {
        if (this.directoryPath == null) {
            String fp = this.getFullPath();
            this.directoryPath = this.directory ? fp : SOSCommonProvider.getFullParentFromPath(fp);
        }
        return this.directoryPath;
    }

    public String getDirectoryPath() {
        this.setDirectoryPath();
        return this.directoryPath;
    }

    public boolean isDirUp() {
        return this.filename != null && "..".equals(this.filename);
    }

    public String getFilesizeAsString() {
        return String.valueOf(this.filesize);
    }

    public String getCategory() {
        if (this.isDirectory()) {
            return FOLDER;
        }
        return FILE;
    }

    public boolean isFileOrFolder() {
        return this.filename != null && !"..".equals(this.filename) && !".".equals(this.filename) && !"".equals(this.filename);
    }

    public static enum EntryType {
        FILESYSTEM,
        HTTP,
        SMB;

    }
}

